/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pass3.c,v 1.14 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "getCGIparm_int.h"
#include "getCGIparm.h"

static int
quote_literal(const u_char *pattern, const u_char *const query, u_char **result) {
    u_char *p;
    const u_char *q;
    int i;
    i = 0;
    q = query;
    *result = malloc(strlen((char*)query) * 2 + 1);
    if  (!*result) return(EX_TEMPFAIL);
    p = *result;
    for (; *q; q++) {
        switch(*q) {
        case '\'': case '\\': i |= 1; *p++ = *q; *p++ = *q; break;
        default: *p++ = *q;
    }   }
    *p++ = '\0';
    if  (!i) { free(*result); *result = (u_char *)query;}
    return(EX_OK);
};

static int
quote_ident(const u_char *pattern, const u_char *const query, u_char **result) {
    u_char *p;
    const u_char *q;
    int i;
    i = 0;
    q = query;
    *result = malloc(strlen((char*)query) * 2 + 1);
    if  (!*result) return(EX_TEMPFAIL);
    p = *result;
    for (; *q; q++) {
        switch(*q) {
        case '\"': case '\\': i |= 1; *p++ = *q; *p++ = *q; break;
        default: *p++ = *q;
    }   }
    *p++ = '\0';
    if  (!i) { free(*result); *result = (u_char *)query;}
    return(EX_OK);
};

static int
quote_copy(const u_char *pattern, const u_char *const query, u_char **result) {
    u_char *p;
    const u_char *q;
    int i;
    q = query;
    i = 0;
    *result = malloc(strlen((char*)query) * 2 + 1);
    if  (!*result) return(EX_TEMPFAIL);
    p = *result;
    for (; *q; q++) {
        switch(*q) {
        case 0x08: i |= 1; *p++ = '\\'; *p++ = 'b';   break;
        case 0x09: i |= 1; *p++ = '\\'; *p++ = 't';   break;
        case 0x0A: i |= 1; *p++ = '\\'; *p++ = 'n';   break;
        case 0x0B: i |= 1; *p++ = '\\'; *p++ = 'v';   break;
        case 0x0C: i |= 1; *p++ = '\\'; *p++ = 'f';   break;
        case 0x0D: i |= 1; *p++ = '\\'; *p++ = 'r';   break;
        case '\\': i |= 1; *p++ = '\\'; *p++ = '\\';  break;
        default: *p++ = *q;
    }   }
    *p++ = '\0';
    if  (!i) { free(*result); *result = (u_char *)query;}
    return(EX_OK);
};
static int
quote_single(const u_char *pattern, const u_char *const query, u_char **result) {
    char *p;
    *result = malloc(strlen((char*)query) + 3);
    if  (!*result) return(EX_TEMPFAIL);
    p = (char*)*result;
    strcpy(p, "\'");
    strcat(p, (char*)query);
    strcat(p, "\'");
    return(EX_OK);
};

static int
quote_double(const u_char *pattern, const u_char *const query, u_char **result) {
    char *p;
    *result = malloc(strlen((char*)query) + 3);
    if  (!*result) return(EX_TEMPFAIL);
    p = (char*)*result;
    strcpy(p, "\"");
    strcat(p, (char*)query);
    strcat(p, "\"");
    return(EX_OK);
};

const struct getCGIparmquotens getCGIparmquotens[] =
{ {"psql" , 0, quote_literal}
, {"psqi" , 0, quote_ident  }
, {"copy" , 0, quote_copy   }
, {"sq"   , 0, quote_single }
, {"dq"   , 0, quote_double }
, {NULL   , 0, NULL         }
};

int
getCGIparmpass3( BLIN_flag flags
     , const u_char * const qq
     , u_char ** const unescaped
     ) {
    int i, ex;
    u_char *r;
    char *q;
    const u_char * const empty = (const u_char *)"";

    q = qq ? strdup((char*)qq) : NULL;
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "P3 flags=%06X, q=%s~, unescaped=%s~\n"
               , flags
               , qq ? qq : empty
               , unescaped ? (*unescaped ? *unescaped : empty) : empty
               );
    ex = EX_OK;
    if  (!unescaped)
        ex = EX_SOFTWARE;
    else if (!q || !*q) ex = EX_OK;
    else if (~flags & gCGI_ZERO || **unescaped) {
        u_char *p = NULL, *f1 = NULL;

        while (!ex && q && *q) {
            ex = EX_USAGE;
            r = (u_char*)strsep(&q, "/");
            for (i = 0; getCGIparmquotens[i].name; i++) {
                if  ( getCGIparmquotens[i].namelen
                    ? !strncmp(getCGIparmquotens[i].name, (char*)r, getCGIparmquotens[i].namelen)
                    : !strcmp(getCGIparmquotens[i].name, (char*)r)
                    ) {
                    ifBLIN_QV3(flags) fprintf(stderr, "r=%s unesc=%s\n", r, *unescaped);
                    if  (!(ex = (getCGIparmquotens[i].test_proc)(r, *unescaped, &p) ? EX_DATAERR : EX_OK)) {
                        if  (*unescaped != p) {
                            if  (f1 && *unescaped == f1 && p != f1) {
                                free(*unescaped);
                            }
                            *unescaped = f1 = p;
                            ifBLIN_QV2(flags) fprintf(stderr, "%d NEW=%s~\n", ex, p);
                        } else {
                            ifBLIN_QV2(flags) fprintf(stderr, "%d OLD=%s~\n", ex, p);
                    }   }
                    break;
    }   }   }   }
    free(q);
    ifBLIN_QV3(flags) fprintf(stderr, "P3 ex=%d\n", ex);
    return(ex);
}
