/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pass2.c,v 1.12 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "getCGIparm_int.h"
#include "getCGIparm.h"

static const enum classes koi[256] =
{no,no,no,no ,no,no,no,no ,no,ok,ok,no ,no,ok,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok

,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,no,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,ok ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,ok ,no,no,no,no ,no,no,no,no ,no,no,no,no

,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
};
static const enum classes ascii[256] =
{no,no,no,no ,no,no,no,no ,no,ok,ok,no ,no,ok,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok

,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,no,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
};

/*
 *   
 *     .
 *    .
 */

static int
test_set(const u_char *pattern, const u_char *query) {
    u_char ctest[256], c;
    const u_char *q = pattern, *p = query;
    int rev = (*++q == '^');

    bzero(ctest, 256 * sizeof(u_char));
    if  (rev) ++q;
    if  (*q == '-') ctest[*q++] = 1;
    for (c = 0; *q; c = *q++)
    {   switch (*q)
        {case '-':
            q++;
            while (c < *q) ctest[++c] = 1;
            break;
         case '\\':
            ctest[*++q] = 1;
            break;
         case ']':
            q = (u_char*)index((char*)q, '\0');
            break;
         default:
            ctest[*q] = 1;
            break;
        }
        if  (!*q) break;
    }
    while (*p) if (ctest[*p++] == rev) return(1);
    return(0);
};

static int
test_inetnet(const u_char *pattern, const u_char *query) {
    const u_char *p = query;
    int i0, i;

    /* Look for 4 integers 0..255 */
    for (i0 = 0; i0 < 4; i0++)
    {   if  (*p < '0' || *p > '9') return(1);  /* Number begin - must be digit */
        i = (int)strtol((char*)p, (char**)&p, 0);
        if  (i < 0 || i > 255) return(1);      /* 0..255 */
        if  (i0 < 3 && *p++ != '.') return(1); /* Dot if not 4 clause */
    }
    if  (*p)
    {   if  (*p++ != '/') return(1);           /* Must be / if not the end */
        if  (*p < '0' || *p > '9') return(1);  /* Number begin - must be digit */
        i = (int)strtol((char*)p, (char**)&p, 0);
        if  (i < 0 || i > 32) return(1);       /* 0..32 */
    }
    return(!(!*p));
};

static int
test_date(const u_char *pattern, const u_char *query) {
    const u_char *p = query;
    int i;

    if  (!(*p >= '0' && *p <= '9')) return(1);
    i = (int)strtol((char*)p, (char**)&p, 10);
    if  (!(i >= 1900 && i <= 2147)) return(1);
    if  (*p++ != '-') return(1);
    if  (!(*p >= '0' && *p <= '9')) return(1);
    i = (int)strtol((char*)p, (char**)&p, 10);
    if  (!(i >= 1 && i <= 12)) return(1);
    if  (*p++ != '-') return(1);
    if  (!(*p >= '0' && *p <= '9')) return(1);
    i = (int)strtol((char*)p, (char**)&p, 10);
    if  (!(i >= 1 && i <= 31)) return(1);
    return(0);
};

static int
test_macaddr(const u_char *pattern, const u_char *query) {
    u_char c;
    const u_char *p = query;
    int i0, i1;

    for (i0 = 0; i0 < 6; i0++)
    {   for (i1 = 0; i1 < 2; i1++)
        {   c = *p++;
            if  (! (  (c >= '0' && c <= '9')
                   || (c >= 'a' && c <= 'f')
                   || (c >= 'A' && c <= 'F')
                )  ) return(1);
        }
        if  (i0 < 5 && *p++ != ':') return(1);
    }
    return(!(!*p));
};

static int
test_inetaddr(const u_char *pattern, const u_char *query) {
    const u_char *p = query;
    int i0, i;

    for (i0 = 0; i0 < 4; i0++)
    {   if  (!(*p >= '0' && *p <= '9')) return(1);
        if  (i0 < 3 && *p == '0' && *(p + 1) != '.') return(1);
        i = (int)strtol((char*)p, (char**)&p, 10);
        if  (!(i >= 0 && i <= 255)) return(1);
        if  (i0 < 3 && *p++ != '.') return(1);
    }
    return(!(!*p));
};

static int
test_ascii(const u_char *pattern, const u_char *query) {
    const u_char *p = query;

    while (*p) if (!ascii[*p++]) return(1);
    return(0);
};

static int
test_koi8(const u_char *pattern, const u_char *query) {
    const u_char *p = query;

    while (*p) if (!koi[*p++]) return(1);
    return(0);
};

static int
test_eq(const u_char *pattern, const u_char *query) {
    return(strcmp((char*)++pattern, (char*)query));
};

static int
test_dummy(const u_char *pattern, const u_char *query) {
    return(0);
};

/*
 *    .
 *        :
 */

const struct getCGIparmpatterns getCGIparmpatterns[] =
{ {"[list]"  , 1, test_set      }
, {"any"     , 0, test_dummy    }
, {"8"    , 0, test_koi8     }
, {"8"    , 0, test_koi8     }
, {"ASCII"   , 0, test_ascii    }
, {"ascii"   , 0, test_ascii    }
, {"macaddr" , 0, test_macaddr  }
, {"inetaddr", 0, test_inetaddr }
, {"inetnet" , 0, test_inetnet  }
, {"=string" , 1, test_eq       }
, {"date"    , 0, test_date     }
, {NULL      , 0, NULL          }
};

int
getCGIparmpass2( BLIN_flag flags
     , const u_char * const q
     , const u_char * const unescaped
     )
{   int i, ex;
    const u_char * const empty = (const u_char *)"";

    ifBLIN_QV3(flags)
        fprintf( stderr
               , "P2 flags=%06X, q=%s~, unescaped=%s~\n"
               , flags
               , q ? q : empty
               , unescaped ? unescaped : empty
               );
    if  (!q || !*q || !unescaped)
        ex = EX_SOFTWARE;
    else if  (!*unescaped)
    {    ex = (flags & gCGI_NONL) ? EX_DATAERR : EX_OK;
    }else
    {   ex = EX_USAGE;
        for (i = 0; getCGIparmpatterns[i].name; i++)
        {   if  ( getCGIparmpatterns[i].namelen
                ? !strncmp(getCGIparmpatterns[i].name, (char*)q, getCGIparmpatterns[i].namelen)
                : !strcmp(getCGIparmpatterns[i].name, (char*)q)
                )
            {   ex = (getCGIparmpatterns[i].test_proc)(q, unescaped) ? EX_DATAERR : EX_OK;
                break;
    }   }   }
    ifBLIN_QV3(flags) fprintf(stderr, "P2 ex=%d\n", ex);
    return(ex);
}
