/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pass1.c,v 1.12 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <string.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "getCGIparm_int.h"
#include "getCGIparm.h"

#define C_er 0x80000000 /*     -                                         */
#define C_r1 0x40000000 /*   %XX  ,            */
#define C_r2 0x20000000 /*                                                                   */
#define C_d0 0x10000000 /*    %XX                                */
#define C_dd  0x8000000 /*                                */
#define C_dh  0x4000000 /*    -       */
#define C_dH  0x2000000 /*    -      */
#define C_d2   0x800000 /*                                  */
#define C_mv   0x400000 /*     -                            */
#define C_mw   0x200000 /*      -             XXXX */
#define C_bb   0x100000 /*                                                        */
#define C_zr     0x8000 /*    \0 -                                        */
#define C_cm     0x4000 /*     ,    -         *
                         *                          */
#define C_ad     0x2000 /*                                                 */
#define C_np     0x1000 /*                                                       */
#define C_xo      0x800 /*  ,                              */
#define C_in      0x200 /*     ,          */
#define C_rt      0x100 /*                                 */
#define C_state    0xFF /*                                                        */
#define C_r3  (C_r1|C_r2)
#define C_xin (C_xo|C_in)
#define C_xnp (C_xo|C_np)
#define C_zin (C_zr|C_cm|C_in|C_np)
#define C_zrt (C_zr|C_rt|C_ad)

enum states {d0, d1, d2, v0, v1, v2, vx, dx};
/* d0 -   
   d1 -    - %,  1 
   d2 -  2    
   v0 -  
   v1 -    - %,  1 
   v2 -  2    
   vx -  .
   dx -  
 */

static const char *pn[] = 
{ "er", "r1", "r2", "d0", "dd", "dh", "dH", "- "
, "d2", "mv", "mw", "bb", "- ", "- ", "- ", "- "
, "zr", "cm", "ad", "np", "xo", "rs", "in", "rt"
};
static const char *statenames[] = {"d0", "d1", "d2", "v0", "v1", "v2", "vx", "dx"};
static const char *clasnames[] = {"no", "ok", "pc", "am", "eq", "pl", "hd", "hx", "hX", "nl", "xx"};
static const enum classes class[256] =
{nl,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,ok,ok,ok,ok ,ok,pc,am,ok ,ok,ok,ok,pl ,ok,ok,ok,ok
,hd,hd,hd,hd ,hd,hd,hd,hd ,hd,hd,ok,ok ,ok,eq,ok,ok

,ok,hX,hX,hX ,hX,hX,hX,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,hx,hx,hx ,hx,hx,hx,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok

,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok

,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok ,ok,ok,ok,ok
};

static const u_int32_t automa[xx][dx] =
/* &nnn=ee&        %XX=ee         %XX=ee       eee        e%XXee          e%XXee  &nn=ee&    */
/*   ^              ^               ^           ^           ^                ^       ^       */
/*      d0 ;           d1 ;           d2 ;      v0 ;           v1 ;           v2 ;     vx  */
{{      d0 , C_er |    dx , C_er |    dx ,      v0 ,  C_er|    dx , C_er |    dx ,     vx}/*ctrl*/
,{C_mv |d0 ,C_r1|C_mv |d0 ,C_r3| C_mv|d0 ,C_mv |v0 ,C_r1|C_mv |v0 ,C_r3|C_mv |v0 ,     vx}/***/
,{C_d0 |d1 ,C_r1|      d1 ,C_r3|      d1 ,C_d0 |v1 ,C_r1|      v1 ,C_r3|      v1 ,     vx}/*%*/
,{C_xin|d0 ,      C_in|d0 , C_in |    d0 ,C_zrt|dx ,C_r1|C_zrt|dx ,C_r3|C_zrt|dx ,     d0}/*&*/
,{C_zin|vx ,C_r1|C_zin|vx ,C_r3|C_zin|vx ,C_mv |v0 ,           dx ,           dx ,     vx}/*=*/
,{C_bb |d0 ,C_r1|C_bb |d0 ,C_r3| C_bb|d0 ,C_bb |v0 ,C_r1|C_bb |v0 ,C_r3|C_bb |v0 ,     vx}/*+*/
,{C_mv |d0 , C_dd |    d2 ,C_dd |C_d2|d0 ,C_mv |v0 , C_dd |    v2 ,C_dd |C_d2|v0 ,     vx}/*digit*/
,{C_mv |d0 , C_dh |    d2 ,C_dh |C_d2|d0 ,C_mv |v0 , C_dh |    v2 ,C_dh |C_d2|v0 ,     vx}/*hex*/
,{C_mv |d0 , C_dH |    d2 ,C_dH |C_d2|d0 ,C_mv |v0 , C_dH |    v2 ,C_dH |C_d2|v0 ,     vx}/*HEX*/
,{C_xnp|dx ,     C_xnp|dx ,C_xnp |    dx ,C_zrt|dx ,C_r1|C_zrt|dx ,C_r3|C_zrt|dx ,     dx}/*\000*/
};

void
getCGIparmdebug1() {
    int i, j;

    for (i = no; i < xx; i++) {
        for (j = d0; j < dx; j++) fprintf(stderr, " %08X", automa[i][j]);
        fprintf(stderr, "\n");
}   }

int
getCGIparmpass1( BLIN_flag flags
    , const u_char ** const query
    , const u_char * const tofind
    , u_char * const unescaped
    ) {
    int q, pointer;
    u_char *p, value;
    u_int32_t control = 0;
    enum states state;
    int ex = EX_OK;
    const u_char *empty = (const u_char *)"";

    ifBLIN_QV3(flags)
        fprintf( stderr
               , "P1 flags=%06X, query=%s~, tofind=%s~, unescaped=%08lX~\n"
               , flags
               , query ? (*query ? *query : empty) : empty
               , tofind ? tofind : empty
               , (long)unescaped
               );
    /*    *query   q
     *   unescaped   p
     * pointer -   ,
     *        %XX 
     */
    q = 0;
    p = unescaped;
    pointer = q;
    value = 0;
    state = (flags & gCGI_SEPR || tofind) ? d0 : v0;
    if  (!query || !(*query)) state = dx;

    ifBLIN_QV5(flags) BLIN_STATEHEADER(stderr, pn)
    while (state < dx) {
        control = automa[class[(*query)[q]]][state];
        ifBLIN_QV5(flags)
            BLIN_STATEBODY(stderr, pn, 0, clasnames[class[(*query)[q]]], *query, q, (unsigned)p, control, statenames, state, C_state, 1)
        if  (control & C_er) ex = -EX_DATAERR;
        if  (control & C_r1) *p++ = (*query)[pointer++];
        if  (control & C_r2) *p++ = (*query)[pointer++];
        if  (control & C_d0) pointer = q;
        if  (control & C_dd) value = (value << 4) | (((*query)[q] - '0') & 0x0F);
        if  (control & C_dh) value = (value << 4) | (((*query)[q] - 'a' + 10) & 0x0F);
        if  (control & C_dH) value = (value << 4) | (((*query)[q] - 'A' + 10) & 0x0F);
        if  (  control & C_d2
            && (~flags & gCGI_NOCR || ((value & 0xFF) != '\r'))
            && (~flags & gCGI_NOLF || ((value & 0xFF) != '\n'))
            ) *p++ = value & 0xFF;
        if  (control & C_mv) *p++ = (*query)[q];
        if  (control & C_bb) *p++ = ' ';
        if  (control & C_zr) *p++ = '\0';
        if  (control & C_cm) {
            if  (flags & gCGI_SEPR) {
                control = v0;
                *(p - 1) = '=';
                ex = p - unescaped;
            } else if (!strcmp((char*)unescaped, (char*)tofind)) control = C_in | C_np | v0;
        }
        ifBLIN_QV4(flags) {
            int i;

            for (i = 0; unescaped + i < p; i++) fprintf(stderr, "%c", unescaped[i]);
            fprintf(stderr, "\n");
        }
        if  (control & C_xo && flags & gCGI_SEPR) control = C_ad | C_rt | C_np | dx;
        if  (control & C_in) p = unescaped;
        if  (control & C_np) *p = '\0';
        if  (~control & C_ad) q++;
        state = control & C_state;
    }
    p = unescaped;
    if  (query && *query) *query += q;
    if  (~control & C_rt) {
        *p = '\0';
        ex = -EX_DATAERR;
    }
    ifBLIN_QV3(flags) fprintf(stderr, "P1 ex=%d %08X ~%s~%s~\n", ex, control, p, *query);
    return(ex);
}
