/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: getCGIparm.h,v 1.14 2013/01/26 11:44:33 babolo Exp $
 */

#ifndef _GETCGIPARM_H_
#define _GETCGIPARM_H_

__BEGIN_DECLS

#define gCGI_DOER    0x000001   /* Error indicate when parameter not found */
#define gCGI_MATC    0x000002   /* Non-matching result is error            */
#define gCGI_NONL    0x000004   /* Empty result string is error            */
#define gCGI_ERRMASK 0x000007
#define gCGI_RNUM    0x000008   /* First column is number in COPY TO       */
#define gCGI_TEXT    0x000010   /* errform is text                         */
#define gCGI_FILE    0x000020   /* errform is filename with text           */
#define gCGI_FORM    0x000040   /* errform is filename of errors formats   */
#define gCGI_OUTMASK 0x000070
#define gCGI_NOCR    0x000100   /* Delete CR on output                     */
#define gCGI_NOLF    0x000200   /* Delete LF on output                     */
#define gCGI_OTST    0x000400   /* No output - test only                   */
#define gCGI_ZERO    0x000800   /* Empty parameter will be substituted     */
#define gCGI_EOPT    0x002000   /*    ( )*/
#define gCGI_OPEN    0x004000   /* tofind on pass4 has * at end            */
#define gCGI_SEPR    0x008000   /* Separate name and value                 */

struct getCGIparmpatterns {
    char      *name;
    int     namelen;
    int (*test_proc)(const u_char *pattern, const u_char *query);
};

struct getCGIparmquotens {
    char      *name;
    int     namelen;
    int (*test_proc)(const u_char *pattern, const u_char *query, u_char **result);
};

extern const struct getCGIparmpatterns getCGIparmpatterns[];
extern const struct getCGIparmquotens  getCGIparmquotens[];

int getCGIparmpass1  __P(( BLIN_flag flags, const u_char **const query
                         , const u_char *const tofind, u_char *const unescaped
                        ));
int getCGIparmpass2  __P((BLIN_flag flags, const u_char *pattern, const u_char *unescaped));
int getCGIparmpass3  __P((BLIN_flag flags, const u_char *const quoten, u_char **const unescaped));
void getCGIparmpass4 __P(( BLIN_flag flags, const u_char *totype, const u_char *toname
                         , const u_char *errform, FILE *errout
                        ));
int getCGIparmcopy   __P(( BLIN_flag flags, const u_char *query
                         , const u_char *pattern
                         , const u_char *query_delimit, const u_char *null_sign
                         , int(*wri)(int outf, const void *buf, size_t size), int outf
                        ));
int getCGIparmenv    __P(( BLIN_flag flags, const u_char *const *const envp
                         , const u_char *pattern
                         , const u_char *query_delimit, const u_char *null_sign
                         , int(*wri)(int outf, const void *buf, size_t size), int outf
                        ));
int getCGIparmarray  __P(( BLIN_flag flags, u_char *const *const args
                         , const u_char *pattern
                         , const u_char *query_delimit, const u_char *null_sign
                         , int(*wri)(int outf, const void *buf, size_t size), int outf
                        ));
int getCGIparmopt    __P(( BLIN_flag flags, u_char *const *const argv, const u_char *opts
                         , const u_char *pattern
                         , const u_char *query_delimit, const u_char *null_sign
                         , int(*wri)(int outf, const void *buf, size_t size), int outf
                        ));
int getCGIparmproc   __P(( BLIN_flag flags
                         , const u_char *pattern
                         , const u_char *query_delimit, const u_char *null_sign
                         , int(*wri)(int outf, const void *buf, size_t size), int outf
                        ));

__END_DECLS

#endif /* !_GETCGIPARM_H_ */
