/*-
 * Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2000, 2001, 2002 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: getCGIparm.c,v 1.22 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#define lCGI_HOVR    0x001000   /* Hack ON - use SERVER_PROTOCOL           */
#define lCGI_RTRY    0x002000   /* Retry if empty parameter found          */
#define lCGI_ARGS    0x004000   /* get args                                */
#define lCGI_GENV    0x008000   /* get environment                         */
#define lCGI_PROC    0x010000   /* get proc                                */

#include <sys/types.h>
#include <sysexits.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <time.h>
#include <mife.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "getCGIparm.h"

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;
extern int optreset;

void
usage(int ex) {
    int i;
    fprintf(stderr,
           "getCGIparm " VERS "  " DATE " @BABOLO http://www.babolo.ru/\n"
           "getCGIparm [aAEHinNpPrtvx]"
           "[-c text][-e file][-f file][-q quoten][-w amp_subst][-z subst] pattern [name]\n"
           "known patterns:"
          );
    for (i = 0; getCGIparmpatterns[i].name; i++)
        fprintf(stderr, " %s", getCGIparmpatterns[i].name);
    fprintf(stderr, "\nknown quotens:");
    for (i = 0; getCGIparmquotens[i].name; i++)
        fprintf(stderr, " %s", getCGIparmquotens[i].name);
    fprintf(stderr, "\n"
           " -a retry find nonempty parameter\n"
           " -A args COPY TO\n"
           " -c error text\n"
           " -f error message file\n"
           " -e error messages file\n"
           " -E environment COPY TO\n"
           " -H use SERVER_PROTOCOL in addition to QUERY_STRING\n"
           " -i proc COPY TO\n"
           " -n delete LF\n"
           " -N numerate rows in COPY TO\n"
           " -p pipe from stdin\n"
           " -P output for PostgreSQL's COPY\n"
           " -r no CR\n"
           " -t test mode - no output\n"
           " -v verbose\n"
           " -w alternate &\n"
           " -x[x[x]] strictness levels\n"
           " -z text instead empty parameter\n"
          );
    exit(ex);
};

int
main(int argc, char **argv, char **envp) {
#define INBUF 1048576
    const u_char *query = (const u_char *)getenv("QUERY_STRING");
    const char *proto = getenv("SERVER_PROTOCOL");
    u_char *const *const varg = (u_char **)argv;
    u_char *unescaped, *p, *q;
    int i, ex = EX_OK, ch;
    const char *empty = "";
    u_char *quot, *zero, *query_delimit;
    char *errform;
    BLIN_flag flags;
    u_int32_t lflag;
    int out;
    mife_descriptor *in = NULL;

#ifdef DEBUG
# if DEBUG > 1
#  include "getCGIparm_int.h"
    getCGIparmdebug1();
# endif
#endif
#ifdef SPY
    {   FILE *spy;
        const char *empty = "";
        int i;
# ifdef DEBUG
        spy = stderr;
# else
        spy = fopen(SPY, "a");
# endif
        if  (spy) {
            for (i = 0; i < argc; i++)
                fprintf(spy, "%s~", argv[i]);
            fprintf( spy, "\nQUERY_STRING=%s~\nSERVER_PROTOCOL=%s~\n"
                   , query ? query : (const u_char *)empty
                   , proto ? proto : empty
                   );
# ifndef DEBUG
            fclose(spy);
# endif
    }   }
#endif
    flags = 0;
    lflag = 0;
    quot = NULL;
    zero = NULL;
    errform = NULL;
    query_delimit = NULL;
    while ((ch = getopt(argc, argv, "aAc:e:Ef:hHinNpPq:rtvw:xz:")) != EOF)
        switch (ch) {
         case 'a': lflag |= lCGI_RTRY;              break;
         case 'A': lflag |= lCGI_ARGS;              break;
         case 'c': errform = optarg;
                   flags &= ~gCGI_OUTMASK;
                   flags |= gCGI_TEXT;
                                                    break;
         case 'e': errform = optarg;
                   flags &= ~gCGI_OUTMASK;
                   flags |= gCGI_FORM;
                                                    break;
         case 'E': lflag |= lCGI_GENV;              break;
         case 'f': errform = optarg;
                   flags &= ~gCGI_OUTMASK;
                   flags |= gCGI_FILE;
                                                    break;
         case 'h': usage(ex);                       break;
         case 'H': if  (proto == NULL) {
                       ifBLIN_QV1(flags) warnx("SERVER_PROTOCOL absent");
                       exit(EX_USAGE);
                   }
                   if  (strncmp(proto, "HTTP", 4)) {
                       q = malloc(strlen((char*)query) + strlen(proto) + 2);
                       strcpy((char*)q, (char*)query);
                       strcat((char*)q, " ");
                       strcat((char*)q, proto);
                       p = (u_char*)strstr((char*)q, " HTTP");
                       if (p) *p = '\0';
                       query = q;
                   };                               break;
         case 'i': lflag |= lCGI_PROC;              break;
         case 'p': if (!(in = mife_opef(MIFE_FULL, fileno(stdin))))         err(EX_IOERR, "mife_opef");
                   if (mife_read(in, 0, 0) < 0)                             err(EX_IOERR, "mife_read");
                   if (!(query = mife_get(in, 0)))                           err(EX_IOERR, "mife_get");
                                                    break;
         case 'P': flags |= gCGI_SEPR;              break;
         case 'q': quot = (u_char*)optarg;          break;
         case 'n': flags |= gCGI_NOLF;              break;
         case 'N': flags |= gCGI_RNUM;              break;
         case 'r': flags |= gCGI_NOCR;              break;
         case 't': flags |= gCGI_OTST;              break;
         case 'v': BLIN_VERBOSE(flags);             break;
         case 'w': query_delimit = (u_char*)optarg; break;
         case 'x': flags |= (flags << 1) & gCGI_ERRMASK;
                   flags |= gCGI_DOER;
                                                    break;
         case 'z': flags |= gCGI_ZERO;
                   zero = (u_char*)optarg;
                                                    break;
         default:  usage(EX_USAGE);
        }
    argc -= optind;
    argv += optind;
    ifBLIN_QV1(flags) {
        for (i = 0; i < argc; i++) fprintf(stderr, "[%d]=%s~\n", i, argv[i]);
        fprintf( stderr, "QUERY_STRING=%s~\nSERVER_PROTOCOL=%s~\n"
               , query ? query : (const u_char *)empty
               , proto ? proto : empty
               );
    }

    if  (argc > 0 && !argv[0]) usage(EX_USAGE);
    if  (argc > 1 && !argv[1]) usage(EX_USAGE);
    if  (argc > 2) usage(EX_USAGE);
    out = fileno(stdout);
    if  (flags & gCGI_SEPR || lflag & lCGI_ARGS || lflag & lCGI_GENV || lflag & lCGI_PROC) {
        if  (!query_delimit) query_delimit = (u_char *)"\t";
        p = (u_char*)((argc > 1) ? argv[1] : "\\N");
        q = (u_char*)((argc > 0) ? argv[0] : "any");
        if  (flags & gCGI_SEPR) {
            ex = getCGIparmcopy(flags, query, q, query_delimit, p, mife_writ, out);
        } else if (lflag & lCGI_GENV) {
            ex = getCGIparmenv(flags, (const u_char **)envp, q, query_delimit, p, mife_writ, out);
        } else if (lflag & lCGI_ARGS) {
            ex = getCGIparmarray(flags, varg, q, query_delimit, p, mife_writ, out);
        } else if (lflag & lCGI_PROC) {
            ex = getCGIparmproc(flags, q, query_delimit, p, mife_writ, out);
        }
        if  (ex) getCGIparmpass4(flags, (u_char*)argv[0], NULL, (u_char*)errform, stderr);
        exit(ex);
    }
    if  (argc == 0) usage(EX_USAGE);

    unescaped = malloc(strlen((char*)query) * (query_delimit ? strlen((char*)query_delimit) : 1) + 1);
    if  (!unescaped)                                                       errx(EX_TEMPFAIL, "malloc");
    p = unescaped;
    i = 0;

    for (;;) {
        ex = getCGIparmpass1(flags, &query, (u_char*)((query_delimit) ? NULL : argv[1]), p);
        ifBLIN_QV1(flags) fprintf(stderr, "pass1 = %d\n", ex);
        if  (ex < 0 || *query++ != '&') break;
        if  (query_delimit) p = (u_char*)index(strcat((char*)unescaped, (char*)query_delimit), '\0');
        else if (lflag & lCGI_RTRY && !*unescaped) i++;
        else break;
    }

    if  (ex && i) {
        *unescaped = '\0';
        ex = EX_OK;
    }

    if  (!ex) {
        ex = getCGIparmpass2(flags, (u_char*)argv[0], unescaped);
        if  (!ex) {
            ex = getCGIparmpass3(flags, quot, &unescaped);
            if  (!ex && flags & gCGI_NONL && !*unescaped) ex = EX_DATAERR;
        } else if (~flags & gCGI_MATC) {
            *unescaped = '\0';
            ex = EX_OK;
        }
    } else if (~flags & gCGI_DOER) ex = EX_OK;

    if  (ex) getCGIparmpass4(flags, (u_char*)argv[0], (u_char*)argv[1], (u_char*)errform, stderr);
    else if (~flags & gCGI_OTST) printf("%s", (flags & gCGI_ZERO && !*unescaped) ? zero : unescaped);

#ifdef SPY
    {   FILE *spy;
        time_t t;
# ifdef DEBUG
        spy = stderr;
# else
        spy = fopen(SPY, "a");
# endif
        if  (spy) {
            t = time(NULL);
            fprintf( spy, "%04X, %2d, OUT=%s~\n%s\n"
                   , flags, ex, (flags & gCGI_ZERO && !*unescaped) ? zero : unescaped, ctime(&t)
                   );
# ifndef DEBUG
            fclose(spy);
# endif
    }   }
#endif
    exit(ex);
}
