/*-
 * Copyright (C)2003..2007 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2003 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: copyout.c,v 1.12 2013/01/26 11:44:33 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sysexits.h>
#include <dirent.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <mife.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "getCGIparm.h"

#define PROCDIR "/proc/"
#define CMDLINE "/cmdline"
#define PIDLENG 8
#define TOTALEN (strlen(PROCDIR) + PIDLENG + strlen(CMDLINE) + 1)
#define	BADCH	(int)'?'

static FILE *
dostream(int(*wri)(int out, const void *buf, size_t size), int outf) {
    return(fwopen((void *)outf, (int(*)(void *, const char *, int))wri));
}

static int
/************************************
 * Test dirent for right PID name
 * < 0 = not PID name
 * > 0 = error
 * = 0 true PID name
 ************************************/
detest(struct dirent *dp) {
    int i, ex = EX_OK;

    if  (dp->d_namlen > PIDLENG) ex = EX_OSERR;
    for (i = 0; ex == EX_OK; i++) {
        if  (i == dp->d_namlen) {
            if  ((dp->d_name[i])) ex = EX_OSERR;
            break;
        }
        if  (dp->d_name[i] < '0' || dp->d_name[i] > '9') ex = -1;
    }
    return(ex);
}

int
getCGIparmproc( BLIN_flag flags
    , const u_char * const tofind
    , const u_char * const query_delimit
    , const u_char * const null_sign
    , int(*wri)(int dout, const void *buf, size_t size), int dout
    ) {
    u_char *f1 = NULL, *p, *n;
    int i, ex = EX_OK;
    const u_char *empty = (const u_char *)"";
    FILE *outf;
    DIR *dirp;
    struct dirent *dp;
    mife_descriptor *md;
    char dname[TOTALEN + 1];
    ssize_t argl;

    if  (!query_delimit || !null_sign) return(EX_DATAERR);
    if  (!(outf = dostream(wri, dout))) {
        ifBLIN_QV1(flags) warn("Can\'t open out file in getCGIparmproc");
        return(-1);
    }
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "PC flags=%08X, tofind=%s~, query_delimit=%s~, null_sign=%s~\n"
               , flags
               , tofind ? tofind : empty
               , query_delimit
               , null_sign
               );

    if  (!(dirp = opendir(PROCDIR))) {
        ifBLIN_QV1(flags) warn("Can\'t open %s in getCGIparmproc", PROCDIR);
        return(-1);
    }
    ex = EX_OK;
    while ((dp = readdir(dirp)) != NULL) {
        int e;

        e = detest(dp);
        if  (e > 0) {
            ex = e;
        } else if (!e) {
            if  (snprintf(dname, TOTALEN, PROCDIR "%s" CMDLINE, dp->d_name) > TOTALEN) {
                ex = EX_OSERR;
            } else {
                if  (!(md = mife_open(MIFE_PIPE, dname))) {
                    ifBLIN_QV1(flags) warn("mife open");
                    ex = EX_IOERR;
                } else if ((argl = mife_read(md, 0, 0)) < 0) {
                    ifBLIN_QV1(flags) warn("mife read");
                    ex = EX_IOERR;
                } else if (!(n = p = mife_get(md, 0))) {
                    ifBLIN_QV1(flags) warn("mife get");
                    ex = EX_IOERR;
                } else {
                    for (i = 0; p - n < argl; i++) {
                        ifBLIN_QV4(flags) fprintf(stderr, "[%d]=%s~\n", i, p);
                        f1 = p;
                        if  (!(ex = getCGIparmpass2(flags, tofind, p)) && ~flags & gCGI_OTST) {
                            if  (!(ex = getCGIparmpass3(flags, (const u_char*)"copy", &p))) {
                                fprintf(outf, "%s%s%d%s", dp->d_name, query_delimit, i, query_delimit);
                                fprintf(outf, "%s\n", p);
                                if  (p && f1 && p != f1) {
                                    free(p);
                                    p = f1;
                        }   }   }
                        if  (p && f1 && p != f1) free(p);
                        f1 = NULL;
                        p = (u_char*)index((char*)p, 0) + 1;
                }   }
                mife_close(md);
    }   }   }
    if  (~flags & gCGI_OTST) fprintf(outf, "\\.\n");
    ifBLIN_QV3(flags) fprintf(stderr, "PC ex=%d\n", ex);
    closedir(dirp);
    fclose(outf);
    return(ex);
}

int
getCGIparmopt( BLIN_flag flags
    , u_char * const * const args
    , const u_char * const opts
    , const u_char * const tofind
    , const u_char * const query_delimit
    , const u_char * const null_sign
    , int(*wri)(int dout, const void *buf, size_t size), int dout
    ) {
    u_char *a, *p, *q, t[2] = "\0\0";
    const u_char *f1 = NULL, *f2 = NULL;
    int i, j, ex = EX_OK;
    const u_char * const empty = (const u_char *)"";
    FILE *outf;

    if  (!args || !opts || !query_delimit || !null_sign) return(EX_DATAERR);
    if  (!(outf = dostream(wri, dout))) {
        ifBLIN_QV1(flags) warn("Can\'t open out file in getCGIparmopt");
        return(-1);
    }
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "OP flags=%08X, opts=%s~, tofind=%s~, query_delimit=%s~, null_sign=%s~\n"
               , flags, opts
               , tofind ? tofind : empty
               , query_delimit
               , null_sign
               );
    for (i = 0, j = 0; !ex && (p = args[j]) && *p == '-';) {
        j++;
        ifBLIN_QV4(flags) fprintf(stderr, "p=%s~\n", p);
        if  (*++p == '-') break;
        for (; !ex && *p && (t[0] = *(p++)); i++) {
        ;   ifBLIN_QV4(flags) fprintf(stderr, "  t=%s~\n", t);
        ;   q = NULL;
        ;   f1 = f2 = NULL;
        ;   if  (t[0] == ':' || !(a = (u_char*)strchr((char*)opts, t[0]))) {
        ;       if  (t[0] == '-') { ex = -j; break;}
        ;       if  (~flags & gCGI_EOPT) t[0] = BADCH;
        ;   } else if (*++a == ':') {
        ;       if  (*p) {
        ;           q = p;
        ;           p = (u_char*)empty;
        ;       } else if (args[j]) {
        ;           q = args[j++];
        ;       } else if (~flags & gCGI_EOPT) {
        ;           q = (u_char *)":";
        ;   }   }
        ;   ifBLIN_QV4(flags) fprintf(stderr, ". t=%s%s%s~\n", t, q ? " q=" : "", q ? q : (u_char*)"");
        ;   if  (q && (ex = getCGIparmpass2(flags, tofind, q)) && ~flags & gCGI_OTST) break;
        ;   f1 = a = t;
        ;   if  (a && (ex = getCGIparmpass3(flags, (const u_char*)"copy", &a))) break;
        ;   f2 = q;
        ;   if  (q && (ex = getCGIparmpass3(flags, (const u_char*)"copy", &q))) break;
        ;   if  (flags & gCGI_RNUM) fprintf(outf, "%d%s", i, query_delimit);
        ;   fprintf(outf, "%s%s", a ? a : null_sign, query_delimit);
        ;   fprintf(outf, "%s\n", q ? q : null_sign);
        ;   if  (a && f1 && a != f1) { free(a); a = NULL;}
        ;   if  (q && f2 && q != f2) { free(q); q = NULL;}
        }
        if  (a && f1 && a != f1) { free(a); a = NULL;}
        if  (q && f2 && q != f2) { free(q); q = NULL;}
    }
    if  (~flags & gCGI_OTST) fprintf(outf, "\\.\n");
    ifBLIN_QV3(flags) fprintf(stderr, "OP ex=%d j=%d\n", ex, j);
    fclose(outf);
    return(ex ? ex : -j);
}

int
getCGIparmcopy( BLIN_flag flags
    , const u_char * query
    , const u_char * const tofind
    , const u_char * const query_delimit
    , const u_char * const null_sign
    , int(*wri)(int dout, const void *buf, size_t size), int dout
    ) {
    u_char *unescaped, *p, *q, *f1, *f2;
    int i, ex = EX_OK;
    const u_char *const empty = (const u_char *)"";
    FILE *outf;

    if  (!query_delimit || !null_sign) return(EX_DATAERR);
    if  (!(outf = dostream(wri, dout))) {
        ifBLIN_QV1(flags) warn("Can\'t open out file in getCGIparmcopy");
        return(-1);
    }
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "CP flags=%08X, query=%s~, tofind=%s~, query_delimit=%s~, null_sign=%s~\n"
               , flags
               , query ? query : empty
               , tofind ? tofind : empty
               , query_delimit
               , null_sign
               );
    if  (query) {
    ;   if  (!(unescaped = malloc(strlen((char*)query) + 1)))                      return(EX_TEMPFAIL);
    ;   f1 = f2 = q = NULL;

    ;   for (i = 0; !ex; i++) {
    ;   ;   f1 = f2 = q = NULL;
    ;   ;   p = unescaped;
    ;   ;   ex = getCGIparmpass1(flags, &query, NULL, p);
    ;   ;   ifBLIN_QV4(flags) fprintf(stderr, "pass1 = %d\n", ex);
    ;   ;   if  (ex < 0) break;
    ;   ;   ifBLIN_QV4(flags) fprintf(stderr, "p=%s~\n", p);
    ;   ;   if (ex > 0) {
    ;   ;       p[ex - 1] = '\0';
    ;   ;       q = (u_char*)index((char*)p, '\0') + 1;
    ;   ;       ex = 0;
    ;   ;       ifBLIN_QV4(flags) fprintf(stderr, "p=%s~ q=%s~\n", p, q);
    ;   ;   } else {
    ;   ;       q = p;
    ;   ;       p = NULL;
    ;   ;       ifBLIN_QV4(flags) fprintf(stderr, "p=NULL q=%s~\n", q);
    ;   ;   }
    ;   ;   if  (!(ex = getCGIparmpass2(flags, tofind, q)) && ~flags & gCGI_OTST) {
    ;   ;       f1 = p;
    ;   ;       if  (p && (ex = getCGIparmpass3(flags, (const u_char *)"copy", &p))) break;
    ;   ;       f2 = q;
    ;   ;       if  ((ex = getCGIparmpass3(flags, (const u_char *)"copy", &q))) break;
    ;   ;       if  (flags & gCGI_RNUM) fprintf(outf, "%d%s", i, query_delimit);
    ;   ;       if  (!p) fprintf(outf, "%s%s", null_sign, query_delimit);
                  else fprintf(outf, "%s%s", p, query_delimit);
    ;   ;       fprintf(outf, "%s\n", q);
    ;   ;       if  (p && p != f1) {free(p); p = NULL;}
    ;   ;       if  (q && q != f2) {free(q); q = NULL;}
    ;   ;   }
    ;   ;   if  (ex > 0 || *query++ != '&') break;
    ;   }
    ;   if  (p && f1 && p != f1) free(p);
    ;   if  (q && f2 && q != f2) free(q);
    ;   free(unescaped);
    }
    if  (~flags & gCGI_OTST) fprintf(outf, "\\.\n");
    ifBLIN_QV3(flags) fprintf(stderr, "CP ex=%d\n", ex);
    fclose(outf);
    return(ex);
}

int
getCGIparmenv( BLIN_flag flags
    , const u_char * const * const envp
    , const u_char * const tofind
    , const u_char * const query_delimit
    , const u_char * const null_sign
    , int(*wri)(int dout, const void *buf, size_t size), int dout
    ) {
    u_char *unescaped, *p, *q, *f1, *f2;
    int i, agrmax, k, ex = EX_OK;
    const u_char *empty = (const u_char *)"";
    FILE *outf;

    if  (!envp || !query_delimit || !null_sign) return(EX_DATAERR);
    if  (!(outf = dostream(wri, dout))) {
        ifBLIN_QV1(flags) warn("Can\'t open out file in getCGIparmenv");
        return(-1);
    }
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "EN flags=%08X, tofind=%s~, query_delimit=%s~, null_sign=%s~\n"
               , flags
               , tofind ? tofind : empty
               , query_delimit
               , null_sign
               );
    for (i = 0, agrmax = 0; envp && envp[i]; i++) {
        ifBLIN_QV4(flags) fprintf(stderr, "%s~\n", envp[i]);
        k = strlen((char*)(envp[i]));
        if  (k > agrmax) agrmax = k;
    }
    unescaped = malloc(agrmax + 1);
    if  (!unescaped)                                                               return(EX_TEMPFAIL);
    f1 = f2 = NULL;

    for (i = 0; !ex && envp[i]; i++) {
        f1 = f2 = NULL;
        q = unescaped;
        strlcpy((char*)unescaped, (char*)(envp[i]), agrmax);
        p = (u_char*)strsep((char**)&q, "=");
        if  (!q) {
            q = p;
            p = NULL;
        }
        ifBLIN_QV4(flags) fprintf(stderr, "p=%s~ q=%s~\n", p, q);
        if  (!(ex = getCGIparmpass2(flags, tofind, q)) && ~flags & gCGI_OTST) {
            f1 = p;
            if  (p && (ex = getCGIparmpass3(flags, (const u_char *)"copy", &p))) break;
            f2 = q;
            if  ((ex = getCGIparmpass3(flags, (const u_char *)"copy", &q))) break;
            if  (flags & gCGI_RNUM) fprintf(outf, "%d%s", i, query_delimit);
            if  (!p) fprintf(outf, "%s%s", null_sign, query_delimit);
              else fprintf(outf, "%s%s", p, query_delimit);
            fprintf(outf, "%s\n", q);
            if  (p && p != f1) {free(p); p = NULL;}
            if  (q && q != f2) { free(q); q = NULL;}
    }   }
    if  (p && f1 && p != f1) free(p);
    if  (q && f2 && q != f2) free(q);
    if  (~flags & gCGI_OTST) fprintf(outf, "\\.\n");
    free(unescaped);
    ifBLIN_QV3(flags) fprintf(stderr, "EN ex=%d\n", ex);
    fclose(outf);
    return(ex);
}

int
getCGIparmarray( BLIN_flag flags
    , u_char * const * const args
    , const u_char * const tofind
    , const u_char * const query_delimit
    , const u_char * const null_sign
    , int(*wri)(int dout, const void *buf, size_t size), int dout
    ) {
    const u_char *f1 = NULL;
    u_char *p;
    int i, ex = EX_OK;
    const u_char *empty = (const u_char *)"";
    FILE *outf;

    if  (!args || !query_delimit || !null_sign) return(EX_DATAERR);
    if  (!(outf = dostream(wri, dout))) {
        ifBLIN_QV1(flags) warn("Can\'t open out file in getCGIparmarray");
        return(-1);
    }
    ifBLIN_QV3(flags)
        fprintf( stderr
               , "AR flags=%08X, tofind=%s~, query_delimit=%s~, null_sign=%s~\n"
               , flags
               , tofind ? tofind : empty
               , query_delimit
               , null_sign
               );

    for (i = 0; !ex && args[i]; i++) {
        p = args[i];
        f1 = p;
        ifBLIN_QV4(flags) fprintf(stderr, "p=%s~\n", p);
        if  (!(ex = getCGIparmpass2(flags, tofind, p)) && ~flags & gCGI_OTST) {
            if  (!(ex = getCGIparmpass3(flags, (const u_char *)"copy", &p))) {
                fprintf(outf, "%d%s", i, query_delimit);
                if  (flags & gCGI_RNUM) fprintf(outf, "%s%s", null_sign, query_delimit);
                fprintf(outf, "%s\n", p);
                if  (p && p != f1) {
                    free(p);
                    p = NULL;
    }   }   }   }
    if  (p && f1 && p != f1) free(p);
    if  (~flags & gCGI_OTST) fprintf(outf, "\\.\n");
    ifBLIN_QV3(flags) fprintf(stderr, "AR ex=%d\n", ex);
    fclose(outf);
    return(ex);
}
