#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/sysctl.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <syslog.h>
#include <sys/types.h>

#include <net/if.h>
#include <net/if_dl.h>
#include <net/if_types.h>
#include <net/route.h>

/* IP */
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "auto.h"
#include <mife.h>

#ifndef MAXROUTENET
#define MAXROUTENET 1000
#endif

typedef struct Rnet	{u_int32_t	gateway           ;
                        u_int32_t       addr;
                        u_int32_t       netmask;
			int		notallow;} Routenet;

typedef struct Rnet     *Rnpointer;
typedef Rnpointer        *Ppointer;

Rnpointer		RnetNow,RnetTask;
Ppointer		IndexNow,IndexTask;
Ppointer		IndexDel,IndexCr;

int                     NowN, TaskN;
int			DelN,CrN;
int                     MaxRoute = MAXROUTENET;  
int                     e_sysctl = ERROR_SYSCTL;
int			t_out	 = TOUT;
int			sock;
#define ROUNDUP(a) \
        ((a) > 0 ? (1 + (((a) - 1) | (sizeof(long) - 1))) : sizeof(long))
#define ADVANCE(x, n) (x += ROUNDUP((n)->sa_len))


/* The Comparison function for pointers of Interfaces */
int comparison(Ppointer pointer1, Ppointer pointer2) {

if (ntohl((*pointer1)->addr) > ntohl((*pointer2)->addr))
        {
        return 1;
        }
if (ntohl((*pointer1)->addr) < ntohl((*pointer2)->addr))
        {
        return -1;
        }
if ((*pointer1)->netmask > (*pointer2)->netmask)
        {
        return 1;
        }
if ((*pointer1)->netmask < (*pointer2)->netmask)
        {
        return -1;
        }
if (ntohl((*pointer1)->gateway) > ntohl((*pointer2)->gateway))
        {
        return 1;
        }
if (ntohl((*pointer1)->gateway) < ntohl((*pointer2)->gateway))
        {
        return -1;
        }
return 0;
}

/* The Comparison function for pointers of Interfaces which sees if only a gateway differs */
int comparison_gate(Ppointer pointer1, Ppointer pointer2) {

if (((*pointer1)->addr == (*pointer2)->addr) && ((*pointer1)->netmask == (*pointer2)->netmask) && ((*pointer1)->gateway !=(*pointer2)->gateway) )
	{
	return 1;
	}
return 0;
}

/* Funtion, which takes the task */
int addTask(void){  
        
    int st=S_i1_1;
    int newst;
    int flag=0;
    struct mife_descriptor *in;
    u_char *q;
    int ip=0,gate=0;
    int ipN=0,maskN=0;
    int j;
    int i;
    int wrongconfig=0;

/* Preparing the Input Stream */
    if (!(in=mife_opef(MIFE_FULL, fileno(stdin)))) {
        syslog (LOG_ALERT,"Reading Task failed: %m");
        exit(-1);
    }
    if (mife_read(in, 0, 0, NULL) <= 0 || !(q = mife_get(in, 0))) {
        syslog(LOG_ALERT,"MIFE ERROR READING: %m");
        exit(-1);
    }

/*  Initialization */
    TaskN=0;
    if ((RnetTask = (Rnpointer)malloc(sizeof(Routenet)*MaxRoute))==NULL) {
        syslog(LOG_ALERT,"Malloc Error\n");
        exit(-1);
    }

/* Consuming Task */
    while (*q != '\0') {
        newst=automat[st][symbol[*q]];
	if (newst==S_sleoip)
	    if (flag) newst=S_err; else newst=S_m1|C_adip;
	if (newst==S_nleoip)
	    if (flag) newst=S_i1_1|C_adip|C_rec; else newst=S_i1_1|C_nl;

	if ((newst!=S_err) & (st=S_err)) {
            syslog (LOG_WARNING,"Error in TaskStream: %m");
        } 
        if (newst&C_anip) {
            ipN=ipN*10+(*q-48);
        }
        if (newst&C_adip) {
            if (!flag) ip=ip*256+ipN; else gate=gate*256 + ipN;
            ipN=0;
        }
        if (newst&C_md) {
            maskN=maskN*10+(*q-48);
        }
        if (newst&C_rec) {
                RnetTask[TaskN].addr=htonl(ip);
		RnetTask[TaskN].gateway=htonl(gate);
		RnetTask[TaskN].notallow=0;
                if (maskN==0) {
		    RnetTask[TaskN].netmask=htonl(0x00000000);
		}
                else {
		    RnetTask[TaskN].netmask=htonl(((0xffffffff)<<(32-maskN)));
		}
                TaskN++;
                if (TaskN>MaxRoute-1) {
                   MaxRoute =MaxRoute*2;
                    if ((RnetTask=(Rnpointer)realloc(RnetTask,sizeof(Routenet)*MaxRoute))==NULL){
                        syslog(LOG_ALERT,"Realloc Error\n");
                        exit(-1);
                    }
		}
            ip=0;
            maskN=0;
	    gate=0;
	    flag=0;
        }
	if (newst&C_nl) {
	    flag=0;
	    ip=0;
	    ipN=0;
	    gate=0;
	    maskN=0;
	} 
	if (newst&C_sflag) {
	    flag=1;
        }
        st=newst&0xFF;
        q++;
    }
    if ((RnetTask = (Rnpointer)realloc(RnetTask,sizeof(Routenet)*TaskN))==NULL){
        syslog(LOG_ALERT,"Realloc Error\n");
        exit(-1);
    }
    if ((IndexTask=(Ppointer)malloc(sizeof(Rnpointer)*TaskN))==NULL){
        syslog(LOG_ALERT,"Malloc Error\n");
        exit(-1);
    }
    for (i=0;i<TaskN;i++) {
        IndexTask[i]=&RnetTask[i];
    }
    qsort((void **) IndexTask, TaskN, sizeof(Rnpointer), (int (*)(const void *, const void *))comparison);
    for (i=1;i<TaskN;i++) {
	if (comparison(IndexTask+i,IndexTask+i-1) == 0)
	    (*IndexTask[i]).notallow=1;
    }
    for (i=1;i<TaskN;i++) {
	if (comparison_gate(IndexTask+i,IndexTask+i-1) == 1) {
	    (*IndexTask[i]).notallow=1;
	    if (wrongconfig==0) syslog(LOG_ALERT,"WRONG Configuration - Same Net, but different gateways");
	    wrongconfig++;
	}
    }
    return 0;
}

int addNow(void){
    int     i;   
    size_t  needed;
    int     mib[6];
    int     errnumber,errorprevious;
    char    *buf, *lim, *next;
    struct  sockaddr_in *sin;
    int     j;
    struct  rt_msghdr	*rtm;            
    struct  sockaddr	*sa;
    struct  in_addr	in;            
    char 	*cp;
    /* Retrieving Configuration */
    mib[0]=CTL_NET;
    mib[1]=PF_ROUTE;
    mib[2]=0;
    mib[3]=AF_INET;
    mib[4]=NET_RT_DUMP;
    mib[5]=0;


    errnumber=1;
    errorprevious = 0;
    while (errnumber>errorprevious) {
        errorprevious = errnumber;
        if  (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0) {
            syslog (LOG_WARNING,"sysctl-estimate error");
            errnumber++;
            if (errnumber>e_sysctl) {
                syslog(LOG_ALERT,"Failed to acquire via Sysctl()\n");
                exit(-1);
            }
        }
        if ((buf = malloc(needed)) == NULL) {
            syslog (LOG_ALERT,"malloc error");
            exit(-1);
        }
        if (sysctl(mib, 6, buf, &needed, NULL, 0) <0) {
            syslog (LOG_WARNING,"actual retrival error");
            errnumber++;
            if (errnumber>e_sysctl) {
                syslog(LOG_ALERT,"Failed to acquire via Sysctl()\n");
                exit(-1);
            }
        }
    }

    /* Initializing */
    NowN=0;
    lim = buf + needed;
    next = buf;
    if ((RnetNow = (Rnpointer)malloc(sizeof(Routenet)*MaxRoute))==NULL) {
        syslog(LOG_ALERT,"Malloc Error\n");
        exit(-1);
    }

    for (next = buf; next < lim; next += rtm->rtm_msglen) {
    	rtm = (struct rt_msghdr *)next;
	if (((rtm->rtm_flags & RTF_GATEWAY) == 0) | (rtm->rtm_flags & RTF_WASCLONED))
	    continue;
	if ((rtm->rtm_addrs &(RTA_DST | RTA_NETMASK | RTA_GATEWAY))== 0)
	    continue;
	cp=(char *)(rtm+1);
	for (i=1;i;i<<=1) {
	    if (i&RTA_DST) {
		sa = (struct sockaddr *)cp;
		if (sa->sa_len==0)
		    RnetNow[NowN].addr=0;
		else {
		    in = ((struct sockaddr_in *)sa)->sin_addr;
		    RnetNow[NowN].addr=in.s_addr;
		}
		ADVANCE(cp, sa);
	    }
	    if (i&RTA_NETMASK) {
                sa = (struct sockaddr *)cp;
                if (sa->sa_len==0)
                    RnetNow[NowN].netmask=0;   
                else {
                    in = ((struct sockaddr_in *)sa)->sin_addr;
                    RnetNow[NowN].netmask=in.s_addr;
                }
                ADVANCE(cp, sa);
            }
	    if (i&RTA_GATEWAY) {
                sa = (struct sockaddr *)cp;
                in = ((struct sockaddr_in *)sa)->sin_addr;
                RnetNow[NowN].gateway=in.s_addr;
                ADVANCE(cp, sa);
            }
	}
	NowN++;
        if (NowN>MaxRoute-1) {
                MaxRoute=MaxRoute*2;
                    if ((RnetNow=(Rnpointer)realloc(RnetNow,sizeof(Routenet)*MaxRoute))==NULL){
                        syslog(LOG_ALERT,"Realloc Error\n");
                        exit(-1);
                    }
	}
    }
    if ((RnetNow = (Rnpointer)realloc(RnetNow,sizeof(Routenet)*NowN))==NULL){
        syslog(LOG_ALERT,"Realloc Error\n");
        exit(-1);
    }
    if ((IndexNow=(Ppointer)malloc(sizeof(Rnpointer)*NowN))==NULL){
        syslog(LOG_ALERT,"Malloc Error\n");
        exit(-1);
    }
    for (i=0;i<NowN;i++) {
        IndexNow[i]=&RnetNow[i];
    }
    qsort((void **) IndexNow, NowN, sizeof(Rnpointer), (int (*)(const void *, const void *))comparison);
    free (buf);
    return 0;
    
}

delete_route(Rnpointer route) {
    
    struct message { 
	    struct rt_msghdr m_rtm;
            char m_space[512];
    } m_rtmsg;
    int l;
    struct sockaddr_in *sa;
    int pid;
    int seqno;
    int forkpid;
    int status;
    int writedone;
#define rtm m_rtmsg.m_rtm
    bzero(&m_rtmsg,sizeof(m_rtmsg));
    rtm.rtm_type=RTM_DELETE;
    rtm.rtm_version=RTM_VERSION;
    rtm.rtm_inits=0;
    rtm.rtm_msglen=sizeof(struct rt_msghdr) + sizeof(struct sockaddr_in)*3;
    rtm.rtm_addrs= RTA_DST | RTA_GATEWAY | RTA_NETMASK;
    rtm.rtm_seq = seqno = 9998;  
    sa = (struct sockaddr_in *) &m_rtmsg.m_space;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=AF_INET;
    sa->sin_addr.s_addr=(*route).addr;
    sa++;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=AF_INET;
    sa->sin_addr.s_addr=(*route).gateway;
    sa++;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=0;
    sa->sin_addr.s_addr=(*route).netmask;
    writedone=0;
    while (writedone==0) {
        forkpid = fork();
        if (forkpid==0) {
            /* Try to write and read socket*/
            pid = rtm.rtm_pid = getpid();
            write (sock,(char *)&m_rtmsg,rtm.rtm_msglen);
            alarm(t_out);
            do {
                l = read(sock, (char *)&m_rtmsg, sizeof(m_rtmsg));
            } while (l > 0 && (rtm.rtm_seq != seqno || rtm.rtm_pid != pid));
            if (rtm.rtm_errno != 0) {
                alarm(0);
                syslog(LOG_ERR,"Route Message failed :%m");
                exit(errno);
            }
            alarm(0);
            exit(0);
        }
        else if (forkpid>0) {
            wait(&status);
            if (!WIFSIGNALED(status)) {
                writedone=1;
                if (!WIFEXITED(status))
                    syslog(LOG_WARNING, "Can't get status of ioctl child");
            }
        }
        else {
            syslog(LOG_ALERT, "Termination - can't create a child");
            exit(-1);
        }
    }
#undef rtm
    return (WEXITSTATUS(status));
}

create_route (Rnpointer route) {
    struct message {
    	    struct rt_msghdr m_rtm;
	    char m_space[512];
    } m_rtmsg;

    
     
    int l;
    struct sockaddr_in *sa;
    int pid;
    int seqno;
    int forkpid;
    int status;
    int writedone;
#define rtm m_rtmsg.m_rtm
    bzero(&m_rtmsg,sizeof(m_rtmsg));
    rtm.rtm_type=RTM_ADD;
    rtm.rtm_version=RTM_VERSION;
    rtm.rtm_inits=0;
    rtm.rtm_msglen=sizeof(struct rt_msghdr) + sizeof(struct sockaddr_in)*3;
    rtm.rtm_addrs= RTA_DST | RTA_GATEWAY | RTA_NETMASK;
    rtm.rtm_seq = seqno = 9998;
    rtm.rtm_flags=RTF_UP|RTF_GATEWAY|RTF_STATIC;
    sa = (struct sockaddr_in *) &m_rtmsg.m_space;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=AF_INET;
    sa->sin_addr.s_addr=(*route).addr;
    sa++;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=AF_INET;
    sa->sin_addr.s_addr=(*route).gateway;
    sa++;
    sa->sin_len=sizeof(struct sockaddr_in);
    sa->sin_family=0;
    sa->sin_addr.s_addr=(*route).netmask;
    writedone=0;
    while (writedone==0) {
        forkpid = fork();
        if (forkpid==0) {
            /* Try to write and read socket*/
            alarm(t_out);
            pid = rtm.rtm_pid = getpid();
            write (sock,(char *)&m_rtmsg,rtm.rtm_msglen);
            do {
                l = read(sock, (char *)&m_rtmsg, sizeof(m_rtmsg));
            } while (l > 0 && (rtm.rtm_seq != seqno || rtm.rtm_pid != pid));
            if (rtm.rtm_errno != 0) {
                alarm(0);
                syslog(LOG_WARNING,"Route Message failed :%m");
                exit(errno);
            }
            alarm(0);
            exit(0);
        }
        else if (forkpid>0) {
            wait(&status);
            if (!WIFSIGNALED(status)) {
                writedone=1;
                if (!WIFEXITED(status))
                    syslog(LOG_WARNING, "Can't get status of ioctl child");
            }
        }
        else {
            syslog(LOG_ALERT, "Termination - can't create a child");
            exit(-1);
        }
    }
#undef rtm
    return 0;
}

main(){
    int i,j,k;
    int changed;
    int res;
    int doublenets=0;


    openlog("Route_Reconfigurator", LOG_CONS, LOG_USER);
    sock=socket(AF_ROUTE,SOCK_RAW,0);
    if ((res = addTask())!=0) {
            syslog(LOG_ALERT,"Unrecoverable Error in addTask()\n");
            exit(-1);
    }
    /* Starting of Reconfiguration Round. If something has been changed - repeat the process */
    changed = 1;
    while (changed) {
        changed = 0;
        if ((res = addNow())!=0) {
            syslog(LOG_ALERT,"Unrecoverable Error in addNow()\n");
            exit(-1);
        }
/* Preparation of Memory for Del and Cr lists */
   if ((IndexDel=(Ppointer)malloc(sizeof(Rnpointer)*NowN))==NULL){
        syslog(LOG_ALERT,"Malloc Error\n");
	exit(-1);
    }
    if ((IndexCr=(Ppointer)malloc(sizeof(Rnpointer)*TaskN))==NULL){
        syslog(LOG_ALERT,"Malloc Error\n");
        exit(-1);
    }
    CrN=DelN=0;
/* Reconfiguration */
	i=0;
        j=0;
        while (i<NowN && j<TaskN){
	    if ((*IndexTask[j]).notallow == 1) {
		j++;
		if (doublenets == 0) {
		    syslog(LOG_WARNING,"Double nets in Task\n");
		    doublenets=1;
		}
		continue;
	    }
            res=(comparison(IndexNow+i,IndexTask+j));	
	    switch (res) { 
		case 1: {
		    IndexCr[CrN++]=IndexTask[j];
		    j++;
		    changed=1;
		    break;
		}
		case 0: {
		    j++;i++;
		    break;
		}
		case -1: {
		    IndexDel[DelN++]=IndexNow[i];
		    changed=1;
		    i++;
		    break;
		}
		default: {
	    	    syslog(LOG_ALERT,"Abnormal Termination while comparing\n");
                    exit(-1);
                }
	    }
	}
	if (j==TaskN) {
	    for (k=i;k<NowN;k++) {
		IndexDel[DelN++]=IndexNow[k];
		changed=1;
	    }
	}
	if (i==NowN) {
	    for (k=j;k<TaskN;k++) {
		if ((*IndexTask[k]).notallow == 1) {
                    k++;
		    if (doublenets == 0) {
                        syslog(LOG_WARNING,"Double nets in Task\n");
                        doublenets=1;
                    }
		    continue;
                }
		IndexCr[CrN++]=IndexTask[k];
		changed=1;
	    }
	}
	for (i=0;i<DelN;i++)
	delete_route(IndexDel[i]); 
	for (i=0;i<CrN;i++)
	create_route(IndexCr[i]);
	free (IndexDel);
	free (IndexCr);
	free (RnetNow);
	free (IndexNow);
	if (changed != 0) syslog (LOG_INFO,"Configuration updated: deleted %i added %i",DelN,CrN);
    }
syslog (LOG_INFO,"Completed");
return 0;
}
