/*
 * Copyright (c) 2005 Anton Antonov <aga@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: contables.h,v 1.11 2005/08/04 17:13:11 aga Exp $ 
 */

/*   */
enum states {
   w0, /*    */
   tn, /*    */
   w1, /*  value */
   va, /*  value */
   w2, /*  ip */
   ip, /*  ip */
   ml, /*   */
   w3, /*  return  */
   er, /*  */
   end /*  */
};

/*  */
enum classes {
   no, /*   */
   hd, /*   */
   sp, /* , (space) */
   po, /* . (point) */
   sl, /* / - slash */
   re, /* return */
   xx
};

enum classes class[256] =
{no,no,no,no ,no,no,no,no ,no,sp,re,no ,no,re,no,no 
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no 
,sp,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,po,sl  
,hd,hd,hd,hd ,hd,hd,hd,hd ,hd,hd,no,no ,no,no,no,no  

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
};

/* Actions */
#define A_rn  0x800 /*    */
#define A_wd  0x400 /*     */
#define A_wi  0x200 /*  ip   */
#define A_ws  0x100 /*   */

u_int32_t automat[end][xx] =
/*       TN        value     ip_addr/masklen      */
/*   ^   ^    ^      ^    ^    ^      ^      ^    */
/*  w0   tn   w1     va   w2   ip     ml     w3   */
/*           no        hd           sp        po        sl       re  */
/* w0  */ {{ er,  A_rn|tn,          w0,       er,       er,      w0 },
/* tn  */  { er,  A_rn|tn,     A_wd|w1,       er,       er,      w0 },
/* w1  */  { er,  A_rn|va,          w1,       er,       er,      w0 },
/* va  */  { er,  A_rn|va,     A_wd|w2,       er,       er,      w0 },
/* w2  */  { er,  A_rn|ip,          w2,       er,       er,      w0 },
/* ip  */  { er,  A_rn|ip,          er,  A_rn|ip,  A_wi|ml,      w0 },
/* ml  */  { er,  A_rn|ml,     A_wd|w3,       er,       er,   A_wd|A_ws|w0 },
/* w3  */  { er,       er,          w3,       er,       er,   A_ws|w0 },
/* er  */  { er,       er,          er,       er,       er,      w0 }};

