/*
 * Copyright (c) 2005 Anton Antonov <aga@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: contables.c,v 1.6 2005/09/01 15:33:16 aga Exp $ 
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <net/if.h>
#include <netinet/ip_fw2.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdlib.h>
#include <fcntl.h>
#include "contables.h"
#include <multilar.h>
#include <babolo/BLINflag.h>

#define FROM_STDIN 0x1
#define FROM_FILE  0x2

int 
compare_tables(mular_descriptor **mular, int *counter);

void
show_usage(void) {
    fprintf(stderr, "usage:
            contables [-f file ... ]
            The program will read the first 12 files\n");
    exit(-1);
}

void 
writeLogs(int priority, const char *message){
       openlog("contables",LOG_PID | LOG_NDELAY,LOG_DAEMON);
       syslog(priority, message);
       closelog(); 
}

int 
compare_ent(ipfw_table_entry ent1, ipfw_table_entry ent2){
        int ex = 0;
        if (ntohl(ent1.addr) < ntohl(ent2.addr)) ex = 1;
        else if (ntohl(ent1.addr) > ntohl(ent2.addr)) ex = -1;
        else if (ent1.masklen > ent2.masklen) ex = 1;
        else if (ent1.masklen < ent2.masklen) ex = -1; 
        return ex;
}

int 
find_ind(mular_descriptor *mular, int begin_ind, int max_ind, ipfw_table_entry ent){
        ipfw_table_entry *tmp_ent;
        int i;
        while (begin_ind < max_ind) {
                   tmp_ent = (ipfw_table_entry *)mular_getix(mular, begin_ind);
                   if ((i = compare_ent(*tmp_ent,ent)) < 0 || i == 0) return -1;
                   else {
                        begin_ind++; 
                        while (begin_ind < max_ind){
                                tmp_ent = (ipfw_table_entry *)mular_getix(mular, begin_ind++);
                                if (compare_ent(*tmp_ent,ent) < 0) return begin_ind - 1;
                                if (compare_ent(*tmp_ent,ent) == 0) return -1;
                        }
                        return max_ind;
                    }
                    begin_ind++;
         }
         return max_ind;        
}

int 
tables_reader(int ac, char **av){
    char errMessage[256];
    int input = NULL, fd = NULL, c, lineno, i = 0;  
    FILE *f = NULL;
    uint32_t state, action, old_state;
    ipfw_table_entry ent, *tmp_ent,prev[128];
    char str[16];
    uint8_t t_num, masklen;
    uint32_t mask;
    int counter[128], in_counter[128], j, new_file=0;
    mular_descriptor *mular[128];
    int size[]={ 81920, 4096, 16 };

    if (ac == 1) {
        input=FROM_STDIN;
        if( (fd = open("/dev/fd/0",O_RDONLY)) < 0) {
            snprintf(errMessage,256,"open: /dev/fd/0: %s", strerror(errno));
            writeLogs(LOG_EMERG,errMessage);
            exit(-1);
        } 
    } else {
        while ( (i = getopt(ac, av, "f")) > 0) {
                switch (i) {
                case 'f':
                        input = FROM_FILE;
                        break;
                default:
                        show_usage();
                }   
        }
        if (input != FROM_FILE) show_usage();
        ac -= optind;
        av += optind;
    }
    
    for (j = 0; j < 128; j++) counter[j] = 0;
    memset(mular, 0, 128*4);

next_file:
    while (ac > 0) {
        if (input & FROM_STDIN) {
            if ((f = fdopen(fd,"r")) < 0) {
                snprintf(errMessage, 256, "fdopen: %s", strerror(errno));
                writeLogs(LOG_EMERG, errMessage);
                exit(-1);
            } 
        } else if (input & FROM_FILE)
                if ((f = fopen(*av, "r")) == NULL){ 
                        snprintf(errMessage, 256, "fopen: %s : %s", *av, strerror(errno));
                        writeLogs(LOG_ALERT, errMessage);
                        ac--;
                        av++;
                        goto next_file;
                }
        ac--;
        av++;
        
        state = 0;
        action = 0;
        lineno = 1;
        i = 0; c = 0;
        memset(prev, 0, 128*sizeof(ipfw_table_entry));
        for (j = 0; j < 128; j++) {
		in_counter[j] = 0;
		prev[j].masklen = 32;
	}
        
        while (state < end) {
                old_state = state;
                c = getc(f);
                if (class[c] == re) lineno++; /*    */
                if (c == EOF) { state = end; continue; }
                action = automat[state][class[c]];
                state = action & 0xff;     /*   */
                
                if (state == er && old_state != er) {
                        snprintf(errMessage, 256, "Syntax error: %s: Line number: %d", *(av-1), lineno);
                        writeLogs(LOG_ALERT, errMessage);
                        i = 0;
                        memset(&ent, 0, sizeof(ent));
                }
                
                if (action & A_rn) {
                        if (i > 16) state = er;
                        else str[i++] = (char)c;
                        continue;}
                if (action & A_wd) {
                        str[i] = '\0';
                        switch (old_state) {
                        case tn:
                                t_num = atoi(str);
                                if (t_num < 128) ent.tbl = t_num;
                                else state = er;
                                break;
                        case va:
                                ent.value = strtoul(str, NULL, 0);
                                break;
                        case ml:
                                masklen = atoi(str);
                                if (masklen <= 32) ent.masklen = masklen;
                                else state = er;
                                break;
                        default:
                                state = er;
                        }
                        i = 0;}
                if (action & A_wi) {
                        str[i] = '\0';
                        if ( !inet_aton(str, (struct in_addr *)&ent.addr) ) state = er;
                        i = 0;}
                if (action & A_ws) {
                        mask = 0;
                        for(j = 0; j < 32; j++) {
                                mask <<= 1;
                                if (j < ent.masklen) mask |= 0x1;
                        }
                        ent.addr = htonl(ntohl(ent.addr) & mask);
                        /*   */
                        if (compare_ent(prev[ent.tbl],ent) <= 0) {  
                                snprintf(errMessage, 256, "bad IP order: file %s: line %d", *(av-1), lineno);
                                writeLogs(LOG_ALERT, errMessage);
                                memset(&ent, 0, sizeof(ent));
                                continue;       
                        }
                        if (mular[ent.tbl] == NULL)
                                if (!(mular[ent.tbl] = mular_create(NULL, 3, sizeof(ipfw_table_entry), size))) {
                                        snprintf(errMessage,256,"mular[%d] not create: %s", ent.tbl, strerror(errno));
                                        writeLogs(LOG_EMERG, errMessage);
                                        return -1;
                                }
                        if (new_file)
                                j = find_ind(mular[ent.tbl], in_counter[ent.tbl], counter[ent.tbl], ent);
                        else j = counter[ent.tbl];
                        if (j > -1){       
                                if( (tmp_ent = (ipfw_table_entry  *)mular_insert(mular[ent.tbl], j)) ) {
                                        *tmp_ent = ent;
                                        counter[ent.tbl]++;  
                                        in_counter[ent.tbl] = j+1;
                                        prev[ent.tbl] = ent;
                                } else {
                                        snprintf(errMessage, 256, "mular_insert: tbl %d: ip is not inserted", ent.tbl);
                                        writeLogs(LOG_EMERG, errMessage);
                                        return -1;
                                }
                        }               
                        memset(&ent, 0, sizeof(ent));
                }
        } /* end of while (for one file) */
        new_file = 1;
     } /* end of while (for all files) */
      /* Just for test */
     /*for(i = 0; i < 128; i++){
        printf("------Table %d------\n",i);
        for (j = 0; j < counter[i]; j++) {
                tmp_ent = (ipfw_table_entry *)mular_getix(mular[i], j);
                printf("%x/%d %u\n", ntohl(tmp_ent->addr), tmp_ent->masklen, tmp_ent->value);
        }
     }*/
    i = 0;
    for(j = 0; j < 128; j++) 
        if (counter[j] != 0) { 
                while( (i = compare_tables(mular, counter)) == -1) {
                        snprintf(errMessage, 256, "tables_reader: restart compare_tables");
                        writeLogs(LOG_ALERT, errMessage);
                }
                break;
        }
     return i;    
}

int
main(int ac, char **av) {
    int i;
    char errMessage[256];
    while ((i = tables_reader(ac, av)) != 0) {
        snprintf(errMessage, 256, "main: restart from the beginning");
        writeLogs(LOG_ALERT, errMessage);
    }
    return 0;
}
