/*
 * Copyright (c) 2005 Anton Antonov <aga@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: conrules.h,v 1.5 2006/08/10 14:27:29 aga Exp $
 */

/*   */
enum states {
  w0,    /*   ,   ( */
  w1,    /*      */
  r_num, /*    */
  w2,    /*    */ 
  s_num, /*    */
  w_id,  /*   */ 
  r_id,  /*   */ 
  er,    /*  */
};
   
/*  */
enum classes {
    no, /*   */
    hd, /*   */
    hx, /*   */
    hX, /*   */
    ob, /*   (open bracket) */
    cb, /*   (close bracket) */
    sp, /* ,,   (space) */
    sl, /* / (slash) */
    co, /* : (colon) */
    po, /* . (point) */
    or, /* | (or) */
    nt, /* ! (not) */
    da, /* dash ( - ) */
    xx
};

enum classes class[256] =
{no,no,no,no ,no,no,no,no ,no,sp,sp,no ,no,sp,no,no //0-15
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no  //16-31
,sp,nt,no,no ,no,no,no,no ,ob,cb,no,no ,no,da,po,sl   //32-47
,hd,hd,hd,hd ,hd,hd,hd,hd ,hd,hd,co,no ,no,no,no,no  //48-63

,no,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,hX //64-79
,hX,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,no ,no,no,no,hX //80-95
,no,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,hx  //96-111
,hx,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,no ,or,no,no,no //112-127

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
};

/*Actions*/
#define A_RC  0x4000 /*  */
#define A_cr  0x2000 /* struct ip_fw *rule */
#define A_cX  0x1000 /* ,         */
#define A_rn   0x800 /*  */
#define A_wd   0x400 /* */ 
#define A_wo   0x200 /* F_OR */
#define A_wn   0x100 /* F_NOT*/

u_int32_t automat[er][xx]=
/*     (      rule_number       set_number       IDENTIFIER    * 
 *  ^    ^          ^       ^         ^      ^        ^        *
 * w0    w1       r_num     w2      s_num   w_id     r_id      */
/*            no       hd     hx       hX         (             )        sp     /    :    .              |             !     - */ 
/* w0   */ {{ er,      er,    er,      er,   A_cr|w1,           er,      w0,   er,  er,  er,            er,            er,   er }, 
/* w1   */  { er, A_rn|r_num, er,      er,        er,      A_RC|w0,      w1,   er,  er,  er,            er,            er,   er },   
/*r_num */  { er, A_rn|r_num, er,      er,        er, A_wd|A_RC|w0, A_wd|w2,   er,  er,  er,            er,            er,   er }, 
/* w2   */  { er, A_rn|s_num, er,      er,        er,      A_RC|w0,      w2,   er,  er,  er,            er,            er,   er },   
/*s_num */  { er, A_rn|s_num, er,      er,        er, A_wd|A_RC|w0, A_wd|w_id, er,  er,  er,            er,            er,   er },  
/* w_id */  { er,      er,    er, A_rn|r_id,      er,      A_RC|w0,      w_id, er,  er,  er,      A_wo|w_id,      A_wn|w_id, er }, 
/* r_id */  { er,      er,    er, A_rn|r_id,A_cX|w_id,A_cX|A_RC|w0, A_cX|w_id, er,  er,  er, A_cX|A_wo|w_id, A_cX|A_wn|w_id, er }};                                                     
/* er   */

/* "  */
enum in_states {
	w_ob, /*   */
	w_xX, /*    */
	next, /*    */
	w_xX2, /*     */
	next2, /*    */
	w_cb, /*   */
	in_end
};

#define A_wr      0x8000 /*    */
#define DASH     0x10000 /* dash */
#define MASKLEN  0x20000 /*   */
#define MASK  	 0x40000 /*  */

/*       */
u_int32_t in_auto[6][in_end][xx]={
/* class 1 (single parameter) */
/*           no      hd       hx        hX        (         )           sp      /     :       .     |     !      -    */
/* w_ob */{{ er,     er,      er,       er,       w_xX,    er,          w_ob,   er,   er,     er,   er,   er,    er },
/* w_xX */ { er, A_rn|next, A_rn|next, A_rn|next, er,      in_end,      w_xX,   er,   er,     er,   er,   er,    er },
/* next */ { er, A_rn|next, A_rn|next, A_rn|next, er, A_wr|in_end, A_wr|w_cb,   er,   er,     er,   er,   er,    er },
/* w_xX2*/ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er },
/* next2*/ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er },
/* w_cb */ { er,     er,      er,       er,       er,      in_end,      w_cb,   er,   er,     er,   er,   er,    er }},
/* class 2 (ip_addr and port) */
/*           no      hd       hx        hX        (         )           sp      /     :       .     |     !      -    */
/* w_ob */{{ er,     er,      er,       er,      w_xX,     er,          w_ob,   er,   er,     er,   er,   er,    er },
/* w_xX */ { er, A_rn|next,   er,       er,      er,      in_end,       w_xX,   er,   er,     er,   er,   er,    er },
/* next */ { er, A_rn|next,   er,       er,      er, A_wr|in_end,  A_wr|w_xX2,  er,   er, A_rn|next,er,   er,    er },
/* w_xX2*/ { er, A_rn|next2,  er,       er,      er,      in_end,       w_xX2,  er,   er,     er,   er,   er,    er },
/* next2*/ { er, A_rn|next2,  er,       er,      er, A_wr|in_end,  A_wr|w_cb,   er,   er,     er,   er,   er,    er },
/* w_cb */ { er,     er,      er,       er,       er,      in_end,      w_cb,   er,   er,     er,   er,   er,    er }},
/* class 3 (integers divided by spaces or range of integers) */
/*           no      hd       hx        hX        (         )           sp      /     :       .     |     !      -    */
/* w_ob */{{ er,     er,      er,       er,      w_xX,     er,          w_ob,   er,   er,     er,   er,   er,    er },
/* w_xX */ { er,   A_rn|next, er,       er,       er,      in_end,      w_xX,   er,   er,     er,   er,   er,    er },
/* next */ { er,   A_rn|next, er,       er,       er, A_wr|in_end, A_wr|w_xX,   er,   er,     er,   er,   er,A_wr|DASH|next },
/* w_xX2*/ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er },
/* next2*/ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er },
/* w_cb */ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er }},  
/* class 4 (words or integers divided by spaces) */
/*           no      hd       hx        hX        (         )           sp      /     :       .     |     !      -    */
/* w_ob */{{ er,     er,      er,       er,       w_xX,    er,          w_ob,   er,   er,     er,   er,   er,    er },
/* w_xX */ { er, A_rn|next2,A_rn|next,  er,       er,      in_end,      w_xX,   er,   er,     er,   er,A_rn|next,er },
/* next */ { er,     er,    A_rn|next,  er,       er, A_wr|in_end, A_wr|w_xX,   er,   er,     er,   er,   er,    er },
/* w_xX2*/ { er,     er,      er,       er,       er,      er,          er,     er,   er,     er,   er,   er,    er },
/* next2*/ { er, A_rn|next2,  er,       er,       er, A_wr|in_end, A_wr|w_cb,   er,   er,     er,   er,   er,    er },
/* w_cb */ { er,     er,      er,       er,       er,      in_end,      w_cb,   er,   er,     er,   er,   er,    er }},  
/* class 5 (ip_addr[:mask | /masklen]) */
/*           no      hd       hx        hX        (        	 )           sp           /                :                 .          |     !     -    */
/* w_ob */{{ er,     er,      er,       er,      w_xX,     	er,          w_ob,        er,              er,               er,       er,   er,   er },
/* w_xX */ { er,   A_rn|next, er,       er,       er,      	in_end,      w_xX,        er,              er,               er,       er,   er,   er },
/* next */ { er,   A_rn|next, er,       er,       er,      A_wr|in_end, A_wr|w_xX, A_wr|MASKLEN|next2,A_wr|MASK|w_xX,   A_rn|next,     er,   er,   er }, 
/* w_xX2*/ { er,     er,      er,       er,       er,      	er,          er,          er,              er,               er,       er,   er,   er },
/* next2*/ { er,   A_rn|next2,er,       er,       er,      A_wr|in_end, A_wr|w_xX,	  er,              er,               er,       er,   er,   er },
/* w_cb */ { er,     er,      er,       er,       er,      	in_end,      w_cb,        er,              er,               er,       er,   er,   er }},
/* class 6 (ip_addr/masklen bitmap) */
/*           no      hd       hx        hX        (        	 )           sp           /                :                 .          |     !     -    */
/* w_ob */{{ er,     er,      er,       er,      w_xX,     	er,          w_ob,        er,              er,               er,       er,   er,   er },
/* w_xX */ { er,   A_rn|next, er,       er,       er,      	in_end,      w_xX,        er,              er,               er,       er,   er,   er },
/* next */ { er,   A_rn|next, er,       er,       er,           er,     A_wr|w_xX2, A_wr|MASKLEN|next2,    er,          A_rn|next,     er,   er,   er }, 
/* w_xX2*/ { er,   A_rn|next2,er,       er,       er,      	er,          er,          er,              er,               er,       er,   er,   er },
/* next2*/ { er,   A_rn|next2,er,       er,       er,      A_wr|in_end, A_wr|w_xX2,       er,              er,               er,       er,   er,   er },
/* w_cb */ { er,     er,      er,       er,       er,      	in_end,      w_cb,        er,              er,               er,       er,   er,   er }}	   
}; 

struct _s_x {
	char const *s;
	int x;
};


struct state_to_array{
	int x;
	enum in_states *st_array;
};


/*    */
static struct _s_x id_state_table[ ]={
/* single parameter */
	{"LOG",    1}, /* integer */
	{"DIVERT", 1},
	{"PIPE",   1},
	{"QUEUE",  1},
	{"SKIPTO", 1},
	{"REJECT", 1},
	{"TEE",    1},
	{"PROTO",  1},
	{"IPPRECEDENCE", 1},
	{"IPVER",  1},
	{"TCPACK", 1},
	{"TCPWIN", 1},
	{"TCPSEQ", 1},
	{"GID",    1},
	{"UID",    1},
	{"PROB",   1}, /* not integer */
	{"RECV",   1}, /* integer or word */
	{"XMIT",   1},
	{"VIA",    1},
/* ip_addr and port */
	{"FORWARD_IP", 2},
/* integers divided by spaces or range of integers */
	{"IP_SRCPORT", 3},
	{"IP_DSTPORT", 3},
	{"ICMPTYPE",   3},
	{"IPID",       3},
	{"IPLEN",      3},
	{"IPTTL",      3},
	{"IP_SRC_LOOKUP", 3},
	{"IP_DST_LOOKUP", 3},
/* words or integers divided by spaces */
	{"IPOPT",    4},
	{"IPTOS",    4},
	{"TCPFLAGS", 4},
	{"TCPOPTS",  4},
	{"LIMIT",    4},
/* ip_addr [mask or masklen] */
	{"IP_SRC",      5},
	{"IP_DST",      5},
	{"IP_SRC_MASK", 5},
	{"IP_DST_MASK", 5},
/* ip_addr[mask or masklen](bitmap) */
	{"IP_SRC_SET",  6},
	{"IP_DST_SET",  6},
/*no parameters*/
	{"ACCEPT",     10}, 
	{"CHECK_STATE",10},
	{"PROBE_STATE",10},
	{"COUNT",      10},
	{"DENY",       10},
	{"IP_SRC_ME",  10},
	{"IP_DST_ME",  10},
	{"LAYER2",     10},
	{"ESTAB",      10},
	{"FRAG",       10},
	{"IN",         10},
	{"KEEP_STATE", 10},
	{"VERREVPATH", 10},
/*NULL*/
	{NULL,0}
}; 

/*    (    ) */
struct _s_x identifiers[] = {
	{"ACCEPT",       O_ACCEPT}, 
	{"CHECK_STATE",  O_CHECK_STATE},
	{"PROBE_STATE",  O_PROBE_STATE},
	{"COUNT", 	 O_COUNT},
	{"DENY",	 O_DENY},
	{"IP_SRC_ME",    O_IP_SRC_ME},
	{"IP_DST_ME",    O_IP_DST_ME},
	{"LAYER2",       O_LAYER2},
	{"ESTAB",        O_ESTAB},
	{"FRAG",         O_FRAG},
	{"IN",           O_IN},
	{"KEEP_STATE",   O_KEEP_STATE},
	{"VERREVPATH",   O_VERREVPATH},
/*one integer parameter*/
	{"LOG",		 O_LOG},
	{"DIVERT",       O_DIVERT},
	{"PIPE",	 O_PIPE},
	{"QUEUE",        O_QUEUE},
	{"SKIPTO",       O_SKIPTO},
	{"REJECT",       O_REJECT},
	{"TEE",		 O_TEE},
	{"PROTO",	 O_PROTO},
	{"IPPRECEDENCE", O_IPPRECEDENCE},
	{"IPVER",        O_IPVER},
	{"TCPACK",	 O_TCPACK},
	{"TCPWIN",	 O_TCPWIN},
	{"TCPSEQ",	 O_TCPSEQ},
	{"GID",		 O_GID},
	{"UID",		 O_UID},
/*one not integer number*/
	{"PROB",	 O_PROB},
/*integer or word*/
	{"RECV",	 O_RECV},
	{"XMIT",	 O_XMIT},
	{"VIA",		 O_VIA},
/*ip_addr and port*/
	{"FORWARD_IP",   O_FORWARD_IP},
/*integers divided by spaces or range of integers*/
	{"IP_SRCPORT",	 O_IP_SRCPORT},
	{"IP_DSTPORT", 	 O_IP_DSTPORT},
	{"ICMPTYPE",	 O_ICMPTYPE},
	{"IPID",	 O_IPID},
	{"IPLEN",	 O_IPLEN},
	{"IPTTL",	 O_IPTTL},
	{"IP_SRC_LOOKUP",O_IP_SRC_LOOKUP},
	{"IP_DST_LOOKUP",O_IP_DST_LOOKUP},
/*words divided by spaces*/
	{"IPOPT",	 O_IPOPT},
	{"IPTOS",	 O_IPTOS},
	{"TCPFLAGS",	 O_TCPFLAGS},
	{"TCPOPTS",	 O_TCPOPTS},
/*words and integer*/
	{"LIMIT",	 O_LIMIT},
/*ip_addr*/
	{"IP_SRC",	 O_IP_SRC},
	{"IP_DST",	 O_IP_DST},
/*ip_addr and mask*/
	{"IP_SRC_MASK",	 O_IP_SRC_MASK},
	{"IP_DST_MASK",  O_IP_DST_MASK},
/*ip_addr, mask and bitmap*/
	{"IP_SRC_SET",	 O_IP_SRC_SET},
	{"IP_DST_SET",   O_IP_DST_SET},
/*NULL*/
	{NULL,0}
};

static struct _s_x f_ipopts[] = {
	{ "ssrr",	IP_FW_IPOPT_SSRR},
	{ "lsrr",	IP_FW_IPOPT_LSRR},
	{ "rr",		IP_FW_IPOPT_RR},
	{ "ts",		IP_FW_IPOPT_TS},
	{ "ip_option",	0 },
	{ NULL,	0 }
};

static struct _s_x f_iptos[] = {
	{ "lowdelay",	IPTOS_LOWDELAY},
	{ "throughput",	IPTOS_THROUGHPUT},
	{ "reliability", IPTOS_RELIABILITY},
	{ "mincost",	IPTOS_MINCOST},
	{ "congestion",	IPTOS_CE},
	{ "ecntransport", IPTOS_ECT},
	{ "ip_tos_option", 0},
	{ NULL,	0 }
};

static struct _s_x f_tcpflags[] = {
	{ "syn", TH_SYN },
	{ "fin", TH_FIN },
	{ "ack", TH_ACK },
	{ "psh", TH_PUSH },
	{ "rst", TH_RST },
	{ "urg", TH_URG },
	{ "tcp_flag", 0 },
	{ NULL,	0 }
};

static struct _s_x limit_masks[] = {
	{"all",		DYN_SRC_ADDR|DYN_SRC_PORT|DYN_DST_ADDR|DYN_DST_PORT},
	{"src_addr",	DYN_SRC_ADDR},
	{"src_port",	DYN_SRC_PORT},
	{"dst_addr",	DYN_DST_ADDR},
	{"dst_port",	DYN_DST_PORT},
	{NULL,		0}
};
static struct _s_x f_tcpopts[] = {
	{ "mss",	IP_FW_TCPOPT_MSS },
	{ "maxseg",	IP_FW_TCPOPT_MSS },
	{ "window",	IP_FW_TCPOPT_WINDOW },
	{ "sack",	IP_FW_TCPOPT_SACK },
	{ "ts",		IP_FW_TCPOPT_TS },
	{ "timestamp",	IP_FW_TCPOPT_TS },
	{ "cc",		IP_FW_TCPOPT_CC },
	{ "tcp option",	0 },
	{ NULL,	0 }
};
