/*
 * Copyright (c) 2005 Anton Antonov <aga@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: conpipes.h,v 1.5 2005/08/04 17:12:32 aga Exp $ 
 */

/*   */
enum states {
   b0, /*      hX */
   b1, /*  ,    QUEUE  PIPE  */   
   w0, /*    ( */
   w1, /*         */
   n1, /*      */
   w2, /*  bandwidth  parent_nr */
   n2, /*  bandwidth  parent_nr */
   w3, /*  delay  weight */
   n3, /*  delay  weight */
   w4, /*  qsize */
   qs, /*  qsize */
   w5, /*  plr */
   pl, /*  plr */
   w6, /*  buckets */
   bu, /*  buckets */
   w7, /*  ( -  */
   w8, /*   */
   ri, /*   */
   w9, /*  ( */
   w10,/*    */
   rm, /*   */
   w11,/*  ) */
   w12,/*  ) -  */
   w13,/*   RED, GRED, NOERROR  DROPTAIL */
   id, /*   */
   w14,/*  ( */
   w15,/*  w_q */
   wq, /*  wq */
   w16,/*  min_th */
   min,/*  min_th */
   w17,/*  max_th */
   max,/*  max_th */
   w18,/*  max_p  */
   mp, /*  max_p  */
   w19,/*  ) */
   w20,/*  ) */
   w21,/*  return */
   er,  /*  */
   end  /*  */
};

/*  */
enum classes {no, hd, hx, hX, ob, cb, sp, po, da, re, xx };
/* no -  
   hd -  
   hx -  
   hX -  
   ob -   (open bracket)
   cb -   (close bracket)
   sp - , (space)
   po - . (point)
   da - dash ( - )
   re - return
   xx
*/

enum classes class[256] =
{no,no,no,no ,no,no,no,no ,no,sp,re,no ,no,re,no,no 
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no 
,sp,no,no,no ,no,no,no,no ,ob,cb,no,no ,no,da,po,no  
,hd,hd,hd,hd ,hd,hd,hd,hd ,hd,hd,no,no ,no,no,no,no  

,no,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,hX 
,hX,hX,hX,hX ,hX,hX,hX,hX ,hX,hX,hX,no ,no,no,no,hX 
,no,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,hx 
,hx,hx,hx,hx ,hx,hx,hx,hx ,hx,hx,hx,no ,no,no,no,no 

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no

,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
,no,no,no,no ,no,no,no,no ,no,no,no,no ,no,no,no,no
};

/*Actions*/
#define A_RC  0x1000 /*  */
#define A_cr   0x800 /*  struct dn_pipe  dn_flow_set */
#define A_rn   0x400 /*  */
#define A_cX   0x200 /*  */
#define A_wd   0x100 /* */ 


u_int32_t automat[end][xx] =
/*    PIPE/QUEUE  (   p_num/q_num   band/par_nr  delay/weight  qsize  plr   buckets  (   IDENTIFIER  (   mask   )   )    IDENTIFIER   (     w_q    min_th    max_th    max_p   )    ) */  
/*  ^     ^     ^   ^      ^      ^      ^     ^      ^      ^   ^  ^  ^  ^    ^   ^   ^      ^    ^  ^    ^  ^   ^   ^      ^      ^    ^   ^   ^    ^   ^     ^   ^    ^   ^    ^   */
/* b0    b1    w0   w1     n1     w2     n2    w3     n3     w4  qs w5 pl w6   bu  w7  w8     ri   w9 w10  rm w11 w12 w13   id     w14  w15  wq w16  min w17   max w18   mp w19  w20  */
/*           no        hd        hx       hX          (              )             sp        .        -     re */ 
/* b0  */ {{ er,       er,       er,  A_rn|b1,       er,            er,            b0,      er,       er,   b0 },    
/* b1  */  { er,       er,       er,  A_rn|b1,  A_cX|A_cr|w1,       er,       A_cX|w0,      er,       er,   b0 },                                                                     
/* w0  */  { er,       er,       er,       er,  A_cr|w1,            er,            w0,      er,       er,   b0 }, 
/* w1  */  { er,  A_rn|n1,       er,       er,       w8,       A_RC|w21,           w1,      er,       er,   b0 }, 
/* n1  */  { er,  A_rn|n1,       er,       er,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w2,      er,       er,   b0 }, 
/*5 w2 */  { er,  A_rn|n2,       er,       er,       w8,       A_RC|w21,           w2,      er,       er,   b0 }, 
/* n2  */  { er,  A_rn|n2,       er,       er,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w3,      er,       er,   b0 },
/* w3  */  { er,  A_rn|n3,       er,       er,       w8,       A_RC|w21,           w3,      er,       er,   b0 }, 
/* n3  */  { er,  A_rn|n3,       er,       er,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w4,      er,       er,   b0 }, 
/* w4  */  { er,  A_rn|qs,       er,       er,       w8,       A_RC|w21,           w4,      er,       er,   b0 },
/*10 qs*/  { er,  A_rn|qs,       er,  A_rn|qs,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w5,      er,       er,   b0 },
/* w5  */  { er,  A_rn|pl,       er,       er,       w8,       A_RC|w21,           w5,      er,       er,   b0 },
/* pl  */  { er,  A_rn|pl,       er,       er,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w6, A_rn|pl,       er,   b0 }, 
/* w6  */  { er,  A_rn|bu,       er,       er,       w8,       A_RC|w21,           w6,      er,       er,   b0 },
/* bu  */  { er,  A_rn|bu,       er,       er,  A_wd|w8,  A_wd|A_RC|w21,      A_wd|w7,      er,       er,   b0 },
/*15 w7*/  { er,       er,       er,  A_rn|id,       w8,       A_RC|w21,           w7,      er,       er,   b0 }, 
/* w8  */  { er,       er,       er,  A_rn|ri,       er,            w13,           w8,      er,       er,   b0 },
/* ri  */  { er,       er,       er,  A_rn|ri,  A_cX|w10,      A_cX|w13,      A_cX|w9,      er,       er,   b0 },
/* w9  */  { er,       er,       er,       er,       w10,           w13,           w9,      er,       er,   b0 },                                     
/* w10 */  { er,  A_rn|rm,       er,       er,       er,            w12,          w10,      er,  A_rn|rm,   b0 },                                 
/*20 rm*/  { er,  A_rn|rm,  A_rn|rm,  A_rn|rm,       er,       A_wd|w12,     A_wd|w11,      er,       er,   b0 },     
/* w11 */  { er,       er,       er,       er,       er,            w12,          w11,      er,       er,   b0 },  
/* w12 */  { er,       er,       er,  A_rn|ri,       er,            w13,          w12,      er,       er,   b0 },  
/* w13 */  { er,       er,       er,  A_rn|id,       er,       A_RC|w21,          w13,      er,       er,   b0 },
/* id  */  { er,       er,       er,  A_rn|id,  A_cX|w15, A_cX|A_RC|w21,     A_cX|w14,      er,       er,   b0 },                              
/*25w14*/  { er,       er,       er,       er,       w15,      A_RC|w21,          w14,      er,       er,   b0 },
/* w15 */  { er,  A_rn|wq,       er,       er,       er,            w20,          w15,      er,       er,   b0 },
/* wq  */  { er,  A_rn|wq,       er,       er,       er,       A_wd|w20,     A_wd|w16, A_rn|wq,       er,   b0 },
/* w16 */  { er,  A_rn|min,      er,       er,       er,            w20,          w16,      er,       er,   b0 },
/* min */  { er,  A_rn|min,      er,       er,       er,       A_wd|w20,     A_wd|w17,A_rn|min,       er,   b0 },
/*30w17*/  { er,  A_rn|max,      er,       er,       er,            w20,          w17,      er,       er,   b0 },
/* max */  { er,  A_rn|max,      er,       er,       er,       A_wd|w20,     A_wd|w18,A_rn|max,       er,   b0 },
/* w18 */  { er,  A_rn|mp,       er,       er,       er,            w20,          w18,      er,       er,   b0 },
/* mp  */  { er,  A_rn|mp,       er,       er,       er,       A_wd|w20,     A_wd|w19, A_rn|mp,       er,   b0 },
/* w19 */  { er,       er,       er,       er,       er,            w20,          w19,      er,       er,   b0 },
/*35w20*/  { er,       er,       er,  A_rn|id,       er,       A_RC|w21,          w20,      er,       er,   b0 },
/* w21 */  { er,       er,       er,       er,       er,            er,           w21,      er,       er,   b0 },
/* er  */  { er,       er,       er,       er,       er,            er,           er,       er,       er,   b0 }};                                                                            


