/*
 * Copyright (c) 2005 Anton Antonov <aga@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: conpipes.c,v 1.6 2005/08/04 17:12:19 aga Exp $ 
 */

#include <syslog.h>
#include <stdarg.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/mbuf.h>
#include <sys/socket.h>
#include <sys/sysctl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sysexits.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/ip_fw2.h>
#include <net/route.h> /* def. of struct route */
#include <netinet/ip_dummynet.h>
#include <string.h>
#include <multilar.h>
#include <babolo/BLINflag.h>
#include "conpipes.h"

#define IS_QUEUE    0x100
#define IS_PIPE     0x200
#define FROM_FILE   0x400
#define FROM_STDIN  0x800

int lookup_depth, avg_pkt_size;
size_t len;
struct clockinfo ck;

int 
compare_pipes(mular_descriptor *mularP, int *maskP,mular_descriptor *mularQ, int *maskQ);

void 
show_usage(void) {
    fprintf(stderr, "usage:
            conpipes [-f file ... ]
            The program will read the first 12 files\n");
    exit(-1);
}

void 
writeLogs(int priority, const char *message){
       openlog("conpipes", LOG_PID | LOG_NDELAY, LOG_DAEMON);
       syslog(priority, message);
       closelog(); 
}

int 
check(struct dn_pipe *object, int objectID) {
    if (objectID & IS_PIPE) {   /* if pipe */
        if (object->pipe_nr < 1 || object->pipe_nr > 65534 || object->bandwidth < 0 ||
            object->delay < 0 || object->delay > 10000 || object->fs.plr < 0 ||
            object->fs.rq_size < 0 || object->fs.rq_size > 65536) return 1;
        if (object->fs.flags_fs & DN_QSIZE_IS_BYTES) {
                if (object->fs.qsize < 0 || object->fs.qsize > 1024 * 1024) return 1;
        } else if(object->fs.qsize < 0 || object->fs.qsize > 100) return 1;
        if (object->fs.flags_fs & DN_IS_RED) { /* RED & GRED */
                int t;
                double s, idle, weight, w_q;
                                
                if (object->fs.min_th >= object->fs.max_th || object->fs.max_th == 0 ||
                    lookup_depth == 0 || avg_pkt_size == 0 || ck.hz == 0) return 1;
                if (object->bandwidth == 0)  s = 0; /* this is a WF2Q+ queue */
                else s = ck.hz * avg_pkt_size * 8 / object->bandwidth;
                w_q = ((double)object->fs.w_q) / (1 << SCALE_RED);
                idle = s * 3. / w_q;
                object->fs.lookup_step = (int)idle / lookup_depth;
                if (!object->fs.lookup_step) object->fs.lookup_step = 1;
                weight = 1 - w_q;
                for (t = object->fs.lookup_step; t > 0; --t) weight *= weight;
                object->fs.lookup_weight = (int)(weight * (1 << SCALE_RED));
        }
        return 0;
    } else if (objectID & IS_QUEUE) {
          if (object->fs.fs_nr <= 0 || object->fs.fs_nr > 65534 || object->fs.parent_nr <= 0 ||
              object->fs.parent_nr > 65534 || object->fs.weight < 1 || object->fs.weight > 100 ||
              object->fs.plr < 0 || object->fs.rq_size < 16 || object->fs.rq_size > 65536) return 1;
          if (object->fs.flags_fs & DN_QSIZE_IS_BYTES) {
                if (object->fs.qsize < 0 || object->fs.qsize > 1024 * 1024) return 1;
          } else if (object->fs.qsize < 0 || object->fs.qsize > 100) return 1;
          if (object->fs.flags_fs & DN_IS_RED) {  /* RED & GRED */
                double weight, w_q;
                
                if (object->fs.min_th >= object->fs.max_th || object->fs.max_th == 0 ||
                    lookup_depth == 0 || avg_pkt_size == 0) return 1;
                w_q = ((double)object->fs.w_q) / (1 << SCALE_RED);
                object->fs.lookup_step = 1;
                weight = 1 - w_q;
                weight *= weight;
                object->fs.lookup_weight = (int)(weight * (1 << SCALE_RED));
          }
          return 0;
     }
     return 1; 
}

int
pipes_reader(int ac, char **av) {
    
    FILE *f = NULL;
    int fd = NULL, c, i, objectID, state, old_state;
    char str[20], ID[20], errMessage[256];
    struct dn_pipe *object;
    int lineno, lineno_begin = NULL;
    
    int pipe_counter = 0, queue_counter = 0;
    double w_q, max_p;
    uint32_t *p32 = NULL, a32, action;
    uint16_t *p16 = NULL;

    int input = NULL;
    
    int maskP[65535], maskQ[65535];
    mular_descriptor *mularP, *mularQ;
    int size[] = {4096, 16};
    
    struct dn_pipe *tmp_pipe;
    struct dn_flow_set *tmp_queue;
    
    if ( !(mularP = mular_create(NULL, 2, sizeof(struct dn_pipe), size)) ) {
         snprintf(errMessage, 256, "mularP not create: %s", strerror(errno));
         writeLogs(LOG_EMERG, errMessage);
         return -1;
    }
    if ( !(mularQ = mular_create(NULL, 2, sizeof(struct dn_flow_set), size))) {
         snprintf(errMessage, 256, "mularP not create: %s", strerror(errno));
         writeLogs(LOG_EMERG, errMessage);
         return -1;
    }  
    
    for (i = 0; i < 65535; i++) {
        maskP[i] = 0;
        maskQ[i] = 0;
    }
    if (ac == 1) {
        input = FROM_STDIN;
        if( (fd = open("/dev/fd/0", O_RDONLY)) < 0) {
            snprintf(errMessage, 256, "open: /dev/fd/0: %s", strerror(errno));
            writeLogs(LOG_EMERG, errMessage);
            exit(-1);
        } 
    } else {
        while ((i = getopt(ac, av, "f")) > 0) {
                switch (i) {
                case 'f':
                        input = FROM_FILE;
                        break;
                default:
                        show_usage();
                }   
        }
        if (input != FROM_FILE) show_usage();
        ac -= optind;
        av += optind;
    }
    
    if((object = malloc(240)) == NULL) {  /*    */
        snprintf(errMessage, 256, "malloc: object: %s", strerror(errno));
        writeLogs(LOG_EMERG, errMessage);
        return -2;
    }
    /*   */
    len = sizeof(int);
    if (sysctlbyname("net.inet.ip.dummynet.red_lookup_depth", &lookup_depth, &len, NULL, 0) == -1) lookup_depth = 0;
    if (sysctlbyname("net.inet.ip.dummynet.red_avg_pkt_size", &avg_pkt_size, &len, NULL, 0) == -1) avg_pkt_size = 0;
    len = sizeof(struct clockinfo);
    if (sysctlbyname("kern.clockrate", &ck, &len, NULL, 0) == -1) ck.hz = 0;

    if(ac > 12) ac = 12;

next_file:
    while (ac > 0) {
        if (input & FROM_STDIN) {
            if((f = fdopen(fd, "r")) < 0) {
                snprintf(errMessage, 256, "fdopen: %s", strerror(errno));
                writeLogs(LOG_EMERG, errMessage);
                exit(-1);
            } 
        } else if(input & FROM_FILE)
                if((f = fopen(*av, "r")) == NULL) { 
                        snprintf(errMessage, 256, "fopen: %s : %s", *av, strerror(errno));
                        writeLogs(LOG_ALERT, errMessage);
                        ac--;
                        av++;
                        goto next_file;
                }
        ac--;
        av++;

        lineno = 1;
        state = 0;
        old_state = 0;
        i = 0;c = 0;
        objectID = 0;
        
        while (state < end) {
		old_state = state;
                c = getc(f);
                if (class[c] == re) lineno++; /*    */
                if (c == EOF) { state = end; continue; }
                action = automat[state][class[c]];
                state = action & 0xff;     /*   */
                
                if (state == er && old_state != er) {
                        snprintf(errMessage, 256, "Syntax error: %s: Line number: %d",*(av-1), lineno);
                        writeLogs(LOG_ALERT, errMessage);
                        i = 0;
                        memset(object, NULL, sizeof(struct dn_pipe));
                }
                if (action & A_rn) {
			if (i > 18) state = er;
			else str[i++] = (char)c;
                        continue;}
		if (action & A_cr) {
			memset(object, NULL, sizeof(struct dn_pipe));
                	lineno_begin = lineno; /*       */}
		if (action & A_wd) {
			if ((int)str[i-1] == 'B') {
                    		object->fs.flags_fs |= DN_QSIZE_IS_BYTES;
                    		i--;
                	}
                	str[i] = '\0';
                	switch(old_state) {
                	case n1:
                    		if (objectID & IS_PIPE) object->pipe_nr = atoi(str);
                    		else if (objectID & IS_QUEUE) object->fs.fs_nr = atoi(str);
                    		break;
                	case n2:
                    		if (objectID & IS_PIPE) object->bandwidth = strtoul(str, NULL, 0);
                    		else if (objectID & IS_QUEUE) object->fs.parent_nr = strtoul(str, NULL, 0);
                    		break;
                	case n3:
                    		if (objectID & IS_PIPE) object->delay = strtoul(str, NULL, 0);
                    		else if (objectID & IS_QUEUE) object->fs.weight = strtoul(str, NULL, 0);
                    		break;
                	case qs:
                    		object->fs.qsize = strtoul(str, NULL, 0);
                    		break;
                	case pl:
                    		object->fs.plr = (int)(strtod(str, NULL) * 0x7fffffff);
                    		break;
                	case bu:
                    		object->fs.rq_size = strtoul(str, NULL, 0);
                    		break;
                	case wq:
                    		w_q = strtod(str, NULL);
                    		object->fs.w_q = (int) (w_q * (1 << SCALE_RED));
                    		break;
                	case min:
                    		object->fs.min_th = strtoul(str, 0, 0);
                    		break;
                	case max:
                    		object->fs.max_th = strtoul(str, 0, 0);
                    		break;
                	case mp:
                    		max_p = strtod(str, NULL);
                    		object->fs.max_p = (int)(max_p * (1 << SCALE_RED));
                    		break;
                	case rm: /*   */
                    		if (strcmp(ID, "DSTIP") == 0) p32 = &(object->fs.flow_mask.dst_ip);
                    		else if (strcmp(ID, "SRCIP") == 0) p32 = &(object->fs.flow_mask.src_ip);
                    		else if (strcmp(ID, "DSTPORT") == 0) p16 = &(object->fs.flow_mask.dst_port);
                    		else if (strcmp(ID, "SRCPORT") == 0) p16 = &(object->fs.flow_mask.src_port);
                    		else if (strcmp(ID, "DSTIP") != 0 && strcmp(ID, "SRCIP") != 0 && strcmp(ID,"DSTPORT") != 0
                            		&& strcmp(ID, "SRCPORT") != 0 && strcmp(ID, "PROTO_MASK") != 0) {
                              			state = w11;
                              			break;
                    		}
                    		a32 = strtoul(str, 0, 0);
                    		if (p32 != NULL) *p32 = a32;
                    		else if (p16 != NULL) *p16 = (uint16_t)a32;
                    		else object->fs.flow_mask.proto = (uint8_t)a32;
                    		if (a32 != 0) object->fs.flags_fs |= DN_HAVE_FLOW_MASK;    
                    		break;
                	}
			i = 0;}
		if (action & A_cX){
			/*       */
			str[i] = '\0';
                	if (old_state == b1) {
                    		if (strcmp(str, "PIPE") == 0) objectID = IS_PIPE;
                      		else if (strcmp(str, "QUEUE") == 0) objectID = IS_QUEUE;
                	} else if (old_state == ri) { /* flow mask id */
                        	if (strcmp(str, "SRCIP") == 0 || strcmp(str, "DSTIP") == 0 ||
                            	   strcmp(str,"DSTPORT") == 0 || strcmp(str, "SRCPORT") == 0 ||
                            	   strcmp(str,"PROTO_MASK") == 0) strcpy(ID,str); /*   */
                        	else if (strcmp(str,"ALL") == 0) {
                                	object->fs.flow_mask.dst_ip = ~0;
                                	object->fs.flow_mask.src_ip = ~0;
                                	object->fs.flow_mask.dst_port = ~0;
                                	object->fs.flow_mask.src_port = ~0;
                                	object->fs.flow_mask.proto = ~0;
                                	object->fs.flags_fs |= DN_HAVE_FLOW_MASK;}
                        } else if (old_state == id) {
                    		if (strcmp(str, "NOERROR") == 0) object->fs.flags_fs |= DN_NOERROR;
                        	else if (strcmp(str, "DROPTAIL") == 0) object->fs.flags_fs &= ~(DN_IS_RED|DN_IS_GENTLE_RED);
                         	else if (strcmp(str, "RED") == 0) object->fs.flags_fs |= DN_IS_RED;
                         	else if (strcmp(str, "GRED") == 0) {
                        		object->fs.flags_fs |= DN_IS_RED;
                        		object->fs.flags_fs |= DN_IS_GENTLE_RED;
                        	}
                	}
			i = 0;}
                if (action & A_RC) {
			if (check(object, objectID)) {
                        	snprintf(errMessage, 256, "Invalid object: %s: Line number: %d", *(av-1), lineno_begin);
                        	writeLogs(LOG_ALERT, errMessage);
                	} else if (objectID & IS_PIPE){ 
                        	if (maskP[(*object).pipe_nr-1] == 0) {
                                	maskP[(*object).pipe_nr-1] = pipe_counter + 1;
                                	if ((tmp_pipe = (struct dn_pipe *)mular_insert(mularP, pipe_counter++))) *tmp_pipe = *object;  
                                	else {
                                        	snprintf(errMessage, 256, "mular_insert: pipe %d not insert", (*object).pipe_nr);
                                        	writeLogs(LOG_EMERG, errMessage);
                                        	return -1;
                                	}                       
                         	}     
                	}else if (objectID & IS_QUEUE) 
                        	if (maskQ[(*object).fs.fs_nr-1] == 0) {
                                	maskQ[(*object).fs.fs_nr-1] = queue_counter + 1;
                                	if((tmp_queue = (struct dn_flow_set *)mular_insert(mularQ, queue_counter++))) 
                                        	*tmp_queue = (*object).fs;
                                	else{
                                        	snprintf(errMessage, 256, "mular_insert: queue %d not insert",(*object).fs.fs_nr);
                                        	writeLogs(LOG_ALERT, errMessage);
                                        	return -1;
                                	}                       
                         	}     
                	objectID = 0;
			}
        }/*end of while */
    } /*end of while*/
    free(object);
    /* Just for test */
    /*for (i = 0; i < 65535; i++)
        if (maskP[i] > 0) {
                tmp_pipe = (struct dn_pipe *)mular_getix(mularP, maskP[i] - 1);
                printf("maskP[%d]=%d pipe_nr=%d src_ip=%x fs_nr=%d\n", i, maskP[i] - 1, (*tmp_pipe).pipe_nr, (*tmp_pipe).fs.flow_mask.src_ip, (*tmp_pipe).fs.fs_nr);
        }
    for(i = 0;i < 65535; i++)
        if(maskQ[i] > 0){
                tmp_queue = (struct dn_flow_set *)mular_getix(mularQ, maskQ[i] - 1);
                printf("maskQ[%d]=%d queue_nr=%d src_ip=%x\n", i, maskQ[i] - 1, (*tmp_queue).fs_nr, (*tmp_queue).flow_mask.src_ip);
        }*/
    i = 0;
    if (pipe_counter > 0 || queue_counter > 0)
        while ((i = compare_pipes(mularP, maskP, mularQ, maskQ)) == -1) {
            snprintf(errMessage, 256, "pipes_reader: restart compare_pipes");
            writeLogs(LOG_ALERT, errMessage);
        } 
    return i;
} /*end of pipes_reader */

int 
main(int ac, char **av) {
    int i;
    char errMessage[256];
    while((i = pipes_reader(ac, av)) != 0) {
        snprintf(errMessage, 256, "conpipes: restart from the beginning");
        writeLogs(LOG_ALERT, errMessage);
    }
    return 0;
}
