--# Copyright (C)2002..2018 @BABOLO http://www.babolo.ru/
--# Copyright (C)2005..2007 GD <gd@pikenet.ru>
--# Copyright (C)2005 Michael Deryugin <dem@pikenet.ru>
--# All rights reserved.
--#
--# Redistribution and use in source and binary forms, with or without
--# modification, are permitted provided that the following conditions
--# are met:
--# 1. Redistributions of source code must retain the above copyright
--#    notice, this list of conditions and the following disclaimer.
--# 2. Redistributions in binary form must reproduce the above copyright
--#    notice, this list of conditions and the following disclaimer in the
--#    documentation and/or other materials provided with the distribution.
--#
--# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
--# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
--# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
--# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
--# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
--# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
--# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
--# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
--# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
--# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
--# SUCH DAMAGE.
--#
--# $Id: babolo_pglib.sql.m4,v 1.3 2018/08/10 17:23:26 babolo Exp $

--########################################################################
--#  pglib_text
--########################################################################

CREATE OR REPLACE FUNCTION quote_html(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_html'
 LANGUAGE C IMMUTABLE STRICT
;
CREATE OR REPLACE FUNCTION quote_sh(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_sh'
 LANGUAGE C IMMUTABLE STRICT
;
CREATE OR REPLACE FUNCTION quote_copy(text) RETURNS text
 AS 'MODULE_PATHNAME/pglib_text.so.VMAJOR', 'quote_copy'
 LANGUAGE C IMMUTABLE
;

CREATE OR REPLACE FUNCTION compare(integer, text[], text[]) RETURNS bool
 AS 'SELECT CASE WHEN $1 IS NULL
                 THEN FALSE
                 WHEN $2 IS NULL AND $3 IS NULL
                 THEN TRUE
                 WHEN $2 IS NULL OR $3 IS NULL
                 THEN FALSE
                 WHEN array_lower($2, 1) <> array_lower($3, 1)
                   OR (   array_upper($2, 1) <> array_upper($3, 1)
                      AND (array_upper($2, 1) < $1 OR array_upper($3, 1) < $1)
                      )
                 THEN FALSE
                 WHEN array_lower($2, 1) > $1
                 THEN TRUE
                 WHEN array_upper($2, 1) > $1
                 THEN $2[array_lower($2, 1):$1] = $3[array_lower($3, 1):$1]
                 ELSE $2 = $3
            END
    '
 LANGUAGE SQL IMMUTABLE
;
COMMENT ON FUNCTION compare(integer, text[], text[]) IS '  $1   $2  $3';

--########################################################################
--#  pglib_ip
--########################################################################

CREATE OR REPLACE FUNCTION inet(int4) RETURNS inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'int4_inet'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION inet(int4)        IS ' int4  IP ';

CREATE OR REPLACE FUNCTION inet(int8) RETURNS inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'int8_inet'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION inet(int8)        IS ' int8  IP ';

CREATE OR REPLACE FUNCTION int4(inet) RETURNS int4
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inet_int4'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION int4(inet)        IS ' IP   int4';

CREATE OR REPLACE FUNCTION int8(inet) RETURNS int8
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inet_int8'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION int8(inet)        IS ' IP   int8';

CREATE OR REPLACE FUNCTION ip_set(inet, int) RETURNS SETOF inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ip_set'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION ip_set(inet, int) IS '       ';

CREATE OR REPLACE FUNCTION ip_set(inet) RETURNS SETOF inet
 AS 'SELECT ip_set($1, 32)'
 LANGUAGE SQL IMMUTABLE STRICT
;
COMMENT ON FUNCTION ip_set(inet)      IS '    ';

CREATE OR REPLACE FUNCTION ip_supernet(inet) RETURNS SETOF inet
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ip_supernet'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION ip_supernet(inet) IS '    ';

--#
CREATE OR REPLACE FUNCTION ipaggr_in(cstring) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ipaggr_in'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION ipaggr_in(cstring)        IS '   IP ';

CREATE OR REPLACE FUNCTION ipaggr_out(ipaggr) RETURNS cstring
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'ipaggr_out'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION ipaggr_out(ipaggr)        IS ' IP   ';

CREATE OR REPLACE FUNCTION add_net(ipaggr, inet) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'add_net'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION add_net(ipaggr, inet)     IS '  IP  ';

CREATE OR REPLACE FUNCTION sub_net(ipaggr, inet) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'sub_net'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION sub_net(ipaggr, inet)     IS '  IP  ';

CREATE OR REPLACE FUNCTION add_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'add_ipaggr'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION add_ipaggr(ipaggr, ipaggr)IS '  IP ';

CREATE OR REPLACE FUNCTION sub_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'sub_ipaggr'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION sub_ipaggr(ipaggr, ipaggr)IS '  IP ';

CREATE OR REPLACE FUNCTION inter_ipaggr(ipaggr, ipaggr) RETURNS ipaggr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'inter_ipaggr'
 LANGUAGE C IMMUTABLE STRICT
;

CREATE OR REPLACE FUNCTION show_net(ipaggr) RETURNS SETOF cidr
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'show_net'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION show_net(ipaggr)          IS ' IP    ';

CREATE OR REPLACE FUNCTION check_net(ipaggr, inet) RETURNS boolean
 AS 'MODULE_PATHNAME/pglib_ip.so.VMAJOR', 'check_net'
 LANGUAGE C IMMUTABLE STRICT
;

CREATE TYPE ipaggr (
   internallength = VARIABLE, 
   input = ipaggr_in,
   output = ipaggr_out,
   alignment = double,
   storage = external
);

CREATE AGGREGATE sum_net (
    sfunc = add_net,
    basetype = inet,
    stype = ipaggr,
    initcond = 'f'
);
COMMENT ON AGGREGATE sum_net(inet)            IS '   IP ';

CREATE OPERATOR + (
    leftarg = ipaggr,
    rightarg = ipaggr,
    procedure = add_ipaggr,
    commutator = +
);

CREATE OPERATOR - (
    leftarg = ipaggr,
    rightarg = ipaggr,
    procedure = sub_ipaggr,
    commutator = -
);

CREATE OPERATOR * (
    leftarg = ipaggr,
    rightarg = ipaggr,
    procedure = inter_ipaggr,
    commutator = *
);

CREATE OPERATOR + (
    leftarg = ipaggr,
    rightarg = inet,
    procedure = add_net,
    commutator = +
);

CREATE OPERATOR - (
    leftarg = ipaggr,
    rightarg = inet,
    procedure = sub_net,
    commutator = -
);

--########################################################################
--#  pglib_bytea
--########################################################################

CREATE OR REPLACE FUNCTION bytea(int4, int4) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'int4_bytea'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION bytea(int4, int4) IS '      ,   ';

CREATE OR REPLACE FUNCTION bytea(int4) RETURNS bytea
 AS 'SELECT bytea($1, 4)'
 LANGUAGE SQL IMMUTABLE STRICT
;
COMMENT ON FUNCTION bytea(int4)       IS '    bytea';

CREATE OR REPLACE FUNCTION bytea(int8, int4) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'int8_bytea'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION bytea(int8, int4) IS '      ,   ';

CREATE OR REPLACE FUNCTION bytea(int8) RETURNS bytea
 AS 'SELECT bytea($1, 8)'
 LANGUAGE SQL IMMUTABLE STRICT
;
COMMENT ON FUNCTION bytea(int8)       IS '    bytea';

CREATE OR REPLACE FUNCTION bytea(text) RETURNS bytea
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'text_bytea'
 LANGUAGE C IMMUTABLE STRICT
;

COMMENT ON FUNCTION bytea(text)       IS '    bytea';
CREATE OR REPLACE FUNCTION text(bytea) RETURNS text
 AS 'MODULE_PATHNAME/pglib_bytea.so.VMAJOR', 'bytea_text'
 LANGUAGE C IMMUTABLE STRICT
;

--########################################################################
--#  pglib_bit
--########################################################################

--#          --
--#-------------------------------------------------------------
CREATE OR REPLACE FUNCTION num2bit(integer) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'num2bit'
 LANGUAGE C IMMUTABLE STRICT
;
CREATE OR REPLACE FUNCTION bit2num(varbit) RETURNS SETOF int4
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bit2num'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION bit2num(varbit) IS '   ,        ,       '
;

--#    --
--#----------------------------
CREATE OR REPLACE FUNCTION bitex0(bit, int4) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bitex0'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION bitex0(bit, int4) IS '   ,    0';

CREATE OR REPLACE FUNCTION bitex1(bit, int4) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'bitex1'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION bitex1(bit, int4) IS '   ,    1';

--#  varbit  bool  AND  OR --
--#-------------------------------------
CREATE OR REPLACE FUNCTION boolor(bit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'boolor'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION boolor(bit)       IS 'OR    ';

CREATE OR REPLACE FUNCTION booland(bit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'booland'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION booland(bit)      IS 'AND    ';

--#    , ,            --
--#    ,    --
--#----------------------------------------------------------------------
CREATE OR REPLACE FUNCTION public.varbiteq(bit, bit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbiteq'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbiteq(bit, bit)   IS '    ';

CREATE OR REPLACE FUNCTION varbitand(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitand'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbitand(bit, bit)  IS 'AND      ';

CREATE OR REPLACE FUNCTION varbitor(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitor'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbitor(bit, bit)   IS 'OR      ';

CREATE OR REPLACE FUNCTION varbitxor(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitxor'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbitxor(bit, bit)  IS 'XOR      ';

CREATE OR REPLACE FUNCTION varbitrst(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitrst'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbitrst(bit, bit)  IS '$1 AND ~$2,       ';

CREATE OR REPLACE FUNCTION varbitmeq(bit, bit, bit) RETURNS bool
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitmeq'
 LANGUAGE C IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbitmeq(bit, bit, bit)  IS '$1  $2    $3';

CREATE OPERATOR ==
     ( LEFTARG = bit
     , RIGHTARG = bit
     , PROCEDURE = public.varbiteq
     , COMMUTATOR = ==
     )
;
COMMENT ON OPERATOR == (bit, bit)        IS '    ';

CREATE OPERATOR /|
     ( LEFTARG = bit
     , RIGHTARG = bit
     , PROCEDURE = varbitand
     , COMMUTATOR = /|
     )
;
COMMENT ON OPERATOR /| (bit, bit)        IS 'AND      ';

CREATE OPERATOR |/
     ( LEFTARG = bit
     , RIGHTARG = bit
     , PROCEDURE = varbitor
     , COMMUTATOR = |/
     )
;
COMMENT ON OPERATOR |/ (bit, bit)        IS 'OR      ';

CREATE OPERATOR /|/
     ( LEFTARG = bit
     , RIGHTARG = bit
     , PROCEDURE = varbitxor
     , COMMUTATOR = /|/
     )
;
COMMENT ON OPERATOR /|/ (bit, bit)       IS 'XOR      ';

CREATE OPERATOR !
     ( LEFTARG = bit
     , RIGHTARG = bit
     , PROCEDURE = varbitrst
     )
;
COMMENT ON OPERATOR ! (bit, bit)         IS '$1 AND ~$2,       ';

--# / varbit --
--#---------------------
CREATE OR REPLACE FUNCTION varbit(text) RETURNS varbit
 AS 'DECLARE
        i int;
        r varbit;
        c char;
     BEGIN
        r := ''''::varbit;
        FOR i IN 1..length($1) LOOP
           c := substr($1, i, 1);
           IF c = ''1''
           THEN r := varbitor(r, bitex0(''1''::varbit, i) >> (i - 1));
           ELSIF c <> ''0''
           THEN RAISE EXCEPTION ''"%" is not a valid binary digit'', c;
           END IF;
        END LOOP;
        RETURN r;
     END;
    '
 LANGUAGE 'plpgsql' IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbit(text) IS '   varbit';

CREATE OR REPLACE FUNCTION text(varbit) RETURNS text 
 AS 'DECLARE
        i int;
        t text;
     BEGIN
        t := ''''::text;
        FOR i IN 1..bit_length($1) LOOP
           IF boolor(varbitand($1, (bitex0(''1''::varbit, i) >> (i - 1))))
           THEN t := t || ''1'';
           ELSE t := t || ''0'';
           END IF;
        END LOOP;
        RETURN t;
     END;
    '
 LANGUAGE 'plpgsql' IMMUTABLE STRICT
;
COMMENT ON FUNCTION varbit(text) IS ' varbit  ';

--#  bool  AND  OR --
--#-------------------------------
CREATE OR REPLACE FUNCTION bool_and(bool, bool) RETURNS bool
 AS 'SELECT $1 AND $2'
 LANGUAGE SQL IMMUTABLE STRICT
;
COMMENT ON FUNCTION bool_and(bool, bool) IS '        ';

CREATE OR REPLACE FUNCTION bool_or(bool, bool) RETURNS bool
 AS 'SELECT $1 OR $2'
 LANGUAGE SQL IMMUTABLE STRICT
;
COMMENT ON FUNCTION bool_or(bool, bool)  IS '        ';

CREATE AGGREGATE conjunction
     ( BASETYPE = bool
     , SFUNC = bool_and
     , STYPE = bool
     , INITCOND = 1
     )
;
COMMENT ON AGGREGATE conjunction(bool)   IS ' AND  bool';

CREATE AGGREGATE disjunction
     ( BASETYPE = bool
     , SFUNC = bool_or
     , STYPE = bool
     , INITCOND = 0
     )
;
COMMENT ON AGGREGATE disjunction(bool)   IS ' OR  bool';

--#  varbit  AND  OR --
--#---------------------------------
CREATE OR REPLACE FUNCTION varbitandn(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitand'
 LANGUAGE C IMMUTABLE
;
COMMENT ON FUNCTION varbitandn(bit, bit) IS 'varbitand  ';

CREATE OR REPLACE FUNCTION varbitorn(bit, bit) RETURNS varbit
 AS 'MODULE_PATHNAME/pglib_bit.so.VMAJOR', 'varbitor'
 LANGUAGE C IMMUTABLE
;
COMMENT ON FUNCTION varbitorn(bit, bit)  IS 'varbitor  ';

CREATE AGGREGATE conjunction
     ( BASETYPE = bit
     , SFUNC = varbitandn
     , STYPE = varbit
     )
;
COMMENT ON AGGREGATE conjunction(bit)    IS ' AND  bit';

CREATE AGGREGATE disjunction
     ( BASETYPE = bit
     , SFUNC = varbitorn
     , STYPE = varbit
     )
;
COMMENT ON AGGREGATE disjunction(bit)    IS ' OR  bit';
