/*-
 * Copyright (C) @BABOLO  2002 Nov 03
 * Portions Copyright (c) 2000, PostgreSQL Global Development Group
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Nov 03\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pglib_text.c,v 1.5 2016/07/12 22:02:34 babolo Exp $";
#endif /* not lint */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <postgres.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <fmgr.h>
#include <utils/inet.h>
#include <nodes/nodes.h>
#include <nodes/execnodes.h>
#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif
//#define ELOG(X) elog X
#define ELOG(X)

static const u_char subst_in[]    = {
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,5,0, 0,0,4,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 3,0,3,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 5,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

static const char *subst_out[] = {
 "\000"  ,"\001"  ,"\002"  ,"\003"  , "\004"  ,"\005"  ,"\006"  ,"\007",
 "\010"  ,"\011"  ,"\012"  ,"\013"  , "\014"  ,"\015"  ,"\016"  ,"\017",
 "\020"  ,"\021"  ,"\022"  ,"\023"  , "\024"  ,"\025"  ,"\026"  ,"\027",
 "\030"  ,"\031"  ,"\032"  ,"\033"  , "\034"  ,"\035"  ,"\036"  ,"\037",
 "\040"  ,"\041"  ,"&quot;","\043"  , "\044"  ,"\045"  ,"&amp;" ,"\047",
 "\050"  ,"\051"  ,"\052"  ,"\053"  , "\054"  ,"\055"  ,"\056"  ,"\057",
 "\060"  ,"\061"  ,"\062"  ,"\063"  , "\064"  ,"\065"  ,"\066"  ,"\067",
 "\070"  ,"\071"  ,"\072"  ,"\073"  , "&lt;"  ,"\075"  ,"&gt;"  ,"\077",

 "\100"  ,"\101"  ,"\102"  ,"\103"  , "\104"  ,"\105"  ,"\106"  ,"\107",
 "\110"  ,"\111"  ,"\112"  ,"\113"  , "\114"  ,"\115"  ,"\116"  ,"\117",
 "\120"  ,"\121"  ,"\122"  ,"\123"  , "\124"  ,"\125"  ,"\126"  ,"\127",
 "\130"  ,"\131"  ,"\132"  ,"\133"  , "\134"  ,"\135"  ,"\136"  ,"\137",
 "\140"  ,"\141"  ,"\142"  ,"\143"  , "\144"  ,"\145"  ,"\146"  ,"\147",
 "\150"  ,"\151"  ,"\152"  ,"\153"  , "\154"  ,"\155"  ,"\156"  ,"\157",
 "\160"  ,"\161"  ,"\162"  ,"\163"  , "\164"  ,"\165"  ,"\166"  ,"\167",
 "\170"  ,"\171"  ,"\172"  ,"\173"  , "\174"  ,"\175"  ,"\176"  ,"\177",

 "\200"  ,"\201"  ,"\202"  ,"\203"  , "\204"  ,"\205"  ,"\206"  ,"\207",
 "\210"  ,"\211"  ,"\212"  ,"\213"  , "\214"  ,"\215"  ,"\216"  ,"\217",
 "\220"  ,"\221"  ,"\222"  ,"\223"  , "\224"  ,"\225"  ,"\226"  ,"\227",
 "&nbsp;","\231"  ,"\232"  ,"\233"  , "\234"  ,"\235"  ,"\236"  ,"\237",
 "\240"  ,"\241"  ,"\242"  ,"\243"  , "\244"  ,"\245"  ,"\246"  ,"\247",
 "\250"  ,"\251"  ,"\252"  ,"\253"  , "\254"  ,"\255"  ,"\256"  ,"\257",
 "\260"  ,"\261"  ,"\262"  ,"\263"  , "\264"  ,"\265"  ,"\266"  ,"\267",
 "\270"  ,"\271"  ,"\272"  ,"\273"  , "\274"  ,"\275"  ,"\276"  ,"\277",

 "\300"  ,"\301"  ,"\302"  ,"\303"  , "\304"  ,"\305"  ,"\306"  ,"\307",
 "\310"  ,"\311"  ,"\312"  ,"\313"  , "\314"  ,"\315"  ,"\316"  ,"\317",
 "\320"  ,"\321"  ,"\322"  ,"\323"  , "\324"  ,"\325"  ,"\326"  ,"\327",
 "\330"  ,"\331"  ,"\332"  ,"\333"  , "\334"  ,"\335"  ,"\336"  ,"\337",
 "\340"  ,"\341"  ,"\342"  ,"\343"  , "\344"  ,"\345"  ,"\346"  ,"\347",
 "\350"  ,"\351"  ,"\352"  ,"\353"  , "\354"  ,"\355"  ,"\356"  ,"\357",
 "\360"  ,"\361"  ,"\362"  ,"\363"  , "\364"  ,"\365"  ,"\366"  ,"\367",
 "\370"  ,"\371"  ,"\372"  ,"\373"  , "\374"  ,"\375"  ,"\376"  ,"\377"};

PG_FUNCTION_INFO_V1(quote_html);
Datum quote_html(PG_FUNCTION_ARGS) {
    text *t = PG_GETARG_TEXT_P(0);
    text *result;
    char const *cp0;
    char *cp1, *cp2;
    int rq, len;

    cp2 = VARDATA(t);
    cp1 = VARDATA(t) + VARSIZE(t) - VARHDRSZ;
    for (rq = 0; cp2 < cp1; cp2++) rq += subst_in[*(u_char*)cp2];

    if  (rq) {
        len = VARSIZE(t) - VARHDRSZ;
        result = (text *) palloc(len + rq + VARHDRSZ);
        if  (result == NULL)
                   ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_sh: out of memory")));
        cp2 = VARDATA(result);
        for (cp1 = VARDATA(t); len-- > 0; cp1++) {
            cp0 = subst_out[*(u_char*)cp1];
            do  {
                *cp2++ = *cp0++;
            } while (*cp0);
	}
#ifdef VARATT_SIZEP
        VARATT_SIZEP(result) = cp2 - ((char *) result);
#else
        SET_VARSIZE(result, cp2 - ((char *) result));
#endif
    } else {
        result = (text *) palloc(VARSIZE(t));
        if  (result == NULL)
                   ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_sh: out of memory")));
        memcpy(result, t, VARSIZE(t));
    }

    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_TEXT_P(result);
}

#define C_bq     0x2000 /*   \                                                                 */
#define C_aq     0x1000 /*                                                      */
#define C_dq      0x400 /*                                       */
#define C_sq      0x200 /*                                     */
#define C_pl      0x100 /*                                            */
#define C_state    0xFF /*                                                        */

enum states {c0, c1, c2, s0, s1, s2, s3, sx};
/****************************************
 * c0 -    
 * c1 -   
 * 2 -   
 * sx -  
 ****************************************/
#define ze 6
#define zx 7
static const u_char subst_ih[] = {
 1,0,0,0, 0,0,0,0, 0,1,5,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 1,1,2,1, 2,0,1,3, 1,1,1,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,1, 1,0,1,1,

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /************************************/
 0,0,0,0, 0,0,0,0, 0,0,0,0, 2,0,0,0,   /* 0 - as is                        */
 4,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /* 1 - any 'X', "X", \X acceptable  */
 0,0,0,0, 0,0,0,0, 0,0,0,1, 1,1,0,1,   /* 2 - any 'X', "\X", \X acceptable */
                                       /* 3 - '                            */
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /* 4 - only 'X' acceptable          */
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /* 5 - any 'X', "X" acceptable      */
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /* 6 -                   */
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,   /************************************/

 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};

u_int32_t automa[sx][zx] =
/*      0;       1;       2;            3;            4;       5;      ze;  */
{{C_pl|c0, C_pl|c0, C_pl|c0,      C_pl|c1,      C_pl|c2, C_pl|c0, C_sq|c0}/* c0 */
,{C_pl|c1, C_pl|c1, C_pl|c1,      C_pl|c1, C_dq|C_pl|c2, C_pl|c1, C_dq|c0}/* c1 */
,{C_pl|c2, C_pl|c2, C_pl|c2, C_sq|C_pl|c1,      C_pl|c2, C_pl|c2, C_sq|c0}/* c2 */
};

/*
 * asfdg -> asfdg
 * asf`dg -> 'asf`dg'
 * as'f``d -> as\'f'``'d
 * a s 'f` d -> "a s 'f"'`'\ d
 */
PG_FUNCTION_INFO_V1(quote_sh);
Datum quote_sh(PG_FUNCTION_ARGS) {
    text *t = PG_GETARG_TEXT_P(0);
    text *result;
    char *cp0, *cp1, *cp2;
    int rq[ze], rp, len;
    u_int32_t control;
    enum states state;

    bzero(rq, sizeof(rq));
    rp = 0;
    cp1 = VARDATA(t);
    len = VARSIZE(t) - VARHDRSZ;
    for (state = c0; len-- >= 0; cp1++) {
        control = automa[state][(len >= 0) ? subst_ih[(u_char)*cp1] : ze];
        ELOG((DEBUG, "quote_sh:%d: %08X %02X"
            , state, control, (len >= 0) ? subst_ih[(u_char)*cp1] : ze
            ));
        if  (control & C_sq) {
            rp += (rq[5] || (rq[1] + rq[2] + rq[4]) > 1) ? 2 : (rq[1] + rq[2] + rq[4]);
            bzero(rq, sizeof(rq));
        }
        if  (control & C_dq) {
            rp += rq[2] + ((rq[5] || (rq[1] + rq[3]) > 1) ? 2 : (rq[1] + rq[3]));
            bzero(rq, sizeof(rq));
        }
        if  (control & C_pl) rq[subst_ih[(u_char)*cp1]]++;
        state = control & C_state;
    }
    ELOG((DEBUG, "quote_sh: %d", rp));
    if  (rp) {
        len = VARSIZE(t) - VARHDRSZ;
        result = (text *) palloc(len + rp + VARHDRSZ);
        if  (result == NULL)
                   ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_sh: out of memory")));
        cp0 = cp1 = VARDATA(t);
        cp2 = VARDATA(result);
        for (state = c0; len-- >= 0; cp1++) {
            control = automa[state][(len >= 0) ? subst_ih[(u_char)*cp1] : ze];
            ELOG((DEBUG, "quote_sh:%d: %08X %02X"
                , state, control, (len >= 0) ? subst_ih[(u_char)*cp1] : ze
                ));
            if  (control & C_sq) {
                if  (rq[5] || (rq[1] + rq[2] + rq[4]) > 1) {
                    *cp2++ = '\'';
                    for (; cp0 < cp1; ++cp0) *cp2++ = *cp0;
                    *cp2++ = '\'';
                } else control |= C_bq;
                bzero(rq, sizeof(rq));
            }
            if  (control & C_dq) {
                if  (rq[5] || (rq[1] + rq[2] + rq[3]) > 1) {
                    *cp2++ = '\"';
                    for (; cp0 < cp1; ++cp0) {
                        if  (subst_ih[(u_char)*cp0] == 2) *cp2++ = '\\';
                        *cp2++ = *cp0;
                    }
                    *cp2++ = '\"';
                } else control |= C_bq;
                bzero(rq, sizeof(rq));
            }
            if  (control & C_bq) {
                for (; cp0 < cp1; ++cp0) {
                    if  (subst_ih[(u_char)*cp0]) *cp2++ = '\\';
                    *cp2++ = *cp0;
            }   }
            if  (control & C_pl) rq[subst_ih[(u_char)*cp1]]++;
            state = control & C_state;
	}
#ifdef VARATT_SIZEP
        VARATT_SIZEP(result) = cp2 - ((char *) result);
#else
        SET_VARSIZE(result, cp2 - ((char *) result));
#endif
    } else {
        result = (text *) palloc(VARSIZE(t));
        if  (result == NULL)
                   ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_sh: out of memory")));
        memcpy(result, t, VARSIZE(t));
    }

    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_TEXT_P(result);
}

#define STRNULL "\\N"

static const u_char copy_subst[] =
{ 0 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 , 'b','t','n','v', 'f','r', 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1

, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,'\\', 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1

, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1

, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
, 1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1 ,  1 , 1 , 1 , 1
};

PG_FUNCTION_INFO_V1(quote_copy);
Datum quote_copy(PG_FUNCTION_ARGS) {
    text *t, *result;
    char *cp1, *cp2;
    int rq, len, i;

    if  (PG_ARGISNULL(0)) {
        len = strlen(STRNULL);
        result = (text*)palloc(len + VARHDRSZ);
#ifdef VARATT_SIZEP
        VARATT_SIZEP(result) = len + VARHDRSZ;
#else
        SET_VARSIZE(result, len + VARHDRSZ);
#endif
        cp2 = VARDATA(result);
        memcpy(cp2, STRNULL, len);
    } else {
        t = PG_GETARG_TEXT_P(0);
        cp1 = VARDATA(t);
        len = VARSIZE(t);
        for (rq = 0, i = 0; i < len; i++) rq += (copy_subst[cp1[i] & 0xFF] < ' ') ? 0 : 1;

        if  (rq) {
            len -= VARHDRSZ;
            result = (text*)palloc(len + rq + VARHDRSZ);
#ifdef VARATT_SIZEP
            VARATT_SIZEP(result) = len + rq + VARHDRSZ;
#else
            SET_VARSIZE(result, len + rq + VARHDRSZ);
#endif
            if  (!result)
                ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_copy: out of memory")));
            cp2 = VARDATA(result);
            for (i = 0; i < len; i++) {
                if  (copy_subst[cp1[i] & 0xFF] < ' ') {
                    *(cp2++) = cp1[i];
                } else {
                    *(cp2++) = '\\';
                    *(cp2++) = copy_subst[cp1[i] & 0xFF];
            }   }
        } else {
            result = (text*)palloc(len);
            if  (!result)
                ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("quote_copy: out of memory")));
            memcpy(result, t, len);
        }
        PG_FREE_IF_COPY(t, 0);
    }
    PG_RETURN_TEXT_P(result);
}
