/*-
 * Copyright (C) @BABOLO  2002 Dec 02
 * Portions Copyright (c) 2000, PostgreSQL Global Development Group
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO  2002 Dec 02\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pglib_bytea.c,v 1.3 2016/02/19 20:21:03 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <postgres.h>
#include <fmgr.h>
#include <utils/inet.h>
#include <nodes/nodes.h>
#include <nodes/execnodes.h>

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

PG_FUNCTION_INFO_V1(int4_bytea);
Datum
int4_bytea(PG_FUNCTION_ARGS) {
    text *result;
    char *cp;
    int in, len, i;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    in = PG_GETARG_INT32(0);
    len = PG_GETARG_INT32(1);
    if  ((result = (text *) palloc(len + VARHDRSZ)) == NULL)
                 ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("int4_bytea: out of memory")));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(result) = len + VARHDRSZ;
#else
    SET_VARSIZE(result, len + VARHDRSZ);
#endif
    cp = VARDATA(result);
    for (i = 0; i < len; i++) {
        *cp++ = in & 0xFF;
        in = in >> 8;
    }
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(int8_bytea);
Datum
int8_bytea(PG_FUNCTION_ARGS) {
    text *result;
    char *cp;
    int len, i;
    u_int64_t in;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    in = PG_GETARG_INT64(0);
    len = PG_GETARG_INT32(1);
    if  ((result = (text *) palloc(len + VARHDRSZ)) == NULL)
                 ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("int8_bytea: out of memory")));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(result) = len + VARHDRSZ;
#else
    SET_VARSIZE(result, len + VARHDRSZ);
#endif
    cp = VARDATA(result);
    for (i = 0; i < len; i++) {
        *cp++ = in & 0xFF;
        in = in >> 8;
    }
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(text_bytea);
Datum
text_bytea(PG_FUNCTION_ARGS) {
    text *t = PG_GETARG_TEXT_P(0);
    text *result;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    result = (text *) palloc(VARSIZE(t));
    memcpy(result, t, VARSIZE(t));
    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_BYTEA_P(result);
}

PG_FUNCTION_INFO_V1(bytea_text);
Datum
bytea_text(PG_FUNCTION_ARGS) {
    text *t = PG_GETARG_TEXT_P(0);
    text *result;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    result = (text *) palloc(VARSIZE(t));
    memcpy(result, t, VARSIZE(t));
    PG_FREE_IF_COPY(t, 0);
    PG_RETURN_TEXT_P(result);
}
