/*-
 * Copyright (C)2005..2018 @BABOLO Mar 30 http://www.babolo.ru/
 * Copyright (C) GD <gd@pikenet.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C) @BABOLO, GD\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: pglib_bit.c,v 1.7 2018/08/10 17:18:51 babolo Exp $";
#endif /* not lint */

#include <sys/param.h>
#include <sys/types.h>
#include <string.h>
#include <postgres.h>
#include <utils/varbit.h>
#include <babolo/BLINflag.h>
#include <funcapi.h>
#define fctx ((results*)funcctx->user_fctx)

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

#define ELOG(X) elog X
//#define ELOG(X)

typedef struct {
    int cur;
    VarBit* str;
} results;

PG_FUNCTION_INFO_V1(boolor);
Datum 
boolor(PG_FUNCTION_ARGS) {
    VarBit *arg;
    size_t len;
    bits8 *bits;
    int res;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    arg = PG_GETARG_VARBIT_P(0);
    len = VARBITLEN(arg);
    bits = VARBITS(arg);

    for (res = 0; !res && len >= BITS_PER_BYTE; len -= BITS_PER_BYTE) {
        res = *(bits++);
    }
    if  (!res && len) {
        res = *(bits++) & (BITMASK << (BITS_PER_BYTE - len)) & BITMASK;
    }
    PG_RETURN_BOOL(res);
}

PG_FUNCTION_INFO_V1(booland);
Datum 
booland(PG_FUNCTION_ARGS) {
    VarBit *arg;
    size_t len;
    bits8 *bits;
    int res;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    arg = PG_GETARG_VARBIT_P(0);
    len = VARBITLEN(arg);
    bits = VARBITS(arg);

    for (res = 0; !res && len >= BITS_PER_BYTE; len -= BITS_PER_BYTE) {
        res = ~(*(bits++)) & BITMASK;
    }
    if  (!res && len) {
        res = ~(*(bits++)) & (BITMASK << (BITS_PER_BYTE - len)) & BITMASK;
    }
    PG_RETURN_BOOL(!res);
}

static bits8
gbit(bits8 **bits, size_t len, size_t maxlen) {
    u_char res;

    if  ((len + BITS_PER_BYTE) <= maxlen) res = *((*bits)++);
      else if (len >= maxlen) res = 0;
        else res = **bits & (BITMASK << (BITS_PER_BYTE + len - maxlen)) & BITMASK;
    return(res);
}

PG_FUNCTION_INFO_V1(varbiteq);
Datum 
varbiteq(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1;
    size_t len0, len1;
    size_t maxlen, len;
    bits8 *bits0, *bits1;
    int res;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    maxlen = (len0 > len1) ? len0 : len1;
    for (res = 0, len = 0; !res && len < maxlen; len += BITS_PER_BYTE) {
        res = gbit(&bits0, len, len0) ^ gbit(&bits1, len, len1);
    }
    PG_RETURN_BOOL(!res);
}

PG_FUNCTION_INFO_V1(varbitmeq);
Datum 
varbitmeq(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1, *arg2;
    size_t len0, len1, len2;
    size_t minlen, maxlen, len;
    bits8 *bits0, *bits1, *bits2;
    int res;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1) || PG_ARGISNULL(2)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    arg2 = PG_GETARG_VARBIT_P(2);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    len2 = VARBITLEN(arg2);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    bits2 = VARBITS(arg2);
    minlen = (len0 > len1) ? len1 : len0;
    maxlen = (minlen > len2) ? minlen : len2;
    for (res = 0, len = 0; !res && len < maxlen; len += BITS_PER_BYTE) {
        res = (gbit(&bits0, len, len0) & gbit(&bits1, len, len1)) ^ gbit(&bits2, len, len2);
    }
    PG_RETURN_BOOL(!res);
}

PG_FUNCTION_INFO_V1(varbitor);
Datum 
varbitor(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1, *res;
    size_t len0, len1;
    size_t maxlen, len;
    bits8 *bits0, *bits1, *bitsr;

    if  (PG_ARGISNULL(0) && PG_ARGISNULL(1)) PG_RETURN_NULL();
    if  (PG_ARGISNULL(1)) PG_RETURN_VARBIT_P(PG_GETARG_VARBIT_P(0));
    if  (PG_ARGISNULL(0)) PG_RETURN_VARBIT_P(PG_GETARG_VARBIT_P(1));
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    maxlen = (len0 > len1) ? len0 : len1;
    res = (VarBit*)palloc(VARBITTOTALLEN(maxlen));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(maxlen);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(maxlen));
#endif
    VARBITLEN(res) = maxlen;
    bitsr = VARBITS(res);

    for (len = 0; len < maxlen; len += BITS_PER_BYTE) {
        *(bitsr++) = gbit(&bits0, len, len0) | gbit(&bits1, len, len1);
    }
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(varbitxor);
Datum 
varbitxor(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1, *res;
    size_t len0, len1;
    size_t maxlen, len;
    bits8 *bits0, *bits1, *bitsr;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    maxlen = (len0 > len1) ? len0 : len1;
    res = (VarBit*)palloc(VARBITTOTALLEN(maxlen));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(maxlen);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(maxlen));
#endif
    VARBITLEN(res) = maxlen;
    bitsr = VARBITS(res);

    for (len = 0; len < maxlen; len += BITS_PER_BYTE) {
        *(bitsr++) = gbit(&bits0, len, len0) ^ gbit(&bits1, len, len1);
    }
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(varbitand);
Datum 
varbitand(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1, *res;
    size_t len0, len1;
    size_t minlen, len;
    bits8 *bits0, *bits1, *bitsr;

    if  (PG_ARGISNULL(0) && PG_ARGISNULL(1)) PG_RETURN_NULL();
    if  (PG_ARGISNULL(1)) PG_RETURN_VARBIT_P(PG_GETARG_VARBIT_P(0));
    if  (PG_ARGISNULL(0)) PG_RETURN_VARBIT_P(PG_GETARG_VARBIT_P(1));
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    minlen = (len0 > len1) ? len1 : len0;
    res = (VarBit*)palloc(VARBITTOTALLEN(minlen));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(minlen);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(minlen));
#endif
    VARBITLEN(res) = minlen;
    bitsr = VARBITS(res);

    for (len = 0; len < minlen; len += BITS_PER_BYTE) {
        *(bitsr++) = gbit(&bits0, len, len0) & gbit(&bits1, len, len1);
    }
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(varbitrst);
Datum 
varbitrst(PG_FUNCTION_ARGS) {
    VarBit *arg0, *arg1, *res;
    size_t len0, len1, len;
    bits8 *bits0, *bits1, *bitsr;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    arg1 = PG_GETARG_VARBIT_P(1);
    len0 = VARBITLEN(arg0);
    len1 = VARBITLEN(arg1);
    bits0 = VARBITS(arg0);
    bits1 = VARBITS(arg1);
    res = (VarBit*)palloc(VARBITTOTALLEN(len0));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(len0);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(len0));
#endif
    VARBITLEN(res) = len0;
    bitsr = VARBITS(res);

    for (len = 0; len < len0; len += BITS_PER_BYTE) {
        *(bitsr++) = gbit(&bits0, len, len0) & ~gbit(&bits1, len, len1);
    }
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(bitex0);
Datum
bitex0(PG_FUNCTION_ARGS) {
    VarBit *arg0, *res;
    ssize_t len0, len;
    bits8  *bits0, *bitsr;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    len = PG_GETARG_INT32(1);
    if  (len < 0) {
        elog(ERROR, "Length %"BLIN_D" < 0", BLIN_I(len));
    }
    len0 = VARBITLEN(arg0);
    if  (len == len0) PG_RETURN_VARBIT_P(arg0);
    bits0 = VARBITS(arg0);
    res = (VarBit*)palloc0(VARBITTOTALLEN(len));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(len);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(len));
#endif
    VARBITLEN(res) = len;
    bitsr = VARBITS(res);
    memcpy(bitsr, bits0, Min(VARBITBYTES(res), VARBITBYTES(arg0)));
    *(bitsr + VARBITBYTES(res) - 1) &= (BITMASK << VARBITPAD(res));
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(bitex1);
Datum
bitex1(PG_FUNCTION_ARGS) {
    VarBit *arg0, *res;
    ssize_t len0, len;
    bits8  *bits0, *bitsr;
    int    ipad;

    if  (PG_ARGISNULL(0) || PG_ARGISNULL(1)) PG_RETURN_NULL();
    arg0 = PG_GETARG_VARBIT_P(0);
    len = PG_GETARG_INT32(1);
    if  (len < 0) {
        elog(ERROR, "Length %"BLIN_D" < 0", BLIN_I(len));
    }
    len0 = VARBITLEN(arg0);
    if  (len == len0) PG_RETURN_VARBIT_P(arg0);
    bits0 = VARBITS(arg0);
    res = (VarBit*)palloc(VARBITTOTALLEN(len));
#ifdef VARATT_SIZEP
    VARATT_SIZEP(res) = VARBITTOTALLEN(len);
#else
    SET_VARSIZE(res, VARBITTOTALLEN(len));
#endif
    VARBITLEN(res) = len;
    bitsr = VARBITS(res);
    ipad = VARBITPAD(arg0);

    if  (VARBITBYTES(res) > VARBITBYTES(arg0)) {
        memset(bitsr + VARBITBYTES(arg0), BITMASK, VARBITBYTES(res) - VARBITBYTES(arg0));
    }
    memcpy(bitsr, bits0, Min(VARBITBYTES(res), VARBITBYTES(arg0)));
    if  (ipad > 0) {
        *(bitsr + VARBITBYTES(arg0) - 1) |= (BITMASK >> (8 - ipad));
    }
    *(bitsr + VARBITBYTES(res) - 1) &= (BITMASK << VARBITPAD(res));
    PG_RETURN_VARBIT_P(res);
}

PG_FUNCTION_INFO_V1(bit2num);
Datum
bit2num(PG_FUNCTION_ARGS) {
    FuncCallContext *funcctx;
    MemoryContext    oldcontext;
    VarBit          *bitstr;
    int              i;

    if  (SRF_IS_FIRSTCALL()) {
        funcctx = SRF_FIRSTCALL_INIT();
        oldcontext = MemoryContextSwitchTo(funcctx->multi_call_memory_ctx);
        if  (PG_ARGISNULL(0)) SRF_RETURN_DONE(funcctx);
        bitstr = PG_GETARG_VARBIT_P(0);
        funcctx->user_fctx = (results*)palloc(sizeof(int) + VARBITTOTALLEN(VARBITLEN(bitstr)));
        if  (fctx == NULL)
            ereport(ERROR, (errcode(ERRCODE_OUT_OF_MEMORY), errmsg("bit2num: out of memory")));
        MemSet(fctx, 0, sizeof(int) + VARBITTOTALLEN(VARBITLEN(bitstr)));
        fctx->str = bitstr;
        fctx->cur = 0;
        MemoryContextSwitchTo(oldcontext);
    }
    funcctx = SRF_PERCALL_SETUP();
    for (i = fctx->cur; i < VARBITLEN(fctx->str); i++) {
        if  ( ((*(VARBITS(fctx->str) + i / BITS_PER_BYTE)) >> (BITS_PER_BYTE - (i % BITS_PER_BYTE) - 1)) & (bits8)1 ) {
            fctx->cur = i + 1;
            break;
    }   }
    if  ( fctx->cur == i + 1 ) SRF_RETURN_NEXT(funcctx, Int32GetDatum(i));
    else SRF_RETURN_DONE(funcctx);
}

PG_FUNCTION_INFO_V1(num2bit);
Datum 
num2bit(PG_FUNCTION_ARGS) {
    VarBit *newval;
    uint32  port;
    int     rlen, newlen, ipad;
    bits8  *r, mask;

    if  (PG_ARGISNULL(0)) PG_RETURN_NULL();
    port = PG_GETARG_INT32(0);
    newlen = port + 1;
    rlen = VARBITTOTALLEN(newlen);
    newval = (VarBit *) palloc0(rlen);
#ifdef VARATT_SIZEP
    VARATT_SIZEP(newval) = rlen;
#else
    SET_VARSIZE(newval, rlen);
#endif
    VARBITLEN(newval) = newlen;
    bzero(VARBITS(newval), VARBITBYTES(newval));
    r = VARBITS(newval);

    for (; port + 1 > BITS_PER_BYTE; r++, port -= BITS_PER_BYTE) {}

    *r |= (bits8) (1 << (BITS_PER_BYTE - (port + 1)));
    ipad = VARBITPAD(newval);

    if  (ipad > 0) {
        mask = BITMASK << ipad;
        *(VARBITS(newval) + VARBITBYTES(newval) - 1) &= mask;
    }
    PG_RETURN_VARBIT_P(newval);
}
