#!/bin/sh
# Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: test.sh.m4,v 1.10 2025/01/29 05:33:41 babolo Exp $

PREFIX=/usr/local
c=0
n=0

R=`mktemp -t parserRXXXX`
O=`mktemp -t parserOXXXX`
I=`mktemp -t parserIXXXX`

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(000000, '')
STST(200000, '')
STST(010000, '')
STST(210000, '')
STST(080000, '')
STST(280000, '')
STST(090000, '')
STST(290000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STET(000000, '')
STET(200000, '')
STET(010000, '')
STET(210000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	err=7
	EOF
STEE(080000, '')
STEE(280000, '')
STEE(090000, '')
STEE(290000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============0
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(020000, '')
STST(220000, '')
STST(030000, '')
STST(230000, '')
STST(0A0000, '')
STST(2A0000, '')
STST(0B0000, '')
STST(2B0000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============0
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STET(020000, '')
STET(220000, '')
STET(030000, '')
STET(230000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============0
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	err=7
	EOF
STEE(0A0000, '')
STEE(2A0000, '')
STEE(0B0000, '')
STEE(2B0000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~$TU~
	   1 ~$TU~
	   2 ~$TU$TU$TU${TU}
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(040000, '')
STST(240000, '')
STST(050000, '')
STST(250000, '')
STST(0C0000, '')
STST(2C0000, '')
STST(0D0000, '')
STST(2D0000, '')
STET(040000, '')
STET(240000, '')
STET(050000, '')
STET(250000, '')
STET(0C0000, '')
STET(2C0000, '')
STET(0D0000, '')
STET(2D0000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============0
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============0
	argc=3 ==============0
	   0 ~$TU~
	   1 ~$TU~
	   2 ~$TU$TU$TU${TU}
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=9 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(060000, '')
STST(260000, '')
STST(070000, '')
STST(270000, '')
STST(0E0000, '')
STST(2E0000, '')
STST(0F0000, '')
STST(2F0000, '')
STET(060000, '')
STET(260000, '')
STET(070000, '')
STET(270000, '')
STET(0E0000, '')
STET(2E0000, '')
STET(0F0000, '')
STET(2F0000, '')

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=0 ==============1
	argc=3 ==============0
	   0 ~~
	   1 ~a~
	   2 ~fg~
	argc=2 ==============1
	   0 ~23#@%^	~
	   1 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=3 ==============0
	   0 ~--comment~
	   1 ~{}~
	   2 ~{~
	argc=1 ==============1
	   0 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~$TU~
	   1 ~$TU~
	   2 ~$TU$TU$TU${TU}
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=3 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	argc=3 ==============1
	   0 ~e~
	   1 ~
	 a ~
	   2 ~b~
	argc=3 ==============1
	   0 ~ c  d ~
	   1 ~e~
	   2 ~~
	argc=3 ==============1
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	argc=3 ==============0
	   0 ~b~
	   1 ~~
	   2 ~c~
	argc=3 ==============1
	   0 ~ d ~
	   1 ~e~
	   2 ~~
	EOF
STST(160403)
STST(360403)
STST(170403)
STST(370403)
STST(1E0403)
STST(3E0403)
STST(1F0403)
STST(3F0403)
STET(160403)
STET(360403)
STET(170403)
STET(370403)
STET(1E0403)
STET(3E0403)
STET(1F0403)
STET(3F0403)

cat > ${O} <<- "EOF"
	argc=41 ==============0
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	   8 ~E~
	   9 ~%	$~
	  10 ~S~
	  11 ~\045\301\011~
	  12 ~ ~
	  13 ~ 	~
	  14 ~--comment~
	  15 ~{}~
	  16 ~{~
	  17 ~}~
	  18 ~tu~
	  19 ~tu~
	  20 ~tutututu
	~
	  21 ~test
	~
	  22 ~\
	test~
	  23 ~ a " b  c ~
	  24 ~d~
	  25 ~~
	  26 ~e~
	  27 ~
	 a ~
	  28 ~b~
	  29 ~ c  d ~
	  30 ~e~
	  31 ~~
	  32 ~ a '  b ' c ~
	  33 ~d~
	  34 ~ e "
	" a ~
	  35 ~b~
	  36 ~~
	  37 ~c~
	  38 ~ d ~
	  39 ~e~
	  40 ~~
	EOF
STST(000000)
STST(200000)
STST(010000)
STST(210000)
STST(080000)
STST(280000)
STST(090000)
STST(290000)

cat > ${O} <<- "EOF"
	argc=41 ==============0
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	   8 ~E~
	   9 ~%	$~
	  10 ~S~
	  11 ~\045\301\011~
	  12 ~ ~
	  13 ~ 	~
	  14 ~--comment~
	  15 ~{}~
	  16 ~{~
	  17 ~}~
	  18 ~tugarinzmey~
	  19 ~tugarinzmey~
	  20 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	  21 ~test
	~
	  22 ~\
	test~
	  23 ~ a " b  c ~
	  24 ~d~
	  25 ~~
	  26 ~e~
	  27 ~
	 a ~
	  28 ~b~
	  29 ~ c  d ~
	  30 ~e~
	  31 ~~
	  32 ~ a '  b ' c ~
	  33 ~d~
	  34 ~ e "
	" a ~
	  35 ~b~
	  36 ~~
	  37 ~c~
	  38 ~ d ~
	  39 ~e~
	  40 ~~
	EOF
STET(000000)
STET(200000)
STET(010000)
STET(210000)

cat > ${O} <<- "EOF"
	err=7
	EOF
STEE(080000)
STEE(280000)
STEE(090000)
STEE(290000)

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23 ~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23#@%^	E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~   	 --comment {} { }~
	argc=0 ==============0
	argc=2 ==============0
	   0 ~tu~
	   1 ~tu tutututu
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=2 ==============0
	   0 ~ a " b  c ~
	   1 ~d  e 
	 a  b  c  d  e ~
	argc=2 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d  e "
	" a  b  c  d  e ~
	EOF
STST(000002, '')
STST(200002, '')
STST(010002, '')
STST(210002, '')
STST(080002, '')
STST(280002, '')
STST(090002, '')
STST(290002, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23 ~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23#@%^	E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~   	 --comment {} { }~
	argc=0 ==============0
	argc=2 ==============0
	   0 ~tugarinzmey~
	   1 ~tugarinzmey tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=2 ==============0
	   0 ~ a " b  c ~
	   1 ~d  e 
	 a  b  c  d  e ~
	argc=2 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d  e "
	" a  b  c  d  e ~
	EOF
STET(000002, '')
STET(200002, '')
STET(010002, '')
STET(210002, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23 ~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg 23#@%^	E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~   	 --comment {} { }~
	argc=0 ==============0
	err=7
	EOF
STEE(080002, '')
STEE(280002, '')
STEE(090002, '')
STEE(290002, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=1 ==============0
	   0 ~23~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=2 ==============0
	   0 ~23#@%^	~
	   1 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	argc=2 ==============0
	   0 ~ 	~
	   1 ~--comment~
	argc=2 ==============0
	   0 ~{}~
	   1 ~{~
	argc=1 ==============0
	   0 ~}~
	argc=0 ==============0
	argc=2 ==============0
	   0 ~tu~
	   1 ~tu~
	argc=1 ==============0
	   0 ~tutututu
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=2 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	argc=2 ==============0
	   0 ~~
	   1 ~e~
	argc=2 ==============0
	   0 ~
	 a ~
	   1 ~b~
	argc=2 ==============0
	   0 ~ c  d ~
	   1 ~e~
	argc=1 ==============0
	   0 ~~
	argc=2 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	argc=2 ==============0
	   0 ~ e "
	" a ~
	   1 ~b~
	argc=2 ==============0
	   0 ~~
	   1 ~c~
	argc=2 ==============0
	   0 ~ d ~
	   1 ~e~
	argc=1 ==============0
	   0 ~~
	EOF
STST(100002, '')
STST(300002, '')
STST(110002, '')
STST(310002, '')
STST(180002, '')
STST(380002, '')
STST(190002, '')
STST(390002, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=1 ==============0
	   0 ~23~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=2 ==============0
	   0 ~23#@%^	~
	   1 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	argc=2 ==============0
	   0 ~ 	~
	   1 ~--comment~
	argc=2 ==============0
	   0 ~{}~
	   1 ~{~
	argc=1 ==============0
	   0 ~}~
	argc=0 ==============0
	argc=2 ==============0
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	argc=1 ==============0
	   0 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============0
	   0 ~test
	~
	argc=1 ==============0
	   0 ~\
	test~
	argc=2 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	argc=2 ==============0
	   0 ~~
	   1 ~e~
	argc=2 ==============0
	   0 ~
	 a ~
	   1 ~b~
	argc=2 ==============0
	   0 ~ c  d ~
	   1 ~e~
	argc=1 ==============0
	   0 ~~
	argc=2 ==============0
	   0 ~ a '  b ' c ~
	   1 ~d~
	argc=2 ==============0
	   0 ~ e "
	" a ~
	   1 ~b~
	argc=2 ==============0
	   0 ~~
	   1 ~c~
	argc=2 ==============0
	   0 ~ d ~
	   1 ~e~
	argc=1 ==============0
	   0 ~~
	EOF
STET(100002, '')
STET(300002, '')
STET(110002, '')
STET(310002, '')

cat > ${O} <<- "EOF"
	argc=2 ==============0
	   0 ~#~
	   1 ~test~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=1 ==============0
	   0 ~23~
	argc=2 ==============0
	   0 ~a~
	   1 ~fg~
	argc=2 ==============0
	   0 ~23#@%^	~
	   1 ~E~
	argc=2 ==============0
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	argc=2 ==============0
	   0 ~ 	~
	   1 ~--comment~
	argc=2 ==============0
	   0 ~{}~
	   1 ~{~
	argc=1 ==============0
	   0 ~}~
	argc=0 ==============0
	err=7
	EOF
STEE(180002, '')
STEE(380002, '')
STEE(190002, '')
STEE(390002, '')

cat > ${O} <<- "EOF"
	argc=0 ==============0
	argc=7 ==============0
	   0 ~test~
	   1 ~a~
	   2 ~fg~
	   3 ~23~
	   4 ~a~
	   5 ~fg~
	   6 ~23~
	argc=34 ==============0
	   0 ~@%^	~
	   1 ~E~
	   2 ~%	$~
	   3 ~S~
	   4 ~\045\301\011~
	   5 ~ ~
	   6 ~ 	~
	   7 ~--comment~
	   8 ~{}~
	   9 ~{~
	  10 ~}~
	  11 ~tu~
	  12 ~tu~
	  13 ~tutututu
	~
	  14 ~test
	~
	  15 ~\
	test~
	  16 ~ a " b  c ~
	  17 ~d~
	  18 ~~
	  19 ~e~
	  20 ~
	 a ~
	  21 ~b~
	  22 ~ c  d ~
	  23 ~e~
	  24 ~~
	  25 ~ a '  b ' c ~
	  26 ~d~
	  27 ~ e "
	" a ~
	  28 ~b~
	  29 ~~
	  30 ~c~
	  31 ~ d ~
	  32 ~e~
	  33 ~~
	EOF
STST(000000, '#')
STST(200000, '#')
STST(010000, '#')
STST(210000, '#')
STST(080000, '#')
STST(280000, '#')
STST(090000, '#')
STST(290000, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============0
	argc=7 ==============0
	   0 ~test~
	   1 ~a~
	   2 ~fg~
	   3 ~23~
	   4 ~a~
	   5 ~fg~
	   6 ~23~
	argc=34 ==============0
	   0 ~@%^	~
	   1 ~E~
	   2 ~%	$~
	   3 ~S~
	   4 ~\045\301\011~
	   5 ~ ~
	   6 ~ 	~
	   7 ~--comment~
	   8 ~{}~
	   9 ~{~
	  10 ~}~
	  11 ~tu~
	  12 ~tu~
	  13 ~tutututu
	~
	  14 ~test
	~
	  15 ~\
	test~
	  16 ~ a " b  c ~
	  17 ~d~
	  18 ~~
	  19 ~e~
	  20 ~
	 a ~
	  21 ~b~
	  22 ~ c  d ~
	  23 ~e~
	  24 ~~
	  25 ~ a '  b ' c ~
	  26 ~d~
	  27 ~ e "
	" a ~
	  28 ~b~
	  29 ~~
	  30 ~c~
	  31 ~ d ~
	  32 ~e~
	  33 ~~
	EOF
STST(000000, '#')
STST(200000, '#')
STST(010000, '#')
STST(210000, '#')
STST(080000, '#')
STST(280000, '#')
STST(090000, '#')
STST(290000, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============0
	argc=7 ==============0
	   0 ~test~
	   1 ~a~
	   2 ~fg~
	   3 ~23~
	   4 ~a~
	   5 ~fg~
	   6 ~23~
	argc=34 ==============0
	   0 ~@%^	~
	   1 ~E~
	   2 ~%	$~
	   3 ~S~
	   4 ~\045\301\011~
	   5 ~ ~
	   6 ~ 	~
	   7 ~--comment~
	   8 ~{}~
	   9 ~{~
	  10 ~}~
	  11 ~tugarinzmey~
	  12 ~tugarinzmey~
	  13 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	  14 ~test
	~
	  15 ~\
	test~
	  16 ~ a " b  c ~
	  17 ~d~
	  18 ~~
	  19 ~e~
	  20 ~
	 a ~
	  21 ~b~
	  22 ~ c  d ~
	  23 ~e~
	  24 ~~
	  25 ~ a '  b ' c ~
	  26 ~d~
	  27 ~ e "
	" a ~
	  28 ~b~
	  29 ~~
	  30 ~c~
	  31 ~ d ~
	  32 ~e~
	  33 ~~
	EOF
STET(000000, '#')
STET(200000, '#')
STET(010000, '#')
STET(210000, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============0
	argc=7 ==============0
	   0 ~test~
	   1 ~a~
	   2 ~fg~
	   3 ~23~
	   4 ~a~
	   5 ~fg~
	   6 ~23~
	err=7
	EOF
STEE(080000, '#')
STEE(280000, '#')
STEE(090000, '#')
STEE(290000, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============1
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(000400, '#')
STST(200400, '#')
STST(010400, '#')
STST(210400, '#')
STST(080400, '#')
STST(280400, '#')
STST(090400, '#')
STST(290400, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============1
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STET(000400, '#')
STET(200400, '#')
STET(010400, '#')
STET(210400, '#')

cat > ${O} <<- "EOF"
	argc=0 ==============1
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	err=7
	EOF
STEE(080400, '#')
STEE(280400, '#')
STEE(090400, '#')
STEE(290400, '#')

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(000400, '--')
STST(200400, '--')
STST(010400, '--')
STST(210400, '--')
STST(080400, '--')
STST(280400, '--')
STST(090400, '--')
STST(290400, '--')

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STET(000400, '--')
STET(200400, '--')
STET(010400, '--')
STET(210400, '--')

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=0 ==============1
	err=7
	EOF
STEE(080400, '--')
STEE(280400, '--')
STEE(090400, '--')
STEE(290400, '--')

cat > ${O} <<- "EOF"
	argc=2 ==============2
	   0 ~#~
	   1 ~test~
	argc=4 ==============2
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=7 ==============2
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=3 ==============3
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============2
	   0 ~test~
	argc=1 ==============3
	   0 ~\
	test~
	err=22
	EOF
STSE(000400, '')
STSE(200400, '')
STSE(010400, '')
STSE(210400, '')
STSE(080400, '')
STSE(280400, '')
STSE(090400, '')
STSE(290400, '')

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STST(000400)
STST(200400)
STST(010400)
STST(210400)
STST(080400)
STST(280400)
STST(090400)
STST(290400)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
STET(000400)
STET(200400)
STET(010400)
STET(210400)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	err=7
	EOF
STEE(080400)
STEE(280400)
STEE(090400)
STEE(290400)

cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	argc=33 ==============0
	   0 ~E~
	   1 ~%	$~
	   2 ~S~
	   3 ~\045\301\011~
	   4 ~ ~
	   5 ~ 	~
	   6 ~--comment~
	   7 ~{}~
	   8 ~{~
	   9 ~}~
	  10 ~tu~
	  11 ~tu~
	  12 ~tutututu
	~
	  13 ~test
	~
	  14 ~\
	test~
	  15 ~ a " b  c ~
	  16 ~d~
	  17 ~~
	  18 ~e~
	  19 ~
	 a ~
	  20 ~b~
	  21 ~ c  d ~
	  22 ~e~
	  23 ~~
	  24 ~ a '  b ' c ~
	  25 ~d~
	  26 ~ e "
	" a ~
	  27 ~b~
	  28 ~~
	  29 ~c~
	  30 ~ d ~
	  31 ~e~
	  32 ~~
	EOF
STST(000100)
STST(200100)
STST(010100)
STST(210100)
STST(080100)
STST(280100)
STST(090100)
STST(290100)

cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	argc=33 ==============0
	   0 ~E~
	   1 ~%	$~
	   2 ~S~
	   3 ~\045\301\011~
	   4 ~ ~
	   5 ~ 	~
	   6 ~--comment~
	   7 ~{}~
	   8 ~{~
	   9 ~}~
	  10 ~tugarinzmey~
	  11 ~tugarinzmey~
	  12 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	  13 ~test
	~
	  14 ~\
	test~
	  15 ~ a " b  c ~
	  16 ~d~
	  17 ~~
	  18 ~e~
	  19 ~
	 a ~
	  20 ~b~
	  21 ~ c  d ~
	  22 ~e~
	  23 ~~
	  24 ~ a '  b ' c ~
	  25 ~d~
	  26 ~ e "
	" a ~
	  27 ~b~
	  28 ~~
	  29 ~c~
	  30 ~ d ~
	  31 ~e~
	  32 ~~
	EOF
STET(000100)
STET(200100)
STET(010100)
STET(210100)

cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	err=7
	EOF
STEE(080100)
STEE(280100)
STEE(090100)
STEE(290100)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=0 ==============1
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	argc=1 ==============1
	   0 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=3 ==============0
	   0 ~--comment~
	   1 ~{}~
	   2 ~{~
	argc=1 ==============1
	   0 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=3 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	argc=3 ==============1
	   0 ~e~
	   1 ~
	 a ~
	   2 ~b~
	argc=3 ==============1
	   0 ~ c  d ~
	   1 ~e~
	   2 ~~
	argc=3 ==============1
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	argc=3 ==============0
	   0 ~b~
	   1 ~~
	   2 ~c~
	argc=3 ==============1
	   0 ~ d ~
	   1 ~e~
	   2 ~~
	EOF
STST(100403)
STST(300403)
STST(110403)
STST(310403)
STST(180403)
STST(380403)
STST(190403)
STST(390403)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=0 ==============1
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	argc=1 ==============1
	   0 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=3 ==============0
	   0 ~--comment~
	   1 ~{}~
	   2 ~{~
	argc=1 ==============1
	   0 ~}~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tugarinzmey~
	   1 ~tugarinzmey~
	   2 ~tugarinzmeytugarinzmeytugarinzmeytugarinzmey
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=3 ==============0
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	argc=3 ==============1
	   0 ~e~
	   1 ~
	 a ~
	   2 ~b~
	argc=3 ==============1
	   0 ~ c  d ~
	   1 ~e~
	   2 ~~
	argc=3 ==============1
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	argc=3 ==============0
	   0 ~b~
	   1 ~~
	   2 ~c~
	argc=3 ==============1
	   0 ~ d ~
	   1 ~e~
	   2 ~~
	EOF
STET(100403)
STET(300403)
STET(110403)
STET(310403)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=0 ==============1
	argc=3 ==============0
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	argc=1 ==============1
	   0 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============0
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=3 ==============0
	   0 ~--comment~
	   1 ~{}~
	   2 ~{~
	argc=1 ==============1
	   0 ~}~
	argc=0 ==============1
	err=7
	EOF
STEE(180403)
STEE(380403)
STEE(190403)
STEE(390403)

cat > ${O} <<- "EOF"
	argc=2 ==============2
	   0 ~#~
	   1 ~test~
	argc=4 ==============2
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=7 ==============2
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=3 ==============3
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============2
	   0 ~test~
	argc=1 ==============3
	   0 ~\
	test~
	err=22
	EOF
STSE(000400, '')
STSE(200400, '')
STSE(010400, '')
STSE(210400, '')
STSE(080400, '')
STSE(280400, '')
STSE(090400, '')
STSE(290400, '')

cat > ${O} <<- "EOF"
	argc=2 ==============2
	   0 ~#~
	   1 ~test~
	argc=5 ==============2
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=7 ==============2
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=3 ==============3
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============2
	   0 ~test~
	argc=1 ==============3
	   0 ~\
	test~
	err=22
	EOF
STSE(020400, '')
STSE(220400, '')
STSE(021400, '')
STSE(221400, '')
STSE(028400, '')
STSE(228400, '')
STSE(029400, '')
STSE(229400, '')

cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	argc=21 ==============0
	   0 ~E~
	   1 ~%	$~
	   2 ~S~
	   3 ~\045\301\011~
	   4 ~ ~
	   5 ~ 	~
	   6 ~--comment~
	   7 ~{}~
	   8 ~{~
	   9 ~}~
	  10 ~$TU "$TU" $TU$TU"$TU${TU}
	"~
	  11 ~test
	~
	  12 ~\
	test~
	  13 ~ a " b  c ' d  e ~
	  14 ~ a ' b " c ~
	  15 ~d~
	  16 ~ e 
" a '  b ' c ~
	  17 ~d~
	  18 ~ e "
" a ~
	  19 ~b~
	  20 ~ c " d " e ~
	EOF
STSA(000100, 01)
STSA(200100, 01)
STSA(010100, 01)
STSA(210100, 01)
STSA(080100, 01)
STSA(280100, 01)
STSA(090100, 01)
STSA(290100, 01)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	argc=1 ==============2
	   0 ~$TU "$TU" $TU$TU"$TU${TU}
	"~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=1 ==============1
	   0 ~ a " b  c ' d  e ~
	argc=7 ==============3
	   0 ~ a ' b " c ~
	   1 ~d~
	   2 ~ e 
" a '  b ' c ~
	   3 ~d~
	   4 ~ e "
" a ~
	   5 ~b~
	   6 ~ c " d " e ~
	EOF
STSA(000400, 01)
STSA(200400, 01)
STSA(010400, 01)
STSA(210400, 01)
STSA(080400, 01)
STSA(280400, 01)
STSA(090400, 01)
STSA(290400, 01)

cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=7 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	   4 ~{}~
	   5 ~{~
	   6 ~}~
	argc=0 ==============1
	err=7
	EOF
echo "${n} turasefhkm s0x080400"
n=$((${n} + 1))
env TU=turasefhkm ./tools/test -s0x080400 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "78" ]; then echo "Error ${e} not 78"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	argc=1 ==============0
	   0 ~-b~
	EOF
echo -n '-b' > ${I}
echo ${n}' min'
n=$((${n} + 1))
./tools/test -s0 $1 ${I} > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	 s NULL
	 d NULL
	 g NULL
	 b=yu~
	 A NULL
	 S NULL
	 D NULL
	 n NULL
	 h NULL
	 j NULL
	 a=rt~
	 y NULL
	 : NULL
	 ^ NULL
	 ~ NULL
	 ! NULL
	 C NULL
	 V NULL
	 B NULL
	 X NULL
	 X NULL
	0=kuguyg~
	1=liutg~
	EOF
echo ${n}' f='
OTST(-sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg)
NTST(-sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg, INIT_FLAGS=0x00C00000, INIT_RECUR='R')

cat > ${O} <<- "EOF"
	 f=0x00E00000~
	 s NULL
	 d NULL
	 g NULL
	 b=yu~
	 A NULL
	 S NULL
	 D NULL
	 n NULL
	 h NULL
	 j NULL
	 a=rt~
	 y NULL
	 : NULL
	 ^ NULL
	 ~ NULL
	 ! NULL
	 C NULL
	 V NULL
	 B NULL
	 X NULL
	 X NULL
	0=kuguyg~
	1=liutg~
	EOF
echo ${n}' f0x00E00000'
OTST(-f0x00E00000 -sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg)

cat > ${O} <<- "EOF"
	 f=0x00A00000~
	 s NULL
	 d NULL
	 g NULL
	 b=yu~
	 A NULL
	 S NULL
	 D NULL
	ERR 22
	ERR 22
	ERR 22
	 a=rt~
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	 D NULL
	ERR 22
	ERR 22
	 X NULL
	 X NULL
	0=kuguyg~
	1=liutg~
	EOF
echo ${n}' f0x00A00000'
OTST(-f0x00A00000 -sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -DVB " -XX kuguyg liutg)

cat > ${O} <<- "EOF"
	 f=0x00600000~
	 s NULL
	 d NULL
	 g NULL
	 b=yu~
	 A NULL
	 S NULL
	 D NULL
	 n NULL
	 h NULL
	 j NULL
	 a=rt~
	 y NULL
	 : NULL
	 ^ NULL
	 ~ NULL
	 ! NULL
	 C NULL
	 V NULL
	 B NULL
	 X NULL
	 X NULL
	0=kuguyg~
	1=liutg~
	EOF
echo ${n}' f0x00600000'
OTST(-f0x00600000 -sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg)

cat > ${O} <<- "EOF"
	 f=0x00200000~
	 s NULL
	 d NULL
	 g NULL
	 b=yu~
	 A NULL
	 S NULL
	 D NULL
	ERR 22
	ERR 22
	ERR 22
	 a=rt~
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	 D NULL
	ERR 22
	ERR 22
	 X NULL
	 X NULL
	0=kuguyg~
	1=liutg~
	EOF
echo ${n}' f0x00200000'
OTST(-f0x00200000 -sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -DVB " -XX kuguyg liutg)
cat > ${O} <<- "EOF"
	ERR 22
	ERR 22
	ERR 22
	 b=yu~
	ERR 22
	ERR 22
	 D NULL
	ERR 22
	ERR 22
	ERR 22
	 a=rt~
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	ERR 22
	0=kuguyg~
	1=liutg~
	EOF
NTST(-sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg, INIT_FLAGS=0x00200000, INIT_RECUR='R')
NTST(-sdgbyu -ASD "-R  -nhjart '-R-y:^ -~!' -CVB " -XX kuguyg liutg, INIT_FLAGS=0x00200000, INIT_RECUR='r')

echo ${n}" ''"
cat > ${O} <<- "EOF"
	0=~
	EOF
OTST('')
NTST('')

echo ${n}" u ''"
cat > ${O} <<- "EOF"
	0=u~
	1=~
	EOF
OTST(u '')
NTST(u '')

echo ${n}" '' u"
cat > ${O} <<- "EOF"
	0=~
	1=u~
	EOF
OTST('' u)
NTST('' u)

echo ${n}" -D ''"
cat > ${O} <<- "EOF"
	 D NULL
	0=~
	EOF
OTST(-D '')
NTST(-D '')

echo ${n}" -D u ''"
cat > ${O} <<- "EOF"
	 D NULL
	0=u~
	1=~
	EOF
OTST(-D u '')
NTST(-D u '')

echo ${n}" -D '' u"
cat > ${O} <<- "EOF"
	 D NULL
	0=~
	1=u~
	EOF
OTST(-D '' u)
NTST(-D '' u)

cat > ${O} <<- "EOF"
	 b=e~
	ERR 2
	EOF
echo ${n}' E0x00200000'
n=$((${n} + 1))
env INIT_FLAGS=0x00200000 ./tools/opt -R-b e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi
env INIT_FLAGS=0x00200000 ./tools/opts -R-b e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	 b= e~
	ERR 2
	EOF
echo ${n}' E0x00200000\\'
n=$((${n} + 1))
env INIT_FLAGS=0x00200000 ./tools/opt -R-b\\\ e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi
env INIT_FLAGS=0x00200000 ./tools/opts -R-b\\\ e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	 b=e~
	 a NULL
	EOF
echo ${n}' E0x00E00000'
n=$((${n} + 1))
env INIT_FLAGS=0x00E00000 ./tools/opt -R-b e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi
env INIT_FLAGS=0x00E00000 ./tools/opts -R-b e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	 b= e~
	 a NULL
	EOF
echo ${n}' E0x00E00000\\'
n=$((${n} + 1))
env INIT_FLAGS=0x00E00000 ./tools/opt -R-b\\\ e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi
env INIT_FLAGS=0x00E00000 ./tools/opts -R-b\\\ e -a > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	0=-ab~
	EOF
echo ${n}'  --'
OTST(-- -ab)
./tools/optn -- -ab > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo ${n}' R--'
OTST(-R-- -ab)
NTST(-R-- -ab, INIT_RECUR=R)

echo ${n}' R --'
OTST(-R -- -ab)
NTST(-R -- -ab, INIT_RECUR=R)

cat > ${O} <<- "EOF"
	 a=Z~
	0=-ab~
	EOF
echo ${n}' Z --'
n=$((${n} + 1))
NTST(-Z '-a ${INIT_RECUR} -- -a'b, INIT_RECUR=Z)

cat > ${O} <<- "EOF"
	 a=${INIT_RECUR}~
	0=-ab~
	EOF
echo ${n}' z --'
n=$((${n} + 1))
NTST(-z '-a ${INIT_RECUR} -- -a'b, INIT_RECUR=Z)

cat > ${O} <<- "EOF"
	 a=0x00000045~
	 f=69
	EOF
echo ${n}' E'
n=$((${n} + 1))
NTST(-E -a INIT_FLAGS -E -f INIT_FLAGS, INIT_FLAGS=0x00000045)

F=`mktemp -d -t lexor.testXXXX`
sed -e "s|@@INCLUDELEXOR@@|${F}|" -e "s|@@MAJOR@@|VMAJOR|" ./tools/texot > ${F}/t.c

LXOR()

echo "${n} lexor        (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor        (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     4         4
	   12     3         4
	   13     3         4
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6         5
	   18     6         6
	   19     6         7
	   20     0         0
	   20     1
	EOF
${F}/t -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a2 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a2 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     4      1024
	   12     3      1024
	   13     3      1024
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6      1280
	   18     6      1536
	   19     6      1792
	   20     0         0
	   20     1
	EOF
${F}/t -a2 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a3 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a3 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     4    262144
	   12     3    262144
	   13     3    262144
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6    327680
	   18     6    393216
	   19     6    458752
	   20     0         0
	   20     1
	EOF
${F}/t -a3 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a4 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a4 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     4  67108864
	   12     3  67108864
	   13     3  67108864
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6  83886080
	   18     6 100663296
	   19     6 117440512
	   20     0         0
	   20     1
	EOF
${F}/t -a4 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

LXOR(f)

echo "${n} lexor -f     (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f     (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     4         4
	   12     3         4
	   13     3         4
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6         5
	   18     6         6
	   19     6         7
	   20     0         0
	   20     1
	EOF
${F}/t -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a2 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a2 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     4      1024
	   12     3      1024
	   13     3      1024
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6      1280
	   18     6      1536
	   19     6      1792
	   20     0         0
	   20     1
	EOF
${F}/t -a2 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a3 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a3 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     4    262144
	   12     3    262144
	   13     3    262144
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6    327680
	   18     6    393216
	   19     6    458752
	   20     0         0
	   20     1
	EOF
${F}/t -a3 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a4 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a4 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     4  67108864
	   12     3  67108864
	   13     3  67108864
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6  83886080
	   18     6 100663296
	   19     6 117440512
	   20     0         0
	   20     1
	EOF
${F}/t -a4 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi

LXOR()

echo "${n} lexor"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     3         4
	   12     0         0
	   12     1
	   13     3         4
	   14     3         4
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6         5
	   19     6         6
	   20     6         7
	   21     0         0
	   21     1
	EOF
${F}/t -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a2"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a2 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     3      1024
	   12     0         0
	   12     1
	   13     3      1024
	   14     3      1024
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6      1280
	   19     6      1536
	   20     6      1792
	   21     0         0
	   21     1
	EOF
${F}/t -a2 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a3"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a3 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     3    262144
	   12     0         0
	   12     1
	   13     3    262144
	   14     3    262144
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6    327680
	   19     6    393216
	   20     6    458752
	   21     0         0
	   21     1
	EOF
${F}/t -a3 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a4"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a4 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     3  67108864
	   12     0         0
	   12     1
	   13     3  67108864
	   14     3  67108864
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6  83886080
	   19     6 100663296
	   20     6 117440512
	   21     0         0
	   21     1
	EOF
${F}/t -a4 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

LXOR(f)

echo "${n} lexor -f"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     3         4
	   12     0         0
	   12     1
	   13     3         4
	   14     3         4
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6         5
	   19     6         6
	   20     6         7
	   21     0         0
	   21     1
	EOF
${F}/t -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a2"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a2 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     3      1024
	   12     0         0
	   12     1
	   13     3      1024
	   14     3      1024
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6      1280
	   19     6      1536
	   20     6      1792
	   21     0         0
	   21     1
	EOF
${F}/t -a2 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a3"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a3 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     3    262144
	   12     0         0
	   12     1
	   13     3    262144
	   14     3    262144
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6    327680
	   19     6    393216
	   20     6    458752
	   21     0         0
	   21     1
	EOF
${F}/t -a3 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a4"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor -f -a4 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     3  67108864
	   12     0         0
	   12     1
	   13     3  67108864
	   14     3  67108864
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6  83886080
	   19     6 100663296
	   20     6 117440512
	   21     0         0
	   21     1
	EOF
${F}/t -a4 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10    10         1
	   11     8         1
	   12     4         1
	   13     9         1
	   14     3         2
	   15     9         1
	   16     3         4
	   17     0         0
	   17     1
	EOF
${F}/t -a0 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10    10         1
	   11     8         1
	   12     4         1
	   13     9         1
	   14     3         2
	   15     9         1
	   16     3         4
	   17     0         0
	   17     1
	EOF
${F}/t -a0 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0x800000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0x800000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0x900000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     0         0
	   11     1
	   12     8         1
	   13     5         1
	   14     0         0
	   14     1
	   15     2         1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     2         1
	   19     0         0
	   19     1
	   20     2         1
	   21     3         3
	   22     0         0
	   22     1
	   23     2         1
	   24     3         2
	   25     0         0
	   25     1
	   26     2         1
	   27     0         0
	   27     1
	   28     0         0
	   28     1
	   29     0         0
	   29     1
	   30     0         0
	   30     1
	   31     2         1
	   32     3         4
	   33     0         0
	   33     1
	EOF
${F}/t -a0 -s0x900000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0xC00000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0xC00000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} lexor    -a0 (0xD00000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     0         0
	   11     1
	   12     8         1
	   13     5         1
	   14     0         0
	   14     1
	   15     2         1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     2         1
	   19     0         0
	   19     1
	   20     2         1
	   21     3         3
	   22     0         0
	   22     1
	   23     2         1
	   24     3         2
	   25     0         0
	   25     1
	   26     2         1
	   27     0         0
	   27     1
	   28     0         0
	   28     1
	   29     0         0
	   29     1
	   30     0         0
	   30     1
	   31     2         1
	   32     3         4
	   33     0         0
	   33     1
	EOF
${F}/t -a0 -s0xD00000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

rm -f ${F}/t.c ${F}/t ${F}/t.o
sed -e "s|@@INCLUDELEXOR@@|${F}|" -e "s|@@MAJOR@@|VMAJOR|" ./tools/mdxot > ${F}/t.c

LXOR()

echo "${n} +lexor        (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor        (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     4         4
	   12     3         4
	   13     3         4
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6         5
	   18     6         6
	   19     6         7
	   20     0         0
	   20     1
	EOF
${F}/t -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a2 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a2 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     4      1024
	   12     3      1024
	   13     3      1024
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6      1280
	   18     6      1536
	   19     6      1792
	   20     0         0
	   20     1
	EOF
${F}/t -a2 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a3 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a3 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     4    262144
	   12     3    262144
	   13     3    262144
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6    327680
	   18     6    393216
	   19     6    458752
	   20     0         0
	   20     1
	EOF
${F}/t -a3 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a4 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a4 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     4  67108864
	   12     3  67108864
	   13     3  67108864
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6  83886080
	   18     6 100663296
	   19     6 117440512
	   20     0         0
	   20     1
	EOF
${F}/t -a4 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

LXOR(f)

echo "${n} +lexor -f     (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f     (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     4         4
	   12     3         4
	   13     3         4
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6         5
	   18     6         6
	   19     6         7
	   20     0         0
	   20     1
	EOF
${F}/t -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a2 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a2 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     4      1024
	   12     3      1024
	   13     3      1024
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6      1280
	   18     6      1536
	   19     6      1792
	   20     0         0
	   20     1
	EOF
${F}/t -a2 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a3 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a3 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     4    262144
	   12     3    262144
	   13     3    262144
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6    327680
	   18     6    393216
	   19     6    458752
	   20     0         0
	   20     1
	EOF
${F}/t -a3 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a4 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a4 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     4  67108864
	   12     3  67108864
	   13     3  67108864
	   14     0         0
	   14     1
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     6  83886080
	   18     6 100663296
	   19     6 117440512
	   20     0         0
	   20     1
	EOF
${F}/t -a4 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi

LXOR()

echo "${n} +lexor"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     3         4
	   12     0         0
	   12     1
	   13     3         4
	   14     3         4
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6         5
	   19     6         6
	   20     6         7
	   21     0         0
	   21     1
	EOF
${F}/t -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a2"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a2 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     3      1024
	   12     0         0
	   12     1
	   13     3      1024
	   14     3      1024
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6      1280
	   19     6      1536
	   20     6      1792
	   21     0         0
	   21     1
	EOF
${F}/t -a2 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a3"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a3 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     3    262144
	   12     0         0
	   12     1
	   13     3    262144
	   14     3    262144
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6    327680
	   19     6    393216
	   20     6    458752
	   21     0         0
	   21     1
	EOF
${F}/t -a3 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a4"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a4 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     3  67108864
	   12     0         0
	   12     1
	   13     3  67108864
	   14     3  67108864
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6  83886080
	   19     6 100663296
	   20     6 117440512
	   21     0         0
	   21     1
	EOF
${F}/t -a4 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

LXOR(f)

echo "${n} +lexor -f"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2         1
	    3     6         2
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5         3
	   10     5         3
	   11     3         4
	   12     0         0
	   12     1
	   13     3         4
	   14     3         4
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6         5
	   19     6         6
	   20     6         7
	   21     0         0
	   21     1
	EOF
${F}/t -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a2"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a2 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2       256
	    3     6       512
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5       768
	   10     5       768
	   11     3      1024
	   12     0         0
	   12     1
	   13     3      1024
	   14     3      1024
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6      1280
	   19     6      1536
	   20     6      1792
	   21     0         0
	   21     1
	EOF
${F}/t -a2 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a3"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a3 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2     65536
	    3     6    131072
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5    196608
	   10     5    196608
	   11     3    262144
	   12     0         0
	   12     1
	   13     3    262144
	   14     3    262144
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6    327680
	   19     6    393216
	   20     6    458752
	   21     0         0
	   21     1
	EOF
${F}/t -a3 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a4"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor -f -a4 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     2  16777216
	    3     6  33554432
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     5  50331648
	   10     5  50331648
	   11     3  67108864
	   12     0         0
	   12     1
	   13     3  67108864
	   14     3  67108864
	   15     0         0
	   15     1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     6  83886080
	   19     6 100663296
	   20     6 117440512
	   21     0         0
	   21     1
	EOF
${F}/t -a4 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0x400000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 -s0x400000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0x500000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10    10         1
	   11     8         1
	   12     4         1
	   13     9         1
	   14     3         2
	   15     9         1
	   16     3         4
	   17     0         0
	   17     1
	EOF
${F}/t -a0 -s0x500000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0x100000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10    10         1
	   11     8         1
	   12     4         1
	   13     9         1
	   14     3         2
	   15     9         1
	   16     3         4
	   17     0         0
	   17     1
	EOF
${F}/t -a0 -s0x100000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0x800000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0x800000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0x900000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     0         0
	   11     1
	   12     8         1
	   13     5         1
	   14     0         0
	   14     1
	   15     2         1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     2         1
	   19     0         0
	   19     1
	   20     2         1
	   21     3         3
	   22     0         0
	   22     1
	   23     2         1
	   24     3         2
	   25     0         0
	   25     1
	   26     2         1
	   27     0         0
	   27     1
	   28     0         0
	   28     1
	   29     0         0
	   29     1
	   30     0         0
	   30     1
	   31     2         1
	   32     3         4
	   33     0         0
	   33     1
	EOF
${F}/t -a0 -s0x900000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0xC00000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0xC00000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

echo "${n} +lexor    -a0 (0xD00000)"
n=$((${n} + 1))
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     0         0
	    1     1
	    2     0         0
	    2     1
	    3     0         0
	    3     1
	    4     0         0
	    4     1
	    5     0         0
	    5     1
	    6     0         0
	    6     1
	    7     0         0
	    7     1
	    8     0         0
	    8     1
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     0         0
	   11     1
	   12     8         1
	   13     5         1
	   14     0         0
	   14     1
	   15     2         1
	   16     0         0
	   16     1
	   17     0         0
	   17     1
	   18     2         1
	   19     0         0
	   19     1
	   20     2         1
	   21     3         3
	   22     0         0
	   22     1
	   23     2         1
	   24     3         2
	   25     0         0
	   25     1
	   26     2         1
	   27     0         0
	   27     1
	   28     0         0
	   28     1
	   29     0         0
	   29     1
	   30     0         0
	   30     1
	   31     2         1
	   32     3         4
	   33     0         0
	   33     1
	EOF
${F}/t -a0 -s0xD00000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
if ! diff -u ${O} ${R}; then c=$((${c} + 1)); fi

cat > ${O} <<- "EOF"
	48=V
	EOF
STHX(56, 45)

cat > ${O} <<- "EOF"
	48=Vx
	EOF
STHX(5678, 45)

cat > ${O} <<- "EOF"
	8=Vx
	EOF
STHX(5678, 5)

cat > ${O} <<- "EOF"
	16=Vx
	EOF
STHX(5678, 7)

cat > ${O} <<- "EOF"
	16=Vx#4E
	EOF
STHX(5678233445, 6)

cat > ${O} <<- "EOF"
	48=Vx#4E
	EOF
STHX('56782     334     45', 36)

if [ "${c}" -ne "0" ]; then echo "=== ${c} Errors ==="; fi

rm -rf ${F} ${O} ${R} ${I}
