/*-
 * Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: test.c,v 1.25 2025/12/21 18:17:48 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>

#ifdef BLIN_OSLinux
# include <malloc.h>
# include <time.h>
#else
# include <malloc_np.h>
#endif

#include "../parser.h"

int
main(int argc, char **argv) {
    char        *intext;
    BLIN_flag    flags;
    int          infil;
    char        *inpp;
    char         absq;
    char       **varg;
    char        *inp;
    ssize_t      len;
    struct stat  sb;
    babolo_parm *pm;
    int          ch;
    int          z;
    int          h;
    int          i;
    int          e;

    blin_ctl(BLIN_CTL_FEQU, BLIN_BIT0);
    z = 0;
    h = 0;
    flags = 0;
    absq = 0;
#ifdef BLIN_OSLinux
    while ((ch = getopt(argc, argv, "+a:l:s:v")) != EOF)
#else
    while ((ch = getopt(argc, argv, "a:l:s:v")) != EOF)
#endif
        switch (ch) {
        case 'a': absq = (char)strtol(optarg, NULL, 0);    break;
        case 'l':
            len = strtol(optarg, NULL, 0);
            h = 1;
            break;
        case 's': flags |= strtoul(optarg, NULL, 0); break;
        case 'v': BLIN_VERBOSE(flags);               break;
        default:  ;
        }
    argc -= optind;
    argv += optind;
    if  (!!h) {
        u_char *s;

        if  (argc != 1) errx(EX_USAGE, "Give hex string");
        if  (!(s = babolo_hextrin(argv[0], &len))) err(EX_DATAERR, "Input format error");
        printf("%zu=%s\n", malloc_usable_size(s), s);
        exit(0);
    }
    if  (argc < 1 || argc > 2 || !argv || !argv[0]) errx(EX_USAGE, "Give filename and EOL");
    if  (argc == 1) z = 1;
    if  ((infil = open(argv[0], O_RDONLY)) < 0) err(EX_NOINPUT, NULL);
    if  (fstat(infil, &sb) < 0) err(EX_NOINPUT, NULL);
    intext = mmap(NULL, (size_t)sb.st_size, PROT_READ | PROT_WRITE, MAP_PRIVATE, infil, 0);
    if  (intext == MAP_FAILED) err(EX_NOINPUT, NULL);
    inpp = NULL;
    for (inp = intext; inp < intext + sb.st_size && inp != inpp; ) {
        inpp = inp;
        pm = babolo_getparm(flags, &inp, z ? "" : *argv[1] ? argv[1] : "\n", absq);
        if  (!pm) {
            e = errno;
            printf("err=%d\n", errno);
            switch (e) {
            case EINVAL: exit(EX_DATAERR);
            case E2BIG : exit(EX_CONFIG);
            default    : exit(EX_SOFTWARE);
        }   }
        printf("argc=%d ==============%zu\n", pm->argc, pm->cntr);
        if  (flags & Bpars_NONU) {
            for (i = 0; i < pm->argc; ++i) printf("%4d ~%s~\n", i, pm->argv[i]);
        } else {
            i = 0;
            for (varg = pm->argv; *varg; ++varg) printf("%4d ~%s~\n", i++, *varg);
        }
        babolo_freeparm(pm);
    }
    exit(0);
}
