/*-
 * Copyright (C)2003..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: parser.h,v 1.45 2025/03/04 08:30:50 cuhegh Exp $
 */

#ifndef  _BABOLO_PARSER_H_
# define _BABOLO_PARSER_H_

__BEGIN_DECLS

# ifndef Bpars_COMPAT
#  warning Bpars_COMPAT not defined
# endif

/* For babolo_parm.flags                                                           */
# define Bpars_NPRM    0x0000FF /*                 */
# define Bpars_LNSH    8
# define Bpars_VTLN /* 0x000100  VT -        */ (0x1 << Bpars_LNSH)
# define Bpars_CRLN /* 0x000200  CR -        */ (0x2 << Bpars_LNSH)
# define Bpars_LFLN /* 0x000400  LF -        */ (0x4 << Bpars_LNSH)
# define Bpars_XXLN /* 0x000700     */ (Bpars_VTLN | Bpars_LFLN | Bpars_CRLN)
# define Bpars_DUMP    0x000800 /*    babolo_getparm()    */
# define Bpars_FAST    0x010000 /*                  */
# define Bpars_FIXB    0x020000 /*              */
# define Bpars_NOEN    0x040000 /*                 */
# define Bpars_NOAL    0x080000 /*                         */
# define Bpars_FIRM    0x100000 /*                   */
# define Bpars_NONU    0x200000 /*                   */

/* For babolo_lexor.flags                                                          */
/*       Bpars_FIRM                 *word      0 */
# define Bpars_AABS    0x200000 /*    lexgraf                 */
# define Bpars_CEND    0x400000 /*                        */
# define Bpars_CMID    0x800000 /*         */

/* For babolo_opts.flags                                                           */
# define Bpars_SYMe    0x0000FF /*     env                  */
# define Bpars_SYME    'E'      /* -E      env           */
# define Bpars_EMPT    0x001000 /*                                            */
# define Bpars_DASH    0x002000 /*  --                                  */
# define Bpars_CMPT    0x008000 /*  bos->next->flags            */
                                /*     bos->flags  Bpars_ESYM                   */
# define Bpars_PREA    0x040000 /*          */
# define Bpars_ESYM    0x400000 /*                           */
# define Bpars_EPRM    0x800000 /*     NULL        */

/* For babolo_opt.flags                                                            */
/*       Bpars_NPRM              *                         */
# define Bpars_OWBP    0x000800 /*  bp (parm)                            */
# define Bpars_FPTR    0x010000 /*      argv           */
# define Bpars_FTXT    0x020000 /*      argv          */
/*       Bpars_NOAL              *             *
 *                               *          */
# define Bpars_EOOP    0x100000 /*   ,        */
/*       Bpars_NONU              *   argv[0]                            *
 * For babolo_chopts() flags                                                       *
                                 *           */
# define Bpars_ONLU    0x100000 /*                   */

# if defined(Bpars_COMPAT) && (Bpars_COMPAT < 3)
#  define kukBpars_NPRM(x)   ((u_int32_t)(x) & Bpars_NPRM)
#  define setBpars_NPRM(a,x) do {(a) &= ~Bpars_NPRM; (a) |= kukBpars_NPRM(x);} while (0)
#  define getBpars_NPRM(a)   ((a) & Bpars_NPRM)
# endif

# define Bpars_UPPER                                                                 \
    "\000\001\002\003""\004\005\006\007""\010\011\012\013""\014\015\016\017"         \
    "\020\021\022\023""\024\025\026\027""\030\031\032\033""\034\035\036\037"         \
    " !\"#"	      "$%&\'"		"()*+"  	  ",-./"		     \
    "0123"	      "4567"		"89:;"  	  "<=>?"		     \
    "@ABC"	      "DEFG"		"HIJK"  	  "LMNO"		     \
    "PQRS"	      "TUVW"		"XYZ["  	  "\\]^_"		     \
    "`ABC"	      "DEFG"		"HIJK"  	  "LMNO"		     \
    "PQRS"	      "TUVW"		"XYZ{"  	  "|}~\177"		     \
    "\200\201\202\203""\204\205\206\207""\210\211\212\213""\214\215\216\217"	     \
    "\220\221\222\223""\224\225\226\227""\230\231\232\233""\234\235\236\237"	     \
    "\240\241\242"   "\244\245\246\247""\250\251\252\253""\254\255\256\257"	     \
    "\260\261\262"   "\264\265\266\267""\270\271\272\273""\274\275\276\277"	     \
    ""	      ""		""  	  ""		     \
    ""	      ""		""  	  ""		     \
    ""	      ""		""  	  ""		     \
    ""	      ""		""  	  ""		     \

# define Bpars_LOWER                                                                 \
    "\000\001\002\003""\004\005\006\007""\010\011\012\013""\014\015\016\017"         \
    "\020\021\022\023""\024\025\026\027""\030\031\032\033""\034\035\036\037"         \
    " !\"#"           "$%&\'"           "()*+"            ",-./"                     \
    "0123"            "4567"            "89:;"            "<=>?"                     \
    "@abc"            "defg"            "hijk"            "lmno"                     \
    "pqrs"            "tuvw"            "xyz["            "\\]^_"                    \
    "`abc"            "defg"            "hijk"            "lmno"                     \
    "pqrs"            "tuvw"            "xyz{"            "|}~\177"                  \
    "\200\201\202\203""\204\205\206\207""\210\211\212\213""\214\215\216\217"         \
    "\220\221\222\223""\224\225\226\227""\230\231\232\233""\234\235\236\237"         \
    "\240\241\242"   "\244\245\246\247""\250\251\252\253""\254\255\256\257"         \
    "\260\261\262"   "\264\265\266\267""\270\271\272\273""\274\275\276\277"         \
    ""            ""            ""            ""                     \
    ""            ""            ""            ""                     \
    ""            ""            ""            ""                     \
    ""            ""            ""            ""                     \

typedef struct babolo_parm {
    BLIN_flag     flags;      /*                                     */
    int            argc;      /*    argv                   */
    size_t         cntr;      /*                              */
# if defined(__GNUC__) && __GNUC__ > 2
    char         *(argv[]);   /* -                          */
# else
    char         *(argv[0]);  /* -                          */
# endif
} babolo_parm;

typedef struct babolo_opt babolo_opt;
struct babolo_opt {
    babolo_opt    *next;      /*  (sic!)               */
# if defined(Bpars_COMPAT) && (Bpars_COMPAT < 3)
    u_char        *arg;       /*   ( NULL)            */
    u_char        *plc;       /*             */
    u_char       **argv;      /* -                          */
# else
    const char    *arg;       /*   ( NULL)            */
    const char    *plc;       /*             */
    char         **argv;      /* -                          */
# endif
    u_char        *opts;      /*            */
    BLIN_flag      flags;     /*                                     */
    int            argc;      /*    argv                   */
    int            ind;       /*            */
# if BLINAP > 4
    u_int32_t      dummy;
# endif
    babolo_parm   *bp;        /*  argc  argv ( NULL)          */
};

typedef struct babolo_opts {
    BLIN_flag      flags;     /*                                */
    char           c;         /*                              */
    int8_t         redirenv;  /*     env         */
    int8_t         argin;     /*       */
    char           symr;      /*                             */
    const char    *o;         /*                      */
    babolo_opt    *next;      /*      */
    babolo_opt    *free;      /*                             */
} babolo_opts;

typedef struct babolo_lexor {
    const u_char  *retable;   /*                      */
    void          *printable; /*                                 */
    BLIN_flag      flags;     /*                                     */
    u_int32_t      szt;       /*      szp + 1  */
    u_int32_t      szz;       /*     szp + 1 */
    u_char         szp;       /*                      */
    u_char         lexgraf[]; /*  flexible array                    */
       /*****************************************************************
        *      :                            *
        *    N(1 ) + 1 -   (, )             *
        *      (1 ), (szp )                         *
        *      ...                                                      *
        *    (szp )  ,              *
        *                                                               *
        *      szp + 1,  Bpars_AABS ,       *
        *       + szp           *
        *    ,             *
        *   .                                                    *
        *      szz,             *
        *    ,               *
        *    -    .                *
        *****************************************************************/
} babolo_lexor;

void          babolo_dumparm    __P((babolo_parm *parsed));
void          babolo_freeparm   __P((babolo_parm *parsed));
babolo_opts  *babolo_openopts   __P((BLIN_flag flags, char symr));
int           babolo_chopts     __P((babolo_opts *bos, BLIN_flag flags, const char *ostr));
int           babolo_closeopts  __P((babolo_opts *bos));
int           babolo_getopts    __P((babolo_opts *bos));
const char   *babolo_getoptsarg __P((babolo_opts *bos));
unsigned long babolo_getoptunum __P((babolo_opts *bos, int base));
long          babolo_getoptsnum __P((babolo_opts *bos, int base));
const char   *babolo_getargs    __P((babolo_opts *bos));
void          babolo_optest     __P((const char *ostr));
void          babolo_optext     __P((const babolo_opts *bos));
void          babolo_dumpopts   __P((const babolo_opts *bos));
void          babolo_treedump   __P((const babolo_lexor *lext));
u_char       *babolo_hextrin    __P((const char *o, ssize_t *len));
u_int32_t     babolo_weakchar   __P((const babolo_lexor *lext, u_int32_t state));
int           babolo_setopts    __P((babolo_opts *bos
                                   , BLIN_flag flags
                                   , int argc
                                   , char **argv
                                   , const char *ostr
                                  ));
int           babolo_setparm    __P((babolo_opts *bos
                                   , BLIN_flag flags
                                   , babolo_parm *bp
                                   , const char *ostr
                                  ));

# if defined(Bpars_COMPAT) && (Bpars_COMPAT < 3)

babolo_parm  *babolo_getparm    __P((BLIN_flag flags, u_char **in, const u_char *strend, u_char absq));
int           babolo_closeopt   __P((babolo_opt **opt));
int           babolo_getopt     __P((babolo_opt **opt));
char         *babolo_getoptarg  __P((babolo_opt **opt, int argn));
char         *babolo_getarg     __P((babolo_opt **opt));
void          babolo_dumpopt    __P((const babolo_opt *opt));
u_int32_t     babolo_testchar   __P((const babolo_lexor *lext, u_int32_t state, const u_char **next));
u_int32_t     babolo_testword   __P((const babolo_lexor *lext, const u_char *word));
u_int32_t     babolo_goword     __P((const babolo_lexor *lext, const u_char **word));
int           babolo_openopt    __P((BLIN_flag flags
                                   , babolo_opt **opt
                                   , int argc
                                   , char **argv
                                   , const char *ostr
                                  ));

# else

babolo_parm  *babolo_getparm    __P((BLIN_flag flags, char **in, const char *strend, char absq));
u_int32_t     babolo_testchar   __P((const babolo_lexor *lext, u_int32_t state, const char **next));
u_int32_t     babolo_testword   __P((const babolo_lexor *lext, const char *word));
u_int32_t     babolo_goword     __P((const babolo_lexor *lext, const char **word));
u_int32_t     babolo_gonword    __P((const babolo_lexor *lext, const char **word, ssize_t len));

#  ifdef _MIFE_H_
u_int32_t     babolo_mdword     __P((const babolo_lexor *lext, mife_descriptor *md));
#  else
u_int32_t     babolo_mdword     __P((const babolo_lexor *lext, void *md));
#  endif

# endif

__END_DECLS

#endif /* _BABOLO_PARSER_H_ */
