/*-
 * Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: getopt2.c,v 1.12 2025/12/21 18:17:48 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "../parser.h"

#define EXOUT(B)     do {errno = (B); goto out;} while (0)

int babolo_openopt __P((BLIN_flag flags, babolo_opt **opt, int argc, char **argv, const char *ostr));
int         babolo_closeopt  __P((babolo_opt **opt));
int         babolo_getopt    __P((babolo_opt **opt));
const char *babolo_getoptarg __P((babolo_opt **opt, int argn));
const char *babolo_getarg    __P((babolo_opt **opt));
void        babolo_dumpopt   __P((const babolo_opt *opt));

static babolo_opts *
/*****************************************************************************************************/
genopts(babolo_opt **opt) {                                                                      /****
 *****************************************************************************************************/
    babolo_opts *bos = NULL;

    if  (!opt) {
        ifBLIN_QX0("no opt");
        EXOUT(EFAULT);
    }
# define blin_internal_flags ((*opt)->flags & BLIN_MASK)
    if  (!(bos = calloc(1, sizeof(babolo_opts)))) {
        ifBLIN_QX0("no mem #0");
        errno = ENOMEM;
        goto out;
    }
    if  (!!(bos->next = *opt)) bos->flags = bos->next->flags;
    bos->flags |= Bpars_PREA | Bpars_CMPT;
out:
    return(bos);
}

int                                                               /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_openopt(BLIN_flag flags, babolo_opt **opt, int argc, char **argv, const char *ostr) {     /****
 *****************************************************************************************************
 *****************************************************************************************************/
    babolo_opts *bos;
    int          ex = EX_OK;

    bos = babolo_openopts(flags | Bpars_PREA | Bpars_CMPT, 0);
    bos->next = *opt;
    ex = babolo_setopts(bos, flags, argc, argv, ostr);
    *opt = bos->next;
    free(bos);
    return(ex);
}

int                                                               /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_closeopt(babolo_opt **opt) {                                                              /****
 *****************************************************************************************************
 *****************************************************************************************************/
    babolo_opts *bos;
    int          ex = EX_OK;

    bos = genopts(opt);
    if  (!!(ex = babolo_closeopts(bos))) {
        ifBLIN_QX0("closeopts");
        ex = EX_SOFTWARE;
        goto out;
    }
    *opt = NULL;
out:
    return(ex);
}

int                                                               /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getopt(babolo_opt **opt) {                                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    babolo_opts *bos;
    int          ex = 0;

    bos = genopts(opt);
    ex = babolo_getopts(bos);
    *opt = bos->next;
    free(bos);
    return(ex);
}

const char *                                                      /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getoptarg(babolo_opt **opt, int argn) {                                                   /****
 *****************************************************************************************************
 *****************************************************************************************************/
    const char *c = NULL;

    if  (!!argn) {
        ifBLIN_QX0("argn %d <> 0", argn);
        errno = EDOM;
    } else if (!!opt && !!*opt) {
        c = (*opt)->arg;
    }
    return(c);
}

const char *                                                      /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getarg(babolo_opt **opt) {                                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    babolo_opts *bos;
    const char  *c;

    bos = genopts(opt);
    c = babolo_getargs(bos);
    *opt = bos->next;
    free(bos);
    return(c);
}

void                                                              /******** Bpars_COMPAT == 2 ********/
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_dumpopt(const babolo_opt *opt) {                                                          /****
 *****************************************************************************************************
 *****************************************************************************************************/
    babolo_opts *bos;

    bos = genopts((babolo_opt **)&opt);
    babolo_dumpopts(bos);
    free(bos);
}
