/*-
 * Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2025 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: getopt.c,v 1.39 2025/03/05 03:25:09 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "../parser.h"

#define ERROUT(A, B) do {errno = (B); ex = (A); goto out;} while (0)
#define EXOUT(B)     do {errno = (B); goto out;} while (0)

# ifdef DEBUG
static void
patt(babolo_parm *bp) {
    if  (!bp) {
        fprintf(stderr, "****p %"BLIN_X"\n", BLIN_I(bp));
    } else {
        fprintf(stderr, "****p %"BLIN_X" c=%"BLIN_D"\n", BLIN_I(bp), bp->cntr);
        for (int i = 0; i < bp->argc; ++i) {
            fprintf( stderr
                   , "**** [%d]=%"BLIN_X"=%s%s\n"
                   , i
                   , BLIN_I(bp->argv[i])
                   , bp->argv[i] ? bp->argv[i] : ""
                   , bp->argv[i] ? "~" : ""
                   );
    }   }
    return;
}

static void
optt(babolo_opt *bo, const char *ind) {
    fprintf( stderr
           , "****o %"BLIN_X" %s %08X a=%s%s p%"BLIN_X"=%s%s f=%s i=%d n%"BLIN_X"\n"
           , BLIN_I(bo)
           , ind
           , bo->flags
           , bo->arg ? bo->arg : ""
           , bo->arg ? "~" : ""
           , BLIN_I(bo->plc)
           , bo->plc ? bo->plc : ""
           , bo->plc ? "~" : ""
           , bo->opts
           , bo->ind
           , BLIN_I(bo->next)
           );
    for (int i = 0; i < bo->argc; ++i) {
        fprintf( stderr
               , "**** [%d]=%"BLIN_X"=%s%s\n"
               , i
               , BLIN_I(bo->argv[i])
               , bo->argv[i] ? bo->argv[i] : ""
               , bo->argv[i] ? "~" : ""
               );
    }
    patt(bo->bp);
    if  (bo->next) optt(bo->next, "");
    return;
}

static void
optst(babolo_opts *bos, const char *ind) {
    fprintf( stderr
           , "****s %"BLIN_X" %s %08X o=%c(%02X) r=%c(%02X) re=%d a=%d o=%s%s n%"BLIN_X" f%"BLIN_X"\n"
           , BLIN_I(bos)
           , ind
           , bos->flags
           , bos->c
           , bos->c
           , bos->symr
           , bos->symr
           , bos->redirenv
           , bos->argin
           , bos->o ? bos->o : ""
           , bos->o ? "~" : ""
           , BLIN_I(bos->next)
           , BLIN_I(bos->free)
           );
    if  (bos->next) optt(bos->next, "");
    if  (bos->free) optt(bos->free, "");
    return;
}
# endif

babolo_opts *
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_openopts(BLIN_flag flags, char symr) {                                                    /****
 *****************************************************************************************************
 *****************************************************************************************************/
# define blin_internal_flags (flags & BLIN_MASK)
    babolo_opts *bos;

    ifBLIN_QX3("+ %08X", flags);
    if  (!(bos = calloc(1, sizeof(babolo_opts)))) {
        ifBLIN_QX0("no mem #0");
        errno = ENOMEM;
    } else {
        bos->flags = flags;
        bos->symr = symr;
    }
    ifBLIN_QX3("- %"BLIN_X, BLIN_I(bos));
    return(bos);
# undef blin_internal_flags
}

static int
/*****************************************************************************************************/
setopts(babolo_opts *bos, BLIN_flag flags, int argc, char **argv, const char *ostr, babolo_parm *bp) {
/*****************************************************************************************************/
    int         ex = EX_OK;
    babolo_opt *next;
    u_char     *c;
    int         i;
    int         j;

# define blin_internal_flags (bos->flags & BLIN_MASK)
    if  (!ostr) {
        ifBLIN_QX3("+ %08X %"BLIN_X" %d %"BLIN_X" ostr NULL", flags, BLIN_I(bos), argc, BLIN_I(argv));
    } else {
        ifBLIN_QX3( "+ %08X %"BLIN_X" %d %"BLIN_X" ostr=%s~"
                  , flags, BLIN_I(bos), argc, BLIN_I(argv), ostr
                  );
    }
    if  (!argv) {
        ifBLIN_QX0("no argv");
        ERROUT(EX_DATAERR, EFAULT);
    }
    for (j = 0; j < argc; ++j) ifBLIN_QX5(" argv[%d]=%s~", j, argv[j]);
    next = bos->next;
    if  (!(bos->next = malloc(sizeof(babolo_opt)))) {
        ifBLIN_QX0("no mem #0");
        ERROUT(EX_OSERR, ENOMEM);
    }
    if  (bos->flags & Bpars_CMPT) {
        bos->next->flags = flags & ~(BLIN_flag)(Bpars_NPRM | Bpars_NOAL | Bpars_EOOP);
    } else {
        bos->next->flags = bos->flags & (BLIN_MASK | Bpars_EPRM | Bpars_ESYM);
        if  (!bp) bos->next->flags |= flags & (Bpars_FPTR | Bpars_FTXT | Bpars_NONU);
    }
    if  (!!bp) {
        bos->next->flags |= flags & Bpars_OWBP; // XXXX     
    }
    bos->next->next = next;
    bos->next->argc = argc;
    bos->next->argv = argv;
    bos->next->ind = (flags & Bpars_NONU) ? 1 : 0;
    bos->next->plc = "";
    bos->next->arg = NULL;
    bos->next->bp = bp;
    if  (!!ostr) {
        if  (!(bos->next->opts = calloc(1, 256))) {
            free(bos->next);
            bos->next = next;
            ifBLIN_QX0("no mem #1");
            ERROUT(EX_OSERR, ENOMEM);
        }
        for (i = 0; ostr[i];) {                                          /*     */
            c = &(bos->next->opts[ostr[i++] & 0xFF]);
            for (*c = 1; ostr[i] == ':'; ++i) if (*c < 255) ++*c;
        }
    } else if (!!next) {   /* opts    (babolo_opt*) bos->next,   NOAL */
        bos->next->opts = next->opts;
        bos->next->flags |= Bpars_NOAL;
    } else {
        free(bos->next);
        bos->next = next;
        ifBLIN_QX0("ostr and next both NULLs");
        ERROUT(EX_DATAERR, EINVAL);
    }
out:
    ifBLIN_QX3("- %d", ex);
    return(ex);
# undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_setopts(babolo_opts *bos, BLIN_flag flags, int argc, char **argv, const char *ostr) {     /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int ex;

    if  (!bos) {
        ifBLIN_QX0("no opt");
        ex = EX_DATAERR;
        errno = EFAULT;
    } else {
        ex = setopts(bos, flags, argc, argv, ostr, NULL);
    }
    return(ex);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_setparm(babolo_opts *bos, BLIN_flag flags, babolo_parm *bp, const char *ostr) {           /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int ex;

    if  (!bos) {
        ifBLIN_QX0("no opt");
        ex = EX_DATAERR;
        errno = EFAULT;
    } else {
        ex = setopts(bos, flags, bp->argc, bp->argv, ostr, bp);
    }
    return(ex);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_chopts(babolo_opts *bos, BLIN_flag flags, const char *ostr) {                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int         ex = EX_OK;
    babolo_opt *next;
    u_char     *c;
    u_char     *s;
    int         i;

    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
    if  (!ostr) {
        ifBLIN_QX0("no opt");
        ERROUT(EX_DATAERR, EFAULT);
    }
    ifBLIN_QX3("+ %08X =%s~", bos->flags, ostr);
    if  (!(s = calloc(1, 256))) {
        ifBLIN_QX0("no mem #1");
        ERROUT(EX_OSERR, ENOMEM);
    }
    for (i = 0; ostr[i];) {                                              /*     */
        c = &s[ostr[i++] & 0xFF];
        for (*c = 1; ostr[i] == ':'; ++i) if (*c < 255) ++*c;
    }
    bos->flags &= (BLIN_flag)~Bpars_EOOP;
    for (next = bos->next; !!next; next = next->next) {
        next->flags &= (BLIN_flag)~Bpars_EOOP;
        if  (!(next->flags & Bpars_NOAL)) free(next->opts);
        next->opts = s;
        if  (flags & Bpars_ONLU) {
            next->flags &= (BLIN_flag)~Bpars_NOAL;
            break;
        }
        if  (!(next->flags & Bpars_NOAL)) {
            if  (flags & Bpars_NONU) break;
            if  (!!next->next) next->flags |= Bpars_NOAL;
    }   }
out:
    if  (!!bos) {
        ifBLIN_QX3("- %d", ex);
    } else {
# undef blin_internal_flags
        ifBLIN_QX3("- %d", ex);
    }
    return(ex);
}

static babolo_opt *
/*****************************************************************************************************/
freeopt(babolo_opts *bos) {                                                                      /****
 *****************************************************************************************************/
# define blin_internal_flags (bos->flags & BLIN_MASK)
    babolo_opt *next = NULL;

    ifBLIN_QX3("+ %08X %"BLIN_X" %"BLIN_X, bos->flags, BLIN_I(bos), BLIN_I(bos->next));
    if  (bos->next) {
        next = bos->next->next;
        bos->next->next = bos->free;
        bos->free = bos->next;
        bos->next = next;
    }
    ifBLIN_QX3("- -%"BLIN_X, BLIN_I(next));
    return(next);
# undef blin_internal_flags
}

static void
/*****************************************************************************************************/
closeopt(babolo_opt *opt) {                                                                      /****
 *****************************************************************************************************/
    babolo_opt *nnext = NULL;
    int         i;

    for (; !!opt;) {
# define blin_internal_flags (opt->flags & BLIN_MASK)
        if  (!(opt->flags & Bpars_NOAL)) free(opt->opts);
        if  (opt->flags & Bpars_FTXT) {
            for (i = 0; i < opt->argc; --i) free(opt->argv[i]);
        }
        if  (opt->flags & Bpars_FPTR) free(opt->argv);
        if  (opt->bp && (opt->flags & Bpars_OWBP)) babolo_freeparm(opt->bp);
        nnext = opt->next;
# undef blin_internal_flags
        free(opt);
        opt = nnext;
}   }

int
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_closeopts(babolo_opts *bos) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int ex = EX_OK;

    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
    ifBLIN_QX3("+ %08X %"BLIN_X, bos->flags, BLIN_I(bos));
    closeopt(bos->next);
    closeopt(bos->free);
    free(bos);
out:
# undef blin_internal_flags
    ifBLIN_QX3("- %d", ex);
    return(ex);
}

static int
/*****************************************************************************************************/
getoptsarg(babolo_opts *bos) {                                                                   /****
 *****************************************************************************************************/
# define blin_internal_flags (bos->flags & BLIN_MASK)
    int ex = 0;

    ifBLIN_QX4("+ argin=%d %08X %08X\n", bos->argin, bos->flags, bos->next->flags);
    bos->next->flags &= (BLIN_flag)~Bpars_NPRM;
    if  (!!bos->argin) {
        for (bos->o = bos->next->arg = NULL; !!bos->next && !bos->o;) {
            ifBLIN_QX4( " Opt%d %"BLIN_X" %08X %08X [%d]%s~"
                      , bos->argin
                      , BLIN_I(bos->next)
                      , bos->flags
                      , bos->next->flags
                      , bos->next->ind
                      , bos->next->plc
                      );
            if  (!!*(bos->next->plc)) {
                bos->o = bos->next->arg = bos->next->plc;
                bos->next->plc = "";
                bos->next->flags |= --(bos->argin) & Bpars_NPRM;
            } else if (!bos->next->argv) {
                ifBLIN_QX0("no argv");
                ERROUT(-1, EFAULT);
            } else if (bos->next->ind < bos->next->argc) {
                bos->o = bos->next->arg = bos->next->argv[bos->next->ind++];
                bos->next->plc = "";
                bos->next->flags |= --(bos->argin) & Bpars_NPRM;
            } else {
                freeopt(bos);
        }   }
        if  (!bos->o && !(bos->flags & Bpars_EPRM)) {
            ifBLIN_QX0("no argument -%u for -%c", bos->argin, bos->c);
            ERROUT(-1, ENOENT);
        }
        if  (!!bos->redirenv) {
            bos->redirenv = 0;
            if  (!!bos->o) {
                const char *o = bos->o;

                bos->o = getenv(bos->o);
                if  (bos->next) bos->next->arg = bos->o;
                if  (!bos->o && !(bos->flags & Bpars_EPRM)) {
                    ifBLIN_QX0("no env for argument -%u for -%c %s", bos->argin, bos->c, o);
                    ERROUT(-1, EDOM);
    }   }   }   }
out:
    if  (!bos->o) {
        ifBLIN_QX4("- %d NULL", ex);
    } else {
        ifBLIN_QX4("- %d =%s~", ex, bos->o);
    }
    return(ex);
# undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getopts(babolo_opts *bos) {                                                               /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int argn;
    int ex  = 0;

    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(-EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
# ifdef DEBUG
    optst(bos, "getopts in");
# endif
    bos->flags &= (BLIN_flag)~Bpars_DASH;
    bos->flags |= Bpars_EMPT;
    if  (!bos->next) goto out;
    bos->flags &= (BLIN_flag)~Bpars_EMPT;
    for (ex = 0; bos->argin > 0;) { /* skip unused opt args */
        if  (!!*(bos->next->plc)) {
            bos->next->plc = "";
            --(bos->argin);
        } else if (bos->next->ind >= bos->next->argc) {
            freeopt(bos);
        } else {
            ++(bos->next->ind);
            --(bos->argin);
    }   }
    if  (!bos->next->argv) {
        ifBLIN_QX0("no argv");
        ERROUT(-EX_DATAERR, EFAULT);
    }
    for (ex = 0; !ex;) {
        if  (!bos->next || bos->next->flags & Bpars_EOOP) goto out;
        ifBLIN_QX3( "+ %"BLIN_X" %"BLIN_X" ind=%d argc=%d %08X %08X"
                  , BLIN_I(bos)
                  , BLIN_I(bos->next)
                  , bos->next->ind
                  , bos->next->argc
                  , bos->flags
                  , bos->next->flags
                  );
        if  (!!*(bos->next->plc)) {
            ifBLIN_QX4(" @@ %"BLIN_X" [%d]%s~", BLIN_I(bos->next), bos->next->ind, bos->next->plc);
            ex = *(bos->next->plc++) & 0xFF;
        } else if (bos->next->ind >= bos->next->argc) {
            freeopt(bos);
        } else if (!(bos->next->plc = bos->next->argv[bos->next->ind++])) {
            ifBLIN_QX0("no argv[%d]", bos->next->ind);
            ERROUT(-EX_DATAERR, EFAULT);
        } else if (*(bos->next->plc) != '-') {
            /* Argument is not an option */
            bos->next->flags |= Bpars_EOOP;
            goto out;
        } else if (!(ex = *(++(bos->next->plc)) & 0xFF)) {
            /* Solitary '-', treat as a '-' option */
            ex = '-';
        } else if (ex == '-') {
            if  (!*(++(bos->next->plc))) {
                /* "--" => end of options */
                bos->flags |= Bpars_DASH;
                ex = 0;
                bos->next->flags |= Bpars_EOOP;
                goto out;
            }
        } else {
            ++(bos->next->plc);
        }
        if  (bos->flags & Bpars_SYMe && ((bos->flags & Bpars_SYMe) == (ex & Bpars_SYMe))) {
            bos->redirenv = 2;
            ex = 0;
        }
        if  (bos->symr && ((bos->symr & 0xDF) == (ex & 0xDF))) {
            bos->argin = 1;
            if  (!getoptsarg(bos)) {
                u_int32_t    mask;
                babolo_parm *bp;
                char        *cp = NULL;

                mask = (bos->flags & BLIN_MASK) | Bpars_NONU;
                if  ((bos->symr ^ ex) & 0x20 ) mask |= Bpars_NOEN;
                if  (!(cp = strdup(bos->o))) {
                    ifBLIN_QW0("strdup=%s~", bos->o);
                    ex = -EX_OSERR;
                } else if (!(bp = babolo_getparm(mask, &cp, "", 0))) {
                    ifBLIN_QX0("no parm=%s~", bos->o);
                    ex = -EX_USAGE;
                } else if (babolo_setparm(bos, Bpars_OWBP, bp, NULL)) {
                    ifBLIN_QX0("no opts=%s~", bos->o);
                    ex = -EX_USAGE;
                } else {
                    ex = 0;
                }
                bos->o = NULL;
                /* if  (!!cp) free(cp); XXXX   */
    }   }   }
    ifBLIN_QX4(" getopt %02X=%c", ex, ex);
    if  ((ex < 0) || !bos->next) goto out;
    bos->next->flags &= (BLIN_flag)~Bpars_NPRM;
    argn = !bos->next->opts[ex] ? 0 : bos->next->opts[ex] - 1;
    bos->c = (char)ex;
    bos->o = bos->next->arg = NULL;
    if  (!(bos->flags & Bpars_PREA)) {
        bos->argin = (int8_t)argn;
        bos->next->flags |= argn & Bpars_NPRM;
        if  (  !(((bos->flags & Bpars_CMPT) ? bos->next->flags : bos->flags) & Bpars_ESYM)
            && !bos->next->opts[ex]
            ) {
            ifBLIN_QX0("invalid option %02X=%c", ex, ex);
            ERROUT(-1, EINVAL);
        }
    } else {
        bos->argin = bos->next->opts[ex] ? (int8_t)(bos->next->opts[ex] - 1) : (int8_t)0;
        switch(bos->next->opts[ex]) {
        case 0:
            ifBLIN_QX4(" NoOpt %"BLIN_X" [%d]%s~", BLIN_I(bos->next), bos->next->ind, bos->next->plc);
            if  (!(((bos->flags & Bpars_CMPT) ? bos->next->flags : bos->flags) & Bpars_ESYM)) {
                ifBLIN_QX0("invalid option %02X=%c", ex, ex);
                ERROUT(-1, EINVAL);
            }
            break;
        case 1:
            ifBLIN_QX4(" Opt0 %"BLIN_X" [%d]%s~", BLIN_I(bos->next), bos->next->ind, bos->next->plc);
            break;
        default:
            if  (0 > (getoptsarg(bos))) {
                ERROUT(-1, ENOENT);
        }   }
        ifBLIN_QX4( " -- %"BLIN_X" [%d]%s~"
                  , BLIN_I(bos->next)
                  , bos->next ? bos->next->ind : -1111
                  , bos->next ? bos->next->plc : ""
                  );
    }
out:
    if  (!!bos) {
        if  (--(bos->redirenv) < 0) bos->redirenv = 0;
        ifBLIN_QX3("- %d", ex);
# ifdef DEBUG
        optst(bos, "getopts out");
# endif
    } else {
# undef blin_internal_flags
        ifBLIN_QX3("- %d", ex);
    }
    return(ex);
}

const char *
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getoptsarg(babolo_opts *bos) {                                                            /****
 *****************************************************************************************************
 *****************************************************************************************************/
    int         ex = EX_OK;
    const char *c  ;

    c = NULL;
    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(-EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
# ifdef DEBUG
    optst(bos, "getoptsarg in");
# endif
    if  (!bos->next) {
        ifBLIN_QX0("no argument %d", ex);
        ERROUT(-1, ENOENT);
    }
    ifBLIN_QX3("+ %"BLIN_X" %"BLIN_X, BLIN_I(bos), BLIN_I(bos->next));
    if  (bos->flags & Bpars_PREA) c = bos->o;
    if  (getoptsarg(bos)) goto out;
    if  (!(bos->flags & Bpars_PREA)) c = bos->o;
    if  (!c) {
        ifBLIN_QX3("- NULL");
    } else {
        ifBLIN_QX3("- =%s~", c);
    }
out:
# ifdef DEBUG
    optst(bos, "getoptsarg out");
# endif
# undef blin_internal_flags
    return(c);
}

unsigned long
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getoptunum(babolo_opts *bos, int base) {                                                  /****
 *****************************************************************************************************
 *****************************************************************************************************/
    unsigned long ex = 0;
    char         *cc ;
    const char   *c  ;

    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
    if  (!(c = babolo_getoptsarg(bos))) goto out;
    errno = 0;
    ex = strtoul(c, &cc, base);
    if  (errno) {
        ifBLIN_QW0("-%c strtoul=%s~", bos->c, c);
        goto out;
    } else if (*cc) {
        ifBLIN_QX0("-%c text=%s~", bos->c, c);
        errno = EPROTO;
    }
out:
# undef blin_internal_flags
    return(ex);
}

long
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getoptsnum(babolo_opts *bos, int base) {                                                 /****
 *****************************************************************************************************
 *****************************************************************************************************/
    long        ex = 0;
    char       *cc ;
    const char *c  ;

    if  (!bos) {
        ifBLIN_QX0("no bos");
        ERROUT(EX_DATAERR, EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
    if  (!(c = babolo_getoptsarg(bos))) goto out;
    errno = 0;
    ex = strtol(c, &cc, base);
    if  (errno) {
        ifBLIN_QW0("-%c strtoul=%s~", bos->c, c);
        goto out;
    } else if (*cc) {
        ifBLIN_QX0("-%c text=%s~", bos->c, c);
        errno = EPROTO;
    }
out:
# undef blin_internal_flags
    return(ex);
}

const char *
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getargs(babolo_opts *bos) {                                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    const char *c;

    c = NULL;
    if  (!bos) {
        ifBLIN_QX0("no bos");
        EXOUT(EFAULT);
    }
# define blin_internal_flags (bos->flags & BLIN_MASK)
# ifdef DEBUG
    optst(bos, "getargs in");
# endif
    for (c = NULL; !!bos->next && !c;) {
        ifBLIN_QX4(" ++ %"BLIN_X" [%d]%s~", BLIN_I(bos->next), bos->next->ind, bos->next->plc);
        if  (!!*(bos->next->plc) || (bos->next->plc == bos->next->argv[bos->next->ind - 1])) {
            c = bos->next->plc;
            bos->next->plc = "";
        } else if (!bos->next->argv) {
            ifBLIN_QX0("no argv");
            EXOUT(EFAULT);
        } else if (bos->next->ind < bos->next->argc) {
            c = bos->next->argv[bos->next->ind++];
        } else {
            freeopt(bos);
    }   }
    ifBLIN_QX4(" -- %"BLIN_X, BLIN_I(bos->next));
out:
    if  (!!bos) {
        if  (!c) ifBLIN_QX3("- NULL"); else ifBLIN_QX3("- =%s~", c);
# ifdef DEBUG
        optst(bos, "getargs out");
# endif
    } else {
# undef blin_internal_flags
        ifBLIN_QX3("-");
    }
    return(c);
}

static const char topr[256] =
".0123456789ABCDE" "FGHIJKLMNOPQRSTU" "VWXYZabcdefghijk" "lmnopqrstuvwxyz_"
"################" "################" "################" "################"
"################" "################" "################" "################"
"################" "################" "################" "################"
;
void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_dumpopts(const babolo_opts *bos) {                                                        /****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (bos->flags & BLIN_MASK)
    const babolo_opt *opt;
    int               ex = 0;
    int               i  ;
    int               j  ;

    fprintf(stderr, "common flags=%08X", bos->flags);
    if  (bos->flags & Bpars_SYMe) fprintf(stderr, " E=%c", bos->flags & Bpars_SYMe);
    if  (bos->symr)               fprintf(stderr, " Z=%c", bos->symr & 0xFF);
    if  (bos->c)                  fprintf(stderr, " -%c", bos->c);
    if  (bos->o)                  fprintf(stderr, "=%s~", bos->o);
    fprintf(stderr, " redirenv=%d argin=%d\n", bos->redirenv, bos->argin);
    for (i = 0, opt = bos->next; !!opt; ++i, opt = opt->next) {
        fprintf( stderr, "%3d %"BLIN_X" flags=%08X argc=%d ind=%d\n"
               , i
               , BLIN_I(opt)
               , opt->flags
               , opt->argc
               , opt->ind
               );
        if  (!!opt->opts) {
            fprintf(stderr, "opts 0123 4567 89AB CDEF\n");
            for (j = 0; j < 16; ++j) {
                fprintf( stderr, " %02X: %c%c%c%c %c%c%c%c %c%c%c%c %c%c%c%c\n"
                       , j * 16
                       , topr[opt->opts[j * 16 +  0]], topr[opt->opts[j * 16 +  1]]
                       , topr[opt->opts[j * 16 +  2]], topr[opt->opts[j * 16 +  3]]
                       , topr[opt->opts[j * 16 +  4]], topr[opt->opts[j * 16 +  5]]
                       , topr[opt->opts[j * 16 +  6]], topr[opt->opts[j * 16 +  7]]
                       , topr[opt->opts[j * 16 +  8]], topr[opt->opts[j * 16 +  9]]
                       , topr[opt->opts[j * 16 + 10]], topr[opt->opts[j * 16 + 11]]
                       , topr[opt->opts[j * 16 + 12]], topr[opt->opts[j * 16 + 13]]
                       , topr[opt->opts[j * 16 + 14]], topr[opt->opts[j * 16 + 15]]
                       );
        }   }
        if  (!!opt->arg) fprintf(stderr, "arg=%s~\n", opt->arg);
        if  (!!opt->plc) fprintf(stderr, "plc=%s~\n", opt->plc);
        if  (!!opt->argv) {
            for (j = 0; j < opt->argc; ++j) {
                fprintf(stderr, "%cargv[%d]=%s~\n", (j == opt->ind) ? '>' : ' ', j, opt->argv[j]);
    }   }   }
    ifBLIN_QX3("- %d", ex);
#   undef blin_internal_flags
}

void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_optest(const char *ostr) {                                                                /****
 *****************************************************************************************************
 *****************************************************************************************************/
    for (u_int i = 0; ostr[i];) {
        u_int c;
        u_int s;

        s = i++;
        for (c = 0; ostr[i] == ':'; ++i) if (c < 255) ++c;
        printf("%c\t%u\n", ostr[s], c);
}   }

void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_optext(const babolo_opts *bos) {                                                           /****
 *****************************************************************************************************
 *****************************************************************************************************/
    const babolo_opt *o;
    int               c;

    printf("-\t0\n");
    if  (bos->flags & Bpars_SYMe) printf("%c\t0\n", bos->flags & Bpars_SYMe);
    if  (bos->symr) printf("%c\t1\n%c\t1\n", bos->symr & 0xFF, (0x20 ^ bos->symr) & 0xFF);
    for (o = bos->next; o; o = o->next) {
        for (c = 0; c < 256; ++c) {
            if  (o->opts[c]) printf((c < ' ') ? "\\%03o\t%u\n" : "%c\t%u\n", c, o->opts[c] - 1);
}   }   }
