/*-
 * Copyright (C)2006..2025 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2006..2025 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: lexor.c,v 1.44 2025/12/21 18:17:48 babolo Exp $\n"

#define BLIN_COMPAT  4
#define MULAR_COMPAT 0
#define MIFE_COMPAT  5
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include <multilar.h>
#include <mife.h>
#include "../parser.h"
#include "lexor.h"

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                              **
 *****************************************************************************************************
 *****************************************************************************************************/
#define FU ((u_char)~0)

static babolo_lexor qvv =
{ NULL, NULL, Bpars_AABS | Bpars_CEND, 127, 127, 2
,{/*  0 */ 0,  '-', 2,0,                                                        (u_char) ~0,FU
 ,/*  2 */ 3,  'q', 7,0,  'v',19,0,  'f',60,0,  'c', 97,0,                      (u_char) ~0,FU
 ,/*  7 */ 4,  'q', 7,0,  'v',13,0,  'f',55,0,  'c', 95,0,   0 ,(u_char)~ 1,FU, (u_char) ~0,FU
 ,/* 13 */ 4,  'q', 7,0,  'v',19,0,  'f',60,0,  'c', 97,0,   0 ,(u_char)~ 2,FU, (u_char) ~0,FU
 ,/* 19 */ 4,  'q', 7,0,  'v',25,0,  'f',65,0,  'c', 99,0,   0 ,(u_char)~ 3,FU, (u_char) ~0,FU
 ,/* 25 */ 4,  'q', 7,0,  'v',31,0,  'f',70,0,  'c',101,0,   0 ,(u_char)~ 4,FU, (u_char) ~0,FU
 ,/* 31 */ 4,  'q', 7,0,  'v',37,0,  'f',75,0,  'c',103,0,   0 ,(u_char)~ 5,FU, (u_char) ~0,FU
 ,/* 37 */ 4,  'q', 7,0,  'v',43,0,  'f',80,0,  'c',105,0,   0 ,(u_char)~ 6,FU, (u_char) ~0,FU
 ,/* 43 */ 4,  'q', 7,0,  'v',49,0,  'f',85,0,  'c',107,0,   0 ,(u_char)~ 7,FU, (u_char) ~0,FU
 ,/* 49 */ 4,  'q', 7,0,  'v',49,0,  'f',90,0,  'c',109,0,   0 ,(u_char)~ 8,FU, (u_char) ~0,FU
 ,/* 55 */ 3,  'q',55,0,  'v',60,0,             'c',111,0,   0 ,(u_char)~ 9,FU, (u_char) ~0,FU
 ,/* 60 */ 3,  'q',55,0,  'v',65,0,             'c',113,0,   0 ,(u_char)~10,FU, (u_char) ~0,FU
 ,/* 65 */ 3,  'q',55,0,  'v',70,0,             'c',115,0,   0 ,(u_char)~11,FU, (u_char) ~0,FU
 ,/* 70 */ 3,  'q',55,0,  'v',75,0,             'c',117,0,   0 ,(u_char)~12,FU, (u_char) ~0,FU
 ,/* 75 */ 3,  'q',55,0,  'v',80,0,             'c',119,0,   0 ,(u_char)~13,FU, (u_char) ~0,FU
 ,/* 80 */ 3,  'q',55,0,  'v',85,0,             'c',121,0,   0 ,(u_char)~14,FU, (u_char) ~0,FU
 ,/* 85 */ 3,  'q',55,0,  'v',90,0,             'c',123,0,   0 ,(u_char)~15,FU, (u_char) ~0,FU
 ,/* 90 */ 3,  'q',55,0,  'v',90,0,             'c',125,0,   0 ,(u_char)~16,FU, (u_char) ~0,FU
 ,/* 95 */ 0,                                                0 ,(u_char)~17,FU, (u_char)~33,FU
 ,/* 97 */ 0,                                                0 ,(u_char)~18,FU, (u_char)~34,FU
 ,/* 99 */ 0,                                                0 ,(u_char)~19,FU, (u_char)~35,FU
 ,/*101 */ 0,                                                0 ,(u_char)~20,FU, (u_char)~36,FU
 ,/*103 */ 0,                                                0 ,(u_char)~21,FU, (u_char)~37,FU
 ,/*105 */ 0,                                                0 ,(u_char)~22,FU, (u_char)~38,FU
 ,/*107 */ 0,                                                0 ,(u_char)~23,FU, (u_char)~39,FU
 ,/*109 */ 0,                                                0 ,(u_char)~24,FU, (u_char)~40,FU
 ,/*111 */ 0,                                                0 ,(u_char)~25,FU, (u_char)~41,FU
 ,/*113 */ 0,                                                0 ,(u_char)~26,FU, (u_char)~42,FU
 ,/*115 */ 0,                                                0 ,(u_char)~27,FU, (u_char)~43,FU
 ,/*117 */ 0,                                                0 ,(u_char)~28,FU, (u_char)~44,FU
 ,/*119 */ 0,                                                0 ,(u_char)~29,FU, (u_char)~45,FU
 ,/*121 */ 0,                                                0 ,(u_char)~30,FU, (u_char)~46,FU
 ,/*123 */ 0,                                                0 ,(u_char)~31,FU, (u_char)~47,FU
 ,/*125 */ 0,                                                0 ,(u_char)~32,FU, (u_char)~48,FU
}};

static int
/*****************************************************************************************************/
argrun(runparm *r, run12parm *r2, int argc, char **argv) {                                       /****
 *****************************************************************************************************
 *                                                       *
 *****************************************************************************************************/
# define blin_internal_flags (r->flags & BLIN_MASK)
    int     ex = EX_OK;
    ssize_t iarp = 1;

    ifBLIN_QX4("+");
    /**************************************
     *   -   -qv *
     **************************************/
    if  (iarp < argc) {
        u_int32_t i;
        i = babolo_testword(&qvv, argv[iarp]);
        if  (i--) {
            ifBLIN_QX2("qvvfc=%02X", i);
            r->flags &= ~BLIN_MASK;
            r->flags |= (0x00FF0000U << (i & 7)) & BLIN_MASK;
            blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, r->flags & BLIN_MASK);
            if  (i & 8) r->flags |= Bpars_AABS;
            if  (i & 16) {
                ++iarp;
                r2->ccname = strdup(argv[iarp]);
            } else if (i & 32) {
                r2->ccname = strdup(strchr(argv[iarp], 'c') + 1);
            } else {
                r2->ccname = strdup("cc");
            }
            ++iarp;
        } else {
            r2->ccname = strdup("cc");
        }
    } else {
        r2->ccname = strdup("cc");
    }
#if 0
    bylex.flags &= ~BLIN_MASK;
    bylex.flags |= r->flags & BLIN_MASK;
    bytree.flags &= ~BLIN_MASK;
    bytree.flags |= r->flags & BLIN_MASK;
#endif
    ifBLIN_QO4 {
        ifBLIN_QX4("qvvfc:");
        babolo_treedump(&qvv);
    }

    if  (iarp < argc) {
        /**********************************
         *       *
         *   ccname         *
         **********************************/
    }
    /*****************************************
     *   ,        *
     *    ,   *
     *    cc      *
     *****************************************/
    if  (!(r2->ccarg = malloc(sizeof(*(r2->ccarg)) * ((unsigned long)argc + 8)))) {
        ifBLIN_QW0("malloc for args");
        ex = EX_OSERR;
    } else {
        r2->ccarp = 0;
        r2->ccarg[r2->ccarp++] = r2->ccname;
        for (; iarp < argc - 1 && argv[iarp];) {
            if  (strcmp(argv[iarp], "-o")) {
                r2->ccarg[r2->ccarp++] = argv[iarp++];
            } else {
                ++iarp;
                r->oufn = argv[iarp++];
        }   }
        if  (iarp == argc - 1) {
            r2->infn = argv[iarp++];
        }
        r2->ccarg[r2->ccarp++] = "-pipe";
        r2->ccarg[r2->ccarp++] = "-nostdlib";
        r2->ccarg[r2->ccarp++] = "-Wl,--oformat=binary,--entry=e";
        r2->ccarg[r2->ccarp++] = "-o";
        r2->ccarg[r2->ccarp++] = "/dev/stdout";
        r2->ccarg[r2->ccarp] = NULL;
        ifBLIN_QO1 {
            for (u_int32_t i = 0; (i < r2->ccarp) && !!r2->ccarg[i]; i++) {
                ifBLIN_QX1("%d=%s~", i, r2->ccarg[i]);
            }
            ifBLIN_QX1("in=%s~", r2->infn);
            ifBLIN_QX1("out=%s~", r->oufn);
    }   }
    ifBLIN_QX4("- %d\n", ex);
    return(ex);
# undef blin_internal_flags
}   /* argrun */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                     **
 *****************************************************************************************************
 *****************************************************************************************************/

static babolo_lexor bylex =
{ NULL, NULL, Bpars_AABS | Bpars_CEND, 53, 53, 1
,{/* 00 */   1,  '#',(u_char) 6, '\n',(u_char)~1,                                    3
 ,/* 03 */   1, '\n',(u_char)~1, '\0',(u_char)~0,                                    3
 ,/* 06 */   2,  ' ',(u_char) 6, '\t',(u_char) 6,  'L',(u_char)10,                   3
 ,/* 10 */   0,  'E',(u_char)12,                                                     3
 ,/* 12 */   0,  'X',(u_char)14,                                                     3
 ,/* 14 */   0,  'O',(u_char)16,                                                     3
 ,/* 16 */   0,  'R',(u_char)18,                                                     3
 ,/* 18 */   3,  ' ',(u_char)18, '\t',(u_char)18,  'B',(u_char)23,  'I',(u_char)36,  3
 ,/* 23 */   0,  'E',(u_char)25,                                                     3
 ,/* 25 */   0,  'G',(u_char)27,                                                     3
 ,/* 27 */   0,  'I',(u_char)29,                                                     3
 ,/* 29 */   0,  'N',(u_char)31,                                                     3
 ,/* 31 */   3,  ' ',(u_char)31, '\t',(u_char)31, '\n',(u_char)~3, '\0',(u_char)~0,  3
 ,/* 36 */   0,  'N',(u_char)38,                                                     3
 ,/* 38 */   0,  'C',(u_char)40,                                                     3
 ,/* 40 */   0,  'L',(u_char)42,                                                     3
 ,/* 42 */   0,  'U',(u_char)44,                                                     3
 ,/* 44 */   0,  'D',(u_char)46,                                                     3
 ,/* 46 */   0,  'E',(u_char)48,                                                     3
 ,/* 48 */   3,  ' ',(u_char)48, '\t',(u_char)48, '\n',(u_char)~2, '\0',(u_char)~0,  3
}};

static babolo_lexor bytree =
{ (const u_char *)
  "0000""0000""3200""0000"
  "0000""0000""0000""0000"
  "3000""4000""4440""1000"
  "4444""4444""4400""0000"

  "0444""4444""4444""4444"
  "4444""4444""4444""0404"
  "0444""4444""4444""4444"
  "4444""4444""4440""0000"

  "0000""0000""0000""0000"
  "0000""0000""0000""0000"
  "0000""0000""0000""0000"
  "0000""0000""0000""0000"

  "0000""0000""0000""0000"
  "0000""0000""0000""0000"
  "0000""0000""0000""0000"
  "0000""0000""0000""0000"
, NULL, Bpars_AABS | Bpars_CEND, 10, 10, 1
, {/* 00 */   3,  '1',(u_char)~3,  '2',(u_char)~2,  '3',(u_char) 0,  '4', 5,  (u_char)~0
  ,/* 05 */   3,  '1',(u_char)~7,  '2',(u_char)~6,  '3',(u_char)~4,  '4', 5,  (u_char)~0
} };

static int
/*****************************************************************************************************/
run1(runparm *r, run12parm *r2) {                                                                /****
 *****************************************************************************************************
 *                                                                                 *
 *****************************************************************************************************/
# define blin_internal_flags (r->flags & BLIN_MASK)
    size_t       s[] = {1024, 512, 512};
    int          ex = EX_OK;
    char        *inwent;
    ssize_t      inlen;
    u_int        line;
    char        *ingo;
    babolo_parm *parm;

    ifBLIN_QO4 {
        fprintf(stderr, "+run1\n");
        fprintf(stderr, "bylex:\n");
        babolo_treedump(&bylex);
        fprintf(stderr, "bytree:\n");
        babolo_treedump(&bytree);
    }
    /**********************************
     *      *
     **********************************/
    if  (!(r->iffed = mife_init(MIFE_FULL))) {
        ifBLIN_QW0("in mife init");
        ex = EX_NOINPUT;
    } else if (0 > mife_ctlfile(r->iffed, r2->infn)) {
        ifBLIN_QW0("in mife open");
        ex = EX_NOINPUT;
    } else if ((inlen = mife_read(r->iffed, 0, 0)) < 0) {
        ifBLIN_QW0("in mife read");
        ex = EX_IOERR;
    } else if (!(ingo = mife_get(r->iffed, 0))) {
        ifBLIN_QW0("in mife get");
        ex = EX_NOINPUT;
    } else {
        /*******************************
         *     *
         *******************************/
        r2->incopy = inwent = ingo;
        r2->ininc = NULL;
        r2->lncopy = 1;
        r2->lninc = line = 0;
        for (;; inwent = ingo) {
            u_int32_t i;

        ;   if  (ingo > ((char*)mife_get(r->iffed, 0) + inlen - 12)) {
        ;       ifBLIN_QW0("No work #0");
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   }
        ;   i = babolo_goword(&bylex, (const char **)&ingo);
        ;   ++line;
        ;   if  (i == 0) {
        ;       ifBLIN_QX0("No work #1");
        ;       ex = EX_DATAERR;
        ;       errno = EFTYPE;
        ;       goto out;
        ;   } else if (i == 2) {
        ;       r2->ininc = r2->incopy;
        ;       r2->lninc = r2->lncopy;
        ;       r2->lncopy = line + 1;
        ;       *inwent = '\0';
        ;       r2->incopy = ingo;
        ;   } else if (i == 3) {
        ;       break;
        }   }
        *inwent = '\0';
        ifBLIN_QO1 {
        ;   if  (r2->ininc) fprintf(stderr, "@%u ininc=%s~\n", (u_int)r2->lninc, r2->ininc);
        ;   if  (r2->incopy) fprintf(stderr, "@%u incopy=%s~\n", (u_int)r2->lncopy, r2->incopy);
        }
        /************************
         *    *
         ************************/
        ++line;
        r2->lntype = 0;
        r2->intype = NULL;
        r2->inname = NULL;
        r2->inflag = NULL;
        for (inwent = ingo; ;inwent = ingo) {
            u_int32_t i;
        ;   i = babolo_goword(&bytree, (const char **)&ingo);
        ;   if  (!i) {
        ;       ifBLIN_QW0("No work #2");
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   } else if (i & 4) {
        ;       if (!r2->intype) r2->intype = r2->inname;
        ;       r2->inname = inwent;
        ;       r2->lntype = line;
        ;   }
        ;   if  (i & 2) {
        ;       if  (!r2->inname) {
        ;           ifBLIN_QX0("Line %u: No name for babolo_lexor structure", line);
        ;           ex = EX_DATAERR;
        ;           errno = EBADMSG;
        ;           goto out;
        ;       }
        ;       if  (r2->intype) *(inwent - 1) = '\0';
        ;       *(ingo - 1) = '\0';
        ;       if  (i & 1) {
        ;           r2->inflag = ingo;
        ;           ingo = strpbrk(ingo, "\n");
        ;           if  (ingo && *ingo == '\n') {
        ;               *(ingo++) = '\0';
        ;           } else {
        ;               ifBLIN_QX0("No babolo_lexor flags");
        ;               ex = EX_DATAERR;
        ;               errno = EBADMSG;
        ;               goto out;
        ;       }   }
        ;       break;
        }   }
        ifBLIN_QO1 {
        ;   if  (r2->intype) fprintf(stderr, "@%u intype=%s~\n", (u_int)r2->lntype, r2->intype);
        ;   if  (r2->inname) fprintf(stderr, "@inname=%s~\n", r2->inname);
        ;   if  (r2->inflag) fprintf(stderr, "@inflag=%s~\n", r2->inflag);
        }
        if  (!r2->inname) {
        ;   ifBLIN_QX0("Line %u: No name for babolo_lexor structure", line);
        ;   ex = EX_DATAERR;
        ;   goto out;
        }
        ++line;
        /*********************************
         *    *
         *********************************/
        if  (*ingo != '\n') {
            size_t b;

        ;   r2->intrans = ingo;
        ;   r2->lntrans = line;
        ;   for (b = 0; b < 2; ++ingo) {
        ;       if  (!ingo) {
        ;           ifBLIN_QX0("Not found words for coding");
        ;           ex = EX_DATAERR;
        ;           errno = ENOMSG;
        ;           goto out;
        ;       }
        ;       if  (*ingo == '\n') {
        ;           ++b;
        ;           ++line;
        ;       } else {
        ;           b = 0;
        ;   }   }
        ;   ingo[-2] = '\0';
        } else {
        ;   r2->intrans = NULL;
        ;   r2->lntrans = line;
        ;   ++ingo;
        }
        if  (r2->intrans) ifBLIN_QX1("@%u intrans=%s~", (u_int)r2->lntrans, r2->intrans);

        /**************************
         *    *
         **************************/
        if  (!(r2->imd = mular_create(MULAR_STRI|MULAR_HEXU, 3, 0, s))) {
        ;   ifBLIN_QW0("mular create #3");
        ;   ex = EX_SOFTWARE;
        ;   goto out;
        }
        r2->imd->tofree = (void*)babolo_freeparm;
        for (;*ingo && ingo < (char*)mife_get(r->iffed, 0) + inlen;) {
        ;   if  (*ingo == '#') {
        ;       ingo = strpbrk(ingo, "\n");
        ;       if  (ingo && *ingo == '\n') {
        ;           ++ingo;
        ;           ++line;
        ;       }
        ;   } else {
                size_t b;
        ;       parm = babolo_getparm( Bpars_FIXB | Bpars_LFLN | Bpars_NOEN | (4 & Bpars_NPRM)
                                     , &ingo, NULL, 0
                                     );
        ;       b = line;
        ;       line += parm->cntr;
        ;       parm->cntr = b;
        ;       if  (parm->argc > 1) {
                    babolo_parm **p;
        ;           ifBLIN_QO1 {
        ;               fprintf( stderr, "%lu..%u 0=%s~ 1=%s~"
                               , (unsigned long)(line - parm->cntr)
                               , line
                               , parm->argv[0]
                               , parm->argv[1]
                               );
        ;               if  (parm->argc > 2) fprintf(stderr, " 2=%s~", parm->argv[2]);
        ;               if  (parm->argc > 3) fprintf(stderr, " 3=%s~", parm->argv[3]);
        ;               fprintf(stderr, "\n");
        ;           }
        ;           if  (!(p = mular_add(r2->imd))) {
        ;               ifBLIN_QW0("mular add #4");
        ;               ex = EX_SOFTWARE;
        ;               goto out;
        ;           }
        ;           *p = parm;
        ;       } else {
        ;           babolo_freeparm(parm);
        }   }   }
        ifBLIN_QO4 mular_dump(r2->imd, stderr);
    }
out:
    if  (!!ex) {
        if  (r->iffed) mife_fini(r->iffed);
        r->iffed = NULL;
        if  (r2->imd) mular_destroy(r2->imd);
        r2->imd = NULL;
    }
    ifBLIN_QX4("- %d\n", ex);
    return(ex);
# undef blin_internal_flags
}   /* run1 */

/*****************************************************************************************************
 *   run1                                                                       *
 *****************************************************************************************************/

static u_char equ[] = 
 "{ 0000,0001,0002,0003, 0004,0005,0006,0007, 0010,0011,0012,0013, 0014,0015,0016,0017\n"
" , 0020,0021,0022,0023, 0024,0025,0026,0027, 0030,0031,0032,0033, 0034,0035,0036,0037\n"
" , 0040,0041,0042,0043, 0044,0045,0046,0047, 0050,0051,0052,0053, 0054,0055,0056,0057\n"
" , 0060,0061,0062,0063, 0064,0065,0066,0067, 0070,0071,0072,0073, 0074,0075,0076,0077\n"
" , 0100,0101,0102,0103, 0104,0105,0106,0107, 0110,0111,0112,0113, 0114,0115,0116,0117\n"
" , 0120,0121,0122,0123, 0124,0125,0126,0127, 0130,0131,0132,0133, 0134,0135,0136,0137\n"
" , 0140,0141,0142,0143, 0144,0145,0146,0147, 0150,0151,0152,0153, 0154,0155,0156,0157\n"
" , 0160,0161,0162,0163, 0164,0165,0166,0167, 0170,0171,0172,0173, 0174,0175,0176,0177\n"
" , 0200,0201,0202,0203, 0204,0205,0206,0207, 0210,0211,0212,0213, 0214,0215,0216,0217\n"
" , 0220,0221,0222,0223, 0224,0225,0226,0227, 0230,0231,0232,0233, 0234,0235,0236,0237\n"
" , 0240,0241,0242,0243, 0244,0245,0246,0247, 0250,0251,0252,0253, 0254,0255,0256,0257\n"
" , 0260,0261,0262,0263, 0264,0265,0266,0267, 0270,0271,0272,0273, 0274,0275,0276,0277\n"
" , 0300,0301,0302,0303, 0304,0305,0306,0307, 0310,0311,0312,0313, 0314,0315,0316,0317\n"
" , 0320,0321,0322,0323, 0324,0325,0326,0327, 0330,0331,0332,0333, 0334,0335,0336,0337\n"
" , 0340,0341,0342,0343, 0344,0345,0346,0347, 0350,0351,0352,0353, 0354,0355,0356,0357\n"
" , 0360,0361,0362,0363, 0364,0365,0366,0367, 0370,0371,0372,0373, 0374,0375,0376,0377\n"
" }";

static u_char eska[] =
{ e_Z, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  'b', 't', 'n', 'v',  'f', 'r', e_C, e_C
, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_D, e_D, e_E, e_D,  e_D, e_D, e_D, e_E,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D

, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_E, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_C

, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_D,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_D,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C

, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
};

static int
intrfil1(runparm *r, run12parm *r2) {
# define blin_internal_flags (r->flags & BLIN_MASK)
    FILE         *sto;
    int           ex = EX_OK;

    ifBLIN_QX3("+");
    if  (!(sto = fdopen(r2->fil1, "w"))) {
        ifBLIN_QW0("fdopen #110");
        ex = EX_IOERR;
    } else {
        babolo_parm **c;
        const char   *s;

        if  (r2->ininc) fprintf(sto, "#line %u \"%s\"\n%s", (u_int)r2->lninc, r2->infn, r2->ininc);
        if  (r2->incopy) fprintf(sto, "#line %u \"%s\"\n%s", (u_int)r2->lncopy, r2->infn, r2->incopy);
        fprintf( sto
               , "struct {\n"
                 "    u_int32_t    f;\n"
                 "    u_int32_t    n;\n"
                 "    const u_char t[256];\n"
                 "    u_int32_t    v[%u];\n"
                 "    const u_char e[%u];\n"
               , (u_int)r2->imd->top.index
               , (u_int)r2->imd->top.index
               );
        ifBLIN_QX2( "struct {\n"
                    "    u_int32_t    f;\n"
                    "    u_int32_t    c;\n"
                    "    const u_char t[256];\n"
                    "    u_int32_t    v[%u];\n"
                    "    const u_char e[%u];"
                  , (u_int)r2->imd->top.index
                  , (u_int)r2->imd->top.index
                  );
# ifdef SEPA
        for (u_int32_t i = 0; (c = (mular_getix(r2->imd, i))); ++i) {
            if  (((*c)->argc > 2) && ((*c)->argv) && ((*c)->argv[2])) {
                fprintf(sto, "    char w%u[%"BLIN_U"];\n", i, strlen((*c)->argv[2]) + 1);
                ifBLIN_QX2("    char w%u[%"BLIN_U"];", i, strlen((*c)->argv[2]) + 1);
            } else {
                fprintf(sto, "    char w%u[1];\n", i);
                ifBLIN_QX2("    char w%u[1];", i);
        }   }
# else
        {   u_int32_t j = 0;

            for (u_int32_t i = 0; (c = (mular_getix(r2->imd, i))); ++i) {
                if  (((*c)->argc > 2) /* && ((*c)->argv)*/ && ((*c)->argv[2])) {
                    j += strlen((char*)((*c)->argv[2])) + 1;
                } else {
                    j += 1;
            }   }
            fprintf(sto, "    char w[%u];\n", j);
            ifBLIN_QX2("    char w[%u];", j);
        }
# endif
        fprintf(sto, "} e = \n");
        ifBLIN_QX2("} e =");
        if  (r2->inflag) {
            fprintf(sto, "{(%s),%u\n", r2->inflag, (u_int)r2->imd->top.index);
            ifBLIN_QX2("{(%s),%u", r2->inflag, (u_int)r2->imd->top.index);
        } else {
            fprintf(sto, "{0,%u\n", (u_int)r2->imd->top.index);
            ifBLIN_QX2("{0,%u", (u_int)r2->imd->top.index);
        }
        if  (r2->intrans) {
            fprintf(sto, "#line %u \"%s\"\n,%s\n", (u_int)r2->lntrans, r2->infn, r2->intrans);
            ifBLIN_QX2("#line %u \"%s\"\n,%s", (u_int)r2->lntrans, r2->infn, r2->intrans);
        } else {
            fprintf(sto, ",%s\n#line %u \"%s\"\n", (char*)equ, (u_int)r2->lntrans + 1, r2->infn);
            ifBLIN_QX2(",%s\n#line %u \"%s\"", (char*)equ, (u_int)r2->lntrans + 1, r2->infn);
        }
        s = ",{";
        for (u_int32_t i = 0; (c = (mular_getix(r2->imd, i))); ++i) {
            fprintf(sto, "%s%s", s, (*c)->argv[1]);
            ifBLIN_QX2("%s%s", s, (*c)->argv[1]);
            s = ",";
        }
        fprintf(sto, "}\n");
        ifBLIN_QX2("}");
        s = ",{";
        for (u_int32_t i = 0; (c = (mular_getix(r2->imd, i))); ++i) {
            if  ((*c)->argv[0]) {
                fprintf(sto, "%s%d", s, (*c)->argv[0][0]);
                ifBLIN_QX2("%s%d", s, (*c)->argv[0][0]);
            } else {
                fprintf(sto, "%s0", s);
                ifBLIN_QX2("%s0", s);
            }
            s = ",";
        }
        fprintf(sto, "}\n");
        ifBLIN_QX2("}");
        s = ",\"";
        for (u_int32_t i = 0; (c = (mular_getix(r2->imd, i))); ++i) {
            fprintf(sto, "#line %u \"%s\"\n", (u_int)(*c)->cntr, r2->infn);
            ifBLIN_QX2("#line %u \"%s\"", (u_int)(*c)->cntr, r2->infn);
# ifdef SEPA
            fprintf(sto, ",\"");
            ifBLIN_QX2(",\"");
# else
            fprintf(sto, "%s", s);
            ifBLIN_QX2("%s", s);
# endif
            s = " \"";
            for (u_int32_t j = 0; ; ++j) {
                u_char u;

                u = 0;
                if  (((*c)->argc > 2) /* && ((*c)->argv) */ && ((*c)->argv[2])) u = (*c)->argv[2][j];
                if  (eska[u] == e_Z) break;
                switch (eska[u]) {
                case e_C: fprintf(sto, "\\%03o", u);
                          ifBLIN_QX2("\\%03o", u);
                          break;
                case e_D: fprintf(sto, "%c", u);
                          ifBLIN_QX2("%c", u);
                          break;
                case e_E: fprintf(sto, "\\%c", u);
                          ifBLIN_QX2("\\%c", u);
                          break;
                default:  fprintf(sto, "\\%c", eska[u]);
                          ifBLIN_QX2("\\%c", eska[u]);
                          break;
            }   }
# ifdef SEPA
            fprintf(sto, "\"\n");
            ifBLIN_QX2("\"");
# else
            fprintf(sto, "\\0\"\n");
            ifBLIN_QX2("\\0\"");
# endif
        }
        fprintf(sto, "};\n");
        ifBLIN_QX2("};");
        if  (fclose(sto) < 0) {
            ifBLIN_QW0("close #111");
            ex = EX_IOERR;
    }   }
    ifBLIN_QX4("- %d", ex);
    return(ex);
# undef blin_internal_flags
}   /* intrfil1 */

/*****************************************************************************************************
 *****************************************************************************************************
 **   -  cc                                                                   **
 *****************************************************************************************************
 *****************************************************************************************************/

static int
run2cc(runparm *r, run12parm *r2) {
# define blin_internal_flags (r->flags & BLIN_MASK)
    int   ex = EX_OK;
    int   status;

    ifBLIN_QX4("+");
    if  (pipe(r2->pip2)) {
        ifBLIN_QW0("pipe #2");
        ex = EX_OSERR;
    } else {
        int ex2 = fork();

        ifBLIN_QX4("fork %d", ex2);
        if  (ex2 < 0) {
            ifBLIN_QW0("fork #2");
            ex = EX_OSERR;
        } else if (ex2 == 0) {
            if  (close(r2->pip2[0]) < 0) {
                ifBLIN_QW0("close dup m#2");
                ex = EX_IOERR;
            } else if (dup2(r2->pip2[1], fileno(stdout)) < 0) {
                ifBLIN_QW0("cc stdout");
                ex = EX_IOERR;
            } else if (close(r2->pip2[1]) < 0) {
                ifBLIN_QW0("close #221");
                ex = EX_IOERR;
            } else {
                ifBLIN_QX2("exec=%s~", r2->ccname);
                ifBLIN_QO2 {
                    for (int g = 0; !!r2->ccarg[g]; ++g) ifBLIN_QX2("[%d]=%s~", g, r2->ccarg[g]);
                }
                execvp(r2->ccname, (char * const*)r2->ccarg);
                ifBLIN_QW0("exec cc=%s~ fail", r2->ccname);
                ex = EX_UNAVAILABLE;
            }
            exit(ex);
        } else if (close(r2->pip2[1]) < 0) {
            ifBLIN_QW0("close #321");
            ex = EX_IOERR;
        } else if (!(r->iffed = mife_init(0))) {
            ifBLIN_QW0("pipe mife init");
            ex = EX_NOINPUT;
        } else if (0 > mife_ctlfdsc(r->iffed, r2->pip2[0])) {
            ifBLIN_QW0("pipe mife");
            ex = EX_NOINPUT;
        } else {
            pid_t pid;

            mular_destroy(r2->imd);
            mife_fini(r->iffed);
            if  (!(r->iffed = mife_init(0))) {
                ifBLIN_QW0("cc mife init");
                ex = EX_NOINPUT;
            } else if (0 > mife_ctlfdsc(r->iffed, r2->pip2[0])) {
                ifBLIN_QW0("cc mife open");
                ex = EX_NOINPUT;
            } else if (((r->ccl = mife_read(r->iffed, 0, 0))) < 0) {
                ifBLIN_QW0("pipe mife read");
                ex = EX_IOERR;
            } else if ((pid = waitpid(ex2, &status, 0)) < 0) {
                ifBLIN_QW0("waitpid");
                ex = EX_TEMPFAIL;
            } else if (pid != ex2) {
                ifBLIN_QW0("wait pid");
                ex = EX_SOFTWARE;
            } else if (!WIFEXITED(status)) {
                ifBLIN_QX0("wait exit");
                errno = ECHILD;
                ex = EX_TEMPFAIL;
            } else {
                ex = WEXITSTATUS(status);
                if  (!!ex) errno = EPIPE;
    }   }   }
    ifBLIN_QX4("- %d", ex);
    return(ex);
# undef blin_internal_flags
}   /* run2cc */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                     **
 *****************************************************************************************************
 *****************************************************************************************************/

static treei
createnode(tree *tree) {
    treei newnode;

    if  (++(tree->treep) > tree->treem) {
        newnode = 0;
    } else {
        newnode = tree->treep;
        tree->trees[newnode] = ~(treei)0;
        tree->treed[newnode] = ~(treei)0;
        tree->treew[newnode] = (treew)0;
        tree->treev[newnode] = 0;
    }
    return(newnode);
}

static int
buildtree(tree *tree, ccbin *ls) {
    treei  treej;
    treei  treen;
    int    ex = EX_OK;
    int    f  = 0;
    size_t n;
    size_t k;

    ifBLIN_QX6("%u", ls->ibin->count);
    /******************************************************
     * k -                       *
     * n -                       *
     * treen -        *
     ******************************************************/
    for (k = 0, n = 0, treen = 0; n < ls->ibin->count;) {
        if  (k >= ls->m) {
            ifBLIN_QX0("Truncated ls");
            ex = EX_USAGE;
            errno = EDOOFUS;
            break;
        }
        /*****************************************************
         *        . *
         *   \0,     ...  *
         *    -     ,     *
         *   ,   .        *
         *    ,       *
         * ""     f,   *
         *   ,     *
         *      .            *
         *****************************************************/
        if  (f) f = 0; else if (!(ls->cbin[k]) && (ls->fbin[n] >= '0')) ++f;
        ifBLIN_QX4("[%2d]%02X [%2d]%02X %d\n", (int)k, ls->cbin[k], (int)n, ls->fbin[n], f);
        if  (!(ls->cbin[k]) && !f) {
            /*      */
            if  (!TRIS(TREE(d, treen))) {
                /*     down  */
                TREE(d, treen) = ~(treei)ls->ibin->v[n];
            } else {
                /* down  ,     side       */
                treej = TREE(d, treen);
                while (TRIS(TREE(s, treej))) treej = TREE(s, treej);
                TREE(d, treej) = ~(treei)ls->ibin->v[n];
            }
            treen = 0;
            ++n;
        } else if (!TRIS(TREE(d, treen))) {
            /*   down     ,  */
            if  (!TRIS(treej = createnode(tree))) {
                ex = EX_SOFTWARE;
                errno = EDOOFUS;
                break;
            }
            TREE(s, treej) = TREE(d, treen);
            TREE(d, treen) = treej;
            treen = treej;
            TREE(v, treen) = f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]];
        } else {
            /*     side  */
            treen = TREE(d, treen);
            while (TREE(v, treen) != (f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]])) {
                if  (!TRIS(TREE(s, treen))) {
                    /*   ,     */
                    if  (!TRIS(treej = createnode(tree))) {
                        ex = EX_SOFTWARE;
                        errno = EDOOFUS;
                        break;
                    }
                    TREE(s, treej) = TREE(s, treen);
                    TREE(s, treen) = treej;
                    treen = treej;
                    TREE(v, treen) = f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]];
                    break;
                }
                treen = TREE(s, treen);
        }   }
        if  (!f) ++k;
    }
    return(ex);
}

static int
/*****************************************************************************************************/
run3(runparm *r, ccbin *ls, tree *tree) {                                                        /****
 *****************************************************************************************************
 *       ,                                 *
 *****************************************************************************************************/
# define blin_internal_flags (r->flags & BLIN_MASK)
    ssize_t lsm;
    int     ex = EX_OK;

    ifBLIN_QX4("+");
    if  (!(ls->ibin = mife_get(r->iffed, 0))) {
        ifBLIN_QW0("Program error");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (r->flags & Bpars_AABS) ls->ibin->flags |= Bpars_AABS;
    ifBLIN_QX4( "c%"BLIN_D" %"BLIN_X" %"BLIN_X" %"BLIN_D" c%"BLIN_U" %u %"BLIN_D" %"BLIN_D
              , r->ccl
              , BLIN_I(&ls->ibin->v)
              , BLIN_I(ls->ibin)
              , (char*)&(ls->ibin->v) - (char*)(ls->ibin)
              , sizeof(u_char)
              , ls->ibin->count
              , sizeof(u_int32_t)
              , sizeof(u_char) * ls->ibin->count + sizeof(u_int32_t)
              );
    if  (0 > (lsm = r->ccl - ((char*)&(ls->ibin->v) - (char*)(ls->ibin)))) {
        ifBLIN_QX0("Size computing error");
        ex = EX_SOFTWARE;
        errno = EDOM;
        goto out;
    }
    ls->m = (size_t)lsm;
    ls->m -= (sizeof(u_int32_t) + sizeof(u_char)) * ls->ibin->count;
    if  (ls->m < 1) {
        ifBLIN_QX0("invalid length for tree");
        ex = EX_USAGE;
        errno = EDOOFUS;
        goto out;
    }
    ifBLIN_QX4( "i%"BLIN_U" w%"BLIN_U" c%"BLIN_U" m%"BLIN_U" %"BLIN_U" %"BLIN_U" %"BLIN_U
              , sizeof(treei)
              , sizeof(treew)
              , sizeof(u_char)
              , ls->m
              , sizeof(treei) * ls->m + 1
              , sizeof(treew) * ls->m + 1
              , sizeof(u_char) * ls->m + 1
              );
    if  ((tree->trees = malloc(sizeof(treei) * ls->m + 1))) {
        if  ((tree->treed = malloc(sizeof(treei) * ls->m + 1))) {
            if  ((tree->treew = malloc(sizeof(treew) * ls->m + 1))) {
                if  ((tree->treev = malloc(sizeof(u_char) * ls->m + 1))) {
                    tree->treem = (treei)ls->m;
                    tree->treep = 0;
                    tree->trees[0] = ~0;
                    tree->treed[0] = ~0;
                    tree->treew[0] = 0;
                    tree->treev[0] = 0;
                    ex = EX_OK;
                } else {
                    ex = EX_TEMPFAIL;
                    free(tree->treev);
                }
            } else {
                ex = EX_TEMPFAIL;
            }
            if  (ex) free(tree->treew);
        } else {
            ex = EX_TEMPFAIL;
        }
        if  (ex) free(tree->trees);
    } else {
        ex = EX_TEMPFAIL;
    }
    if  (!!ex) {
        ifBLIN_QW0("no memory for tree");
        goto out;
    }
/*  ifBLIN_QO0 mife_writ(1, ls->ibin, r->ccl);*/
    ls->fbin = (u_char*)(&(ls->ibin->v[ls->ibin->count]));
    ls->cbin = &(ls->fbin[ls->ibin->count]);
    ex = buildtree(tree, ls);
    if  (!ex && !TRIS(TREE(d, 0))) {
        ifBLIN_QW0("Short tree");
        ex = EX_NOINPUT;
    }
    if  (!!ex) {
        if  (tree->treev) free(tree->treev);
        if  (tree->treew) free(tree->treew);
        if  (tree->trees) free(tree->trees);
        if  (tree->treed) free(tree->treed);
    }
out:
    ifBLIN_QX4("- %d", ex);
    return(ex);
# undef blin_internal_flags
}   /* run3 */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                  **
 *****************************************************************************************************
 *****************************************************************************************************/

static u_int32_t pow[] =
{0U
, 9U
, 99U
, 999U
, 9999U
, 99999U
, 999999U
, 9999999U
, 99999999U
, 999999999U
, 4294967295U
, 0
};

static void
pb(FILE *o, u_int32_t l, u_int32_t i) {
    for (; l && pow[l] && pow[l] >= i; --l) fprintf(o, " ");
}

static void
ptl(treei i, u_int32_t l) {
    if  (l == 0) l = 6;
    if  (i < 0) {
        fprintf(stderr, "~%d", (int)~i);
        pb(stderr, l, (u_int32_t)~i);
    } else if (i > 0) {
        fprintf(stderr, "=%d", (int)i);
        pb(stderr, l, (u_int32_t)i);
    } else {
        fprintf(stderr, "==");
        for (; l; --l) fprintf(stderr, " ");
}   }

static void
dump_tree(tree *tree, u_int32_t l) {
    treei i;

    fprintf(stderr, "     v    d       s           w\n");
    for (i = 0; i <= tree->treep; ++i) {
        if  (i > tree->treem) {
            fprintf(stderr, "Truncated tree\n");
            break;
        }
        fprintf( stderr, "[%2d]%c(%02X)"
               , (int)i
               , (TREE(v, i) >= ' ' && TREE(v, i) < 0177) ? TREE(v, i) : ' '
               , TREE(v, i)
               );
        ptl(TREE(d, i), l);
        ptl(TREE(s, i), l);
        fprintf(stderr, "%6d\n", (int)TREE(w, i));
}   }

static void
finedump_tree(tree *tree, u_int32_t l, treei j, int t) {
    u_int32_t ll;
    treei     i;
    int       f;

    for (i = j, f = t;; ++f) {
        if  (TRIS(TREE(d, i))) finedump_tree(tree, l, TREE(d, i), f);
        i = TREE(s, i);
        if  (!TRIS(i)) break;
    }
    for (f = 0; f < t; ++f) {
        fprintf(stderr, "             ");
        for (ll = l + 2; ll; --ll) fprintf(stderr, " ");
    }
    for(i = j;;) {
        if  (i > tree->treem) {
            fprintf(stderr, "Trunc\n");
            break;
        }
        fprintf( stderr, "%3d[%2d]%c(%02X)"
               , (int)TREE(w, i), (int)i
               , (TREE(v, i) >= ' ' && TREE(v, i) < 0177) ? TREE(v, i) : ' '
               , TREE(v, i)
               );
        if  (!TRIS(TREE(d, i))) ptl(TREE(d, i), l);
          else for (ll = l + 2; ll; --ll) fprintf(stderr, " ");
        i = TREE(s, i);
        if  (!TRIS(i)) {
            ptl(i, l);
            fprintf(stderr, "\n");
            break;
        } else {
            fprintf(stderr, " ");
}   }   }

static void
wghttree(tree *tree) {
    treei i, j;

    i = tree->treep;
    if  (i > tree->treem) i = tree->treem;
    while (!(TREE(w, 0))) {
        for (j = i;; --j) {
            if  (!TRIS(TREE(d, j)) && !TRIS(TREE(s, j))) {
                TREE(w, j) = 2;
            } else if (!TRIS(TREE(s, j))) {
                if  (TREE(w, TREE(d, j))) TREE(w, j) = 2 + TREE(w, TREE(d, j));
            } else if (!TRIS(TREE(d, j))) {
                if  (TREE(w, TREE(s, j))) TREE(w, j) = 1 + TREE(w, TREE(s, j));
            } else if ((TREE(w, TREE(d, j))) && (TREE(w, TREE(s, j)))) {
                TREE(w, j) = 1 + TREE(w, TREE(d, j)) + TREE(w, TREE(s, j));
            }
            if  (!TRIS(j)) break;
}   }   }

static void
sortree(tree *tree, treei n) {
    treei *i;
    treei  j;
    int    f;

    do {
        f = 0;
        for (i = &TREE(d, n); TRIS(*i); i = &TREE(s, *i)) {
            if  (  TRIS(TREE(s, *i))
                &&   (TRIS(TREE(d, TREE(s, *i))) ? TREE(w, TREE(d, TREE(s, *i))) : 0)
                   < (TRIS(TREE(d, *i)) ? TREE(w, TREE(d, *i)) : 0)
                ) {
                treei t;
#if 0
                /*           . *
                 *        ...                             */
                if  ((TREE(w, TREE(s, *i)) > TREE(w, *i))) TREE(w, *i) = TREE(w, TREE(s, *i));
                /* ...      ,                                              *
                 *      .                         */
#endif
                t = *i;
                *i = TREE(s, t);
                TREE(s, t) = TREE(s, *i);
                TREE(s, *i) = t;
                ++f;
        }   }
    } while (f);
    for (j = TREE(d, n); TRIS(j); j = TREE(s, j)) {
        sortree(tree, j);
}   }

static treei
addrfy(tree *tree, treei n, treei j) {
    treei i;

    ++n;
    for (i = j; TRIS(i); i = TREE(s, i)) TREE(w, i) = ++n;
    for (i = j; TRIS(i); i = TREE(s, i)) if (TRIS(TREE(d, i))) n = addrfy(tree, n, TREE(d, i));
    return(n);
}

static treew
tdelta(tree *tree, treei j) {
    treew w;
    treew u;
    treei i;

    for (i = j, w = 0; TRIS(i); i = TREE(s, i)) {
        if  (TRIS(TREE(d, i))) {
            u = tdelta(tree, TREE(d, i));
            if  (w < u) w = u;
            u = TREE(w, TREE(d, i)) - TREE(w, i) - 2;
            if  (w < u) w = u;
    }   }
    return(w);
}

static int
/*****************************************************************************************************/
run4(runparm *r, ccbin *ls, tree *tree) {                                                        /****
 *****************************************************************************************************
 *                                                                                 *
 *****************************************************************************************************/
# define blin_internal_flags (r->flags & BLIN_MASK)
    u_int64_t z[] = {0x1ULL, 0x100ULL, 0x10000ULL, 0x1000000ULL, 0x100000000ULL};
    int       ex = EX_OK;
    size_t    n;

    ifBLIN_QX4("+");
    wghttree(tree);
    sortree(tree, 0);
    ifBLIN_QO3 dump_tree(tree, 0);
    bzero(tree->treew, (size_t)(tree->treep + 1) * sizeof(treew));
    wghttree(tree);
    ls->maxl = TREE(w, TREE(d, 0));
    ls->maxw = 0;
    for (n = 0; n < ls->ibin->count; ++n) if (ls->maxw < ls->ibin->v[n]) ls->maxw = ls->ibin->v[n];
    bzero(tree->treew, (size_t)(tree->treep + 1) * sizeof(treew));
    addrfy(tree, 0, TREE(d, 0));
    if  (ls->ibin->flags & Bpars_AABS) {
        ls->t = ls->maxl;
    } else {
        ls->t = tdelta(tree, TREE(d, 0));
    }
    for (  ls->ll = 1
        ;  pow[ls->ll]
        && pow[ls->ll] <= ( (0 > ls->maxl)
                          ? ls->maxw
                          : ls->maxw > (size_t)ls->maxl ? ls->maxw : (size_t)ls->maxl
                          )
        ;  ++(ls->ll)
        );
    --(ls->ll);
    ifBLIN_QO2 finedump_tree(tree, ls->ll, 0, 0);
    for (ls->p = 0; ls->p < 5; ++(ls->p))
        if (z[ls->p] >= ((u_int64_t)ls->maxw + (u_int64_t)ls->t)) break;
    if  (ls->p > 4) {
        ifBLIN_QX0("More then 4 bytes needed: %llu", (long long)(ls->maxw + (size_t)ls->t));
        errno = E2BIG;
        ex = EX_SOFTWARE;
    }
    ifBLIN_QX1("MAXW=%d MAXT=%d MAXINDX=%d SIZE=%d\n", (int)ls->maxw, (int)ls->t, (int)ls->maxl, ls->p);
    fprintf(ls->o, ",%d,%d,%d\n", (int)ls->maxl, (int)ls->t, ls->p);
    ifBLIN_QX4("- %d", ex);
    return(ex);
# undef blin_internal_flags
}   /* run4 */

/*****************************************************************************************************
 *   run4                                                                            *
 *****************************************************************************************************/

static void
addrout(FILE *o, u_int32_t l, u_int32_t i) {
    while (l > 0) {
        fprintf(o, ",0x%02X", i & 0xFF);
        i >>= 8;
        --l;
}   }

static ssize_t
/*****************************************************************************************************/
run4out(runparm *r, ccbin *ls, tree *tree, treei j, ssize_t p) {                                 /****
 *****************************************************************************************************
 *                                                                       *
 *****************************************************************************************************/
    int    f = 1;
    size_t n ;
    treei  i ;

    if  (!j) {
        fprintf(ls->o, ",{");
        j = TREE(d, j);
    } else if (!TRIS(j)) {
        return(p);
    } else {
        fprintf(ls->o, " ,");
        f = 0;
    }
    fprintf(ls->o, "/*%05X*/", (u_int)++p);
    for (n = 0, i = j; TRIS(i); i = TREE(s, i), ++n);
    if  (!n) {
        ifBLIN_QX0("Empty side");
        p = -1;
    } else {
        pb(ls->o, ls->ll, (u_int32_t)(n - 1));
        fprintf(ls->o, "%u", (u_int)n - 1);
        for (i = j; TRIS(i); i = TREE(s, i)) {
            const u_char tf[256] =
            { 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
            , 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
            , 1, 1, 2, 1,  1, 1, 1, 2,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1

            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  2, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 0

            , 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
            , 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
            , 0, 0, 0, 1,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
            , 0, 0, 0, 1,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0

            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            , 1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1,  1, 1, 1, 1
            };
            const char *rf[] = {", %04o", ",  \'%c\'", ", \'\\%c\'"};

            fprintf(ls->o, rf[tf[TREE(v, i)]], TREE(v, i));
            ++p;
            if  (TRIS(TREE(d, i))) {
                treew  w;

                w = TREE(w, TREE(d, i)) - 2;
                if  (ls->ibin->flags & Bpars_AABS) {
                    addrout(ls->o, (u_int32_t)ls->p, (u_int32_t)w);
                } else if (w < TREE(w, i)) {
                    ifBLIN_QX0("Loop without Bpars_AABS");
                    p = -1;
                    break;
                } else {
                    addrout(ls->o, (u_int32_t)ls->p, (u_int32_t)(w - TREE(w, i)));
                }
            } else {
                addrout(ls->o, (u_int32_t)ls->p, (u_int32_t)TREE(d, i));
        }   }
        if  (p > 0) {
            fprintf(ls->o, " ");
            addrout(ls->o, (u_int32_t)ls->p, (u_int32_t)i);
            fprintf(ls->o, "\n");
            for (i = j; p > 0 && TRIS(i); i = TREE(s, i)) p = run4out(r, ls, tree, TREE(d, i), p);
            if  (p > 0 && f) fprintf(ls->o, "}};\n");
    }   }
    return(p);
}

int
/*****************************************************************************************************
 *****************************************************************************************************/
main(int argc, char **argv) {                                                                    /****
 *****************************************************************************************************
 *****************************************************************************************************/
    tree        tree;
    char       *nam1 = NULL;
    const char *tdir;
    int         ex   = EX_OK;
    ccbin      *ls   = NULL;
    run12parm  *r2   = NULL;
    runparm    *r    = NULL;
    ssize_t     p;

    if  (!(r = calloc(1, sizeof(runparm)))) {
        ifBLIN_QX0("alloc runparm r");
        ex = EX_OSERR;
        goto out;
    }
    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, (r->flags = BLIN_BIT0));
    if  (!(r2 = calloc(1, sizeof(run12parm)))) {
        ifBLIN_QX0("alloc run12parm r2");
        ex = EX_OSERR;
        goto out;
    }
    if  (!(ls = calloc(1, sizeof(ccbin)))) {
        ifBLIN_QX0("alloc ccbinb ls");
        ex = EX_OSERR;
        goto out;
    }
    /*********************************************************************
     *              TMPDIR       2                       *
     * (1)    > (2) cc  | (3)   *
     *********************************************************************/
    if  (!!(ex = argrun(r, r2, argc, argv))) {
        ifBLIN_QW0("argrun");
        goto out;
    }
    if  (!r->oufn) {
        ifBLIN_QX0("No out file");
        ex = EX_USAGE;
        goto out;
    }
    /****** 1  ******/
    if  ((ex = run1(r, r2))) {
        ifBLIN_QW0("run1");
        goto out;
    }
    tdir = getenv("TMPDIR");
    if  (!tdir || !*tdir) tdir = "/tmp";
    if  (asprintf(&nam1, "%s/lexorXXXXXX.c", tdir) < 0) {
        ifBLIN_QW0("asprintf #1");
        ex = EX_OSERR;
        goto out;
    }
    if  ((r2->fil1 = mkstemps(nam1, 2)) < 0) {
        ifBLIN_QW0("mkstemps #1");
        ex = EX_OSERR;
        goto out;
    }
    if  (!r2->imd->top.index) {
        ifBLIN_QX0(" ");
        ex = EX_DATAERR;
        goto out;
    }
    if  ((ex = intrfil1(r, r2))) {
        ifBLIN_QX0("intrfil1");
        goto out;
    }
    /*      */
    if  (!(ls->o = fopen(r->oufn, "w"))) {
        ifBLIN_QW0("fopen");
        ex = EX_IOERR;
        goto out;
    }
    if  (r2->incopy) fprintf(ls->o, "#line %u \"%s\"\n%s", (u_int)r2->lncopy, r2->infn, r2->incopy);
    if  (r2->intype) fprintf(ls->o, "#line %u \"%s\"\n%s ", (u_int)r2->lntype, r2->infn, r2->intype);
    fprintf(ls->o, "babolo_lexor %s = {\n", r2->inname);
    fprintf( ls->o, "#line %u \"%s\"\n(const u_char *)\n%s\n"
           , (u_int)r2->lntrans
           , r2->infn
           , r2->intrans ? r2->intrans : "NULL"
           );
/*  fprintf(ls->o, "#line\n"); XXXX */
    if  (r->flags & Bpars_AABS) {
        fprintf(ls->o, ", NULL, (%s)|Bpars_AABS", r2->inflag ? r2->inflag : "0");
    } else {
        fprintf(ls->o, ", NULL, %s", r2->inflag ? r2->inflag : "0");
    }
    if  (!!r->iffed) {
        mife_fini(r->iffed);
        r->iffed = NULL;
    }
    /****** 2  ******/
    r2->ccarg[r2->ccarp++] = nam1;
    r2->ccarg[r2->ccarp] = NULL;
    ifBLIN_QX1("%d=%s~\n", (int)r2->ccarp - 1, r2->ccarg[r2->ccarp - 1]);
    ex = run2cc(r, r2);
    free(r2->ccname);
    free(r2->ccarg);
    free(r2);
    r2 = NULL;
    if  (ex) {
        ifBLIN_QW0("run2cc");
        goto out;
    }
    /****** 3  ******/
    if  ((ex = run3(r, ls, &tree))) {
        ifBLIN_QW0("run3");
        goto out;
    }
    /****** 4  ******/
    if  ((ex = run4(r, ls, &tree))) {
        ifBLIN_QW0("run4");
        goto out;
    }
    p = run4out(r, ls, &tree, 0, 0);
    if  (tree.treev) free(tree.treev);
    if  (tree.treew) free(tree.treew);
    if  (tree.trees) free(tree.trees);
    if  (tree.treed) free(tree.treed);
    if  (p < 0) {
        ifBLIN_QW0("run4out");
        ex = EX_DATAERR;
        goto out;
    } else if (p != ls->maxl) {
        ifBLIN_QX0("Size mismatch: %zd <> %zd", p, ls->maxl);
        ex = EX_SOFTWARE;
        goto out;
    }
out:
    if  (!ex && !!(ex = fclose(ls->o))) ifBLIN_QW0("fclose");
    ls->o = NULL;
    if  (!!ls) {
        if  (!!ls->o) {
            fpurge(ls->o);
            fclose(ls->o);
        }
        free(ls);
        ls = NULL;
    }
    if  (!!r2) {
        free(r2);
        r2 = NULL;
    }
    if  (!!r) {
        if  (!!ex && !!r->oufn) unlink(r->oufn);
        if  (!!r->iffed) {
            mife_fini(r->iffed);
        }
        if  (!(r->flags & BLIN_BIT4) && !!nam1) {
            unlink(nam1);
            free(nam1);
        }
        free(r);
        r = NULL;
    }
    exit(ex);
}
