/*-
 * Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2014..2024 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: base.c,v 1.7 2024/01/14 18:18:05 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include "parser.h"

static int
nibble(char c) {
    int e;

    if  (c >= '0' && c <= '9') e = c - '0';
    else if (c >= 'A' && c <= 'F') e = c - 'A' + 10;
    else if (c >= 'a' && c <= 'f') e = c - 'a' + 10;
    else if (c <= ' ') e = -1;
    else e = -2;
    return(e);
}

#define EROUT(E) do{ free(octets); octets = NULL; errno = (E); goto out; } while (0)

u_char *
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_hextrin(const char *o, ssize_t *len) {                                                    /****
 *****************************************************************************************************
 *****************************************************************************************************/
    u_char  *octets = NULL;
    ssize_t  i      ;
    size_t   l      ;
    int      s      ;

    l = strlen(o);
    s = (0 < *len) ? 1 : -1;
    l = (l + 1) / 2;
    if  (!(octets = malloc(l + ((0 < s) ? (size_t)*len : 0)))) {
        ifBLIN_QX0("No mem %"BLIN_U, l + ((0 < s) ? (size_t)*len : 0));
        errno = ENOMEM;
        goto out;
    }
    for (*len = 0, i = 0; !!o[i];) {
        int e;

        if  ((size_t)*len >= l) {
            ifBLIN_QX0("Software error %"BLIN_D" >= %"BLIN_D, BLIN_I(*len), BLIN_I(l));
            EROUT(EDOOFUS);
        }
        do { e = nibble(o[i]); } while ((0 < s) && (-1 == e) && (!!o[++i]));
        if  ((0 > e) && !!o[i]) {
            ifBLIN_QX0("Illegal input %c at %"BLIN_D, o[i], BLIN_I(i));
            EROUT(EINVAL);
        }
        octets[*len] = (u_char)(e << 4);
        if  (!o[i]) {
            octets[++(*len)] = '\0';
            goto out;
        }
        ++i;
        do { e = nibble(o[i]); } while ((0 < s) && (-1 == e) && (!!o[++i]));
        if  ((0 > e) && !!o[i]) {
            ifBLIN_QX0("Illegal input %02X='%c' at %"BLIN_D, o[i] & 0xFF, o[i], BLIN_I(i));
            EROUT(EINVAL);
        }
        octets[(*len)++] |= e;
        if  (!o[i]) {
            octets[*len] = '\0';
            goto out;
        }
        ++i;
        octets[*len] = '\0';
    }
out:
    return(octets);
}
