/*-
 * Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: optn.c,v 1.6 2024/01/07 23:27:18 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include "../parser.h"

int
main(int argc, char **argv) {
#   define blin_internal_flags (flags & BLIN_MASK)
    BLIN_flag     flags = Bpars_NONU;
    babolo_opts  *bos   ;
    const char   *ss    ;
    int           r     = 0;
    unsigned long x     ;
    int           c     ;
    int           i     ;
    char         *s     ;

    if  (!!(s = getenv("INIT_FLAGS"))) {
        flags = (BLIN_flag)strtoul(s, NULL, 0) | Bpars_NONU;
    }
    if  (!!(s = getenv("INIT_RECUR"))) {
        r = *s;
    }
    if  (!(bos = babolo_openopts(flags, (char)r))) {
        ifBLIN_QW0("openopts");
        exit(EX_SOFTWARE);
    }
    if  (!!babolo_setopts(bos, flags, argc, argv, "a:b:f:vD")) {
        ifBLIN_QW0("setopts");
        exit(EX_SOFTWARE);
    }
    ifBLIN_QO7 babolo_dumpopts(bos);
    for (i = 0;; ++i) {
        switch ((c = babolo_getopts(bos))) {
        case 0:                                     break;
        case -1: printf("ERR %d\n", errno);         break;
        case 'v':
            BLIN_VERBOSE(flags);
            bos->flags |= flags & BLIN_MASK;
            break;
        case 'f':
            x = babolo_getoptunum(bos, 0);
            printf(" %c=%lu\n", c, x);
            break;
        default:
            ss = babolo_getoptsarg(bos);
            if  (ss) {
                printf(" %c=%s~\n", c, ss);
            } else {
                printf(" %c NULL\n", c);
        }   }
        if  (c == 0) break;
    }
    for (i = 0; (ss = babolo_getargs(bos)); ++i) {
        printf("%d=%s~\n", i, ss);
    }
    ifBLIN_QO7 babolo_dumpopts(bos);
    babolo_closeopts(bos);
    exit(0);
#   undef blin_internal_flags
}
