/*-
 * Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2008..2024 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: opt.c,v 1.15 2024/01/07 23:27:18 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT 2

#include <sys/types.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <babolo/BLINflag.h>
#include "../parser.h"

int
main(int argc, char **argv) {
    BLIN_flag flags = Bpars_NONU | Bpars_ESYM | Bpars_EPRM | Bpars_CMPT;
#   define blin_internal_flags (flags & BLIN_MASK)
    babolo_opt *opt;
    babolo_parm *bp;
    const char *ss;
    int c, i;
    char *s;

    opt = NULL;
    if  (!!(s = getenv("INIT_FLAGS"))) {
        flags = (BLIN_flag)strtoul(s, NULL, 0);
    }
    if  (!!babolo_openopt(flags, &opt, argc, argv, "a:b:f:vDR:")) {
        ifBLIN_QW0("openopt");
        exit(EX_SOFTWARE);
    }
    ifBLIN_QO7 babolo_dumpopt(opt);
    for (i = 0;; ++i) {
        switch ((c = babolo_getopt(&opt))) {
        case 0:                                     break;
        case -1: printf("ERR %d\n", errno);         break;
        case 'v':
            BLIN_VERBOSE(flags);
            opt->flags |= flags & BLIN_MASK;
            break;
        case 'R':
            ss = babolo_getoptarg(&opt, 0);
            if  (!!ss) {
                s = strdup(ss);
                bp = babolo_getparm(flags & Bpars_NOEN, (u_char **)&s, (const u_char *)"", 0);
                babolo_openopt(flags & ~(BLIN_flag)Bpars_NONU, &opt, bp->argc, bp->argv, NULL);
                ifBLIN_QO7 babolo_dumpopt(opt);
                break;
            }
        case 'f':
            ss = babolo_getoptarg(&opt, 0);
            if  (!!ss) flags = (BLIN_flag)strtoul(ss, NULL, 0) | (flags & BLIN_MASK);
        default:
            if  (babolo_getoptarg(&opt, 0)) printf(" %c=%s~\n", c, babolo_getoptarg(&opt, 0));
              else printf(" %c NULL\n", c);
        }
        if  (c == 0) break;
    }
    for (i = 0; (ss = babolo_getarg(&opt)); ++i) {
        printf("%d=%s~\n", i, ss);
    }
    ifBLIN_QO7 babolo_dumpopt(opt);
    babolo_closeopt(&opt);
    exit(0);
#   undef blin_internal_flags
}
