/*-
 * Copyright (C)2003..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2003..2024 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: getparm.c,v 1.39 2024/01/07 23:27:18 babolo Exp $\n"

#define BLIN_COMPAT  4
#define Bpars_COMPAT VMAJOR

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sysexits.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "parser.h"

#define Ca 0x00800000 /*              */
#define Cr 0x00400000 /*                       */
#define Ct 0x00200000 /*        */
#define Cw 0x00100000 /*    ()     */
#define Cz 0x00080000 /*                   */
#define Cp 0x00020000 /*   ()          */
#define Cq 0x00010000 /*   ()           */
#define Cv 0x00008000 /*    ()    */
#define Cc 0x00004000 /*         */
#define Cn 0x00002000 /*             */
#define Cy 0x00001000 /*                          */
#define Cm 0x00000400 /*                             */
#define Cl 0x00000200 /*      */
#define Ce 0x00000800 /*                                */
#define Cx 0x00000100 /*                                 */
#define C_state  0xFF /*                    */

static const char pn[][3] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "a ", "r ", "t ", "w ", "z ", "- ", "p ", "q "
, "v ", "c ", "n ", "y ", "m ", "l ", "e ", "x "
};
extern u_char **environ;

enum states
{ db  /*                                */
, df  /*                  */
, di  /*                              */
, da  /*                     */
, dc  /*      */
, dp  /*        */
, s0  /*  \                                    */
, d0  /*  \                    */
, ds  /*                      */
, dd  /*                        */
, s1  /*  \  2                        */
, d1  /*  \     2     */
, s2  /*  \  1                        */
, d2  /*  \     1     */
, v0  /*                          */
, v2  /* ?                         */
, v3  /*                           */
, v4  /*                 */
, v6  /* ?                */
, v7  /*                  */
, v5  /*                */
, v1  /*                         */
, sc  /* Skip comment                               */
, dx  /*                                  */
};
enum classes {sy, sp, dl, aq, sq, dq, no, lt, bs, bo, bc, el, nl, xx};
static const char statenames[][3] =
{ "db", "df", "di", "da", "dc", "dp", "s0", "d0", "ds", "dd", "s1", "d1", "s2", "d2"
, "v0", "v2", "v3", "v4", "v6", "v7", "v5", "v1", "sc", "dx"
};
static const char *clasnames[] =
{ "sy", "sp", "dl", "aq", "sq", "dq", "no", "lt", "bs", "bo", "bc", "el", "nl", "xx"
};
/****************************************************************
 * recode    , 
 *   \x,  x -     .
 *        1 .
 *      2 ,  
 *       
 *  ( Bpars_NOEN ).
 */
static const u_char recode[256][2] =
{"\000","\001","\002","\003" ,"\004","\005","\006","\007"
,"\010","\011","\000","\013" ,"\014","\015","\016","\017"
,"\020","\021","\022","\023" ,"\024","\025","\026","\027"
,"\030","\031","\032","\033" ,"\034","\035","\036","\037"
,"\040","\041","\042","\043" ,"\044","\045","\046","\047"
,"\050","\051","\052","\053" ,"\054","\055","\056","\057"
,"\060","\061","\062","\063" ,"\064","\065","\066","\067"
,"\070","\071","\072","\073" ,"\074","\075","\076","\077"

,"\100","\101","\102","\103" ,"\104","\105","\106","\107"
,"\110","\111","\112","\113" ,"\114","\115","\116","\117"
,"\120","\121","\122","\123" ,"\124","\125","\126","\127"
,"\130","\131","\132","\133" ,"\134","\135","\136","\137"
,"\140","\007","\010","\143" ,"\144","\145","\014","\147"
,"\150","\151","\152","\153" ,"\154","\155","\012","\157"
,"\160","\161","\015","\163" ,"\011","\165","\013","\167"
,"\170","\171","\172","\173" ,"\174","\175","\176","\177"

,"\200","\201","\202","\203" ,"\204","\205","\206","\207"
,"\210","\211","\212","\213" ,"\214","\215","\216","\217"
,"\220","\221","\222","\223" ,"\224","\225","\226","\227"
,"\230","\231","\232","\233" ,"\234","\235","\236","\237"
,"\240","\241","\242","\243" ,"\244","\245","\246","\247"
,"\250","\251","\252","\253" ,"\254","\255","\256","\257"
,"\260","\261","\262","\263" ,"\264","\265","\266","\267"
,"\270","\271","\272","\273" ,"\274","\275","\276","\277"

,"\300","\301","\302","\303" ,"\304","\305","\306","\307"
,"\310","\311","\312","\313" ,"\314","\315","\316","\317"
,"\320","\321","\322","\323" ,"\324","\325","\326","\327"
,"\330","\331","\332","\333" ,"\334","\335","\336","\337"
,"\340","\341","\342","\343" ,"\344","\345","\346","\347"
,"\350","\351","\352","\353" ,"\354","\355","\356","\357"
,"\360","\361","\362","\363" ,"\364","\365","\366","\367"
,"\370","\371","\372","\373" ,"\374","\375","\376","\377"
};
/****************************************************************
 *     
 */
#define LN(L) (Bpars_##L##LN >> Bpars_LNSH)
static const u_char eolns[256] =
{  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, LN(LF), LN(VT),  0, LN(CR), 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0

,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0

,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0

,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0
};
/****************************************************************
 *    class - 2 
 * 0x2 -    $  ${}
 * 0x1 -    ,
 *         -  
 */
static const enum classes class[4][256] =
{{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sp,sp,sp ,sy,sp,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sp,sy,dq,sy ,dl,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,bo ,sy,bc,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,dq,sy ,dl,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,bo ,sy,bc,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sp,sp,sp ,sy,sp,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sp,sy,dq,sy ,sy,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,dq,sy ,sy,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
}};

static const u_int32_t automa[dx][xx] =
/*         .           b        $              '        "           9           A           \           {           }                 \n    \0  */
/*         sy,         sp,      dl,   aq,      sq,      dq,         no,         lt,         bs,         bo,         bc,               el,   nl  */
{{Cz|Cp|Cn|di,Cz      |db,Cz|Cp|v0,Cp|da,Cz|Cp|ds,Cz|Cp|dd,Cz|Cp|Cn|di,Cz|Cp|Cn|di,   Cp|Cc|s0,Cz|Cp|Cn|di,Cz|Cp|Cn|di,Cz|Cq|Cy   |Cx|dx,Cq|dx}/*db*/
,{Cz|Cp|Cn|di,Cz|Cp|Cq|db,Cz|Cp|v0,Cp|da,Cz|Cp|ds,Cz|Cp|dd,Cz|Cp|Cn|di,Cz|Cp|Cn|di,   Cp|Cc|s0,Cz   |Ce|dx,Cz|Cp|Cn|di,Cz|Cq|Cy   |Cx|dx,Cq|dx}/*df*/
,{Cz   |Cn|di,Cz   |Cq|db,Cz   |v0,   da,Cz   |ds,Cz   |dd,Cz   |Cn|di,Cz   |Cn|di,Cz   |Cc|s0,Cz   |Cn|di,Cz   |Cn|di,Cz|Cq|Cy   |Cx|dx,Cq|dx}/*di*/
,{      Cn|da,      Cn|da,   Cn|da,   di,   Cn|da,   Cn|da,      Cn|da,      Cn|da,      Cn|da,      Cn|da,      Cn|da,      Cy   |Cn|da,Ce|dx}/*da*/
,{      Cn|dc,      Cn|dc,   Cn|dc,   ds,   Cn|dc,   Cn|dc,      Cn|dc,      Cn|dc,      Cn|dc,      Cn|dc,      Cn|dc,      Cy   |Cn|dc,Ce|dx}/*dc*/
,{      Cn|dp,      Cn|dp,   Cn|dp,   dd,   Cn|dp,   Cn|dp,      Cn|dp,      Cn|dp,      Cn|dp,      Cn|dp,      Cn|dp,      Cy   |Cn|dp,Ce|dx}/*dp*/
,{      Ct|di,      Ct|di,   Ct|di,Ce|dx,   Ct|di,   Ct|di,   Ca   |s1,      Ct|di,      Ct|di,      Ct|di,      Ct|di,      Cy|Ct   |di,Ce|dx}/*s0*/
,{      Ct|dd,      Ct|dd,   Ct|dd,Ce|dx,   Ct|dd,   Ct|dd,   Ca   |d1,      Ct|dd,      Ct|dd,      Ct|di,      Ct|dd,      Cy|Ct   |dd,Ce|dx}/*d0*/
,{      Cn|ds,      Cn|ds,   Cn|ds,   dc,      di,   Cn|ds,      Cn|ds,      Cn|ds,      Cn|ds,      Cn|ds,      Cn|ds,      Cy|Cn   |ds,Ce|dx}/*ds*/
,{      Cn|dd,      Cn|dd,      v4,   dp,   Cn|dd,      di,      Cn|dd,      Cn|dd,      Cc|d0,      Cn|dd,      Cn|dd,      Cy|Cn   |dd,Ce|dx}/*dd*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca   |s2,Ce      |dx,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*s1*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca   |d2,Ce      |dx,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*d1*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca|Cr|di,Ce      |dx,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*s2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca|Cr|dd,Ce      |dx,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*d2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v1,   Cv   |v1,Ce      |dx,         v2,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*v0*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v3,   Cv   |v3,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*v2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,         v3,         v3,Ce      |dx,Ce      |dx,Cw      |di,Ce   |Cy      |dx,Ce|dx}/*v3*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v5,   Cv   |v5,Ce      |dx,         v6,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*v4*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v7,   Cv   |v7,Ce      |dx,Ce      |dx,Ce      |dx,Ce   |Cy      |dx,Ce|dx}/*v6*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,         v7,         v7,Ce      |dx,Ce      |dx,Cw      |dd,Ce   |Cy      |dx,Ce|dx}/*v7*/
,{Cz|Cw|Cn|dd,   Cw|Cn|dd,   Cw|v4,Ce|dx,Cn|Cw|dd,   Cw|di,         v5,         v5,   Cw|Cc|d0,Ce      |dx,Ce      |dx,Cz|Cq|Cy|Cw|Cx|dx,Ce|dx}/*v5*/
,{Cz|Cw|Cn|di,Cz|Cw|Cq|db,Cz|Cw|v0,Ce|dx,Cz|Cw|ds,Cz|Cw|dd,         v1,         v1,Cz|Cw|Cc|s0,Ce      |dx,Ce      |dx,Cz|Cq|Cy   |Cx|dx,Ce|dx}/*v1*/
,{         sc,         sc,      sc,Ce|dx,      sc,      sc,         sc,         sc,         sc,         sc,         sc,      Cy   |Cx|dx,   dx}/*sc*/
};

typedef struct {
    BLIN_flag     flags;      /*                                     */
#if BLINAP > 4
    u_int32_t     dummy;
#endif
    u_char      **in;         /*                              */
    const char   *end;        /*   -           */
    size_t        argvmax;    /*   argv                    */
    size_t        parallo;    /*  babolo_parm.argv                  */
    u_int         parnmax;    /*      argv   */
    u_int         nidx;       /*   babolo_parm.argc             */
    int           test;       /*           */
    int           errn;       /*  errno                           */
    u_char        absq;       /*                         */
#if BLINAL2 > 1
    u_char        dummy0;
#endif
#if BLINAL4 > 2
    int16_t       dummy1;
#endif
#if BLINAL8 > 4
    int32_t       dummy2;
#endif
} getparm;

#define CHCL(A) ( (!!parm->absq && (*q == parm->absq))                                                \
                ? (u_int)aq                                                                           \
                :   (((u_int)eolns[*q] << Bpars_LNSH) & parm->flags & Bpars_XXLN)                     \
                  ? (u_int)el                                                                         \
                  : class[A][*q]                                                                      \
                )
#define ASSG(V, B) {   if  (parm->test) {                                                             \
                           ++(parm->argvmax);                                                         \
                       } else if (  !(parm->flags & Bpars_NOAL) && (p >= pm)                          \
                                 || (parm->flags & Bpars_NOAL) && (p > q)                             \
                                 ) {                                                                  \
                           control = Cl | dx;                                                         \
                           B;                                                                         \
                       } else {                                                                       \
                           *(p++) = (u_char)(V);                                                              \
                   }   }

static babolo_parm *
/*****************************************************************************************************/
i_getparm(getparm *parm) {                                                                       /****
 *****************************************************************************************************/
    u_int32_t     control = 0;
    u_int16_t     regsym  = 0;
    u_char       *regvar  = NULL;
    babolo_parm  *parsed  = NULL;
    int           ixvar;                                        /*    (0 .. 3) */
    enum states   state;
    blin_statectl sctl    = {{4, 0, 8, 24, '\0', 5, 1, 0, 0}};  /*  blin_stateheader()            */
    u_char       *pm      = NULL;
    u_char       *p       = NULL;
    u_char       *q;
    size_t        l;

#   define blin_internal_flags (parm->flags & BLIN_MASK)
    ifBLIN_QX3( "+ flags=%08X absq=%02X test=%u end=%s~"
              , parm->flags
              , parm->absq
              , parm->test
              , parm->end ? (const char *)(parm->end) : "NULL"
              );
    if  (!parm->in || !*(parm->in)) {
        ifBLIN_QX0("Params not defined");
        errno = EFAULT;
        goto out;
    }
    l = (((parm->flags & Bpars_NONU) ? 0 : 1) + parm->parallo) * sizeof(u_char*) + sizeof(babolo_parm);
    if  (!parm->test) {
        if  (!(parsed = calloc(1, l))) {
            ifBLIN_QW0("for parsed");
            errno = ENOMEM;
            goto out;
        }
        parsed->flags = parm->flags;
    }
    l = 0;
    if  (parm->end) l = strlen((const char*)(parm->end));
    parm->nidx = 0;
    q = *(parm->in);
    ifBLIN_QO4 blin_stateheader(sctl, pn);
    ixvar = (parm->flags & Bpars_NOEN) ? 2 : 0;
    for (state = (parm->flags & Bpars_FIXB) ? df : db; state < dx; ++q) {
        if  (!(parm->flags & Bpars_FIRM) && (parm->nidx >= parm->parnmax)) ixvar |= 1;
        control = automa[state][CHCL(ixvar)];
        ifBLIN_QO4 blin_statebody( sctl
                                 , pn
                                 , statenames
                                 , clasnames[(size_t)CHCL(ixvar)]
                                 , (char*)q
                                 , (size_t)(q - *(parm->in))
                                 , control
                                 , state
                                 , (u_int32_t)BLIN_I(p)
                                 , (u_char)regsym
                                 );
        if  (control & Ca) {
            regsym = (u_int16_t)(regsym << 3) + (*q - '0');
            if  (*q > '7') control |= Ce;
        }
        if  (control & Cr) {
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
            ASSG(regsym, ;);
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
        }
        if  (control & Ct) {
            const u_char *t = recode[*q];

            while (*t) {
                ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
                ASSG(*t, break);
                ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
                ++t;
        }   }
        if  (control & Cw) {
            int i, j;
            u_char *c, *d;

            for (i = 0; environ && environ[i]; ++i) {
                for ( c = environ[i], d = regvar, j = 1
                    ; (*c != '=') && !!*c && !!*d && (d < q) && (*c == *d)
                    ; ++c, ++d
                    );
                if  ((*c == '=') && (d == q)) {
                    ifBLIN_QX4("%s", environ[i]);
                    while (*++c) {
                        ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
                        ASSG(*c, break);
                        ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
                    }
                    break;
        }   }   }
        if  ((control & Cz) && !!l && !strncmp((char*)q, parm->end, l)) {
            /*   */
            q += (l - 1);
            control &= Cy;
            control |= Cq | sc;
            if  (!(parm->flags & Bpars_XXLN)) control |= Cx;
        }
        if  (control & Cp) {
            if  (parm->test) {
                ++(parm->nidx);
            } else if (parm->nidx >= parm->parallo) {
                control = Cl;
            } else {
                if  (parm->flags & Bpars_NOAL) {
                    p = q;
                } else if (parm->nidx == 0) {
                    if  (!!(p = malloc(sizeof(u_char) * parm->argvmax))) {
                        pm = p + parm->argvmax;
                        ifBLIN_QX6( "%"BLIN_X" + %"BLIN_X" = %"BLIN_X
                                  , BLIN_I(p)
                                  , parm->argvmax
                                  , BLIN_I(pm)
                                  );
                    } else {
                        control = Cm;
                }   }
                parsed->argv[parm->nidx++] = (char*)p;
        }   }
        if  (control & Cq && !!parm->nidx) {
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
            ASSG('\0', ;);
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
            if  ((parm->flags & Bpars_FIRM) && (parm->nidx >= parm->parnmax)) control |= Cx;
        }
        if  (control & Cv) regvar = q;
        if  (control & Cc) regsym = 0;
        if  (control & Cn) {
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
            ASSG(*q, ;);
            ifBLIN_QX6("%"BLIN_X, BLIN_I(p));
        }
        if  (control & Cy && parsed) ++(parsed->cntr);
        if  (control & Cm) parm->errn = errno = ENOMEM;
        if  (control & Cl) parm->errn = errno = E2BIG;
        if  (control & Ce) parm->errn = errno = EINVAL;
        if  (control & (Cm | Cl | Ce)) {
            if  (!!parsed) {
                if  (!(parm->flags & Bpars_NOAL) /* && !!parsed->argv */) free(*(parsed->argv));
                free(parsed);
            }
            parsed = NULL;
            ifBLIN_QW0("mission imossible");
            control |= Cx;
        }
        if  (control & Cx) {
            if  ((~parm->flags & Bpars_NONU) && parsed) parsed->argv[parm->nidx] = NULL;
            control = dx;
        }
        state = control & C_state;
    }
    ifBLIN_QX4("%08X %s", control, statenames[control & C_state]);
    *(parm->in) = q;
    if  (parsed) {
        parsed->argc = (int)parm->nidx;
        ifBLIN_QX3("- flags=%08X argc=%d", parm->flags, parsed->argc);
    } else {
        ifBLIN_QX3("- flags=%08X -", parm->flags);
    }
out:
    return(parsed);
#   undef blin_internal_flags
}

babolo_parm *
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_getparm(BLIN_flag flags, char **in, const char *end, char absq) {                         /****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (flags & BLIN_MASK)
    u_char      *iin = (u_char*)*in;
    babolo_parm *ret;
    getparm      parm;

    parm.flags = flags;
    parm.in = (u_char**)in;
    parm.end = end;
    parm.absq = (u_char)absq;
    parm.parallo = parm.parnmax = (flags & Bpars_NPRM) ? (flags & Bpars_NPRM) : 256;
    parm.errn = 0;
    if  (flags & Bpars_FAST) {
        parm.argvmax = ARG_MAX;
    } else {
        parm.test = 1;
        parm.argvmax = 0;
        i_getparm(&parm);
        *(parm.in) = iin;
        parm.parallo = parm.nidx;
    }
    parm.test = 0;
    ret = parm.errn ? NULL : i_getparm(&parm);
    if  (flags & Bpars_DUMP) babolo_dumparm(ret);
    return(ret);
#   undef blin_internal_flags
}

void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_freeparm(babolo_parm *parm) {                                                             /****
 *****************************************************************************************************
 *****************************************************************************************************/
    if  (parm) {
#       define blin_internal_flags (parm->flags & BLIN_MASK)
        ifBLIN_QX3( "+ flags=%08X argc=%d argv=%"BLIN_X
                  , parm->flags
                  , parm->argc
                  , BLIN_I(parm->argv)
                  )
        ;
        if  (  (!(parm->flags & Bpars_NOAL))
            && (parm->argc > 0)
            && *(parm->argv)
            ) free(*(parm->argv));
        ifBLIN_QX3("-");
#       undef blin_internal_flags
        free(parm);
}   }

static const char * const nm[] =
{  "BIT7", "BIT6", "BIT5", "BIT4",  "BIT3", "BIT2", "BIT1", "BIT0"
,  NULL  , NULL  , "NONU", "FIRM",  "NOAL", "NOEN", "FIXB", "FAST"
,  NULL  , NULL  , NULL  , NULL  ,  "DUMP", "LFLN", "CRLN", "VTLN"
};

void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_dumparm(babolo_parm *parsed) {                                                            /****
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (parsed->flags & BLIN_MASK)
    int i;

    printf("###########################################\n");
    printf("Parm @%" BLIN_X ":", BLIN_I(parsed));
    if  (parsed) {
        blin_64(parsed->flags, nm, -24, stdout);
        printf(" NPRM=%u\n", parsed->flags & Bpars_NPRM);
        printf( "  argc=%d, cntr=%" BLIN_U ", argv=%" BLIN_X "\n"
              , parsed->argc
              , parsed->cntr
              , BLIN_I(parsed->argv)
              );
        for (i = 0; i < parsed->argc; ++i) {
            printf( "  %" BLIN_X "[%d]=[%" BLIN_X "]%s~\n"
                  , BLIN_I(&(parsed->argv[i]))
                  , i
                  , BLIN_I(parsed->argv[i])
                  , parsed->argv[i]
                  );
        }
        if  (!(parsed->flags &Bpars_NONU)) {
            printf( "  %" BLIN_X "[%d]=[%" BLIN_X "]\n"
                  , BLIN_I(&(parsed->argv[i]))
                  , i
                  , BLIN_I( parsed->argv[i])
                  );
        }
    } else if (!errno) {
        printf("\n");
    } else {
        printf(" %s\n", strerror(errno));
    }
#   undef blin_internal_flags
}
