/*-
 * Copyright (C)2006..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2006..2024 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: getord.c,v 1.25 2024/01/07 23:29:19 babolo Exp $\n"

#define BLIN_COMPAT  4
#define MIFE_COMPAT  5
#define Bpars_COMPAT VMAJOR

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <errno.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "parser.h"

static u_int32_t ofm[] = {0x00000000, 0x000000FF, 0x0000FFFF, 0x00FFFFFF, 0xFFFFFFFF};

static u_int32_t
/*****************************************************************************************************
 *  lext    ,  1  3 ,    .             *
 * *lexind      lext.      ,  .   *
 *   *lexind    , return --  .               *
 *   >0,    ,     .                        *
 *****************************************************************************************************/
reconstruct(const babolo_lexor *lext, size_t *lexind) {                                          /****
 *****************************************************************************************************/
# define blin_internal_flags (lext->flags & BLIN_MASK)
    u_int32_t i;
    u_int32_t e;

    for (i = 0, e = 0; i < lext->szp; e += (u_int32_t)(lext->lexgraf[(*lexind)++]) << (8 * i++)) {
                                                     /*  e  ,  *lexind */
    }
    ifBLIN_QX5("  %08X <= %08X ?", e, lext->szz);
    if  (e <= lext->szz) {                 /* e , *lexind      */
        if  (!(lext->flags & Bpars_AABS)) {                      /*     */
            e += (lext->szp + *lexind) / (lext->szp + 1);
        }
        ifBLIN_QX5("Y %08X", e);
    } else {                /* e , *lexind    ,   */
        e |= ~ofm[lext->szp];
        ifBLIN_QX5("N %08X |%08X", e, ~ofm[lext->szp]);
    }
    return(e);
# undef blin_internal_flags
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************
 *  state    lext,  state      .                      *
 *     ,     ,                                *
 *    **next,   ,                              *
 *    **next.                                                                     *
 *    ,      *next    .  *
 *    ,      ,  *next , :   *
 *  --       !Bpars_CMID                                               *
 *  --      !!Bpars_CEND                                                 *
 *****************************************************************************************************/
babolo_testchar(const babolo_lexor *lext, u_int32_t state, const char **next) {                  /****
 *****************************************************************************************************
 *****************************************************************************************************/
# define blin_internal_flags (lext->flags & BLIN_MASK)
    size_t lexind;                         /*      (  )        */
    int    found ;                         /*                        */
    u_char nxch  ;                         /* , , ,    */
    size_t e     = (size_t)~0;             /*                                               */
    size_t n     ;                         /*               */
    u_char c     ;                         /*                                   */

    ifBLIN_QX3("+ flags=%06X state=%d next=%02X(%c)", lext->flags, state, **next & 0xFF, **next);
    nxch = (lext->retable) ? lext->retable[**next & 0xFF] : **next & 0xFF;
    if  (state < lext->szt) {                                         /* state    lext */
        lexind = (lext->szp + 1) * state;             /*        */
        found = 0;
        for (n = lext->lexgraf[lexind++] + 1; n > 0; --n) {          /*      */
            c = lext->lexgraf[lexind++];                                     /*    */
            ifBLIN_QX4("i%d %02X(%c)", (int)n, c, c);
            if  (c == nxch) {   /*     , ,  */
                e = reconstruct(lext, &lexind);
                ++*next;
                found = 1;
                break;
            } else {
                lexind += lext->szp;
        }   }
        if  (!found) {                                                 /*     */
            e = reconstruct(lext, &lexind);
            if  (e < lext->szt) {                      /*       */
                if  (!(lext->flags & Bpars_CMID)) ++*next;           /*     */
            } else {                                                                 /*   */
                if  (lext->flags & Bpars_CEND) ++*next;         /*    */
        }   }
        errno = 0;
    } else {
        errno = EINVAL;
    }
    ifBLIN_QX3("- %d next=%02X", (int)e, nxch);
    return((u_int32_t)e);
# undef blin_internal_flags
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************
 *  state    lext,  state      .                      *
 *  --         ~0,  state   .    *
 *****************************************************************************************************/
babolo_weakchar(const babolo_lexor *lext, u_int32_t state) {                                     /****
 *****************************************************************************************************
 *****************************************************************************************************/
# define blin_internal_flags (lext->flags & BLIN_MASK)
    size_t lexind = 0;
    size_t e      = (size_t)~0;
    size_t n;

    ifBLIN_QX3("+ flags=%06X state=%d", lext->flags, state);
    if  (state < lext->szt) {                                         /* state    lext */
        lexind = (lext->szp + 1) * state;
        n = lext->lexgraf[lexind++] + 1;
        lexind += (lext->szp + 1) * n;
        e = reconstruct(lext, &lexind);
        errno = 0;
    } else {
        errno = EINVAL;
    }
    ifBLIN_QX3("- %d [%d]", (int)e, (int)lexind);
    return((u_int32_t)e);
# undef blin_internal_flags
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************
 * , ,  ,     lext.                         *
 *       ,      .      *
 *           ,                       *
 *        ,                                             *
 *           .                *
 *    .                                                            *
 * *word   ,     ,  Bpars_FIRM  <>0.     *
 *****************************************************************************************************/
babolo_gonword(const babolo_lexor *lext, const char **word, ssize_t len) {                       /****
 *****************************************************************************************************
 *****************************************************************************************************/
# define blin_internal_flags (lext->flags & BLIN_MASK)
    const char *border = NULL; /*                                    */
    u_int32_t   maxcy;         /* Max cicle size                                       */
    u_int32_t   state;         /*                        */
    u_int32_t   curcy;         /*      in                 */
    const char *wcpy   = NULL; /*        */
    const char *in;            /*                                    */
    u_int32_t   j      = 0;    /*       */
    u_int32_t   k;             /*                                             */
    const char *v;             /*   in           */

    ifBLIN_QX3("+ %08X %.*s~", lext->flags, (0 <= len) ? (int)len : 1, *word);
    maxcy  = (lext->szt + lext->szp + 2) / (lext->szp + 1);
    in = *word;
    if  (0 <= len) border = in + len;
    for (state = 0, curcy = maxcy, v = in; state < lext->szt; --curcy) {
        if  (!!border && in >= border) break;
        k = babolo_weakchar(lext, state);
        if  (!!errno) {
            ifBLIN_QW0("babolo_weakchar %u", state);
            goto out;
        }
        if  (k >= lext->szt && !!~k) {    /*         */
            j = ~k;                                         /*      */
            wcpy = in;                                                /*     */
            ifBLIN_QX4("Reserve %u", j);
        }
        state = babolo_testchar(lext, state, &in);
        if  (!!errno) {
            ifBLIN_QW0("babolo_testchar %u", state);
            goto out;
        }
        if  (v != in) {                 /*  *word ,  curcy  */
            curcy = maxcy;
            v = in;
        } else if (!curcy) {               /*      *word,  */
            state = (u_int32_t)~0;
            j = 0;
            ifBLIN_QX1("infinite loop %u", maxcy);
            break;
    }   }
    k = ~state;                                                          /*   */
    if  (((state < lext->szt) || !k) && j) {              /*    ,          */
        k = j;                                            /*      */
        in = wcpy;                                                 /*    */
        ifBLIN_QX4("Reserved %u", k);
    }
    if  (!!k || !(Bpars_FIRM & lext->flags)) *word = in;
out:
    if  (!!errno) k = 0;
    ifBLIN_QX3("- %d errno %d", k, errno);
    return(k);
# undef blin_internal_flags
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_mdword(const babolo_lexor *lext, mife_descriptor *md) {                                   /****
 *****************************************************************************************************
 *****************************************************************************************************/
# define blin_internal_flags (lext->flags & BLIN_MASK)
    off_t       offset = mife_offset(md);
    u_int32_t   maxcy;         /* Max cicle size                                       */
    u_int32_t   state;         /*                        */
    u_int32_t   curcy;         /*      *word              */
    const char *wcpy   = NULL; /*        */
    const char *in     = NULL; /*                                    */
    ssize_t     len    = 1;    /*                     */
    u_int32_t   j      = 0;    /*       */
    u_int32_t   k      = 0;    /*                                             */
    const char *v;             /*   in           */

    ifBLIN_QX3("+ %08X o%"BLIN_D, lext->flags, (size_t)mife_offset(md));
    maxcy  = (lext->szt + lext->szp + 2) / (lext->szp + 1);
    for (state = 0, curcy = maxcy; (state < lext->szt); --curcy) {
        if  (len > mife_read(md, len, offset)) {
            ifBLIN_QW0("mife_read");
            goto out;
        }
        if  (!len) break;
        if  (!(in = mife_pointer(md))) {
            ifBLIN_QW0("mife_pointer");
            goto out;
        }
        in += (len - 1);
        v = in;
        k = babolo_weakchar(lext, state);
        if  (!!errno) {
            ifBLIN_QW0("babolo_weakchar %u", state);
            goto out;
        }
        if  (k >= lext->szt && !!~k) {    /*         */
            j = ~k;                                         /*      */
            wcpy = in;                                                   /*     */
            ifBLIN_QX4("Reserve %u", j);
        }
        state = babolo_testchar(lext, state, &in);
        if  (!!errno) {
            ifBLIN_QW0("babolo_testchar %u", state);
            goto out;
        }
        if  (v != in) {                       /*  in ,  curcy  */
            curcy = maxcy;
            len += (in - v);
            v = in;
        } else if (!curcy) {                  /*      in,  */
            state = (u_int32_t)~0;
            j = 0;
            ifBLIN_QX1("infinite loop %u", maxcy);
            break;
    }   }
    k = ~state;                                                          /*   */
    if  (((state < lext->szt) || !k) && j) {              /*    ,          */
        k = j;                                            /*      */
        len -= (in - wcpy);
        in = wcpy;                                                    /*    */
        ifBLIN_QX4("Reserved %u", k);
    }
    if  (!!k || !(Bpars_FIRM & lext->flags)) mife_get(md, offset + len - 1);
out:
    if  (!!errno) k = 0;
    ifBLIN_QX3("- %d", k);
    return(k);
# undef blin_internal_flags
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_goword(const babolo_lexor *lext, const char **word) {                                     /****
 *****************************************************************************************************
 *****************************************************************************************************/
    return(babolo_gonword(lext, word, -1));
}

u_int32_t
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_testword(const babolo_lexor *lext, const char *word) {                                    /****
 *****************************************************************************************************
 *****************************************************************************************************/
    return(babolo_goword(lext, &word));
}

void
/*****************************************************************************************************
 *****************************************************************************************************/
babolo_treedump(const babolo_lexor *lext) {                                                      /****
 *****************************************************************************************************
 *****************************************************************************************************/
    size_t    lexind;
    u_char    c;
    u_int32_t j;
    u_int32_t k;
    u_int32_t m;
    u_int32_t e;
    u_int32_t n;

    m = 0;
    lexind = 0;
    k = 0;
    for (;;) {
        n = lext->lexgraf[lexind++] + 1;
        fprintf(stderr, "[%2u]", k);
        for (j = 0; j < n; ++j) {
            if  (lexind > (lext->szp + 1) * lext->szt) {
                fprintf(stderr, "Premature end\n");
                return;
            }
            c = lext->lexgraf[lexind++];
            if  (c >= ' ' && c < 127) fprintf(stderr, "   (%c)%02X", c, c);
              else fprintf(stderr, "      %02X", c);
            e = reconstruct(lext, &lexind);
            if  (m < e && e < lext->szt) m = e;
            if  (e < lext->szt) fprintf(stderr, "%c%2u", (e > (k + j)) ? '.' : '!', e);
              else fprintf(stderr, "%c~%u", (e > (k + j)) ? '.' : '!', ~e & ofm[lext->szp]);
        }
        e = reconstruct(lext, &lexind);
        if  (m < e && e < lext->szt) m = e;
        k += n + 1;
        if  (e < lext->szt) fprintf(stderr, "   *%c%2u\n", (e >= k) ? '.' : '!', e);
          else fprintf(stderr, "   *%c~%u\n", (e >= k) ? '.' : '!', ~e & ofm[lext->szp]);
        if  (k >= lext->szt) break;
        if  (k > m) fprintf(stderr, "No way\n");
    }
    if  (m >= lext->szt) fprintf(stderr, "Link out\n");
}
