/*-
 * Copyright (C)2006..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: lexor.h,v 1.14 2024/01/07 23:27:17 babolo Exp $
 */

/*****************************************************************************************************
 *                                                                                                   *
 * lexor  run1        C,                                 *
 *   cc     ,                                    *
 *         .                                  *
 *     C,    run3                               *
 * ,   run4 ,                                         *
 *    .h  .c  C.                                                                      *
 *                                                                                                   *
 *     .h ,   , ,                                 *
 *     .h   .                                     *
 *     2 ,                                     *
 *      , typedef  ,                              *
 *       .h ,                             *
 * lexor.    .lexor    .                                     *
 *     2                                         *
 *  .   .lexor    '# INCLUDES',                                      *
 *     '# BALEX BEGIN',                                          *
 * .lexor    '# INCLUDES'   .                                   *
 *       .c  .                                              *
 *        run12parm.ininc.                                       *
 *                                                                                                   *
 *   '# INCLUDES'  '# BALEX BEGIN',                                        *
 * '# INCLUDES',    .lexor   '# BALEX BEGIN'                              *
 *  .     .c ( .h)                                      *
 * " ".   .c                                              *
 * , typedef, #include  ..                                                        *
 *        run12parm.incopy.                                      *
 *                                                                                                   *
 *        2                                 *
 * :                                                                                          *
 *     -        babolo_lexor;                                 *
 *           ,                                       *
 *          . ,  'static extern eee'                                  *
 *        'static extern babolo_lexor eee = { ... }'                                        *
 *     - ,   .  ,                                    *
 *          .                                                                  *
 *           run12parm.intype,                    *
 *   run12parm.inname,   run12parm.inflag.                                                 *
 *                                                                                                   *
 *                                     *
 *  babolo_lexor   {},  ;                                     *
 *      babolo_lexor.retable                                   *
 *    .lexor .                                                                 *
 *        run12parm.intrans.                                     *
 *                                                                                                   *
 * ,          ,                           *
 *    .                                                                      *
 *        run12parm.imd.                                         *
 *                                                                                                   *
 *       .                                                     *
 *                                                                                                   *
 *****************************************************************************************************/

typedef struct runparm {     /************************************************************/
    mife_descriptor *iffed;  /*        */
    char            *oufn;   /*                                         */
    ssize_t          ccl;    /*                                  */
    BLIN_flag        flags;  /*  ccbin.flags                                        */
#if BLINAP > 4
    u_int32_t        dummy;
#endif
} runparm;                   /************************************************************/

typedef struct run12parm {    /************************************************************/
    mular_descriptor *imd;    /*     : , ,    */
    const char  *ininc;       /*  ,     cc      */
    size_t       lninc;
    const char  *incopy;      /* ,      cc,    */
    size_t       lncopy;
    const char  *intype;      /*     babolo_lexor              */
    size_t       lntype;
    const char  *inname;      /*   babolo_lexor                            */
    const char  *inflag;      /*    babolo_lexor                        */
    const char  *intrans;     /*     babolo_lexor           */
    size_t       lntrans;
    char        *infn;        /*                                          */
    char        *ccname;      /*   (cc)                                     */
    const char **ccarg;       /*   (cc)                               */
    size_t       ccarp;       /*     (cc)                     */
    int          pip2[2];     /*      cc             */
    int          fil1;        /*     cc                                */
#if BLINAP > 4
    u_int32_t    dummy;
#endif
} run12parm;                  /************************************************************/

typedef enum {e_Z, e_C, e_D, e_E} eSKA;

/*****************************************************************************************************
 *                                                                                                   *
 *      ,     .                                  *
 *  3   ,                                      *
 * .                                       *
 *  ,      ,                                    *
 *          -                                   *
 * .       babolo-parser,                                    *
 *                                            *
 *  ,   ( ).                                         *
 *                                                                                                   *
 * 3  - .                                                                               *
 * 2  -  .                                                                      *
 * 1 ,  ,   ,                                    *
 *       .                                        *
 *      '0'  '7',    \000  \007                                        *
 *    ,    '0',                                  *
 *            3 ,                               *
 *     \000                                         *
 *          3 .                                                 *
 *                                                                                                   *
 *       3    1                                         *
 *     ,                                           *
 *     .                                                              *
 *                                                                                                   *
 *          .                             *
 *     '#'    .                                  *
 *                                                                                                   *
 *****************************************************************************************************/

typedef ssize_t treei;
typedef ssize_t treew;

typedef struct ccbin { /***************************************************************/
    struct {           /*    *****************************                            */
        BLIN_flag flags;    /*              *                            */
        u_int32_t count;    /*     *                            */
        u_char    t[256];   /*          *                            */
        u_int32_t v[1];     /*       *                            */
    }        *ibin;    /*        cc                     */
    u_char   *fbin;    /*                                     */
    u_char   *cbin;    /*                                               */
    size_t    m;       /*                                           */
    size_t    maxw;    /*                            */
    treew     maxl;    /*   babolo_lexor.szt:  babolo_lexor.lexgraf */
    treew     t;       /*   babolo_lexor.szz:                    *
                        *    babolo_lexor.lexgraf                  */
    FILE     *o;       /*                                                 */
    int       p;       /*   babolo_lexor.szp:         */
    u_int32_t ll;      /*                              */
} ccbin;               /***************************************************************/

/*****************************************************************************************************
 *                                                                                                   *
 *     :                                                                     *
 * +-------+  +-------+  +-------+                                                                   *
 * |v|w|d|s|->|v|w|0|s|->|v|w|d|0|                                                                   *
 * +-------+  +-------+  +-------+                                                                   *
 *      |                     |                                                                      *
 *      |                     V                                                                      *
 *      V                  +-------+  +-------+                                                      *
 *   +-------+  +-------+  |v|w|d|s|->|v|w|0|0|                                                      *
 *   |v|w|d|s|->|v|w|d|0|  +-------+  +-------+                                                      *
 *   +-------+  +-------+       |                                                                    *
 *        |          |          V                                                                    *
 *        V          V       +-------+                                                               *
 *     +-------+  +-------+  |v|w|0|0|                                                               *
 *     |v|w|0|0|  |v|w|0|0|  +-------+                                                               *
 *     +-------+  +-------+                                                                          *
 *  v -  ()                                                                          *
 *     w -                                                                                        *
 *     s -   (       )                         *
 *     d -   ( ())                                                          *
 *                                                                                                   *
 *****************************************************************************************************/

typedef struct tree {
    treei  *trees; /*                                */
    treei  *treed; /*   ( finedump_tree  )  */
    treew  *treew; /*                                  */
    u_char *treev; /*   ( )          */
    treei   treep; /*      */
    treei   treem; /*           */
} tree;

#define TREE(A, B) (tree->tree##A[B])
#define TRIS(A) ((A) > 0)
