#!/bin/sh
# Copyright (C)2003..2007 @BABOLO
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: test.sh,v 1.9 2007/07/28 18:51:00 babolo Exp $

PREFIX=/usr/local

R=`mktemp -t parserR`
O=`mktemp -t parserO`

echo "s0 ''"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "s0x200"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x200 $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "s0x400 ''"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~$TU~
	   1 ~$TU~
	   2 ~$TU$TU$TU${TU}
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x400 $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "s0x600 ''"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=5 ==============
	   0 ~~
	   1 ~a~
	   2 ~fg~
	   3 ~23#@%^	~
	   4 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~$TU~
	   1 ~$TU~
	   2 ~$TU$TU$TU${TU}
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x600 $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo z
cat > ${O} <<- "EOF"
	argc=38 ==============
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	   8 ~E~
	   9 ~%	$~
	  10 ~S~
	  11 ~\045\301\011~
	  12 ~ ~
	  13 ~ 	~
	  14 ~--comment~
	  15 ~tu~
	  16 ~tu~
	  17 ~tutututu
	~
	  18 ~test
	~
	  19 ~\
	test~
	  20 ~ a " b  c ~
	  21 ~d~
	  22 ~~
	  23 ~e~
	  24 ~
	 a ~
	  25 ~b~
	  26 ~ c  d ~
	  27 ~e~
	  28 ~~
	  29 ~ a '  b ' c ~
	  30 ~d~
	  31 ~ e "
	" a ~
	  32 ~b~
	  33 ~~
	  34 ~c~
	  35 ~ d ~
	  36 ~e~
	  37 ~~
	EOF
env TU=tu ./tools/test $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "s0x02 ''"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=2 ==============
	   0 ~a~
	   1 ~fg 23~
	argc=2 ==============
	   0 ~a~
	   1 ~fg 23#@%^	E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=2 ==============
	   0 ~\045\301\011~
	   1 ~   	 --comment~
	argc=0 ==============
	argc=2 ==============
	   0 ~tu~
	   1 ~tu tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=2 ==============
	   0 ~ a " b  c ~
	   1 ~d  e 
	 a  b  c  d  e ~
	argc=2 ==============
	   0 ~ a '  b ' c ~
	   1 ~d  e "
	" a  b  c  d  e ~
	EOF
env TU=tu ./tools/test -s0x02 $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0 #'
cat > ${O} <<- "EOF"
	argc=0 ==============
	argc=7 ==============
	   0 ~test~
	   1 ~a~
	   2 ~fg~
	   3 ~23~
	   4 ~a~
	   5 ~fg~
	   6 ~23~
	argc=31 ==============
	   0 ~@%^	~
	   1 ~E~
	   2 ~%	$~
	   3 ~S~
	   4 ~\045\301\011~
	   5 ~ ~
	   6 ~ 	~
	   7 ~--comment~
	   8 ~tu~
	   9 ~tu~
	  10 ~tutututu
	~
	  11 ~test
	~
	  12 ~\
	test~
	  13 ~ a " b  c ~
	  14 ~d~
	  15 ~~
	  16 ~e~
	  17 ~
	 a ~
	  18 ~b~
	  19 ~ c  d ~
	  20 ~e~
	  21 ~~
	  22 ~ a '  b ' c ~
	  23 ~d~
	  24 ~ e "
	" a ~
	  25 ~b~
	  26 ~~
	  27 ~c~
	  28 ~ d ~
	  29 ~e~
	  30 ~~
	EOF
env TU=tu ./tools/test ./tools/testln.tst '#' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x4000 #'
cat > ${O} <<- "EOF"
	argc=0 ==============
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x4000 $1 ./tools/testln.tst '#' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x4000 --'
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=3 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	argc=0 ==============
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x4000 $1 ./tools/testln.tst '--' > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "s0x4000 ''"
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=4 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test~
	argc=1 ==============
	   0 ~\
	test~
	EOF
env TU=tu ./tools/test -s0x4000 $1 ./tools/testln.tst '' > ${R}
e="$?"
if [ "${e}" -ne "65" ]; then echo "Error ${e} not 65"; fi
diff -u ${O} ${R}

echo 's0x4000'
cat > ${O} <<- "EOF"
	argc=2 ==============
	   0 ~#~
	   1 ~test~
	argc=3 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============
	argc=3 ==============
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============
	   0 ~test
	~
	argc=1 ==============
	   0 ~\
	test~
	argc=9 ==============
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x4000 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x4800'
cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============1
	argc=3 ==============2
	   0 ~tu~
	   1 ~tu~
	   2 ~tutututu
	~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=9 ==============2
	   0 ~ a " b  c ~
	   1 ~d~
	   2 ~~
	   3 ~e~
	   4 ~
	 a ~
	   5 ~b~
	   6 ~ c  d ~
	   7 ~e~
	   8 ~~
	argc=9 ==============2
	   0 ~ a '  b ' c ~
	   1 ~d~
	   2 ~ e "
	" a ~
	   3 ~b~
	   4 ~~
	   5 ~c~
	   6 ~ d ~
	   7 ~e~
	   8 ~~
	EOF
env TU=tu ./tools/test -s0x4800 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x800'
cat > ${O} <<- "EOF"
	argc=38 ==============0
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	   8 ~E~
	   9 ~%	$~
	  10 ~S~
	  11 ~\045\301\011~
	  12 ~ ~
	  13 ~ 	~
	  14 ~--comment~
	  15 ~tu~
	  16 ~tu~
	  17 ~tutututu
	~
	  18 ~test
	~
	  19 ~\
	test~
	  20 ~ a " b  c ~
	  21 ~d~
	  22 ~~
	  23 ~e~
	  24 ~
	 a ~
	  25 ~b~
	  26 ~ c  d ~
	  27 ~e~
	  28 ~~
	  29 ~ a '  b ' c ~
	  30 ~d~
	  31 ~ e "
	" a ~
	  32 ~b~
	  33 ~~
	  34 ~c~
	  35 ~ d ~
	  36 ~e~
	  37 ~~
	EOF
env TU=tu ./tools/test -s0x800 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x1800'
cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	argc=30 ==============0
	   0 ~E~
	   1 ~%	$~
	   2 ~S~
	   3 ~\045\301\011~
	   4 ~ ~
	   5 ~ 	~
	   6 ~--comment~
	   7 ~tu~
	   8 ~tu~
	   9 ~tutututu
	~
	  10 ~test
	~
	  11 ~\
	test~
	  12 ~ a " b  c ~
	  13 ~d~
	  14 ~~
	  15 ~e~
	  16 ~
	 a ~
	  17 ~b~
	  18 ~ c  d ~
	  19 ~e~
	  20 ~~
	  21 ~ a '  b ' c ~
	  22 ~d~
	  23 ~ e "
	" a ~
	  24 ~b~
	  25 ~~
	  26 ~c~
	  27 ~ d ~
	  28 ~e~
	  29 ~~
	EOF
env TU=tu ./tools/test -s0x1800 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x1800 a0x01'
cat > ${O} <<- "EOF"
	argc=8 ==============1
	   0 ~#~
	   1 ~test~
	   2 ~a~
	   3 ~fg~
	   4 ~23~
	   5 ~a~
	   6 ~fg~
	   7 ~23#@%^	~
	argc=18 ==============0
	   0 ~E~
	   1 ~%	$~
	   2 ~S~
	   3 ~\045\301\011~
	   4 ~ ~
	   5 ~ 	~
	   6 ~--comment~
	   7 ~$TU "$TU" $TU$TU"$TU${TU}
	"~
	   8 ~test
	~
	   9 ~\
	test~
	  10 ~ a " b  c ' d  e ~
	  11 ~ a ' b " c ~
	  12 ~d~
	  13 ~ e 
" a '  b ' c ~
	  14 ~d~
	  15 ~ e "
" a ~
	  16 ~b~
	  17 ~ c " d " e ~
	EOF
env TU=tu ./tools/test -s0x1800 -a0x01 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo 's0x4800 a0x01'
cat > ${O} <<- "EOF"
	argc=2 ==============1
	   0 ~#~
	   1 ~test~
	argc=3 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23~
	argc=4 ==============1
	   0 ~a~
	   1 ~fg~
	   2 ~23#@%^	~
	   3 ~E~
	argc=2 ==============1
	   0 ~%	$~
	   1 ~S~
	argc=4 ==============1
	   0 ~\045\301\011~
	   1 ~ ~
	   2 ~ 	~
	   3 ~--comment~
	argc=0 ==============1
	argc=1 ==============2
	   0 ~$TU "$TU" $TU$TU"$TU${TU}
	"~
	argc=1 ==============3
	   0 ~test
	~
	argc=1 ==============2
	   0 ~\
	test~
	argc=1 ==============1
	   0 ~ a " b  c ' d  e ~
	argc=7 ==============3
	   0 ~ a ' b " c ~
	   1 ~d~
	   2 ~ e 
" a '  b ' c ~
	   3 ~d~
	   4 ~ e "
" a ~
	   5 ~b~
	   6 ~ c " d " e ~
	EOF
env TU=tu ./tools/test -s0x4800 -a0x01 $1 ./tools/testln.tst > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

F=`mktemp -d -t lexor.test`
sed -e "s|@@INCLUDELEXOR@@|${F}|" ./tools/texot > ${F}/t.c

for i in 1 2 3 4; do
    bin/lexor -pipe -Wall -I${PREFIX}/include -o ${F}/t${i}.h ./tools/test${i}.lexor
done
cc -pipe -Wall -I${PREFIX}/include -L${PREFIX}/lib -lmife -lbabolo-parser -o ${F}/t ${F}/t.c

echo "lexor (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a2 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a3 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a4 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

for i in 1 2 3 4; do
    bin/lexor -f -pipe -Wall -I${PREFIX}/include -o ${F}/t${i}.h ./tools/test${i}.lexor
done
cc -pipe -Wall -I${PREFIX}/include -L${PREFIX}/lib -lmife -lbabolo-parser -o ${F}/t ${F}/t.c

echo "lexor -f (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2         1
	    3     6         2
	    4     6         0
	    5     4         0
	    6     5         3
	    7     4         4
	    8     3         4
	    9     3         4
	   10     3         0
	   11     6         5
	   12     6         6
	   13     6         7
	   14     1         0
	EOF
${F}/t -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a2 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2       256
	    3     6       512
	    4     6         0
	    5     4         0
	    6     5       768
	    7     4      1024
	    8     3      1024
	    9     3      1024
	   10     3         0
	   11     6      1280
	   12     6      1536
	   13     6      1792
	   14     1         0
	EOF
${F}/t -a2 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a3 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     6         0
	    5     4         0
	    6     5    196608
	    7     4    262144
	    8     3    262144
	    9     3    262144
	   10     3         0
	   11     6    327680
	   12     6    393216
	   13     6    458752
	   14     1         0
	EOF
${F}/t -a3 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a4 (0x10000)"
cat > ${O} <<- "EOF"
	    0     1         0
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     6         0
	    5     4         0
	    6     5  50331648
	    7     4  67108864
	    8     3  67108864
	    9     3  67108864
	   10     3         0
	   11     6  83886080
	   12     6 100663296
	   13     6 117440512
	   14     1         0
	EOF
${F}/t -a4 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

for i in 1 2 3 4; do
    bin/lexor -pipe -Wall -I${PREFIX}/include -o ${F}/t${i}.h ./tools/test${i}.lexor
done
cc -pipe -Wall -I${PREFIX}/include -L${PREFIX}/lib -lmife -lbabolo-parser -o ${F}/t ${F}/t.c

echo "lexor"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a2"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a3"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a4"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

for i in 1 2 3 4; do
    bin/lexor -f -pipe -Wall -I${PREFIX}/include -o ${F}/t${i}.h ./tools/test${i}.lexor
done
cc -pipe -Wall -I${PREFIX}/include -L${PREFIX}/lib -lmife -lbabolo-parser -o ${F}/t ${F}/t.c

echo "lexor -f"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2         1
	    3     6         2
	    4     5         0
	    5     5         3
	    6     5         3
	    7     3         4
	    8     0         0
	    8     1
	    9     3         4
	   10     3         4
	   11     2         0
	   12     0         0
	   12     1
	   13     6         5
	   14     6         6
	   15     6         7
	   16     1         0
	EOF
${F}/t $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a2"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2       256
	    3     6       512
	    4     5         0
	    5     5       768
	    6     5       768
	    7     3      1024
	    8     0         0
	    8     1
	    9     3      1024
	   10     3      1024
	   11     2         0
	   12     0         0
	   12     1
	   13     6      1280
	   14     6      1536
	   15     6      1792
	   16     1         0
	EOF
${F}/t -a2 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a3"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2     65536
	    3     6    131072
	    4     5         0
	    5     5    196608
	    6     5    196608
	    7     3    262144
	    8     0         0
	    8     1
	    9     3    262144
	   10     3    262144
	   11     2         0
	   12     0         0
	   12     1
	   13     6    327680
	   14     6    393216
	   15     6    458752
	   16     1         0
	EOF
${F}/t -a3 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -f -a4"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     2  16777216
	    3     6  33554432
	    4     5         0
	    5     5  50331648
	    6     5  50331648
	    7     3  67108864
	    8     0         0
	    8     1
	    9     3  67108864
	   10     3  67108864
	   11     2         0
	   12     0         0
	   12     1
	   13     6  83886080
	   14     6 100663296
	   15     6 117440512
	   16     1         0
	EOF
${F}/t -a4 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a0 (0x10000)"
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 -s0x10000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a0"
cat > ${O} <<- "EOF"
	    0     2         0
	    1     8         0
	    2    10         1
	    3     8         1
	    4     4         1
	    5     9         1
	    6     3         2
	    7     9         1
	    8     3         4
	    9     1         0
	EOF
${F}/t -a0 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a0 (0x40000)"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0x40000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

echo "lexor -a0 (0x50000)"
cat > ${O} <<- "EOF"
	    0     0         0
	    0     1
	    1     1         0
	    2     1         0
	    3     0         0
	    3     1
	    4     6         0
	    5     9         0
	    6     0         0
	    6     1
	    7     5         1
	    8     2         0
	    9     0         0
	    9     1
	   10     0         0
	   10     1
	   11     2         0
	   12     0         0
	   12     1
	   13     2         0
	   14     0         0
	   14     1
	   15     3         3
	   16     2         0
	   17     0         0
	   17     1
	   18     3         2
	   19     2         0
	   20     0         0
	   20     1
	   21     2         0
	   22     0         0
	   22     1
	   23     2         0
	   24     0         0
	   24     1
	   25     3         4
	   26     1         0
	EOF
${F}/t -a0 -s0x50000 $1 < ./tools/words > ${R}
e="$?"
if [ "${e}" -ne "0" ]; then echo "Error ${e} not 0"; fi
diff -u ${O} ${R}

rm -rf ${F} ${O} ${R}
