/*-
 * Copyright (C)2003..2007 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: parser.h,v 1.12 2007/07/28 18:51:00 babolo Exp $
 */

#ifndef  _BABOLO_PARSER_H_
# define _BABOLO_PARSER_H_

/* For babolo_parm.flag                                                          */
# define Bpars_NPRM   0x0000FF /*                */
# define Bpars_CHNK   0x000100 /*                               */
# define Bpars_FIXB   0x000200 /*             */
# define Bpars_NOEN   0x000400 /*                */
# define Bpars_XXCN   0x000800 /*                                 */
# define Bpars_LNSH 8
# define Bpars_VTLN/* 0x001000  VT -        */ (0x10 << Bpars_LNSH)
# define Bpars_CRLN/* 0x002000  CR -        */ (0x20 << Bpars_LNSH)
# define Bpars_LFLN/* 0x004000  LF -        */ (0x40 << Bpars_LNSH)
# define Bpars_XXLN/* 0x007000     */ (Bpars_VTLN | Bpars_LFLN | Bpars_CRLN)
# define Bpars_ABSQ   0x800000 /*                         */

/* For babolo_lexor.flag                                                         */
# define Bpars_CEND   0x010000 /*                       */
# define Bpars_AABS   0x020000 /*    lexgraf                */
# define Bpars_CMID   0x040000 /*        */

# define kukBpars_NPRM(x)   ((u_int32_t)(x) & Bpars_NPRM)
# define setBpars_NPRM(a,x) {(a) &= ~Bpars_NPRM; (a) |= kukBpars_NPRM(x);}
# define getBpars_NPRM(a)   ((a) & Bpars_NPRM)

typedef struct {
    u_int32_t flag;
    int       argc;
    u_char  **argv;
} babolo_parm;

typedef struct {
    u_int32_t flag;
    int       argc;
    u_char  **argv;
    size_t    cntr;
} babolo_parm1;

typedef struct {
    u_char   *retable;    /*                      */
    void     *printable;  /*                                 */
    u_int32_t flag;       /*                                     */
    u_int32_t szt;        /*      szp + 1  */
    u_int32_t szz;        /*     szp + 1 */
    u_char    szp;        /*                      */
    u_char    lexgraf[0]; /*                                    */
       /***************************************************************
        *    :                            *
        *  N(1 ) + 1 -   (, )             *
        *    (1 ), (szp )                         *
        *    ...                                                      *
        *  (szp )  ,              *
        *                                                             *
        *    szp + 1,  Bpars_AABS ,       *
        *     + szp           *
        *  ,             *
        * .                                                    *
        *    szz,             *
        *  ,               *
        *  -    .                *
        ***************************************************************/
} babolo_lexor;

babolo_parm * babolo_getparm __P((u_int32_t flag, u_char **instring, const u_char *strend));
babolo_parm *babolo_getparm1 __P((u_int32_t flag, u_char **instring, const u_char *strend, u_char absq));
void         babolo_freeparm __P((babolo_parm *parsed));
u_int32_t    babolo_testchar __P((const babolo_lexor *lext, u_int32_t state, const u_char **next));
u_int32_t    babolo_testword __P((const babolo_lexor *lext, const u_char *word));
u_int32_t      babolo_goword __P((const babolo_lexor *lext, const u_char **word));
void         babolo_treedump __P((const babolo_lexor *lext));

#endif /* _BABOLO_PARSER_H_ */
