/*-
 * Copyright (C)2003 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2003 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: getparm.c,v 1.9 2007/07/28 18:51:00 babolo Exp $";
#endif /* not lint */

#include <sys/syslimits.h>
#include <sys/cdefs.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "parser.h"

#define Ca 0x00800000 /*    */
#define Cr 0x00400000 /*    */
#define Ct 0x00200000 /*     */
#define Cw 0x00100000 /*    () */
#define Cz 0x00080000 /*    */
#define Cp 0x00020000 /*   () */
#define Cq 0x00010000 /*   () */
#define Cv 0x00004000 /*    () */
#define Cc 0x00002000 /*     */
#define Cn 0x00001000 /*    */
#define Ce 0x00000800 /*  */
#define Cl 0x00000400 /*      */
#define Cy 0x00000200 /*   */
#define Cx 0x00000100 /*  */
#define C_state  0xFF /*   */

static const u_char *pn[] = 
{ "- ", "- ", "- ", "- ", "- ", "- ", "- ", "- "
, "a ", "r ", "t ", "w ", "z ", "- ", "p ", "q "
, "- ", "v ", "c ", "n ", "e ", "l ", "y ", "x "
};
extern u_char **environ;

enum states
{ db  /*                             */
, df  /*               */
, di  /*                           */
, da  /*                  */
, dc  /*      */
, dp  /*        */
, s0  /*  \                                 */
, d0  /*  \                 */
, ds  /*                   */
, dd  /*                     */
, s1  /*  \  2                     */
, d1  /*  \     2  */
, s2  /*  \  1                     */
, d2  /*  \     1  */
, v0  /*                       */
, v2  /* ?                      */
, v3  /*                        */
, v4  /*              */
, v6  /* ?             */
, v7  /*               */
, v5  /*             */
, v1  /*                      */
, sc  /* Skip comment                            */
, dx  /*                               */
};
enum classes {sy, sp, dl, aq, sq, dq, no, lt, bs, bo, bc, el, nl, xx};
static const u_char *statenames[] =
{ "db", "df", "di", "da", "dc", "dp", "s0", "d0", "ds", "dd", "s1", "d1", "s2", "d2"
, "v0", "v2", "v3", "v4", "v6", "v7", "v5", "v1", "sc", "dx"
};
static const u_char *clasnames[] =
{ "sy", "sp", "dl", "aq", "sq", "dq", "no", "lt", "bs", "bo", "bc", "el", "nl", "xx"
};
/****************************************************************
 * recode    , 
 *   \x,  x -     .
 *        1 .
 */
static const u_char recode[256][2] =
{"\000","\001","\002","\003" ,"\004","\005","\006","\007"
,"\010","\011","\000","\013" ,"\014","\015","\016","\017"
,"\020","\021","\022","\023" ,"\024","\025","\026","\027"
,"\030","\031","\032","\033" ,"\034","\035","\036","\037"
,"\040","\041","\042","\043" ,"\044","\045","\046","\047"
,"\050","\051","\052","\053" ,"\054","\055","\056","\057"
,"\060","\061","\062","\063" ,"\064","\065","\066","\067"
,"\070","\071","\072","\073" ,"\074","\075","\076","\077"

,"\100","\101","\102","\103" ,"\104","\105","\106","\107"
,"\110","\111","\112","\113" ,"\114","\115","\116","\117"
,"\120","\121","\122","\123" ,"\124","\125","\126","\127"
,"\130","\131","\132","\133" ,"\134","\135","\136","\137"
,"\140","\007","\010","\143" ,"\144","\145","\014","\147"
,"\150","\151","\152","\153" ,"\154","\155","\012","\157"
,"\160","\161","\015","\163" ,"\011","\165","\013","\167"
,"\170","\171","\172","\173" ,"\174","\175","\176","\177"

,"\200","\201","\202","\203" ,"\204","\205","\206","\207"
,"\210","\211","\212","\213" ,"\214","\215","\216","\217"
,"\220","\221","\222","\223" ,"\224","\225","\226","\227"
,"\230","\231","\232","\233" ,"\234","\235","\236","\237"
,"\240","\241","\242","\243" ,"\244","\245","\246","\247"
,"\250","\251","\252","\253" ,"\254","\255","\256","\257"
,"\260","\261","\262","\263" ,"\264","\265","\266","\267"
,"\270","\271","\272","\273" ,"\274","\275","\276","\277"

,"\300","\301","\302","\303" ,"\304","\305","\306","\307"
,"\310","\311","\312","\313" ,"\314","\315","\316","\317"
,"\320","\321","\322","\323" ,"\324","\325","\326","\327"
,"\330","\331","\332","\333" ,"\334","\335","\336","\337"
,"\340","\341","\342","\343" ,"\344","\345","\346","\347"
,"\350","\351","\352","\353" ,"\354","\355","\356","\357"
,"\360","\361","\362","\363" ,"\364","\365","\366","\367"
,"\370","\371","\372","\373" ,"\374","\375","\376","\377"
};
static const u_char eolns[256] =
{0,0,0,0 ,0,0,0,0 ,0,0,Bpars_LFLN>>8,Bpars_VTLN>>8 ,0,Bpars_CRLN>>8,0,0
                                    ,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0

,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
,0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0, 0,0,0,0 ,0,0,0,0 ,0,0,0,0 ,0,0,0,0
};
static const enum classes class[4][256] =
{{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sp,sp,sp ,sy,sp,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sp,sy,dq,sy ,dl,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,bo ,sy,bc,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,dq,sy ,dl,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,bo ,sy,bc,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sp,sp,sp ,sy,sp,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sp,sy,dq,sy ,sy,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 }
,{nl,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,dq,sy ,sy,sy,sy,sq ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,no,no,no,no ,no,no,no,no ,no,no,sy,sy ,sy,sy,sy,sy

 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,bs,sy,sy,lt
 ,sy,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,lt
 ,lt,lt,lt,lt ,lt,lt,lt,lt ,lt,lt,lt,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy

 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
 ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy ,sy,sy,sy,sy
}};

static const u_int32_t automa[dx][xx] =
/*         .           b        $              '        "           9           A           \        {        }              \n    \0*/
/*         sy,         sp,      dl,   aq,      sq,      dq,         no,         lt,         bs,      bo,      bc,            el,   nl*/
{{Cz|Cp|Cn|di,Cz      |db,Cz|Cp|v0,Cp|da,Cz|Cp|ds,Cz|Cp|dd,Cz|Cp|Cn|di,Cz|Cp|Cn|di,   Cp|Cc|s0,Cz|Ce|dx,Cz|Ce|dx,Cz|Cq|Cy   |Cx|dx,   dx}/*db*/
,{Cz|Cp|Cn|di,Cz|Cp|Cq|db,Cz|Cp|v0,Cp|da,Cz|Cp|ds,Cz|Cp|dd,Cz|Cp|Cn|di,Cz|Cp|Cn|di,   Cp|Cc|s0,Cz|Ce|dx,Cz|Ce|dx,Cz|Cq|Cy   |Cx|dx,   dx}/*df*/
,{Cz   |Cn|di,Cz   |Cq|db,Cz   |v0,   da,Cz   |ds,Cz   |dd,Cz   |Cn|di,Cz   |Cn|di,Cz   |Cc|s0,Cz|Ce|dx,Cz|Ce|dx,Cz|Cq|Cy   |Cx|dx,   dx}/*di*/
,{      Cn|da,      Cn|da,   Cn|da,   di,   Cn|da,   Cn|da,      Cn|da,      Cn|da,      Cn|da,   Cn|da,   Cn|da,      Cy   |Cn|da,Ce|dx}/*da*/
,{      Cn|dc,      Cn|dc,   Cn|dc,   ds,   Cn|dc,   Cn|dc,      Cn|dc,      Cn|dc,      Cn|dc,   Cn|dc,   Cn|dc,      Cy   |Cn|dc,Ce|dx}/*dc*/
,{      Cn|dp,      Cn|dp,   Cn|dp,   dd,   Cn|dp,   Cn|dp,      Cn|dp,      Cn|dp,      Cn|dp,   Cn|dp,   Cn|dp,      Cy   |Cn|dp,Ce|dx}/*dp*/
,{      Ct|di,      Ct|di,   Ct|di,Ce|dx,   Ct|di,   Ct|di,   Ca   |s1,      Ct|di,      Ct|di,   Ct|di,   Ct|di,      Cy|Ct   |di,Ce|dx}/*s0*/
,{      Ct|dd,      Ct|dd,   Ct|dd,Ce|dx,   Ct|dd,   Ct|dd,   Ca   |d1,      Ct|dd,      Ct|dd,   Ct|di,   Ct|dd,      Cy|Ct   |dd,Ce|dx}/*d0*/
,{      Cn|ds,      Cn|ds,   Cn|ds,   dc,      di,   Cn|ds,      Cn|ds,      Cn|ds,      Cn|ds,   Cn|ds,   Cn|ds,      Cy|Cn   |ds,Ce|dx}/*ds*/
,{      Cn|dd,      Cn|dd,      v4,   dp,   Cn|dd,      di,      Cn|dd,      Cn|dd,      Cc|d0,   Cn|dd,   Cn|dd,      Cy|Cn   |dd,Ce|dx}/*dd*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca   |s2,Ce      |dx,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*s1*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca   |d2,Ce      |dx,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*d1*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca|Cr|di,Ce      |dx,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*s2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Ca|Cr|dd,Ce      |dx,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*d2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v1,   Cv   |v1,Ce      |dx,      v2,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*v0*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v3,   Cv   |v3,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*v2*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,         v3,         v3,Ce      |dx,Ce   |dx,Cw   |di,Ce   |Cy      |dx,Ce|dx}/*v3*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v5,   Cv   |v5,Ce      |dx,      v6,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*v4*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,   Cv   |v7,   Cv   |v7,Ce      |dx,Ce   |dx,Ce   |dx,Ce   |Cy      |dx,Ce|dx}/*v6*/
,{Ce      |dx,Ce      |dx,Ce   |dx,Ce|dx,Ce   |dx,Ce   |dx,         v7,         v7,Ce      |dx,Ce   |dx,Cw   |dd,Ce   |Cy      |dx,Ce|dx}/*v7*/
,{Cz|Cw|Cn|dd,   Cw|Cn|dd,   Cw|v4,Ce|dx,Cn|Cw|dd,   Cw|di,         v5,         v5,   Cw|Cc|d0,Ce   |dx,Ce   |dx,Cz|Cq|Cy|Cw|Cx|dx,Ce|dx}/*v5*/
,{Cz|Cw|Cn|di,Cz|Cw|Cq|db,Cz|Cw|v0,Ce|dx,Cz|Cw|ds,Cz|Cw|dd,         v1,         v1,Cz|Cw|Cc|s0,Ce   |dx,Ce   |dx,Cz|Cq|Cy   |Cx|dx,Ce|dx}/*v1*/
,{         sc,         sc,      sc,Ce|dx,      sc,      sc,         sc,         sc,         sc,      sc,      sc,      Cy   |Cx|dx,   dx}/*sc*/
};

#define ifOVER if  (p >= &parsed->argv[0][argmax])
#define CHCL ( ((*q == absq) && (flag & Bpars_ABSQ))                                   \
             ? aq                                                                      \
             : ((eolns[*q] << Bpars_LNSH) & flag & Bpars_XXLN) ? el : class[ixvar][*q] \
             )

babolo_parm *
babolo_getparm1(u_int32_t flag, u_char **in, const u_char *end, u_char absq) {
    size_t l;
    babolo_parm *parsed;
    size_t argmax = ARG_MAX;
    int argnmax = 256;
    u_int16_t regsym = 0;
    u_char *regvar = NULL, *p = NULL, *q;
    int nidx, ixvar;
    enum states state;
    u_int32_t control = 0;

    ifBLIN_QV4(flag) fprintf( stderr
                            , "+babolo_getparm flag=%06X, end=%s~\n"
                            , flag
                            , end ? end : (u_char *)"NULL"
                            );
    if  (!end || !in || !*in) {
        errno = EFAULT;
        ifBLIN_QV1(flag) warn("babolo_getparm: Params not defined");
        return(NULL);
    }
    l = strlen(end);
    if  (!(parsed = malloc((flag & Bpars_XXCN) ? sizeof(babolo_parm) : sizeof(babolo_parm1)))) {
        errno = ENOMEM;
        ifBLIN_QV1(flag) warn("babolo_getparm #1");
        return(NULL);
    }
    bzero(parsed, sizeof(parsed));
    parsed->flag = flag;
    if  (flag & Bpars_XXCN) {
        ((babolo_parm1*)parsed)->cntr = 0;
    }
    if  (!(parsed->argv = malloc(sizeof(u_char *) * argnmax))) {
        free(parsed);
        errno = ENOMEM;
        ifBLIN_QV1(flag) warn("babolo_getparm #2");
        return(NULL);
    }
    nidx = 0;
    q = *in;

    ifBLIN_QV4(flag) {
# ifdef ALLIGN_TABLE
        int i, j, k;

        fprintf( stderr, "control-nst");
        for (i = 0; i < 24; i++)
            if  (pn[i][0] != '-') fprintf(stderr, "-%s", pn[i]);
        fprintf(stderr, " vl cl st     p    --- q ---\n");
# else
        fprintf(stderr, "--------nst control ------ rs cl st     p    --- q ---\n");
# endif
    }
    ixvar = (flag & Bpars_NOEN) ? 2 : 0;
    for (state = (flag & Bpars_FIXB) ? df : db; state < dx; q++) {
        if  (getBpars_NPRM(parsed->flag) && getBpars_NPRM(parsed->flag) <= nidx) ixvar |= 1;
        control = automa[state][CHCL];
        ifBLIN_QV4(flag) {
            int i, j, k;

            fprintf( stderr, "%08X %s ", control, statenames[control & C_state]);
            for (i = 0, j = control, k = 0; i < 24; i++, j <<= 1)
# ifdef ALLIGN_TABLE
                if  ((pn[i][0] != '-') || (j & 0x80000000))
                    fprintf( stderr, "%s ", (j & 0x80000000) ? pn[i] : "  ");
            fprintf( stderr, "%02X %s %s %08X %08X ~%s~\t"
# else
                if  (j & 0x80000000) {
                    fprintf( stderr, "%s ", pn[i]);
                    k++;
                };
            for (; k < 5; k++) fprintf( stderr, "   ");
            fprintf( stderr, "\t%02X %s %s %08X %08X\t%02X~"
# endif
                   , regsym
                   , clasnames[CHCL]
                   , statenames[state], (unsigned)p, (unsigned)q, *q
                   );
            for (i = 0; q[i] && strncmp(&q[i], end, strlen(end)); i++) fprintf(stderr, "%c", q[i]);
            fprintf(stderr, "~\n");
        }
        if  (control & Ca) {
            regsym = (regsym << 3) + (*q - '0');
            if  (*q > '7') control |= Ce;
        }
        if  (control & Cr) {
            *p++ = regsym;
            ifOVER control = Cl | dx;
        }
        if  (control & Ct) {
            const u_char *t = recode[*q];
            while (*t) {
                *p++ = *t++;
                ifOVER {
                    control = Cl | dx;
                    break;
        }   }   }
        if  (control & Cw) {
            int i, j;
            u_char *c, *d;

            for (i = 0; environ && environ[i]; i++) {
                for ( c = environ[i], d = regvar, j = 1
                    ; *c != '=' && *c && *d && d < q && *c == *d
                    ; c++, d++
                    );
                if  (*c == '=' && d == q) {
                    ifBLIN_QV5(flag) fprintf(stderr, "%s\n", environ[i]);
                    while (*++c) {
                        *p++ = *c;
                        ifOVER {
                            control = Cl | dx;
                            break;
                    }   }
                    break;
        }   }   }
        if  (control & Cz && l && !strncmp(q, end, l)) {
            /*   */
            q += --l;
            control &= Cy;
            control |= Cq | sc;
            if  (!(flag & Bpars_XXLN)) control |= Cx;
        }
        if  (control & Cp) {
            if  (nidx == 0 && !(p = malloc(sizeof(u_char) * argmax))) {
                free(parsed->argv);
                free(parsed);
                errno = ENOMEM;
                ifBLIN_QV1(flag) warn("babolo_getparm #3");
                break;
            }
            parsed->flag |= Bpars_CHNK;
            parsed->argv[nidx++] = p;
            if  (nidx >= argnmax) control |= Cl | Cx;
        }
        if  (control & Cq && nidx) {
            *p++ = '\0';
            ifOVER control = Cl | dx;
        }
        if  (control & Cv) regvar = q;
        if  (control & Cc) regsym = 0;
        if  (control & Cn) {
            *p++ = *q;
            ifOVER control = Cl | dx;
        }
        if  (control & (Ce | Cl)) {
            free(*parsed->argv);
            free(parsed->argv);
            free(parsed);
            parsed = NULL;
            errno = (control & Cl) ? E2BIG : EINVAL;
            ifBLIN_QV1(flag) warn("babolo_getparm");
            break;
        }
        if  (control & Cy && flag & Bpars_XXCN) {
            ((babolo_parm1*)parsed)->cntr++;
        }
        if  (control & Cx) {
            parsed->argv[nidx] = NULL;
            q++;
            break;
        }
        state = control & C_state;
    }
    *in = q;
    if  (parsed) {
        parsed->argc = nidx;
        ifBLIN_QV4(flag) fprintf(stderr, "-babolo_getparm flag=%08X argc=%d\n", flag, parsed->argc);
    } else ifBLIN_QV4(flag) fprintf(stderr, "-babolo_getparm flag=%08X -\n", flag);
    return(parsed);
}

babolo_parm *
babolo_getparm(u_int32_t flag, u_char **in, const u_char *end) {
    return(babolo_getparm1(flag & ~Bpars_ABSQ, in, end, 0));
}
