/*-
 * Copyright (C)2006,2007 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2006 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: getord.c,v 1.6 2007/07/20 20:23:42 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <stdio.h>
#include <babolo/BLINflag.h>
#include "parser.h"

static u_int32_t ofm[] = {0x00000000, 0x000000FF, 0x0000FFFF, 0x00FFFFFF, 0xFFFFFFFF};

static u_int32_t
reconstruct(const babolo_lexor *lext, size_t *lexind) {
    u_int32_t i, e;

    for (i = 0, e = 0; i < lext->szp; e += lext->lexgraf[(*lexind)++] << (8 * i++));
    ifBLIN_QV6(lext->flag) fprintf(stderr, "  %08X <= %08X ?\n", e, lext->szz);
    if  (e <= lext->szz) {
        if  (!(lext->flag & Bpars_AABS)) e += (lext->szp + *lexind) / (lext->szp + 1);
        ifBLIN_QV6(lext->flag) fprintf(stderr, "Y %08X\n", e);
    } else {
        e |= ~ofm[lext->szp];
        ifBLIN_QV6(lext->flag) fprintf(stderr, "N %08X |%08X\n", e, ~ofm[lext->szp]);
    }
    return(e);
}

u_int32_t
babolo_testchar(const babolo_lexor *lext, u_int32_t state, const u_char **next) {
    size_t lexind, e = ~0;
    u_char nxch, c;
    size_t n;
    int found;

    ifBLIN_QV4(lext->flag) fprintf( stderr
                                  , "+babolo_testchar flag=%06X state=%d next=%02X(%c)\n"
                                  , lext->flag
                                  , state
                                  , **next, **next
                                  );
    nxch = (lext->retable) ? lext->retable[**next] : **next;
    if  (state < lext->szt) {
        lexind = (lext->szp + 1) * state;
        found = 0;
        for (n = lext->lexgraf[lexind++] + 1; n > 0; n--) {
            c = lext->lexgraf[lexind++];
            ifBLIN_QV5(lext->flag) fprintf(stderr, "i%d %02X(%c)\n", n, c, c);
            if  (c == nxch) {
                e = reconstruct(lext, &lexind);
                (*next)++;
                found = 1;
                break;
            } else {
                lexind += lext->szp;
        }   }
        if  (!found) {
            e = reconstruct(lext, &lexind);
            if  (e < lext->szt) {
                if  (!(lext->flag & Bpars_CMID)) (*next)++;
            } else {
                if  (lext->flag & Bpars_CEND) (*next)++;
    }   }   }
    ifBLIN_QV4(lext->flag) fprintf(stderr, "-babolo_testchar %d next=%02X\n", e, nxch);
    return(e);
}

static u_int32_t
babolo_weakchar(const babolo_lexor *lext, u_int32_t state) {
    size_t lexind, e = ~0;
    size_t n;

    ifBLIN_QV4(lext->flag)
        fprintf( stderr, "+babolo_weakchar flag=%06X state=%d\n", lext->flag, state);
    if  (state < lext->szt) {
        lexind = (lext->szp + 1) * state;
        n = lext->lexgraf[lexind++] + 1;
        lexind += (lext->szp + 1) * n;
        e = reconstruct(lext, &lexind);
    }
    ifBLIN_QV4(lext->flag) fprintf(stderr, "-babolo_weakchar %d [%d]\n", e, lexind);
    return(e);
}

u_int32_t
babolo_testword(const babolo_lexor *lext, const u_char *word) {
    u_int32_t i, j = 0, k, o, q = (lext->szt + 3) / 2;
    const u_char *v;

    ifBLIN_QV4(lext->flag) fprintf(stderr, "+babolo_testword %s~\n", word);
    for (i = 0, o = q, v = word; i < lext->szt; i = babolo_testchar(lext, i, &word), o--) {
        if  (v != word) {
            o = q;
            v = word;
        } else if (!o) {
            i = ~0;
            j = 0;
            ifBLIN_QV2(lext->flag) fprintf(stderr, "babolo_testword: infinite loop %u\n", q);
            break;
        }
        k = babolo_weakchar(lext, i);
        if  (k >= lext->szt && ~k) {
            j = ~k;
            ifBLIN_QV5(lext->flag) fprintf(stderr, "Reserve %u\n", j);
    }   }
    k = ~i;
    if  (!k) {
        k = j;
        ifBLIN_QV5(lext->flag) fprintf(stderr, "Reserved %u\n", k);
    }
    ifBLIN_QV4(lext->flag) fprintf(stderr, "-babolo_testword %d\n", k);
    return(k);
}

u_int32_t
babolo_goword(const babolo_lexor *lext, const u_char **word) {
    u_int32_t i, j = 0, k, o, q = (lext->szt + 3) / 2;
    const u_char *v, *w = NULL;

    ifBLIN_QV4(lext->flag) fprintf(stderr, "+babolo_goword %s~\n", *word);
    for (i = 0, o = q, v = *word; i < lext->szt; i = babolo_testchar(lext, i, word), o--) {
        if  (v != *word) {
            o = q;
            v = *word;
        } else if (!o) {
            i = ~0;
            j = 0;
            ifBLIN_QV2(lext->flag) fprintf(stderr, "babolo_goword: infinite loop %u\n", q);
            break;
        }
        k = babolo_weakchar(lext, i);
        if  (k >= lext->szt && ~k) {
            j = ~k;
            w = *word;
            ifBLIN_QV5(lext->flag) fprintf(stderr, "Reserve %u\n", j);
    }   }
    k = ~i;
    if  (!k && j) {
        k = j;
        *word = w;
        ifBLIN_QV5(lext->flag) fprintf(stderr, "Reserved %u\n", k);
    }
    ifBLIN_QV4(lext->flag) fprintf(stderr, "-babolo_goword %d\n", k);
    return(k);
}

void
babolo_treedump(const babolo_lexor *lext) {
    u_int32_t lexind, j, k, m, e, n;
    u_char c;

    m = 0;
    lexind = 0;
    k = 0;
    for (;;) {
        n = lext->lexgraf[lexind++] + 1;
        fprintf(stderr, "[%2u]", k);
        for (j = 0; j < n; j++) {
            if  (lexind > (lext->szp + 1) * lext->szt) {
                fprintf(stderr, "Premature end\n");
                return;
            }
            c = lext->lexgraf[lexind++];
            if  (c >= ' ' && c < 127) fprintf(stderr, "   (%c)%02X", c, c);
              else fprintf(stderr, "      %02X", c);
            e = reconstruct(lext, &lexind);
            if  (m < e && e < lext->szt) m = e;
            if  (e < lext->szt) fprintf(stderr, "%c%2u", (e > (k + j)) ? '.' : '!', e);
              else fprintf(stderr, "%c~%u", (e > (k + j)) ? '.' : '!', ~e & ofm[lext->szp]);
        }
        e = reconstruct(lext, &lexind);
        if  (m < e && e < lext->szt) m = e;
        k += n + 1;
        if  (e < lext->szt) fprintf(stderr, "   *%c%2u\n", (e >= k) ? '.' : '!', e);
          else fprintf(stderr, "   *%c~%u\n", (e >= k) ? '.' : '!', ~e & ofm[lext->szp]);
        if  (k >= lext->szt) break;
        if  (k > m) fprintf(stderr, "No way\n");
    }
    if  (m >= lext->szt) fprintf(stderr, "Link out\n");
}
