/*-
 * Copyright (C)2006,2007 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: lexor.h,v 1.5 2007/07/22 11:41:53 babolo Exp $
 */

/******************************************************************************************************
 *                                                                                                    *
 * lexor  run1        C,                                  *
 *   cc     ,                                     *
 *         .                                   *
 *     C,    run3                                *
 * ,   run4 ,                                          *
 *    .h  .c  C.                                                                       *
 *                                                                                                    *
 *     .h ,   , ,                                  *
 *     .h   .                                      *
 *     2 ,                                      *
 *      , typedef  ,                               *
 *       .h ,                              *
 * lexor.    .lexor    .                                      *
 *     2                                          *
 *  .   .lexor    '# INCLUDES',                                       *
 *     '# BALEX BEGIN',                                           *
 * .lexor    '# INCLUDES'   .                                    *
 *       .c  .                                               *
 *        runparm.ininc.                                          *
 *                                                                                                    *
 *   '# INCLUDES'  '# BALEX BEGIN',                                         *
 * '# INCLUDES',    .lexor   '# BALEX BEGIN'                               *
 *  .     .c ( .h)                                       *
 * " ".   .c                                               *
 * , typedef, #include  ..                                                         *
 *        runparm.incopy.                                         *
 *                                                                                                    *
 *        2                                  *
 * :                                                                                           *
 *     -        babolo_lexor;                                  *
 *           ,                                        *
 *          . ,  'static extern eee'                                   *
 *        'static extern babolo_lexor eee = { ... }'                                         *
 *     - ,   .  ,                                     *
 *          .                                                                   *
 *           runparm.intype,                       *
 *   runparm.inname,   runparm.inflag.                                                      *
 *                                                                                                    *
 *                                      *
 *  babolo_lexor   {},  ;                                      *
 *      babolo_lexor.retable                                    *
 *    .lexor .                                                                  *
 *        runparm.intrans.                                        *
 *                                                                                                    *
 * ,          ,                            *
 *    .                                                                       *
 *        runparm.imd.                                            *
 *                                                                                                    *
 *       .                                                      *
 *                                                                                                    *
 ******************************************************************************************************/

typedef struct {             /************************************************************/
    mife_descriptor  *iffed; /*        */
    char     *oufn;          /*                                         */
    size_t    ccl;           /*                                  */
    u_int32_t flag;          /*  ccbin.flag                                         */
} runparm;                   /************************************************************/

typedef struct {             /************************************************************/
    mular_descriptor *imd;   /*     : , ,    */
    const char *ininc;       /*  ,     cc      */
    size_t      lninc;
    const char *incopy;      /* ,      cc,    */
    size_t      lncopy;
    const char *intype;      /*     babolo_lexor              */
    size_t      lntype;
    const char *inname;      /*   babolo_lexor                            */
    const char *inflag;      /*    babolo_lexor                        */
    const char *intrans;     /*     babolo_lexor           */
    size_t      lntrans;
    char       *infn;        /*                                          */
    char       *ccname;      /*   (cc)                                     */
    char      **ccarg;       /*   (cc)                               */
    size_t      ccarp;       /*     (cc)                     */
    int         pip2[2];     /*      cc             */
    int         fil1;        /*     cc                                */
} run12parm;                 /************************************************************/

typedef enum {e_Z, e_C, e_D, e_E} eSKA;

/******************************************************************************************************
 *                                                                                                    *
 *      ,     .                                   *
 *  3   ,                                       *
 * .                                        *
 *  ,      ,                                     *
 *          -                                    *
 * .       babolo-parser,                                     *
 *                                             *
 *  ,   ( ).                                          *
 *                                                                                                    *
 * 3  - .                                                                                *
 * 2  -  .                                                                       *
 * 1 ,  ,   ,                                     *
 *       .                                         *
 *      '0'  '7',    \000  \007                                         *
 *    ,    '0',                                   *
 *            3 ,                                *
 *     \000                                          *
 *          3 .                                                  *
 *                                                                                                    *
 *       3    1                                          *
 *     ,                                            *
 *     .                                                               *
 *                                                                                                    *
 *          .                              *
 *     '#'    .                                   *
 *                                                                                                    *
 ******************************************************************************************************/

typedef ssize_t treei;
typedef ssize_t treew;

typedef struct {     /***************************************************************/
    struct {         /*    *****************************                            */
        u_int32_t flag;   /*              *                            */
        u_int32_t count;  /*     *                            */
        u_char    t[256]; /*          *                            */
        u_int32_t v[1];   /*       *                            */
    }        *ibin;  /*        cc                     */
    u_char   *fbin;  /*                                     */
    u_char   *cbin;  /*                                               */
    size_t    m;     /*                                           */
    size_t    maxw;  /*                            */
    treew     maxl;  /*   babolo_lexor.szt:  babolo_lexor.lexgraf */
    treew     t;     /*   babolo_lexor.szz:                    *
                      *    babolo_lexor.lexgraf                  */
    int       p;     /*   babolo_lexor.szp:         */
    FILE     *o;     /*                                                 */
    u_int32_t ll;    /*                              */
} ccbin;             /***************************************************************/

/******************************************************************************************************
 *                                                                                                    *
 *     :                                                                      *
 * +-------+  +-------+  +-------+                                                                    *
 * |v|w|d|s|->|v|w|0|s|->|v|w|d|0|                                                                    *
 * +-------+  +-------+  +-------+                                                                    *
 *      |                     |                                                                       *
 *      |                     V                                                                       *
 *      V                  +-------+  +-------+                                                       *
 *   +-------+  +-------+  |v|w|d|s|->|v|w|0|0|                                                       *
 *   |v|w|d|s|->|v|w|d|0|  +-------+  +-------+                                                       *
 *   +-------+  +-------+       |                                                                     *
 *        |          |          V                                                                     *
 *        V          V       +-------+                                                                *
 *     +-------+  +-------+  |v|w|0|0|                                                                *
 *     |v|w|0|0|  |v|w|0|0|  +-------+                                                                *
 *     +-------+  +-------+                                                                           *
 *  v -  ()                                                                           *
 *     w -                                                                                         *
 *     s -   (       )                          *
 *     d -   ( ())                                                           *
 *                                                                                                    *
 ******************************************************************************************************/

typedef struct {
    treei  *trees; /*                                */
    treei  *treed; /*   ( finedump_tree  )  */
    treew  *treew; /*                                  */
    u_char *treev; /*   ( )          */
    treei   treep; /*      */
    treei   treem; /*           */
} tree;

#define TREE(A, B) (tree->tree##A[B])
#define TRIS(A) ((A) > 0)
