/*-
 * Copyright (C)2006,2007 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2006 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: lexor.c,v 1.10 2007/07/28 18:51:00 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/wait.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <err.h>
#include <mife.h>
#include <multilar.h>
#include <babolo/BLINflag.h>
#include "../parser.h"
#include "lexor.h"

/************************
 *   *
 ************************/

static babolo_lexor qvv =
{ NULL, NULL, Bpars_AABS | Bpars_CEND, 78, 78, 1
,{/* 00 */   0,  '-', 2,                              ~0
 ,/* 02 */   2,  'q', 6,  'v',16,  'f',50,            ~0
 ,/* 06 */   3,  'q', 6,  'v',11,  'f',46,   0 ,~ 1,  ~0
 ,/* 11 */   3,  'q', 6,  'v',16,  'f',50,   0 ,~ 2,  ~0
 ,/* 16 */   3,  'q', 6,  'v',21,  'f',54,   0 ,~ 3,  ~0
 ,/* 21 */   3,  'q', 6,  'v',26,  'f',58,   0 ,~ 4,  ~0
 ,/* 26 */   3,  'q', 6,  'v',31,  'f',62,   0 ,~ 5,  ~0
 ,/* 31 */   3,  'q', 6,  'v',36,  'f',66,   0 ,~ 6,  ~0
 ,/* 36 */   3,  'q', 6,  'v',41,  'f',70,   0 ,~ 7,  ~0
 ,/* 41 */   3,  'q', 6,  'v',41,  'f',74,   0 ,~ 8,  ~0
 ,/* 46 */   2,  'q',46,  'v',50,            0 ,~ 9,  ~0
 ,/* 50 */   2,  'q',46,  'v',54,            0 ,~10,  ~0
 ,/* 54 */   2,  'q',46,  'v',58,            0 ,~11,  ~0
 ,/* 58 */   2,  'q',46,  'v',62,            0 ,~12,  ~0
 ,/* 62 */   2,  'q',46,  'v',66,            0 ,~13,  ~0
 ,/* 66 */   2,  'q',46,  'v',70,            0 ,~14,  ~0
 ,/* 70 */   2,  'q',46,  'v',74,            0 ,~15,  ~0
 ,/* 74 */   2,  'q',46,  'v',74,            0 ,~16,  ~0
}};

static int
/*****************************************************************************************************/
argrun(runparm *r, run12parm *r2, int argc, char **argv) {
/*****************************************************************************************************
 *                                                       *
 *****************************************************************************************************/
    int ex = EX_OK;
    size_t iarp = 1;

    ifBLIN_QV5(r->flag) fprintf(stderr, "+argrun\n");
    /**************************************
     *   -   -qv *
     **************************************/
    if  (iarp < argc) {
        u_int32_t i;
        i = babolo_testword(&qvv, argv[iarp]);
        if  (i--) {
            setBLIN_VERMASK(r->flag, ~(0xFF << (i & 7)));
            if  (i & 8) r->flag |= Bpars_AABS;
            iarp++;
    }   }
#if 0
    bylex.flag &= ~BLIN_VERMASK;
    bylex.flag |= r->flag & BLIN_VERMASK;
    bytree.flag &= ~BLIN_VERMASK;
    bytree.flag |= r->flag & BLIN_VERMASK;
#endif
    ifBLIN_QV5(r->flag) {
        fprintf(stderr, "qvv:\n");
        babolo_treedump(&qvv);
    }

    r2->ccname = "cc";
    if  (iarp < argc) {
        /**********************************
         *       *
         *   ccname         *
         **********************************/
    }
    /*****************************************
     *   ,        *
     *    ,   *
     *    cc      *
     *****************************************/
    if  (!(r2->ccarg = malloc(sizeof(*(r2->ccarg)) * (argc + 8)))) {
        ifBLIN_QV1(r->flag) warn("malloc for args");
        ex = EX_TEMPFAIL;
    } else {
        r2->ccarp = 0;
        r2->ccarg[r2->ccarp++] = r2->ccname;
        for (; iarp < argc - 1 && argv[iarp];) {
            if  (strcmp(argv[iarp], "-o")) {
                r2->ccarg[r2->ccarp++] = argv[iarp++];
            } else {
                iarp++;
                r->oufn = argv[iarp++];
        }   }
        if  (iarp == argc - 1) {
            r2->infn = argv[iarp++];
        }
        r2->ccarg[r2->ccarp++] = "-pipe";
        r2->ccarg[r2->ccarp++] = "-nostdlib";
        r2->ccarg[r2->ccarp++] = "-Wl,--oformat=binary,--entry=e";
        r2->ccarg[r2->ccarp++] = "-o";
        r2->ccarg[r2->ccarp++] = "/dev/stdout";
        r2->ccarg[r2->ccarp] = NULL;
        ifBLIN_QV2(r->flag) {
            u_int32_t i;
            for (i=0; r2->ccarg[i] && i < r2->ccarp; i++) fprintf(stderr, "%d=%s~\n", i, r2->ccarg[i]);
            fprintf(stderr, "in=%s~\nout=%s~\n", r2->infn, r->oufn);
    }   }
    ifBLIN_QV5(r->flag) fprintf(stderr, "-argrun %d\n", ex);
    return(ex);
}   /* argrun */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                     **
 *****************************************************************************************************
 *****************************************************************************************************/

static babolo_lexor bylex =
{ NULL, NULL, Bpars_AABS | Bpars_CEND, 53, 53, 1
,{/* 00 */   1,  '#', 6, '\n',~1,                    3
 ,/* 03 */   1, '\n',~1, '\0',~0,                    3
 ,/* 06 */   2,  ' ', 6, '\t', 6,  'L',10,           3
 ,/* 10 */   0,  'E',12,                             3
 ,/* 12 */   0,  'X',14,                             3
 ,/* 14 */   0,  'O',16,                             3
 ,/* 16 */   0,  'R',18,                             3
 ,/* 18 */   3,  ' ',18, '\t',18,  'B',23,  'I',36,  3
 ,/* 23 */   0,  'E',25,                             3
 ,/* 25 */   0,  'G',27,                             3
 ,/* 27 */   0,  'I',29,                             3
 ,/* 29 */   0,  'N',31,                             3
 ,/* 31 */   3,  ' ',31, '\t',31, '\n',~3, '\0',~0,  3
 ,/* 36 */   0,  'N',38,                             3
 ,/* 38 */   0,  'C',40,                             3
 ,/* 40 */   0,  'L',42,                             3
 ,/* 42 */   0,  'U',44,                             3
 ,/* 44 */   0,  'D',46,                             3
 ,/* 46 */   0,  'E',48,                             3
 ,/* 48 */   3,  ' ',48, '\t',48, '\n',~2, '\0',~0,  3
}};

static babolo_lexor bytree =
{"0000""0000""3200""0000"
 "0000""0000""0000""0000"
 "3000""4000""4440""1000"
 "4444""4444""4400""0000"

 "0444""4444""4444""4444"
 "4444""4444""4444""0404"
 "0444""4444""4444""4444"
 "4444""4444""4440""0000"

 "0000""0000""0000""0000"
 "0000""0000""0000""0000"
 "0000""0000""0000""0000"
 "0000""0000""0000""0000"

 "0000""0000""0000""0000"
 "0000""0000""0000""0000"
 "0000""0000""0000""0000"
 "0000""0000""0000""0000"
, NULL, Bpars_AABS | Bpars_CEND, 10, 10, 1
,{/* 00 */   3,  '1',~3,  '2',~2,  '3', 0,  '4', 5,  ~0
 ,/* 05 */   3,  '1',~7,  '2',~6,  '3',~4,  '4', 5,  ~0
}};

static int
/*****************************************************************************************************/
run1(runparm *r, run12parm *r2) {
/*****************************************************************************************************
 *                                                                                 *
 *****************************************************************************************************/
    int ex = EX_OK;
    size_t inlen, line;
    char *inwent;
    u_char *ingo;
    babolo_parm1 *parm;
    size_t s[] = {1024, 512, 512};

    ifBLIN_QV5(r->flag) {
        fprintf(stderr, "+run1\n");
        fprintf(stderr, "bylex:\n");
        babolo_treedump(&bylex);
        fprintf(stderr, "bytree:\n");
        babolo_treedump(&bytree);
    }
    /**********************************
     *      *
     **********************************/
    if  (!(r->iffed = mife_open(MIFE_FULL, r2->infn))) {
        ifBLIN_QV1(r->flag) warn("in mife open");
        ex = EX_NOINPUT;
    } else if ((inlen = mife_read(r->iffed, 0, 0)) < 0) {
        ifBLIN_QV1(r->flag) warn("in mife read");
        ex = EX_IOERR;
    } else if (!(ingo = mife_get(r->iffed, 0))) {
        ifBLIN_QV1(r->flag) warn("in mife get");
        ex = EX_NOINPUT;
    } else {
        /*******************************
         *     *
         *******************************/
        r2->incopy = inwent = ingo;
        r2->ininc = NULL;
        r2->lncopy = 1;
        r2->lninc = line = 0;
        for (;; inwent = ingo) {
            u_int32_t i;
        ;   if  ((char*)ingo > ((char*)mife_get(r->iffed, 0) + inlen - 12)) {
        ;       ifBLIN_QV1(r->flag) warnx("No work #0");
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   }
        ;   i = babolo_goword(&bylex, (const u_char **)&ingo);
        ;   line++;
        ;   if  (i == 0) {
        ;       ifBLIN_QV1(r->flag) warnx("No work #1");
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   } else if (i == 2) {
        ;       r2->ininc = r2->incopy;
        ;       r2->lninc = r2->lncopy;
        ;       r2->lncopy = line + 1;
        ;       *inwent = '\0';
        ;       r2->incopy = ingo;
        ;   } else if (i == 3) {
        ;       break;
        }   }
        *inwent = '\0';
        ifBLIN_QV2(r->flag) {
        ;   if  (r2->ininc) fprintf(stderr, "@%u ininc=%s~\n", r2->lninc, r2->ininc);
        ;   if  (r2->incopy) fprintf(stderr, "@%u incopy=%s~\n", r2->lncopy, r2->incopy);
        }
        /************************
         *    *
         ************************/
        line++;
        r2->lntype = 0;
        r2->intype = NULL;
        r2->inname = NULL;
        r2->inflag = NULL;
        for (inwent = ingo;;inwent = ingo) {
            u_int32_t i;
        ;   i = babolo_goword(&bytree, (const u_char **)&ingo);
        ;   if  (!i) {
        ;       ifBLIN_QV1(r->flag) warnx("No work #2");
        ;       ex = EX_DATAERR;
        ;       goto out;
        ;   } else if (i & 4) {
        ;       if (!r2->intype) r2->intype = r2->inname;
        ;       r2->inname = inwent;
        ;       r2->lntype = line;
        ;   }
        ;   if  (i & 2) {
        ;       if  (!r2->inname) {
        ;           ifBLIN_QV1(r->flag) warnx("Line %u: No name for babolo_lexor structure", line);
        ;           ex = EX_DATAERR;
        ;           goto out;
        ;       }
        ;       if  (r2->intype) *(inwent - 1) = '\0';
        ;       *(ingo - 1) = '\0';
        ;       if  (i & 1) {
        ;           r2->inflag = ingo;
        ;           ingo = strpbrk(ingo, "\n");
        ;           if  (ingo && *ingo == '\n') {
        ;               *(ingo++) = '\0';
        ;           } else {
        ;               ifBLIN_QV1(r->flag) warnx("No babolo_lexor flag");
        ;               ex = EX_DATAERR;
        ;               goto out;
        ;       }   }
        ;       break;
        }   }
        ifBLIN_QV2(r->flag) {
        ;   if  (r2->intype) fprintf(stderr, "@%u intype=%s~\n", r2->lntype, r2->intype);
        ;   if  (r2->inname) fprintf(stderr, "@inname=%s~\n", r2->inname);
        ;   if  (r2->inflag) fprintf(stderr, "@inflag=%s~\n", r2->inflag);
        }
        if  (!r2->inname) {
        ;   ifBLIN_QV1(r->flag) warnx("Line %u: No name for babolo_lexor structure", line);
        ;   ex = EX_DATAERR;
        ;   goto out;
        }
        line++;
        /*********************************
         *    *
         *********************************/
        if  (*ingo != '\n') {
            size_t b;
        ;   r2->intrans = ingo;
        ;   r2->lntrans = line;
        ;   for (b = 0; b < 2; ingo++) {
        ;       if  (!ingo) {
        ;           ifBLIN_QV1(r->flag) warnx("Not found words for coding");
        ;           ex = EX_DATAERR;
        ;           goto out;
        ;       }
        ;       if  (*ingo == '\n') {
        ;           ++b;
        ;           line++;
        ;       } else {
        ;           b = 0;
        ;   }   }
        ;   ingo[-2] = '\0';
        } else {
        ;   r2->intrans = NULL;
        ;   r2->lntrans = line;
        ;   ingo++;
        }
        ifBLIN_QV2(r->flag) {
        ;   if  (r2->intrans) fprintf(stderr, "@%u intrans=%s~\n", r2->lntrans, r2->intrans);
        }

        /**************************
         *    *
         **************************/
        if  (!(r2->imd = mular_create(MULAR_STRI|MULAR_HEXU, 3, 0, s))) {
        ;   ifBLIN_QV1(r->flag) warn("#3");
        ;   ex = EX_SOFTWARE;
        ;   goto out;
        }
        r2->imd->tofree = (void*)babolo_freeparm;
        for (;*ingo && ingo < (u_char*)mife_get(r->iffed, 0) + inlen;) {
        ;   if  (*ingo == '#') {
        ;       ingo = strpbrk(ingo, "\n");
        ;       if  (ingo && *ingo == '\n') {
        ;           ingo++;
        ;           line++;
        ;       }
        ;   } else {
                size_t b;
        ;       parm = (babolo_parm1*)babolo_getparm( Bpars_FIXB
                                                    | Bpars_NOEN
                                                    | Bpars_LFLN
                                                    | Bpars_XXCN
                                                    | kukBpars_NPRM(4)
                                                    , (u_char**)&ingo, ""
                                                    );
        ;       b = line;
        ;       line += parm->cntr;
        ;       parm->cntr = b;
        ;       if  (parm->argc > 1) {
                    babolo_parm1 **p;
        ;           ifBLIN_QV2(r->flag) {
        ;               fprintf( stderr, "%u..%u 0=%s~ 1=%s~"
                               , line - parm->cntr, line, parm->argv[0], parm->argv[1]
                               );
        ;               if  (parm->argc > 2) fprintf(stderr, " 2=%s~", parm->argv[2]);
        ;               if  (parm->argc > 3) fprintf(stderr, " 3=%s~", parm->argv[3]);
        ;               fprintf(stderr, "\n");
        ;           }
        ;           if  (!(p = mular_add(r2->imd))) {
        ;               ifBLIN_QV1(r->flag) warn("#4");
        ;               ex = EX_SOFTWARE;
        ;               goto out;
        ;           }
        ;           *p = parm;
        ;       } else {
        ;           babolo_freeparm((babolo_parm*)parm);
        }   }   }
        ifBLIN_QV5(r->flag) mular_dump(r2->imd, stderr);
    }
out:if  (ex) {
        if  (r->iffed) mife_close(r->iffed);
        r->iffed = NULL;
        if  (r2->imd) mular_destroy(r2->imd);
        r2->imd = NULL;
    }
    ifBLIN_QV5(r->flag) fprintf(stderr, "-run1 %d\n", ex);
    return(ex);
}   /* run1 */

/*****************************************************************************************************
 *   run1                                                                       *
 *****************************************************************************************************/

static u_char equ[] = 
 "{ 0000,0001,0002,0003, 0004,0005,0006,0007, 0010,0011,0012,0013, 0014,0015,0016,0017\n"
" , 0020,0021,0022,0023, 0024,0025,0026,0027, 0030,0031,0032,0033, 0034,0035,0036,0037\n"
" , 0040,0041,0042,0043, 0044,0045,0046,0047, 0050,0051,0052,0053, 0054,0055,0056,0057\n"
" , 0060,0061,0062,0063, 0064,0065,0066,0067, 0070,0071,0072,0073, 0074,0075,0076,0077\n"
" , 0100,0101,0102,0103, 0104,0105,0106,0107, 0110,0111,0112,0113, 0114,0115,0116,0117\n"
" , 0120,0121,0122,0123, 0124,0125,0126,0127, 0130,0131,0132,0133, 0134,0135,0136,0137\n"
" , 0140,0141,0142,0143, 0144,0145,0146,0147, 0150,0151,0152,0153, 0154,0155,0156,0157\n"
" , 0160,0161,0162,0163, 0164,0165,0166,0167, 0170,0171,0172,0173, 0174,0175,0176,0177\n"
" , 0200,0201,0202,0203, 0204,0205,0206,0207, 0210,0211,0212,0213, 0214,0215,0216,0217\n"
" , 0220,0221,0222,0223, 0224,0225,0226,0227, 0230,0231,0232,0233, 0234,0235,0236,0237\n"
" , 0240,0241,0242,0243, 0244,0245,0246,0247, 0250,0251,0252,0253, 0254,0255,0256,0257\n"
" , 0260,0261,0262,0263, 0264,0265,0266,0267, 0270,0271,0272,0273, 0274,0275,0276,0277\n"
" , 0300,0301,0302,0303, 0304,0305,0306,0307, 0310,0311,0312,0313, 0314,0315,0316,0317\n"
" , 0320,0321,0322,0323, 0324,0325,0326,0327, 0330,0331,0332,0333, 0334,0335,0336,0337\n"
" , 0340,0341,0342,0343, 0344,0345,0346,0347, 0350,0351,0352,0353, 0354,0355,0356,0357\n"
" , 0360,0361,0362,0363, 0364,0365,0366,0367, 0370,0371,0372,0373, 0374,0375,0376,0377\n"
" }";

static u_char eska[] =
{ e_Z, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  'b', 't', 'n', 'v',  'f', 'r', e_C, e_C
, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_D, e_D, e_E, e_D,  e_D, e_D, e_D, e_E,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D

, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_E, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_C

, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_D,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C
, e_C, e_C, e_C, e_D,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C,  e_C, e_C, e_C, e_C

, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
, e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D,  e_D, e_D, e_D, e_D
};

static int
intrfil1(runparm *r, run12parm *r2) {
    int ex = EX_OK;
    FILE *sto;
    u_int32_t i, j;
    babolo_parm1 **c;
    char *s;

    ifBLIN_QV5(r->flag) fprintf(stderr, "+intrfil1\n");
    if  (!(sto = fdopen(r2->fil1, "w"))) {
        ifBLIN_QV1(r->flag) warn("fdopen #110");
        ex = EX_IOERR;
    } else {
        if  (r2->ininc) fprintf(sto, "#line %u \"%s\"\n%s", r2->lninc, r2->infn, r2->ininc);
        if  (r2->incopy) fprintf(sto, "#line %u \"%s\"\n%s", r2->lncopy, r2->infn, r2->incopy);
        fprintf( sto, "struct {\n"
                      "    u_int32_t f;\n"
                      "    u_int32_t n;\n"
                      "    u_char t[256];\n"
                      "    u_int32_t v[%u];\n"
                      "    u_char e[%u];\n"
               , r2->imd->top.index, r2->imd->top.index
               );
        ifBLIN_QV3(r->flag) fprintf( stderr, "struct {\n"
                                             "    u_int32_t f;\n"
                                             "    u_int32_t c;\n"
                                             "    u_char t[256];\n"
                                             "    u_int32_t v[%u];\n"
                                             "    u_char e[%u];\n"
                                   , r2->imd->top.index, r2->imd->top.index
                                   );
#ifdef SEPA
        for (i = 0; (c = (mular_getix(r2->imd, i))); i++) {
            if  (((*c)->argc > 2) && ((*c)->argv) && ((*c)->argv[2])) {
                fprintf(sto, "    char w%d[%u];\n", i, strlen((*c)->argv[2]) + 1);
                ifBLIN_QV3(r->flag)
                    fprintf(stderr, "    char w%d[%u];\n", i, strlen((*c)->argv[2]) + 1);
            } else {
                fprintf(sto, "    char w%d[1];\n", i);
                ifBLIN_QV3(r->flag) fprintf(stderr, "    char w%d[1];\n", i);
        }   }
#else
        j = 0;
        for (i = 0; (c = (mular_getix(r2->imd, i))); i++) {
            if  (((*c)->argc > 2) && ((*c)->argv) && ((*c)->argv[2])) {
                j += strlen((*c)->argv[2]) + 1;
            } else {
                j += 1;
        }   }
        fprintf(sto, "    char w[%u];\n", j);
        ifBLIN_QV3(r->flag) fprintf(stderr, "    char w[%u];\n", j);
#endif
        fprintf(sto, "} e = \n");
        ifBLIN_QV3(r->flag) fprintf(stderr, "} e =\n");
        if  (r2->inflag) fprintf(sto, "{(%s)", r2->inflag);
          else fprintf(sto, "{0");
        ifBLIN_QV3(r->flag) {
            if  (r2->inflag) fprintf(stderr, "{(%s)", r2->inflag);
              else fprintf(stderr, "{0");
        }
        fprintf(sto, ",%u\n", r2->imd->top.index);
        ifBLIN_QV3(r->flag) fprintf(stderr, ",%u\n", r2->imd->top.index);
        if  (r2->intrans) {
            fprintf(sto, "#line %u \"%s\"\n,%s\n", r2->lntrans, r2->infn, r2->intrans);
            ifBLIN_QV3(r->flag)
                fprintf(stderr, "#line %u \"%s\"\n,%s\n", r2->lntrans, r2->infn, r2->intrans);
        } else {
            fprintf(sto, ",%s\n#line %u \"%s\"\n", (char*)equ, r2->lntrans + 1, r2->infn);
            ifBLIN_QV3(r->flag)
                fprintf(stderr, ",%s\n#line %u \"%s\"\n", (char*)equ, r2->lntrans + 1, r2->infn);
        }
        s = ",{";
        for (i = 0; (c = (mular_getix(r2->imd, i))); i++) {
            fprintf(sto, "%s%s", s, (*c)->argv[1]);
            ifBLIN_QV3(r->flag) fprintf(stderr, "%s%s", s, (*c)->argv[1]);
            s = ",";
        }
        fprintf(sto, "}\n");
        ifBLIN_QV3(r->flag) fprintf(stderr, "}\n");
        s = ",{";
        for (i = 0; (c = (mular_getix(r2->imd, i))); i++) {
            if  ((*c)->argv[0]) {
                fprintf(sto, "%s%d", s, (*c)->argv[0][0]);
                ifBLIN_QV3(r->flag) fprintf(stderr, "%s%d", s, (*c)->argv[0][0]);
            } else {
                fprintf(sto, "%s0", s);
                ifBLIN_QV3(r->flag) fprintf(stderr, "%s0", s);
            }
            s = ",";
        }
        fprintf(sto, "}\n");
        ifBLIN_QV3(r->flag) fprintf(stderr, "}\n");
        s = ",\"";
        for (i = 0; (c = (mular_getix(r2->imd, i))); i++) {
            fprintf(sto, "#line %u \"%s\"\n", (*c)->cntr, r2->infn);
            ifBLIN_QV3(r->flag) fprintf(stderr, "#line %u \"%s\"\n", (*c)->cntr, r2->infn);
#ifdef SEPA
            fprintf(sto, ",\"");
            ifBLIN_QV3(r->flag) fprintf(stderr, ",\"");
#else
            fprintf(sto, "%s", s);
            ifBLIN_QV3(r->flag) fprintf(stderr, "%s", s);
#endif
            s = " \"";
            for (j = 0;; j++) {
                u_char u;
                u = 0;
                if  (((*c)->argc > 2) && ((*c)->argv) && ((*c)->argv[2])) u = (*c)->argv[2][j];
                if  (eska[u] == e_Z) break;
                switch (eska[u]) {
                 case e_C: fprintf(sto, "\\%03o", u);
                           ifBLIN_QV3(r->flag) fprintf(stderr, "\\%03o", u);
                           break;
                 case e_D: fprintf(sto, "%c", u);
                           ifBLIN_QV3(r->flag) fprintf(stderr, "%c", u);
                           break;
                 case e_E: fprintf(sto, "\\%c", u);
                           ifBLIN_QV3(r->flag) fprintf(stderr, "\\%c", u);
                           break;
                 default:  fprintf(sto, "\\%c", eska[u]);
                           ifBLIN_QV3(r->flag) fprintf(stderr, "\\%c", eska[u]);
                           break;
            }   }
#ifdef SEPA
            fprintf(sto, "\"\n");
            ifBLIN_QV3(r->flag) fprintf(stderr, "\"\n");
#else
            fprintf(sto, "\\0\"\n");
            ifBLIN_QV3(r->flag) fprintf(stderr, "\\0\"\n");
#endif
        }
        fprintf(sto, "};\n");
        ifBLIN_QV3(r->flag) fprintf(stderr, "};\n");
        if  (fclose(sto) < 0) {
            ifBLIN_QV1(r->flag) warn("close #111");
            ex = EX_IOERR;
    }   }
    ifBLIN_QV5(r->flag) fprintf(stderr, "-intrfil1 %d\n", ex);
    return(ex);
}   /* intrfil1 */

/*****************************************************************************************************
 *****************************************************************************************************
 **   -  cc                                                                   **
 *****************************************************************************************************
 *****************************************************************************************************/

static int
run2cc(runparm *r, run12parm *r2) {
    int ex2, ex = EX_OK;
    pid_t pid;
    int status;

    ifBLIN_QV5(r->flag) fprintf(stderr, "+run2cc\n");
    if  (pipe(r2->pip2)) {
        ifBLIN_QV1(r->flag) warn("pipe #2");
        ex = EX_OSERR;
    } else {
        ex2 = fork();
        ifBLIN_QV5(r->flag) fprintf(stderr, "fork %d\n", ex2);
        if  (ex2 < 0) {
            ifBLIN_QV1(r->flag) warn("fork #2");
            ex = EX_OSERR;
        } else if (ex2 == 0) {
            if  (close(r2->pip2[0]) < 0) {
                ifBLIN_QV1(r->flag) warn("close dup m#2");
                ex = EX_IOERR;
            } else if (dup2(r2->pip2[1], fileno(stdout)) < 0) {
                ifBLIN_QV1(r->flag) warn("cc stdout");
                ex = EX_IOERR;
            } else if (close(r2->pip2[1]) < 0) {
                ifBLIN_QV1(r->flag) warn("close #221");
                ex = EX_IOERR;
            } else {
                execvp(r2->ccname, r2->ccarg);
                ifBLIN_QV1(r->flag) warn("exec cc fail");
                ex = EX_UNAVAILABLE;
            }
            exit(ex);
        } else if (close(r2->pip2[1]) < 0) {
            ifBLIN_QV1(r->flag) warn("close #321");
            ex = EX_IOERR;
        } else if (!(r->iffed = mife_opef(0, r2->pip2[0]))) {
            ifBLIN_QV1(r->flag) warn("pipe mife");
            ex = EX_NOINPUT;
        } else {
            mular_destroy(r2->imd);
            mife_close(r->iffed);
            if  (!(r->iffed = mife_opef(0, r2->pip2[0]))) {
                ifBLIN_QV1(r->flag) warn("cc mife open");
                ex = EX_NOINPUT;
            } else if (((r->ccl = mife_read(r->iffed, 0, 0))) < 0) {
                ifBLIN_QV1(r->flag) warn("pipe mife read");
                ex = EX_IOERR;
            } else if ((pid = wait(&status)) < 0) {
                ifBLIN_QV1(r->flag) warn("wait");
                ex = EX_TEMPFAIL;
            } else if (pid != ex2) {
                ifBLIN_QV1(r->flag) warn("wait pid");
                ex = EX_SOFTWARE;
            } else if (!WIFEXITED(status)) {
                ifBLIN_QV1(r->flag) warn("wait exit");
                ex = EX_TEMPFAIL;
            } else {
                ex = WEXITSTATUS(status);
    }   }   }
    ifBLIN_QV5(r->flag) fprintf(stderr, "-run2cc %d\n", ex);
    return(ex);
}   /* run2cc */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                     **
 *****************************************************************************************************
 *****************************************************************************************************/

static treei
createnode(tree *tree) {
    treei newnode;
    if  (++(tree->treep) > tree->treem) {
        newnode = 0;
    } else {
        newnode = tree->treep;
        tree->trees[newnode] = ~0;
        tree->treed[newnode] = ~0;
        tree->treew[newnode] = 0;
        tree->treev[newnode] = 0;
    }
    return(newnode);
}

static int
buildtree(runparm *r, tree *tree, ccbin *ls) {
    int ex = EX_OK;
    size_t n, k;
    treei treei, treen;
    int f = 0;

    /******************************************************
     * k -                       *
     * n -                       *
     * treen -        *
     ******************************************************/
    for (k = 0, n = 0, treen = 0; n < ls->ibin->count;) {
        if  (k >= ls->m) {
            ifBLIN_QV1(r->flag) warnx("Truncated ls");
            ex = EX_USAGE;
            break;
        }
        /*****************************************************
         *        . *
         *   \0,     ...  *
         *    -     ,     *
         *   ,   .        *
         *    ,       *
         * ""     f,   *
         *   ,     *
         *      .            *
         *****************************************************/
        if  (f) f = 0; else if (!(ls->cbin[k]) && (ls->fbin[n] >= '0')) f++;
        ifBLIN_QV5(r->flag)
            fprintf(stderr, "[%2d]%02X [%2d]%02X %d\n", k, ls->cbin[k], n, ls->fbin[n], f);
        if  (!(ls->cbin[k]) && !f) {
            /*      */
            if  (!TRIS(TREE(d, treen))) {
                /*     down  */
                TREE(d, treen) = ~(ls->ibin->v[n]);
            } else {
                /* down  ,     side       */
                treei = TREE(d, treen);
                while (TRIS(TREE(s, treei))) treei = TREE(s, treei);
                TREE(d, treei) = ~(ls->ibin->v[n]);
            }
            treen = 0;
            n++;
        } else if (!TRIS(TREE(d, treen))) {
            /*   down     ,  */
            if  (!TRIS(treei = createnode(tree))) {
                ex = EX_SOFTWARE;
                break;
            }
            TREE(s, treei) = TREE(d, treen);
            TREE(d, treen) = treei;
            treen = treei;
            TREE(v, treen) = f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]];
        } else {
            /*     side  */
            treen = TREE(d, treen);
            while (TREE(v, treen) != (f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]])) {
                if  (!TRIS(TREE(s, treen))) {
                    /*   ,     */
                    if  (!TRIS(treei = createnode(tree))) {
                        ex = EX_SOFTWARE;
                        break;
                    }
                    TREE(s, treei) = TREE(s, treen);
                    TREE(s, treen) = treei;
                    treen = treei;
                    TREE(v, treen) = f ? (ls->fbin[n] - '0') : ls->ibin->t[ls->cbin[k]];
                    break;
                }
                treen = TREE(s, treen);
        }   }
        if  (!f) k++;
    }
    return(ex);
}

static int
/*****************************************************************************************************/
run3(runparm *r, ccbin *ls, tree *tree) {
/*****************************************************************************************************
 *       ,                                 *
 *****************************************************************************************************/
    int ex = EX_OK;

    ifBLIN_QV5(r->flag) fprintf(stderr, "+run3\n");
    if  (!(ls->ibin = mife_get(r->iffed, 0))) {
        ifBLIN_QV1(r->flag) warn("Program error");
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (r->flag & Bpars_AABS) ls->ibin->flag |= Bpars_AABS;
    ls->m = r->ccl - ((char*)&(ls->ibin->v) - (char*)(ls->ibin));
    ls->m -= (sizeof(u_int32_t) + sizeof(u_char)) * ls->ibin->count;
    if  (ls->m < 1) {
        ifBLIN_QV1(r->flag) warnx("invalid length for tree");
        ex = EX_USAGE;
        goto out;
    }
    if  ((tree->trees = malloc(sizeof(treei) * ls->m + 1))) {
        if  ((tree->treed = malloc(sizeof(treei) * ls->m + 1))) {
            if  ((tree->treew = malloc(sizeof(treew) * ls->m + 1))) {
                if  ((tree->treev = malloc(sizeof(u_char) * ls->m + 1))) {
                    tree->treem = ls->m;
                    tree->treep = 0;
                    tree->trees[0] = ~0;
                    tree->treed[0] = ~0;
                    tree->treew[0] = 0;
                    tree->treev[0] = 0;
                    ex = EX_OK;
                } else {
                    ex = EX_TEMPFAIL;
                    free(tree->treev);
                }
            } else {
                ex = EX_TEMPFAIL;
            }
            if  (ex) free(tree->treew);
        } else {
            ex = EX_TEMPFAIL;
        }
        if  (ex) free(tree->trees);
    } else {
        ex = EX_TEMPFAIL;
    }
    if  (ex) {
        ifBLIN_QV1(r->flag) warn("no memory for tree");
        goto out;
    }
/*  ifBLIN_QV1(r->flag) mife_writ(1, ls->ibin, r->ccl);*/
    ls->fbin = (u_char*)(&(ls->ibin->v[ls->ibin->count]));
    ls->cbin = &ls->fbin[ls->ibin->count];
    ex = buildtree(r, tree, ls);
    if  (!ex && !TRIS(TREE(d, 0))) {
        ifBLIN_QV1(r->flag) warn("Short tree");
        ex = EX_NOINPUT;
    }
    if  (ex) {
        if  (tree->treev) free(tree->treev);
        if  (tree->treew) free(tree->treew);
        if  (tree->trees) free(tree->trees);
        if  (tree->treed) free(tree->treed);
    }
out:
    ifBLIN_QV5(r->flag) fprintf(stderr, "-run3 %d\n", ex);
    return(ex);
}   /* run3 */

/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                  **
 *****************************************************************************************************
 *****************************************************************************************************/

static u_int32_t pow[] =
{0U
, 9U
, 99U
, 999U
, 9999U
, 99999U
, 999999U
, 9999999U
, 99999999U
, 999999999U
, 4294967295U
, 0
};

static void
pb(FILE *o, u_int32_t l, u_int32_t i) {
    for (; l && pow[l] && pow[l] >= i; l--) fprintf(o, " ");
}

static void
ptl(treei i, u_int32_t l) {
    if  (l == 0) l = 6;
    if  (i < 0) {
        fprintf(stderr, "~%d", ~i);
        pb(stderr, l, ~i);
    } else if (i > 0) {
        fprintf(stderr, "=%d", i);
        pb(stderr, l, i);
    } else {
        fprintf(stderr, "==");
        for (; l; l--) fprintf(stderr, " ");
}   }

static void
dump_tree(tree *tree, u_int32_t l) {
    treei i;
    fprintf(stderr, "     v    d       s           w\n");
    for (i = 0; i <= tree->treep; i++) {
        if  (i > tree->treem) {
            fprintf(stderr, "Truncated tree\n");
            break;
        }
        fprintf( stderr, "[%2d]%c(%02X)"
               , i
               , (TREE(v, i) >= ' ' && TREE(v, i) < 0177) ? TREE(v, i) : ' '
               , TREE(v, i)
               );
        ptl(TREE(d, i), l);
        ptl(TREE(s, i), l);
        fprintf(stderr, "%6d\n", TREE(w, i));
}   }

static void
finedump_tree(tree *tree, u_int32_t l, treei j, int t) {
    treei i;
    int f;
    u_int32_t ll;

    for (i = j, f = t;; f++) {
        if  (TRIS(TREE(d, i))) finedump_tree(tree, l, TREE(d, i), f);
        i = TREE(s, i);
        if  (!TRIS(i)) break;
    }
    for (f = 0; f < t; f++) {
        fprintf(stderr, "             ");
        for (ll = l + 2; ll; ll--) fprintf(stderr, " ");
    }
    for(i = j;;) {
        if  (i > tree->treem) {
            fprintf(stderr, "Trunc\n");
            break;
        }
        fprintf( stderr, "%3d[%2d]%c(%02X)"
               , TREE(w, i), i
               , (TREE(v, i) >= ' ' && TREE(v, i) < 0177) ? TREE(v, i) : ' '
               , TREE(v, i)
               );
        if  (!TRIS(TREE(d, i))) ptl(TREE(d, i), l);
          else for (ll = l + 2; ll; ll--) fprintf(stderr, " ");
        i = TREE(s, i);
        if  (!TRIS(i)) {
            ptl(i, l);
            fprintf(stderr, "\n");
            break;
        } else {
            fprintf(stderr, " ");
}   }   }

static void
wghttree(tree *tree) {
    treei i, j;

    i = tree->treep;
    if  (i > tree->treem) i = tree->treem;
    while (!(TREE(w, 0))) {
        for (j = i;; j--) {
            if  (!TRIS(TREE(d, j)) && !TRIS(TREE(s, j))) {
                TREE(w, j) = 2;
            } else if (!TRIS(TREE(s, j))) {
                if  (TREE(w, TREE(d, j))) TREE(w, j) = 2 + TREE(w, TREE(d, j));
            } else if (!TRIS(TREE(d, j))) {
                if  (TREE(w, TREE(s, j))) TREE(w, j) = 1 + TREE(w, TREE(s, j));
            } else if ((TREE(w, TREE(d, j))) && (TREE(w, TREE(s, j)))) {
                TREE(w, j) = 1 + TREE(w, TREE(d, j)) + TREE(w, TREE(s, j));
            }
            if  (!TRIS(j)) break;
}   }   }

static void
sortree(tree *tree, treei n) {
    treei *i, j;
    int f;

    do {
        f = 0;
        for (i = &TREE(d, n); TRIS(*i); i = &TREE(s, *i)) {
            if  (  TRIS(TREE(s, *i))
                &&   (TRIS(TREE(d, TREE(s, *i))) ? TREE(w, TREE(d, TREE(s, *i))) : 0)
                   < (TRIS(TREE(d, *i)) ? TREE(w, TREE(d, *i)) : 0)
                ) {
                treei t;
#if 0
                /*           . *
                 *        ...                             */
                if  ((TREE(w, TREE(s, *i)) > TREE(w, *i))) TREE(w, *i) = TREE(w, TREE(s, *i));
                /* ...      ,                                              *
                 *      .                         */
#endif
                t = *i;
                *i = TREE(s, t);
                TREE(s, t) = TREE(s, *i);
                TREE(s, *i) = t;
                f++;
        }   }
    } while (f);
    for (j = TREE(d, n); TRIS(j); j = TREE(s, j)) {
        sortree(tree, j);
}   }

static treei
addrfy(tree *tree, treei n, treei j) {
    treei i;

    n++;
    for (i = j; TRIS(i); i = TREE(s, i)) TREE(w, i) = ++n;
    for (i = j; TRIS(i); i = TREE(s, i)) if (TRIS(TREE(d, i))) n = addrfy(tree, n, TREE(d, i));
    return(n);
}

static treew
tdelta(tree *tree, treei j) {
    treew w, u;
    treei i;

    for (i = j, w = 0; TRIS(i); i = TREE(s, i)) {
        if  (TRIS(TREE(d, i))) {
            u = tdelta(tree, TREE(d, i));
            if  (w < u) w = u;
            u = TREE(w, TREE(d, i)) - TREE(w, i) - 2;
            if  (w < u) w = u;
    }   }
    return(w);
}

static int
/*****************************************************************************************************/
run4(runparm *r, ccbin *ls, tree *tree) {
/*****************************************************************************************************
 *                                                                                 *
 *****************************************************************************************************/
    int ex = EX_OK;
    size_t n;
    u_int64_t z[] = {0x1ULL, 0x100ULL, 0x10000ULL, 0x1000000ULL, 0x100000000ULL};

    ifBLIN_QV5(r->flag) fprintf(stderr, "+run4\n");
    wghttree(tree);
    sortree(tree, 0);
    ifBLIN_QV4(r->flag) dump_tree(tree, 0);
    bzero(tree->treew, (tree->treep + 1) * sizeof(treew));
    wghttree(tree);
    ls->maxl = TREE(w, TREE(d, 0));
    ls->maxw = 0;
    for (n = 0; n < ls->ibin->count; n++) if (ls->maxw < ls->ibin->v[n]) ls->maxw = ls->ibin->v[n];
    bzero(tree->treew, (tree->treep + 1) * sizeof(treew));
    addrfy(tree, 0, TREE(d, 0));
    if  (ls->ibin->flag & Bpars_AABS) {
        ls->t = ls->maxl;
    } else {
        ls->t = tdelta(tree, TREE(d, 0));
    }
    for ( ls->ll = 1
        ; pow[ls->ll] && pow[ls->ll] <= (ls->maxw > ls->maxl ? ls->maxw : ls->maxl)
        ; ls->ll++
        );
    ls->ll--;
    ifBLIN_QV3(r->flag) finedump_tree(tree, ls->ll, 0, 0);
    for (ls->p = 0; ls->p < 5; ls->p++)
        if (z[ls->p] >= ((u_int64_t)ls->maxw + (u_int64_t)ls->t)) break;
    if  (ls->p > 4) {
        ifBLIN_QV1(r->flag)
            warnx("More then 4 bytes needed: %llu", (u_int64_t)ls->maxw + (u_int64_t)ls->t);
        ex = EX_SOFTWARE;
    }
    ifBLIN_QV2(r->flag)
        fprintf(stderr, "MAXW=%d MAXT=%d MAXINDX=%d SIZE=%d\n", ls->maxw, ls->t, ls->maxl, ls->p);
    fprintf(ls->o, ",%d", ls->maxl);
    fprintf(ls->o, ",%d", ls->t);
    fprintf(ls->o, ",%d\n", ls->p);

    ifBLIN_QV5(r->flag) fprintf(stderr, "-run4 %d\n", ex);
    return(ex);
}   /* run4 */

/*****************************************************************************************************
 *   run4                                                                            *
 *****************************************************************************************************/

static void
addrout(FILE *o, u_int32_t l, u_int32_t i) {
    while (l > 0) {
        fprintf(o, ",0x%02X", i & 0xFF);
        i >>= 8;
        l--;
}   }

static size_t
/*****************************************************************************************************/
run4out(runparm *r, ccbin *ls, tree *tree, treei j, ssize_t p) {
/*****************************************************************************************************
 *                                                                       *
 *****************************************************************************************************/
    size_t n;
    treei i;
    treew w;
    int f = 1;

    if  (!j) {
        fprintf(ls->o, ",{");
        j = TREE(d, j);
    } else if (!TRIS(j)) {
        return(p);
    } else {
        fprintf(ls->o, " ,");
        f = 0;
    }
    fprintf(ls->o, "/*%05X*/", p++);
    for (n = 0, i = j; TRIS(i); i = TREE(s, i), n++);
    if  (!n) {
        ifBLIN_QV1(r->flag) warnx("Empty side");
        p = -1;
    } else {
        pb(ls->o, ls->ll, n - 1);
        fprintf(ls->o, "%u", n - 1);
        for (i = j; TRIS(i); i = TREE(s, i)) {
            if  (TREE(v, i) >= ' ' && TREE(v, i) < 0177) {
                fprintf(ls->o, ",  \'%c\'", TREE(v, i));
            } else {
                fprintf(ls->o, ", %04o", TREE(v, i));
            }
            p++;
            if  (TRIS(TREE(d, i))) {
                w = TREE(w, TREE(d, i)) - 2;
                if  (ls->ibin->flag & Bpars_AABS) {
                    addrout(ls->o, ls->p, w);
                } else if (w < TREE(w, i)) {
                    ifBLIN_QV1(r->flag) warnx("Loop without Bpars_AABS");
                    p = -1;
                    break;
                } else {
                    addrout(ls->o, ls->p, w - TREE(w, i));
                }
            } else {
                addrout(ls->o, ls->p, TREE(d, i));
        }   }
        if  (p > 0) {
            fprintf(ls->o, " ");
            addrout(ls->o, ls->p, i);
            fprintf(ls->o, "\n");
            for (i = j; p > 0 && TRIS(i); i = TREE(s, i)) p = run4out(r, ls, tree, TREE(d, i), p);
            if  (p > 0 && f) fprintf(ls->o, "}};\n");
    }   }
    return(p);
}

/*****************************************************************************************************
 *****************************************************************************************************
 ** main                                                                                            **
 *****************************************************************************************************
 *****************************************************************************************************/
int
main(int argc, char **argv) {
    int ex = EX_OK;
    char *nam1 = NULL;
    runparm rr;
    runparm *r = &rr;
    run12parm rr2;
    run12parm *r2 = &rr2;
    ccbin lss;
    ccbin *ls = &lss;
    tree tree;
    ssize_t p;

    bzero(r, sizeof(rr));
    bzero(r2, sizeof(rr2));
    bzero(ls, sizeof(lss));
    r->flag = BLIN_VER1;

    /*********************************************************************
     *              TMPDIR       2                       *
     * (1)    > (2) cc  | (3)   *
     *********************************************************************/
    if  ((ex = argrun(r, r2, argc, argv))) goto out;
    if  (!r->oufn) {
        ifBLIN_QV1(r->flag) warnx("No out file");
        exit(EX_USAGE);
    }

    /****** 1  ******/
    if  ((ex = run1(r, r2))) goto out;
    if  (asprintf(&nam1, "%s/lexorXXXXXX.c", getenv("TMPDIR") ? getenv("TMPDIR") : "/tmp") < 0) {
        ifBLIN_QV1(r->flag) warn("asprintf #1");
        exit(EX_OSERR);
    }
    if  ((r2->fil1 = mkstemps(nam1, 2)) < 0) {
        ifBLIN_QV1(r->flag) warn("mkstemps #1");
        exit(EX_OSERR);
    }
    if  (!r2->imd->top.index) {
        ifBLIN_QV1(r->flag) warn(" ");
        exit(EX_DATAERR);
    }
    if  ((ex = intrfil1(r, r2))) goto out;

    /*      */
    if  (!(ls->o = fopen(r->oufn, "w"))) {
        ifBLIN_QV1(r->flag) warn("fopen");
        exit(EX_IOERR);
    }
    if  (r2->incopy) fprintf(ls->o, "#line %u \"%s\"\n%s", r2->lncopy, r2->infn, r2->incopy);
    if  (r2->intype) fprintf(ls->o, "#line %u \"%s\"\n%s ", r2->lntype, r2->infn, r2->intype);
    fprintf(ls->o, "babolo_lexor %s = {\n", r2->inname);
    fprintf( ls->o, "#line %u \"%s\"\n%s\n"
           , r2->lntrans
           , r2->infn
           , r2->intrans ? r2->intrans : "NULL"
           );
/*  fprintf(ls->o, "#line\n"); XXXX */
    if  (r->flag & Bpars_AABS) {
        fprintf(ls->o, ", NULL, (%s)|Bpars_AABS", r2->inflag ? r2->inflag : "0");
    } else {
        fprintf(ls->o, ", NULL, %s", r2->inflag ? r2->inflag : "0");
    }

    /****** 2  ******/
    r2->ccarg[r2->ccarp++] = nam1;
    r2->ccarg[r2->ccarp] = NULL;
    ifBLIN_QV2(r->flag) fprintf(stderr, "%d=%s~\n", r2->ccarp - 1, r2->ccarg[r2->ccarp - 1]);

    ex = run2cc(r, r2);
    free(r2->ccarg);
    if  (ex) goto out;

    /****** 3  ******/
    if  ((ex = run3(r, ls, &tree))) goto out;

    /****** 4  ******/
    if  ((ex = run4(r, ls, &tree))) goto out;
    p = run4out(r, ls, &tree, 0, 0);
    if  (p < 0) {
        ex = EX_DATAERR;
        goto out;
    } else if (p != ls->maxl) {
        ifBLIN_QV1(r->flag) warnx("Size mismatch");
        ex = EX_SOFTWARE;
        goto out;
    }

out:if  (ex) {
        if  (ls->o) {
            fpurge(ls->o);
            fclose(ls->o);
            ls->o = NULL;
        }
    } else if ((ex = fclose(ls->o))) {
        ifBLIN_QV1(r->flag) warn("fclose");
        ls->o = NULL;
    }
    if  (r->iffed) mife_close(r->iffed);
    r->iffed = NULL;
    if  (!(r->flag & BLIN_VER5) && nam1) {
        unlink(nam1);
        free(nam1);
        nam1 = NULL;
    }
    exit(ex);
}
