/*-
 * Copyright (C)2003 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2003 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n";
static const char rcsid[] = "$Id: test.c,v 1.2 2004/01/25 07:28:47 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <err.h>
#include <babolo/BLINflag.h>
#include "../parser.h"

int
main(int argc, char **argv) {
    int infil, i;
    u_char *intext, *inpp, *inp;
    struct stat sb;
    struct babolo_parm *pm;
    u_int32_t flag;
    int ch, z;

    z = 0;
    flag = 0;
    while ((ch = getopt(argc, argv, "s:v")) != EOF)
        switch (ch) {
        case 's': flag |= strtol(optarg, NULL, 0);
                  break;
        case 'v': flag |= ((flag << 1) & BLIN_VERMASK) | BLIN_VER1;
                  break;
        default:
        }
    argc -= optind;
    argv += optind;
    if  (argc < 1 || argc > 2 || !argv || !argv[0]) errx(EX_USAGE, "Give filename and EOL");
    if  (argc == 1) z = 1;
    if  ((infil = open(argv[0], O_RDONLY)) < 0) err(EX_NOINPUT, NULL);
    if  (fstat(infil, &sb) < 0) err(EX_NOINPUT, NULL);
    intext = mmap(NULL, sb.st_size, PROT_READ, MAP_PRIVATE, infil, 0);
    if  (intext == MAP_FAILED) err(EX_NOINPUT, NULL);
    inpp = NULL;
    for (inp = intext; inp < intext + sb.st_size && inp != inpp; ) {
        inpp = inp;
        pm = babolo_getparm(flag, &inp, z ? "" : *argv[1] ? argv[1] : "\n");
        if  (!pm) err(EX_DATAERR, NULL);
        printf("argc=%d ==============\n", pm->argc);
        for (i = 0; pm->argv[i]; i++) printf("%4d ~%s~\n", i, pm->argv[i]);
        babolo_freeparm(pm);
    }
    exit(0);
}
