#!/usr/bin/awk -f
# Copyright (C)2002..2021 @BABOLO http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: copyrtest.awk,v 1.2 2021/07/31 20:46:48 babolo Exp $

BEGIN{
    y = ""
    f = ""
}

/^.*Copyright +\(C\)[12][0-9]+.+@BABOLO.*$/{
    t = $0
    if  ($0 ~ /^.*Copyright +\(C\)[12][0-9]+\.\.[12][0-9]+ +@BABOLO.*$/){
        sub(/^.*Copyright +\(C\)[12][0-9]+\.\./, "", t)
        sub(/ +@BABOLO.*$/, "", t)
    } else{
        sub(/^.*Copyright +\(C\)/, "", t)
        sub(/ +@BABOLO.*$/, "", t)
    }
    if  ((y != "") && (y != t)){
        print "!!!!!!!!!!! " y " <> " t " " FILENAME
        print "!!!" f
        print "!!!" $0
        exit
    }
    y = t
    f = $0
}

$0 ~ "\\$" "Id: [^ ]+ [0-9.]+ [12][0-9]+\\/[0-9][0-9]\\/[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] [^ ]+ Exp \\$"{
    t = $0
    sub(/^.*\$Id: [^ ]+ [0-9.]+ /, "", t)
    sub(/\/[0-9][0-9]\/[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] [^ ]+ Exp \$.*$/, "", t)
    if  ((y != "") && (y != t)){
        print "!!!!!!!!!!! " y " <> " t " " FILENAME
        print "!!!" f
        print "!!!" $0
        exit
    }
    y = t
    f = $0
}
