/*-
 * Copyright (C)2014..2022 @BABOLO http://www.babolo.ru/
 * pkg = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2014..2022 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n\
@(#)V.M "VERS;
#endif /* not lint */
static const char rcsid[] = "$Id: test0.c,v 1.12 2022/04/30 16:49:03 babolo Exp $";

#define BLIN_COMPAT VMAJOR

#include <sys/types.h>
#include <sysexits.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"

#define DEF_LEVEL  7
#define DEF_WIDTH  5
#define DEF_ACTN   24
#define DEF_REV    0
#define DEF_STATEN 8
#define BASELEN    64
#define SET(T, X)  do {((u_int64_t*)(T))[(X) / BASELEN] |= (1LLU << ((X) % BASELEN));} while(0)

enum classes
{ L0 /* end of string */
, Lb /* '('           */
, Le /* ')'           */
, Li /* '['           */
, Lq /* ']'           */
, Ld /* '1'..'9'      */
, Lh /* 'x'           */
, Lg /* 'a'..'f'      */
, Lz /* '0'           */
, Lp /* '.'           */
, Ls /* ' '           */
, La /* other         */
, Lx /* last          */
};

enum states
{ Di /* Wait for (  */
, Da /* Wait for ]( */
, Dd /* Wait for 0  */
, De /* Wait for ]0 */
, Dh /* Wait for x  */
, Dc /* Wait for 9  */
, Dp /* Wait for .  */
, Df /* Wait for ]. */
, Db /* Wait for .  */
, Dq /* Wait for 0  */
, Dg /* Wait for ]0 */
, Do /* Wait for x  */
, Dv /* Wait for 9  */
, Dx /* Finish      */
};

#define C1 0x00000100 /* first num ready  */
#define C0 0x00000200 /* single num ready */
#define Cz 0x00001000 /* new pair         */
#define Cd 0x00010000 /* decimal +digit   */
#define Co 0x00020000 /* octal            */
#define Ch 0x00040000 /* hex              */
#define Cp 0x00100000 /* +digit           */
#define Cb 0x00200000 /* +hdigit          */
#define C2 0x01000000 /* num pair ready   */
#define Ce 0x80000000 /* Error            */
#define C_state  0xFF

static struct {
    const u_char    recode[256];
    const char      clasnames[Lx + 1][3];
    const char      statenames[Dx + 1][3];
    const char      actnames[24][3];
    const u_int32_t automa[Dx][Lx];
} z
#if 0
 =
{ /* recode */
  {  L0, La, La, La,  La, La, La, Ls,  Ls, Ls, L0, L0,  La, L0, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  Ls, La, La, La,  La, La, La, La,  Lb, Le, La, La,  La, La, Lp, La
  ,  Lz, Ld, Ld, Ld,  Ld, Ld, Ld, Ld,  Ld, Ld, La, La,  La, La, La, La

  ,  La, Lg, Lg, Lg,  Lg, Lg, Lg, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  Lh, La, La, Li,  La, Lq, La, La
  ,  La, Lg, Lg, Lg,  Lg, Lg, Lg, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  Lh, La, La, La,  La, La, La, La

  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La

  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  ,  La, La, La, La,  La, La, La, La,  La, La, La, La,  La, La, La, La
  }
, /* clasnames */
  {  "L0", "Lb", "Le", "Li",  "Lq", "Ld", "Lh", "Lg"
  ,  "Lz", "Lp", "Ls", "La",  "Lx"
  }
, /* statenames */
  {  "Di", "Da", "Dd", "De",  "Dh", "Dc", "Dp", "Df"
  ,  "Db", "Dq", "Dg", "Do",  "Dv", "Dx"
  }
, /* actnames */
  {  "1 ", "0 ", "- ", "- ",  "z ", "- ", "- ", "- "
  ,  "d ", "o ", "h ", "- ",  "p ", "- ", "- ", "- "
  ,  "2 ", "- ", "- ", "- ",  "- ", "- ", "- ", "e "
  }
, /*             (      )      [      ]            9      x      F      0      .             ? */
  /*     L0     Lb     Le     Li     Lq           Ld     Lh     Lg     Lz     Lp     Ls     La */
  { { Ce|Dx,    Dd, Ce|Dx,    Da, Ce|Dx,       Ce|Dx, Ce|Dx, Ce|Dx, Ce|Dx, Ce|Dx,    Di, Ce|Dx}/*Di*/
  , { Ce|Dx,    Da,    Da,    Da,    Di,          Da,    Da,    Da,    Da,    Da,    Da,    Da}/*Da*/
  , { Ce|Dx, Ce|Dx,    Dx,    De, Ce|Dx, Cz|Cd|Cp|Dc, Ce|Dx, Ce|Dx, Cz|Dh, Ce|Dx,    Dd, Ce|Dx}/*Dd*/
  , { Ce|Dx,    De,    De,    De,    Dd,          De,    De,    De,    De,    De,    De,    De}/*De*/
  , { Ce|Dx, Ce|Dx, C1|Dx, C1|Df, Ce|Dx,    Co|Cp|Dc, Ch|Dc, Ce|Dx, Co|Dc, C1|Db, C1|Dp, Ce|Dx}/*Dh*/
  , { Ce|Dx, Ce|Dx, C1|Dx, C1|Df, Ce|Dx,       Cp|Dc, Ce|Dx, Cb|Dc, Cp|Dc, C1|Db, C1|Dp, Ce|Dx}/*Dc*/
  , { Ce|Dx, Ce|Dx, Ce|Dx,    Df, Ce|Dx, C0|Cd|Cp|Dc, Ce|Dx, Ce|Dx, C0|Dh,    Db,    Dp, Ce|Dx}/*Dp*/
  , { Ce|Dx,    Df,    Df,    Df,    Dp,          Df,    Df,    Df,    Df,    Df,    Df,    Df}/*Df*/
  , { Ce|Dx, Ce|Dx, Ce|Dx, Ce|Dx, Ce|Dx,       Ce|Dx, Ce|Dx, Ce|Dx, Ce|Dx,    Dq, Ce|Dx, Ce|Dx}/*Db*/
  , { Ce|Dx, Ce|Dx, C0|Dx,    Dg, Ce|Dx, Cz|Cd|Cp|Dv, Ce|Dx, Ce|Dx, Cz|Do, Ce|Dx,    Dq, Ce|Dx}/*Dq*/
  , { Ce|Dx,    Dg,    Dg,    Dg,    Dq,          Dg,    Dg,    Dg,    Dg,    Dg,    Dg,    Dg}/*Dg*/
  , { Ce|Dx, Ce|Dx, C2|Dx, C2|De, Ce|Dx,    Co|Cp|Dv, Ch|Dv, Ce|Dx, Co|Dv, Ce|Dx, C2|Dd, Ce|Dx}/*Do*/
  , { Ce|Dx, Ce|Dx, C2|Dx, C2|De, Ce|Dx,       Cp|Dv, Ce|Dx, Cb|Dv, Cp|Dv, Ce|Dx, C2|Dd, Ce|Dx}/*Dv*/
} };
#else
;
#endif

// char q[] = "( 0x34 056 56 [dfg] 0xfd..567)";

static void
usage(int ex) {
    fprintf( stderr
           , "babolo-libmake test " VERS " @BABOLO " DATE "\n"
             "Usage: test0 [-options]\n"
             "    -a actN     - action field width (default %u)\n"
             "    -l level    - use output of level (default %u)\n"
             "    -q          - quiet\n"
             "    -r          - reverse actions order (default %s)\n"
             "    -s stateN   - state field width (default %u)\n"
             "    -v[v...]    - verbose\n"
             "    -w width    - width for action output, if 0 - strict align (default %u)\n"
           , DEF_ACTN
           , DEF_LEVEL
           , (DEF_REV) ? "MSB to LSB" : "LSB to MSB"
           , DEF_STATEN
           , DEF_WIDTH
           )
    ;
    exit(ex);
}

int
main(int argc, char **argv) {
    u_int32_t r0 = 0, r1 = 0, d = 0, control = 0, flags = BLIN_BIT0;
    u_int64_t conf[65536 / BASELEN];
    ssize_t i, j, shift = 0;
    int fd, c, ex = EX_OK;
    char *p, *q = NULL;
    enum states state;
    blin_statectl sc;
    const char *cn;

    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, flags);
    blin_ctl(BLIN_CTL_WHAT | BLIN_CTL_FSET | BLIN_BIT1, BLIN_MODTIME);
    blin_ctl(BLIN_CTL_WHAT | BLIN_CTL_FEQU | BLIN_BIT2, BLIN_MODLOGR | BLIN_MODEOAU);
    blin_ctl(BLIN_CTL_WHAT | BLIN_CTL_FEQU | BLIN_BIT3, BLIN_MODLOGR | BLIN_MODEOAU | BLIN_MODTIME);
    blin_ctl(BLIN_CTL_WHAT | BLIN_CTL_FSET | BLIN_BIT5, BLIN_MODTIME);
    blin_ctl(BLIN_CTL_WHAT | BLIN_CTL_FSET | BLIN_BIT7, BLIN_MODDREL | BLIN_MODDSTR);
    blin_ctl(BLIN_CTL_DUMP);
    ifBLIN_QX0("begin");
    sc = (blin_statectl){{DEF_LEVEL, 1, DEF_STATEN, DEF_ACTN, ' ', DEF_WIDTH, DEF_REV}};
    while ((c = getopt(argc, argv, "a:F:f:I:i:l:qrS:s:vw:?")) != -1) {
        switch (c) {
        case 'a': sc.actinn = strtoul(optarg, NULL, 0);
                ; break;
        case 'F': if  (0 > (fd = open(optarg, O_WRONLY | O_CREAT | O_TRUNC | O_NOFOLLOW, 0666))) {
                      ifBLIN_QW0("open for write");
                  }
                ; if  (0 > write(fd, &z, sizeof(z))) {
                      ifBLIN_QW0("write");
                  }
                ; close(fd);
                ; break;
        case 'f': if  (0 > (fd = open(optarg, O_RDONLY, 0))) {
                      ifBLIN_QW0("open for read");
                  }
                ; if  (0 > read(fd, &z, sizeof(z))) {
                      ifBLIN_QW0("read");
                  }
                ; close(fd);
                ; break;
        case 'I': if  (0 > (fd = open(optarg, O_RDONLY, 0))) {
                      ifBLIN_QW0("open in");
                  }
                ; if  (0 > (i = read(fd, q, 65536))) {
                      ifBLIN_QW0("read in");
                  }
                ; q[i] = '\0';
                ; close(fd);
                ; break;
        case 'i': q = optarg;
                ; break;
        case 'l': sc.level = strtoul(optarg, NULL, 0);
                ; break;
        case 'q': BLIN_QUIET(flags);
                ; break;
        case 'r': sc.revert = ~sc.revert;
                ; break;
        case 'S': shift = strtoul(optarg, NULL, 0);
                ; break;
        case 's': sc.staten = strtoul(optarg, NULL, 0);
                ; break;
        case 'v': BLIN_VERBOSE(flags);
                ; break;
        case 'w': sc.allign = strtoul(optarg, NULL, 0);
                ; break;
        case '?': usage(EX_OK);
        default : ifBLIN_QX0("Illegal flag");
                ; usage(EX_USAGE);
    }   }
    argc -= optind;
    argv += optind;
    ifBLIN_QX0( "blin_statectl %08X <l=%u s=%u a=%u w=%u r=%u>"
              , sc.statectl
              , sc.level
              , sc.staten
              , sc.actinn
              , sc.allign
              , sc.revert
              );
    ifBLIN_QX0("%"BLIN_X" %"BLIN_X, blin_internal_flags, flags);
    blin_stateheader(sc, z.actnames);
    for (state = Di, p = q; q && (state < Dx); ++p) {
        control = z.automa[state][z.recode[*p]];
        cn = z.clasnames[z.recode[*p]];
        blin_statebody(sc, z.actnames, z.statenames, cn, p, p - q, control, state, r0, d);
        if  (C1 & control) r1 = r0;
        if  (C0 & control) SET((void*)&conf, r1);
        if  ((Cz | C0 | C1) & control) r0 = 0;
        if  (Cd & control) d = 10;
        if  (Co & control) d = 8;
        if  (Ch & control) d = 16;
        if  (Cp & control) {
            u_int32_t i;

            i = *p - '0';
            if  (i > d) control = Ce | Dx; else r0 = r0 * d + i;
        }
        if  (Cb & control) {
            if  (16 < d) {
                control = Ce | Dx;
            } else {
                u_int32_t i;

                i = *p - 'A';
                if  (i > 6) i -= 'a' - 'A';
                r0 = r0 * d + i + 10;
        }   }
        if  (C2 & control) {
            u_int32_t i;

            for (i = r1; i < r0; i++) SET((void*)&conf, i);
        }
        if  (Ce & control) warnx("bsdfig: c_lists: syntax");
        state = control & C_state;
    }
    blin_dumb(BLIN_MODDTXT | sc.level, (char*)(void*)&z + shift, sizeof(z) - shift);
    blin_dumb(7, (char*)(void*)&z + shift, sizeof(z) - shift, "===>>> ");
    errno = 1981284353;
    ifBLIN_QW1("test %d", errno);
    errno = -1981284353;
    ifBLIN_QW1( "long test                      %016X %016X %016X %016X %016X"
                " %016X %016X %016X"
              , z.automa[0][0], z.automa[0][1], z.automa[0][2], z.automa[0][3], z.automa[0][4]
              , z.automa[1][0], z.automa[1][1], z.automa[1][2]
              );
    errno = 0;
    ifBLIN_QW6( "long test                      %016X %016X %016X %016X %016X"
                " %016X %016X %016X %016X"
              , z.automa[0][0], z.automa[0][1], z.automa[0][2], z.automa[0][3], z.automa[0][4]
              , z.automa[1][0], z.automa[1][1], z.automa[1][2], z.automa[1][3]
              );
    errno = 69;
    ifBLIN_QW1( "long test                      %016X %016X %016X %016X %016X"
                " %016X %016X %016X %016X %016X %016X %016X %016X %016X %016X"
                " %016X %016X %016X %016X %016X %016X %016X %016X %016X %016X"
              , z.automa[0][0], z.automa[0][1], z.automa[0][2], z.automa[0][3], z.automa[0][4]
              , z.automa[1][0], z.automa[1][1], z.automa[1][2], z.automa[1][3], z.automa[1][4]
              , z.automa[2][0], z.automa[2][1], z.automa[2][2], z.automa[2][3], z.automa[2][4]
              , z.automa[3][0], z.automa[3][1], z.automa[3][2], z.automa[3][3], z.automa[3][4]
              , z.automa[4][0], z.automa[4][1], z.automa[4][2], z.automa[4][3], z.automa[4][4]
              );
    ifBLIN_QX0("end %d", ex);
    exit(ex);
}
