/*-
 * Copyright (C)2022 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2022 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: reger.c,v 1.1 2022/02/19 20:55:50 babolo Exp $\n"

#define BLIN_COMPAT   VMAJOR

#include <sys/mman.h>
#include <sys/stat.h>
#include <sysexits.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include "BLINflag.h"

int
main(int argc, char **argv) {
    char       *filarg;
    int         fd;
    int         ex = EX_OK;
    struct stat sb;
    char       *p;
    char       *q;

    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, BLIN_BIT0);
    if  (!(filarg = argv[1])) {
        ifBLIN_QX0("Usage: %s FILE", argv[0]);
        ex = EX_USAGE;
        errno = ENOATTR;
        goto out;
    }
    if  (0 > (fd = open(filarg, O_RDWR | O_EXLOCK))) {
        ifBLIN_QW0("open %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
    if  (0 > fstat(fd, &sb)) {
        ifBLIN_QW0("fstat %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
    if  (!sb.st_size) goto out;
    if  (!(p = mmap(NULL, sb.st_size, PROT_READ, MAP_PRIVATE, fd, (off_t)0))) {
        ifBLIN_QW0("mmap %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
    for (q = p + sb.st_size; q > p; ) {
        if  (!!*--q) {
            ++q;
            break;
    }   }
    if  (0 > munmap(p, sb.st_size)) {
        ifBLIN_QW0("munmap %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
    if  ((q - p) >= sb.st_size) goto out;
    if  (0 > ftruncate(fd, (off_t)(q - p))) {
        ifBLIN_QW0("ftruncate %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
    if  (0 > close(fd)) {
        ifBLIN_QW0("close %s", filarg);
        ex = EX_IOERR;
        goto out;
    }
out:
    return(ex);
}
