#!/bin/sh

dir="${1}"
if [ -z "${dir}" ]; then
   echo "Usage: ${0} DIR"
   echo "where DIR for param.make"
   exit 1
fi
mk="${dir}/param.make"

echo '# Copyright (C)2022 @BABOLO http://www.babolo.ru/'                            > "${mk}"
echo '# All rights reserved.'                                                       >> "${mk}"
echo '#'                                                                            >> "${mk}"
echo '# Redistribution and use in source and binary forms, with or without'         >> "${mk}"
echo '# modification, are permitted provided that the following conditions'         >> "${mk}"
echo '# are met:'                                                                   >> "${mk}"
echo '# 1. Redistributions of source code must retain the above copyright'          >> "${mk}"
echo '#    notice, this list of conditions and the following disclaimer.'           >> "${mk}"
echo '# 2. Redistributions in binary form must reproduce the above copyright'       >> "${mk}"
echo '#    notice, this list of conditions and the following disclaimer in the'     >> "${mk}"
echo '#    documentation and/or other materials provided with the distribution.'    >> "${mk}"
echo '#'                                                                            >> "${mk}"
echo '# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS "AS IS" AND'       >> "${mk}"
echo '# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE'      >> "${mk}"
echo '# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE' >> "${mk}"
echo '# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE'    >> "${mk}"
echo '# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL' >> "${mk}"
echo '# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS'    >> "${mk}"
echo '# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)'      >> "${mk}"
echo '# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT' >> "${mk}"
echo '# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY'  >> "${mk}"
echo '# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF'     >> "${mk}"
echo '# SUCH DAMAGE.'                                                               >> "${mk}"
echo '#'                                                                            >> "${mk}"
echo '# $Id: param.sh,v 1.5 2022/09/03 12:15:23 babolo Exp $'                       >> "${mk}"

mktemp=`which mktemp`
if [ -z "${mktemp}" ]; then
   echo "mktemp not found"
   exit 1
fi

make=`make -V MAKE`
if [ -z "${make}" ]; then
   make=make
fi
make=`which "${make}"`
if [ -z "${make}" ]; then
   echo "make not found"
   exit 1
fi

echo=`"${make}" -V ECHO`
if [ -z "${echo}" ]; then
   echo=echo
fi

cc=`"${make}" -V CC`
if [ -z "${cc}" ]; then
   cc=cc
fi
cc=`which "${cc}"`
if [ -z "${cc}" ]; then
   echo "cc not found"
   exit 1
fi

mv=`"${make}" -V MV`
if [ -z "${mv}" ]; then
   mv=mv
fi
mv=`which "${mv}"`
if [ -z "${mv}" ]; then
   echo "mv not found"
   exit 1
fi

rm=`"${make}" -V RM`
if [ -z "${rm}" ]; then
   rm=rm
fi
rm=`which "${rm}"`
if [ -z "${rm}" ]; then
   echo "rm not found"
   exit 1
fi

sed=`"${make}" -V SED`
if [ -z "${sed}" ]; then
   sed=sed
fi
sed=`which "${sed}"`
if [ -z "${sed}" ]; then
   echo "sed not found"
   exit 1
fi

find=`"${make}" -V FIND`
if [ -z "${find}" ]; then
   find=find
fi
find=`which "${find}"`
if [ -z "${find}" ]; then
   echo "find not found"
   exit 1
fi

head=`"${make}" -V HEAD`
if [ -z "${head}" ]; then
   head=head
fi
head=`which "${head}"`
if [ -z "${head}" ]; then
   echo "head not found"
   exit 1
fi

sort=`"${make}" -V SORT`
if [ -z "${sort}" ]; then
   sort=sort
fi
sort=`which "${sort}"`
if [ -z "${sort}" ]; then
   echo "sort not found"
   exit 1
fi

f=`"${mktemp}" -t babolo-libmake`
"${mv}" -f "${f}" "${f}.c"
"${echo}" 'void e(){};' > "${f}.c"
if ! "${cc}" -pipe -nostdlib -Wl,--oformat=binary,--entry=e -o /dev/null "${f}.c" > /dev/null; then
   NEEDGCC=1
fi

if [ -n "${NEEDGCC}" ]; then
   path=`"${echo}" ${PATH} | "${sed}" -e 's|:| |g'`
   CCLEXOR=` for i in ${path};                        \
             do "${find}" $i -name gcc\* || true;     \
             done                                     \
           | "${sed}" -Ene 's|^/.+/(gcc[0-9]*)$|\1|p' \
           | "${sort}" -u                             \
           `
fi

if [ -n "${NEEDGCC}" ]; then
   "${echo}" "NEEDGCC           ?= ${NEEDGCC}" >> "${mk}"
fi

j=""
for i in ${CCLEXOR}; do
    if "${i}" -pipe -nostdlib -Wl,--oformat=binary,--entry=e -o /dev/null "${f}.c" > /dev/null; then
       j="${j} ${i}"
    fi
done

for i in ${j}; do
    "${echo}" "CCLEXOR           ?= ${i}" >> "${mk}"
done

${rm} -f "${f}.c"
