# Copyright (C)2003..2022 @BABOLO http://www.babolo.ru/
# pkg = babolo-libmake
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: common.make,v 1.59 2022/06/13 13:36:37 babolo Exp $

#######################################################################################################

.BEGIN:
	@${ECHO} "===> make in ${PKG}:${PWD}"

.END:
	@${ECHO} "===> end in ${PKG}:${PWD}"

notify:
.if defined(REQUIRED)
	${BINDIR}/babololib-version ${REQUIRED}
.endif

#######################################################################################################

.if !target(subdir)
subdir: preall
. for I in ${SUBDIR}
	@(cd ${I};                                                                                    \
          ${MAKE} CFLAGSPLUS="${CFLAGSPLUS}" LDFLAGSPLUS="${LDFLAGSPLUS}"                             \
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"                       \
                  CONFDIR="${CONFDIR}"  LIBEDIR=${LIBEDIR} ROOTDATA="${ROOTDATA}" PREFIX="${PREFIX}"  \
                  ${MAKEFLAGS} all                                                                    \
        )
. endfor
.endif

.if !target(supdir)
supdir: doall ${DEPEND}
. for I in ${SUPDIR}
	@(cd ${I};                                                                                    \
          ${MAKE} CFLAGSPLUS="${CFLAGSPLUS}" LDFLAGSPLUS="${LDFLAGSPLUS}"                             \
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"                       \
                  CONFDIR="${CONFDIR}"  LIBEDIR=${LIBEDIR} ROOTDATA="${ROOTDATA}" PREFIX="${PREFIX}"  \
                  ${MAKEFLAGS} all                                                                    \
        )
. endfor
.endif

#######################################################################################################

.for I in ${SGEN}
. if !target(${I})
${I}: ${MAKEINC} Makefile ${M4INC} def.m4 ${I}.m4 ${DEPEND}
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}                               \
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}       \
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}                                   \
             ${M4INC} def.m4 ${I}.m4 > ${I}
. endif
.endfor

.m4: ${MAKEINC} Makefile ${M4INC} def.m4 ${.IMPSRC} ${DEPEND}
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}                               \
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}       \
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}                                   \
             ${M4INC} def.m4 ${.IMPSRC} > ${.TARGET}

# ,    ,    

.for I in ${MGEN}
. if !target(${I})
${I}: ${MAKEINC} Makefile ${M4INC} def.m4 ${I}.m4 ${DEPEND}
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}                               \
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}       \
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}                                   \
             ${M4INC} def.m4 ${I}.m4 > ${I}
. endif
.endfor

.cgm4.cgi: ${MAKEINC} Makefile ${M4INC} def.m4 ${.IMPSRC} ${LIBINCLUDEDIR}/pgocgi.m4 ${DEPEND}
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}                               \
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}       \
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}                                   \
             ${M4INC} ${LIBINCLUDEDIR}/pgocgi.m4 def.m4 ${.IMPSRC} > ${.TARGET}

#######################################################################################################

.for I in ${MANS1} ${MANS3} ${MANS5} ${MANS8}
. if !target(${I}.gz)
${I}.gz: Makefile ${I} ${DEPEND}
	${GZIP} -cn ${I} > ${I}.gz
. endif
.endfor

.for I in ${PGMOD}
. if !target(${I}.so.${VMAJOR})
${I}.so.${VMAJOR}: Makefile ${I}.c ${DEPEND}
	${CC} ${CFLAGS} ${LDFLAGS} -f${FPIC} -shared -I${PG_INCLDIR_SRV} -I${INCLUDEDIR} -o ${I}.so.${VMAJOR} ${I}.c
. endif
.endfor

.for I in ${SHLIB}
   SHLIBOLIST	+= ${I}.o

${I}.o:	Makefile ${INCH} ${I}.c ${DEPEND}
	${CC} ${CFLAGS} -f${FPIC} -c ${I}.c

.endfor
.if !target(${SHLIBVNAME})
${SHLIBVNAME}: Makefile ${SHLIBOLIST} ${DEPEND}
	${CC} ${LDFLAGS} -f${FPIC} -shared -Wl,-h${SHLIBVNAME} -o ${SHLIBVNAME} ${SHLIBOLIST}
.endif

.c.o: Makefile ${INCH} ${LEXORH} ${DEPEND}
	${CC} ${CFLAGS} -c ${.IMPSRC}

.if !target(${SHLIBNAME})
${SHLIBNAME}: Makefile ${SHLIBVNAME} ${DEPEND}
	${LN} -sf ${SHLIBVNAME} ${SHLIBNAME}
.endif

.for I in ${STLIB}
  STLIBOLIST		+= ${I}.o
.endfor
.if !target(${STLIBNAME})
${STLIBNAME}: Makefile ${STLIBOLIST} ${DEPEND}
	${AR} cru ${STLIBNAME} ${STLIBOLIST}
	${RANLIB} ${STLIBNAME}
.endif

.for I in ${PROG}
. if !target(${I})
${I}: Makefile ${OBJS} ${I}.o ${INCH} ${LEXORH} objnlib ${DEPEND}
.  if defined(DOSHLIB)
	${CC} ${LDFLAGS} ${I}.o ${SHLIBVNAME} -o ${I}
.  elif defined(DOSTLIB)
	${CC} ${LDFLAGS} ${I}.o ${STLIBNAME} -o ${I}
.  else
	${CC} ${LDFLAGS} ${I}.o ${OBJS} ${OBJSPLUS} -o ${I}
.  endif
. endif
.endfor

.lexor.h: Makefile ${INCH} ${.IMPSRC} subdir ${DEPEND}
.if !defined(NEEDGCC)
	lexor ${CFLAGS} -I. -o ${.TARGET} ${.IMPSRC}
.elif defined(CCLEXOR)
	lexor -c${CCLEXOR} ${CFLAGS} -I. -o ${.TARGET} ${.IMPSRC}
.else
. error This clang does not support --oformat=binary, install GCC in PATH please
.endif

#######################################################################################################

.if !target(doclean)
doclean: preclean
	${RM} -f *.o *.core .depend *.bak *.gz ${CLEAN}
. for I in ${SUBDIR} ${SUPDIR}
	@(cd ${I};${MAKE} ${MAKEFLAGS} PKG="${PKG}" RM="${RM}" MAKE="${MAKE}" VMAJOR="${VMAJOR}" clean)
. endfor
.endif

preclean:

postclean:

.if !target(clean)
clean: preclean .WAIT doclean .WAIT postclean
.endif

.if !target(cleacvs)
cleacvs:
	@for i in .#*.*[0-9].*[0-9]; do ${ECHO} ${PWD}/$${i}; ${RM} -f $${i}; done
. for I in ${SUBDIR} ${SUPDIR}
	@(cd ${I};${MAKE} ${MAKEFLAGS} cleacvs)
. endfor
.endif

#######################################################################################################

.if !target(doall)
doall: ${INCH} ${LEXORH} ${INCI} objnlib ${PROG} ${MGEN} ${SCRIPTS} ${DATA} ${SAMPLE} ${CONF} ${CONG}
.endif

.if !target(objnlib)
objnlib: ${SHLIBNAME} ${STLIBNAME} ${PGMODOBJ}
.endif

.if !target(doman)
doman: postall ${MANZ1} ${MAN3ZRG} ${MANZ3} ${MANZ5} ${MANZ8}
.endif

preall: Makefile

postall: supdir

.if !target(all)
all: notify preall .WAIT subdir .WAIT doall .WAIT supdir .WAIT postall doman
.endif

#######################################################################################################

.if !target(doinstall)
doinstall: subdirinstall
. if defined(DOSHLIB)
	${MKDIR} -p ${DESTDIR}${LIBODIR}
	${INSTALL_DATA} ${SHLIBVNAME} ${DESTDIR}${LIBODIR}
	${RM} -f ${DESTDIR}${LIBODIR}/${SHLIBNAME}
	${LN} -sf ${SHLIBVNAME} ${DESTDIR}${LIBODIR}/${SHLIBNAME}
.  if !defined(DESTDIR)
	${LDCONFIG} -elf -m ${LIBODIR}
.  endif
. endif
. if defined(STLIB)
	${MKDIR} -p ${DESTDIR}${LIBODIR}
	${INSTALL_DATA} ${STLIBNAME} ${DESTDIR}${LIBODIR}
. endif
. if defined(INCI)
.  for I in ${INCI}
	${MKDIR} -p ${DESTDIR}${FORINCLUDEDIR}
	${INSTALL_DATA} ${I} ${DESTDIR}${FORINCLUDEDIR}
.  endfor
. endif
. if defined(PROG)
.  if defined(BINOVER)
	${MKDIR} -p ${DESTDIR}${BINOVER}
.   for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${DESTDIR}${BINOVER}/${I}
.   endfor
.  else
	${MKDIR} -p ${DESTDIR}${BINDIR}
.   for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${DESTDIR}${BINDIR}/${I}
.   endfor
.  endif
. endif
. if defined(SCRIPTS)
.  if defined(BINOVER)
	${MKDIR} -p ${DESTDIR}${BINOVER}
.   for I in ${SCRIPTS}
.    if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${DESTDIR}${BINOVER}/${I}
	${CHMOD} ${BINMODE} ${DESTDIR}${BINOVER}/${I}
.    else
	${INSTALL_SCRIPT} ${I} ${DESTDIR}${BINOVER}/${I}
.    endif
.   endfor
.  else
	${MKDIR} -p ${DESTDIR}${BINDIR}
.   for I in ${SCRIPTS}
.    if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${DESTDIR}${BINDIR}/${I}
	${CHMOD} ${BINMODE} ${DESTDIR}${BINDIR}/${I}
.    else
	${INSTALL_SCRIPT} ${I} ${DESTDIR}${BINDIR}/${I}
.    endif
.   endfor
.  endif
. endif
. if defined(PGMOD)
	${MKDIR} -p ${DESTDIR}${PG_MODULEDIR}
.  for I in ${PGMOD}
	${INSTALL_DATA} ${I}.so.${VMAJOR} ${DESTDIR}${PG_MODULEDIR}/${I}.so.${VMAJOR}
.  endfor
. endif
. if defined(MANZ1)
	${MKDIR} -p ${DESTDIR}${MAN1DIR}
.  for I in ${MANZ1}
	${INSTALL_MAN} ${I} ${DESTDIR}${MAN1DIR}/${I}
.  endfor
. endif
. if defined(MANZ3)
	${MKDIR} -p ${DESTDIR}${MAN3DIR}
.  for I in ${MANZ3}
	${INSTALL_MAN} ${I} ${DESTDIR}${MAN3DIR}/${I}
.  endfor
. endif
. if defined(MAN3)
	${MKDIR} -p ${DESTDIR}${MAN3DIR}
.  for I in ${MAN3}
	${LN} -f ${DESTDIR}${MAN3DIR}/${PKG}.3.gz ${DESTDIR}${MAN3DIR}/${I}.3.gz
.  endfor
. endif
. if defined(MANZ5)
	${MKDIR} -p ${DESTDIR}${MAN5DIR}
.  for I in ${MANZ5}
	${INSTALL_MAN} ${I} ${DESTDIR}${MAN5DIR}/${I}
.  endfor
. endif
. if defined(MANZ8)
	${MKDIR} -p ${DESTDIR}${MAN8DIR}
.  for I in ${MANZ8}
	${INSTALL_MAN} ${I} ${DESTDIR}${MAN8DIR}/${I}
.  endfor
. endif
. if defined(DATADIR)
.  if defined(DATA)
	${MKDIR} -p ${DESTDIR}${DATADIR}
	${INSTALL_DATA} ${DATA} ${DESTDIR}${DATADIR}
.  endif
.  if defined(SAMPLE)
	${MKDIR} -p ${DESTDIR}${DATADIR}
.   for I in ${SAMPLE}
	${INSTALL_DATA} ${I} ${DESTDIR}${DATADIR}/${I}.sample
	@if [ ! -e ${DESTDIR}${DATADIR}/${I} ]; then\
            ${INSTALL_DATA} ${I} ${DESTDIR}${DATADIR}/${I};\
        fi
.   endfor
.  endif
. endif
. if defined(CONF) || defined(CONG)
	${MKDIR} -p ${DESTDIR}${CONFDIR}
.  for I in ${CONF} ${CONG}
.   if defined(SCRIPTFILTER)
	${RM} -f ${DESTDIR}${CONFDIR}/${I}.orig
	${SED} ${SCRIPTFILTER} ${I} > ${DESTDIR}${CONFDIR}/${I}.orig
	${CHMOD} ${DATAMODE} ${DESTDIR}${CONFDIR}/${I}.orig
.   else
	${INSTALL_DATA} ${I} ${DESTDIR}${CONFDIR}/${I}.orig
.   endif
.   if defined(CONFOWER)
	${MV} ${DESTDIR}${CONFDIR}/${I}.orig ${DESTDIR}${CONFDIR}/${I}
.   else
	${CONFIGCONF} -i ${DESTDIR}${CONFDIR}/${I}
.   endif
.  endfor
. endif
.endif

.if !target(subdirinstall)
subdirinstall: preinstall
. for I in ${SUBDIR}
	@(cd ${I};                                                                                    \
          ${MAKE} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"                                       \
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"                       \
                  LIBEDIR="${LIBEDIR}" CONFDIR="${CONFDIR}" ROOTDATA="${ROOTDATA}"                    \
                  BINMODE="${BINMODE}" MANMODE="${MANMODE}" DATAMODE="${DATAMODE}"                    \
                  INSTALL_PROGRAM="${INSTALL_PROGRAM}" INSTALL_SCRIPT="${INSTALL_SCRIPT}"             \
                  INSTALL_DATA="${INSTALL_DATA}" INSTALL_MAN="${INSTALL_MAN}"                         \
                  OWNER="${OWNER}" CHOWNER="${CHOWNER}"                                               \
                  BINDIR="${BINDIR}" MAN1DIR="${MAN1DIR}" MAN8DIR="${MAN8DIR}"                        \
                  ${MAKEFLAGS} install                                                                \
        )
. endfor
.endif

.if !target(supdirinstall)
supdirinstall: doinstall
. for I in ${SUPDIR}
	@(cd ${I};                                                                                    \
          ${MAKE} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"                                       \
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"                       \
                  LIBEDIR="${LIBEDIR}" CONFDIR="${CONFDIR}" ROOTDATA="${ROOTDATA}"                    \
                  BINMODE="${BINMODE}" MANMODE="${MANMODE}" DATAMODE="${DATAMODE}"                    \
                  INSTALL_PROGRAM="${INSTALL_PROGRAM}" INSTALL_SCRIPT="${INSTALL_SCRIPT}"             \
                  INSTALL_DATA="${INSTALL_DATA}" INSTALL_MAN="${INSTALL_MAN}"                         \
                  OWNER="${OWNER}" CHOWNER="${CHOWNER}"                                               \
                  BINDIR="${BINDIR}" MAN1DIR="${MAN1DIR}" MAN8DIR="${MAN8DIR}"                        \
                  ${MAKEFLAGS} install                                                                \
        )
. endfor
.endif

.if !target(preinstall)
preinstall: notify all
.endif

.if !target(postinstall)
postinstall: supdirinstall
.endif

.if !target(install)
install: preinstall .WAIT subdirinstall .WAIT doinstall .WAIT supdirinstall .WAIT postinstall
. if defined(VMINOR)
	${MKDIR} -p "${DESTDIR}${VERSIONDIR}"
.  if defined(PROTOVER)
	${ECHO} "${VMAJOR}.${VMINOR}" > "${DESTDIR}${VERSIONDIR}/${PKG}:${PROTOVER}.VERSION"
.  else
	${ECHO} "${VMAJOR}.${VMINOR}" > "${DESTDIR}${VERSIONDIR}/${PKG}.VERSION"
.  endif
. endif
.endif

#######################################################################################################

.if !target(dorelease)
dorelease: dotag .WAIT tarball
. for I in ${REMOTE_SRCDIR}
	${SCP} ${DISTNM}.tar.gz ${I}
. endfor
. for I in ${LOCAL_SRCDIR}
	${CP} ${DISTNM}.tar.gz ${I}
. endfor
	@${MD5} ${DISTNM}.tar.gz
	@${ECHO} "SIZE (${DISTNM}.tar.gz) ="`wc -c < "${DISTNM}.tar.gz"`
	@${SHA256} ${DISTNM}.tar.gz
.endif

.if !target(dotarball)
dotarball:
	${MKDIR} -p ${DISTNM}
	${CP} -p ${DIST} ${DISTNM}/
. for I in ${SUBDIR} ${SUPDIR}
	@(cd ${I}; ${MAKE} PKG="${PKG}" ${MAKEFLAGS} DISTNM="../${DISTNM}/${I}" tarball)
. endfor
. if defined(VMINOR)
	${TAR} -czvf ${DISTNM}.tar.gz ${DISTNM}
	${RM} -rf ${DISTNM}
. endif
.endif

.if !target(tarball)
tarball: pretarball .WAIT dotarball .WAIT posttarball
.endif

.if !target(pretarball)
pretarball:
.endif

.if !target(posttarball)
posttarball: pretarball .WAIT dotarball
.endif

.if !target(dotag)
dotag: prerelease
. if defined(VMINOR)
	${CVS} -q up -dP
	${CVS} tag r${VMAJOR}_${VMINOR}
. endif
.endif

.if !target(rerelease)
rerelease: delrelease .WAIT release
.endif

.if !target(delrelease)
delrelease:
. if defined(VMINOR)
	${CVS} tag -d r${VMAJOR}_${VMINOR}
. endif
.endif

.if !target(prerelease)
prerelease:
.endif

.if !target(postrelease)
postrelease: dorelease
.endif

.if !target(release)
release: prerelease .WAIT dorelease .WAIT postrelease
.endif
