/*-
 * Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: utils.c,v 1.5 2021/10/25 15:04:44 cuhegh Exp $\n"

#define Bpars_COMPAT  4
#define MULAR_COMPAT  0
#define MIFE_COMPAT   5
#define BLIN_COMPAT   VMAJOR
#define BLIN_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "blinread.h"

static u_int64_t
pow10(int8_t num) {
    u_int64_t ret;
    for (ret = 1; num > 0; num--) ret *= 10;
    return(ret);
}

int
tim2i(BLINr_cfg *cfg, BLINr_time *time, const char *optargs) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)

    const char *mem;
    struct tm   stime1;               /*      ISO */
    struct tm   stime2;               /*      ISO */
    int         ex = EX_OK;           /*                            */

    stime1.tm_zone = NULL;
    stime1.tm_hour = 0;
    stime1.tm_min = 0;
    stime1.tm_sec = 0;
    time->nrng = 1;
    time->to = 0;
    if  (!!time->abs) {
        time->from = 0;
        stime1.tm_year = strtoul(optargs, (char**) &optargs, 10) - 1900;
        if  (*optargs != '-') isJX(EX_USAGE, "bad syntax");
        optargs++;
        stime1.tm_mon  = strtoul(optargs, (char**) &optargs, 10) - 1;
        if  (*optargs != '-') isJX(EX_USAGE, "bad syntax");
        optargs++;
        stime1.tm_mday = strtoul(optargs, (char**) &optargs, 10);
        if  (*optargs == '_') {
            optargs++;
            stime1.tm_hour = strtoul(optargs, (char**) &optargs, 10);
            if  (*optargs != ':') isJX(EX_USAGE, "bad syntax");
            optargs++;
            stime1.tm_min  = strtoul(optargs, (char**) &optargs, 10);
            if  (*optargs != ':') isJX(EX_USAGE, "bad syntax");
            optargs++;
            stime1.tm_sec  = strtoul(optargs, (char**) &optargs, 10);
            if  (*optargs == '.') {
                mem = ++optargs;
                time->from = strtoul(optargs, (char**) &optargs, 10) * pow10(9 -(optargs - mem));
            } else if(*optargs != '\0') {
                isJX(EX_USAGE, "bad syntax");
        }   }
        time->from += mktime(&stime1) * BLINr_E9;
        if  (*optargs == '-') {
            time->nrng = 0;
            time->to = 0;
            stime2.tm_zone = NULL;
            stime2.tm_hour = 0;
            stime2.tm_min = 0;
            stime2.tm_sec = 0;
            stime2.tm_year = strtoul(optargs, (char**) &optargs, 10) - 1900;
            if  (*optargs != '-') isJX(EX_USAGE, "bad syntax");
            optargs++;
            stime2.tm_mon  = strtoul(optargs, (char**) &optargs, 10) - 1;
            if  (*optargs != '-') isJX(EX_USAGE, "bad syntax");
            optargs++;
            stime2.tm_mday = strtoul(optargs, (char**) &optargs, 10);
            if  (*optargs == '_') {
                optargs++;
                stime2.tm_hour = strtoul(optargs, (char**) &optargs, 10);
                if  (*optargs != ':') isJX(EX_USAGE, "bad syntax");
                optargs++;
                stime2.tm_min  = strtoul(optargs, (char**) &optargs, 10);
                if  (*optargs != ':') isJX(EX_USAGE, "bad syntax");
                optargs++;
                stime2.tm_sec  = strtoul(optargs, (char**) &optargs, 10);
                if  (*optargs == '.') {
                    mem = ++optargs;
                    time->to = strtoul(optargs, (char**) &optargs, 10) * pow10(9 -(optargs - mem));
                } else if(*optargs != '\0') {
                    isJX(EX_USAGE, "bad syntax");
            }   }
            time->to += mktime(&stime2) * BLINr_E9;
        } else if(*optargs != '\0') {
            isJX(EX_USAGE, "bad syntax");
        }
    } else {
        time->from = strtoul(optargs, (char**) &optargs, 0) * BLINr_E9;
        if  (*optargs == '.') {
            mem = ++optargs;
            time->from += strtoul(optargs, (char**) &optargs, 10) * pow10(9 - (optargs - mem));
        }
        if  (*optargs == '-') {
            time->nrng = 0;
            optargs++;
            time->to = strtoul(optargs, (char**) &optargs, 0) * BLINr_E9;
            if  (*optargs == '.') {
                mem = ++optargs;
                time->to += strtoul(optargs, (char**) &optargs, 10) * pow10(9 -(optargs - mem));
            } else if(*optargs != '\0') {
                isJX(EX_USAGE, "bad syntax");
            }
        } else if(*optargs != '\0') {
            isJX(EX_USAGE, "bad syntax");
        } else {
            time->nrng = 1;
    }   }
out:
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}

BLIN_trace *
BLINr_next_wind(BLINr_cfg *cfg) {
#   define isJX(FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); twind = NULL; goto out; }while(0)
#   define isJW(FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); twind = NULL; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    off_t       offset;           /*                */
    BLIN_trace *twind;            /*   tracfile                 */
    u_int32_t   windsize;         /*     tracfile */

    if  (!(twind = mife_pointer(cfg->tfile))) {
        if  (!(twind = mife_window(cfg->tfile, 0, sizeof(u_int32_t)))) isJW("mife_window");
        if  (mife_ctlsize(cfg->tfile) < sizeof(u_int32_t)) isJX("less than u_int32_t");
        windsize = twind->len;
        if  (!(twind = mife_window(cfg->tfile, 0, windsize + sizeof(u_int32_t)))) isJW("mife_window");
        ifBLIN_QX5("%"BLIN_X"[%X]%X", twind, mife_ctlsize(cfg->tfile), windsize);
        if  (mife_ctlsize(cfg->tfile) < windsize) isJX("less than asked");
    } else if (mife_ctlsize(cfg->tfile) < sizeof(u_int32_t)) {
        isJX("less than u_int32_t");
    } else {
        windsize = twind->len;
        offset = cfg->tfile->ofpoint + windsize;
        ifBLIN_QX5("%"BLIN_X"[%X]%X", twind, mife_ctlsize(cfg->tfile), windsize);
        if  (mife_ctlsize(cfg->tfile) < (windsize + sizeof(u_int32_t))) {
            twind = NULL;
            goto out;
        }
        twind = (BLIN_trace *)((char *)twind + windsize);
        ifBLIN_QX5("%"BLIN_X, twind);
        windsize = twind->len;
        if  (!(twind = mife_window(cfg->tfile, offset, windsize + sizeof(u_int32_t)))) {
            isJW("mife_window");
        }
        ifBLIN_QX5("%"BLIN_X"[%u]%u", twind, mife_ctlsize(cfg->tfile), windsize);
        if  (mife_ctlsize(cfg->tfile) < windsize) isJX("less than asked");
    }
out:
    return(twind);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}
