/*-
 * Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: pout.c,v 1.11 2021/09/05 15:36:28 cuhegh Exp $\n"

#define Bpars_COMPAT  4
#define MULAR_COMPAT  0
#define MIFE_COMPAT   5
#define BLIN_COMPAT   VMAJOR
#define BLIN_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "blinread.h"

int
BLINr_rp(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    BLINr_fraze      *curfraze;                /*                            */
    u_int8_t          termvar;                 /*                     */
    u_int8_t          truvar;                  /*                      */
    u_int64_t         fstime;                  /*    tracfile                    */
    time_t            htime;                   /*   stime                            */
    struct tm        *stime    = NULL;         /*      ISO        */
    int               ex       = EX_OK;        /*                                 */
    u_int32_t         p;                       /* ޣ,               */

    for (fstime = twind->time; ; twind = BLINr_next_wind(cfg)) {
        if  (!twind) isJW(EX_IOERR, "tracefile window %"BLIN_U, cfg->tfile->ofpoint);
        ifBLIN_QX3( "twind={%u %u %u %"BLIN_O"u %u %u %u %u %u %.*s}"
                  , twind->len
                  , twind->level
                  , twind->pid
                  , twind->time
                  , twind->erno
                  , twind->line
                  , twind->progsz
                  , twind->filesz
                  , twind->funcsz
                  , (int)(twind->len - offsetof(BLIN_trace, string))
                  , twind->string
                  )
        ;
        for (curfraze = cfg->filt; curfraze; curfraze = curfraze->next) {
            /*      BLINREAD_X */
            ifBLIN_QX3("curfraze %X", curfraze);
            if  (curfraze->flags & BLINREAD_X) {
                truvar = 0;
                termvar = 0;
            }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->time.from == curfraze->time.to) {
                truvar &= ~(termvar & BLINREAD_T);
            } else {
                BLINr_time *i;

                truvar  |= BLINREAD_T;
                termvar |= BLINREAD_T;
                for (p = curfraze->time.from; p < curfraze->time.to; ++p) {
                    if  (!(i = mular_getix(cfg->time, p))) isJW(1, "time getix(%u)", p);
                    ifBLIN_QX5("mular_line(%u) %u-%u %u %u", p, i->from, i->to, i->nrng, i->abs);
                    if  (  (!!i->nrng && (i->from == twind->time))
                        || (  !i->nrng
                           && ((i->from + (i->abs ? 0 : fstime)) <= twind->time)
                           && (twind->time <= (i->to + (i->abs ? 0 : fstime)))
                        )  ) {
                        truvar &= ~BLINREAD_T;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->pid.from == curfraze->pid.to) {
                truvar &= ~(termvar & BLINREAD_I);
            } else {
                u_int32_t *i;

                truvar  |= BLINREAD_I;
                termvar |= BLINREAD_I;
                for (p = curfraze->pid.from; p < curfraze->pid.to; ++p) {
                    if  (!(i = mular_getix(cfg->pid, p))) isJW(1, "pid getix(%u)", p);
                    ifBLIN_QX5("mular_pid(%u) %u", p, *i);
                    if  (*i == twind->pid) {
                        truvar &= ~BLINREAD_I;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->prog.from == curfraze->prog.to) {
                truvar &= ~(termvar & BLINREAD_R);
            } else {
                const char **i;

                truvar  |= BLINREAD_R;
                termvar |= BLINREAD_R;
                for (p = curfraze->prog.from; p < curfraze->prog.to; ++p) {
                    if  (!(i = mular_getix(cfg->prog, p))) isJW(1, "prog getix(%u)", p);
                    ifBLIN_QX5("mular_prog(%u) %zd %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->progsz)
                        && !strncmp(*i, &twind->string[0], twind->progsz)
                        ) {
                        truvar &= ~BLINREAD_R;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->file.from == curfraze->file.to) {
                truvar &= ~(termvar & BLINREAD_S);
            } else {
                const char **i;

                truvar  |= BLINREAD_S;
                termvar |= BLINREAD_S;
                ifBLIN_QX3( "%u %.*s"
                          , twind->filesz
                          , (int) twind->filesz
                          , &twind->string[twind->progsz]
                          )
                ;
                for (p = curfraze->file.from; p < curfraze->file.to; ++p) {
                    if  (!(i = mular_getix(cfg->file, p))) isJW(1, "file getix(%u)", p);
                    ifBLIN_QX5("mular_file(%u) %zd %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->filesz)
                        && !strncmp(*i, &twind->string[twind->progsz], twind->filesz)
                        ) {
                        truvar &= ~BLINREAD_S;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->func.from == curfraze->func.to) {
                truvar &= ~(termvar & BLINREAD_U);
            } else {
                const char **i;

                truvar  |= BLINREAD_U;
                termvar |= BLINREAD_U;
                for (p = curfraze->func.from; p < curfraze->func.to; ++p) {
                    if  (!(i = mular_getix(cfg->func, p))) isJW(1, "func getix(%u)", p);
                    ifBLIN_QX5("mular_func(%u) %zd %s", p, strlen(*i), *i);
                    if  (  (strlen(*i) == twind->funcsz)
                        && !strncmp( *i
                                   , &twind->string[twind->progsz + twind->filesz]
                                   , twind->funcsz
                        )          ) {
                        truvar &= ~BLINREAD_U;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (curfraze->line.from == curfraze->line.to) {
                truvar &= ~(termvar & BLINREAD_N);
            } else {
                BLINr_line *i;

                truvar  |= BLINREAD_N;
                termvar |= BLINREAD_N;
                for (p = curfraze->line.from; p < curfraze->line.to; ++p) {
                    if  (!(i = mular_getix(cfg->line, p))) isJW(1, "line getix(%u)", p);
                    ifBLIN_QX5("mular_line(%u) %u-%u %u", p, i->from, i->to, i->nrng);
                    if  ( i->nrng
                        ? (i->from == twind->line)
                        : ((i->from <= twind->line) && (twind->line <= i->to))
                        ) {
                        truvar &= ~BLINREAD_N;
                        break;
            }   }   }
            ifBLIN_QX4("truvar %02X", truvar);
            if  (!curfraze->levfl) {
                truvar &= ~(termvar & BLINREAD_L);
            } else {
                truvar  |= BLINREAD_L;
                termvar |= BLINREAD_L;
                if  (curfraze->level & (1U << twind->level)) truvar &= ~BLINREAD_L;
            }
            truvar ^= curfraze->flags & BLINREAD_M;
            ifBLIN_QX3("truvar %02X, inv %02X", truvar, curfraze->flags & BLINREAD_M);
            if  (truvar == 0) break;
        }
        if  (truvar == 0) {
            if  (cfg->flags & BLINREAD_P_I) printf("%u ", twind->pid);
            if  (cfg->flags & BLINREAD_P_T) {
                printf( "%04"BLIN_O"u.%09u "
                      , (twind->time - fstime) / BLINr_E9
                      , (u_int32_t)((twind->time - fstime) % BLINr_E9)
                      )
                ;
            } else if  (cfg->flags & BLINREAD_P_D) {
                htime = twind->time / BLINr_E9;
                stime = localtime(&htime);
                printf( "%u-%02u-%02u %02u:%02u:%02u.%09u "
                      , stime->tm_year + 1900
                      , stime->tm_mon + 1
                      , stime->tm_mday
                      , stime->tm_hour
                      , stime->tm_min
                      , stime->tm_sec
                      , (u_int32_t)(twind->time % BLINr_E9)
                      )
                ;
            }
            if  (cfg->flags & BLINREAD_P_L) printf("%u ", twind->level);
            if  (cfg->flags & BLINREAD_P_E) printf("%u ", twind->erno);
            if  (cfg->flags & BLINREAD_P_R) printf("%.*s:", twind->progsz, twind->string);
            if  (cfg->flags & BLINREAD_P_S) {
                printf("%.*s:", twind->filesz, &twind->string[twind->progsz]);
            }
            if  (cfg->flags & BLINREAD_P_U) {
                printf( "%.*s:"
                      , twind->funcsz
                      , &twind->string[twind->progsz + twind->filesz]
                      )
                ;
            }
            if  (cfg->flags & BLINREAD_P_N) printf("%u:", twind->line);
            for ( p = 0
                ; twind->string[BLINr_slen(twind) - 1 - p] == '\n'
                ; p++
                ) {}
            printf( " %.*s\n"
                  , (int)( BLINr_slen(twind) - twind->progsz - twind->filesz - twind->funcsz - p)
                  , &twind->string[twind->progsz + twind->filesz + twind->funcsz]
                  )
            ;
        }
        if  (mife_ctlsize(cfg->tfile) == twind->len) break;
    }
out:
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}
