/*-
 * Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/\n"
#ident "@(#) $Id: over.c,v 1.10 2021/10/25 15:04:44 cuhegh Exp $\n"

#define Bpars_COMPAT  4
#define MULAR_COMPAT  0
#define MIFE_COMPAT   5
#define BLIN_COMPAT   VMAJOR
#define BLIN_INTERNAL

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sysexits.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stddef.h>
#include <malloc_np.h>
#include <limits.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"
#include <babolo/parser.h>
#include <multilar.h>
#include <mife.h>
#include "blinread.h"

static const size_t msz[] = {1024, 512, 512};

static int8_t
compare_sun(BLINr_qbuf_sun *sun, BLIN_trace *twind) {
    int8_t com;

    if  (sun->filesz == twind->filesz) {
        com = strncmp(*sun->file, &twind->string[twind->progsz], twind->filesz);
        if  (com != 0) {
            com *= 3;
            return(com);
        }
    } else if (sun->filesz > twind->filesz) {
        return(3);
    } else {
        return(-3);
    }
    if  (sun->funcsz == twind->funcsz) {
        com = strncmp(*sun->func, &twind->string[twind->progsz + twind->filesz], twind->funcsz);
        if  (com != 0) {
            com *= 2;
            return(com);
        }
    } else if (sun->funcsz > twind->funcsz) {
        return(2);
    } else {
        return(-2);
    }
    if  (sun->line == twind->line) {
        return(0);
    } else if (sun->line > twind->line) {
        return(1);
    } else {
        return(-1);
}   }

void
sunfree(void *fre) {
    BLINr_qbuf_sun *sun = fre;
    if  (!*sun->file) {
        free(*sun->file);
        *sun->file = NULL;
    }
    if  (!*sun->func) {
        free(*sun->func);
        *sun->func = NULL;
}   }

static int
srch_pid(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    int               ex = EX_OK;                /*   */
    mular_descriptor *mular = cfg->qbuf->pid;    /*    */
    u_int32_t        *pid = NULL;
    size_t            first = 0;
    size_t            mid = 0;
    size_t            last = 0;

    ifBLIN_QX2("+srch_pid");
    last = MULAR_NEXT(mular);
    if  (last == 0) goto put;
    ifBLIN_QX2("last=%zd", last);
    while(first != last) {
        mid = (first + last) / 2;
        ifBLIN_QX4("mid=%zd", mid);
        pid = mular_getix(mular, mid);
        if  (!pid) isJW(1, "getix %zd", mid);
        ifBLIN_QX4("getix(%zd) %u", mid, *pid);
        if  (*pid == twind->pid) {
            goto out;
        } else if (*pid > twind->pid) {
            last = mid;
        } else {
            if (first == mid) mid = last;
            first = mid;
        }
        ifBLIN_QX4("first=%zd last=%zd", first, last);
    }
put:
    pid = mular_insert(mular, mid);
    if  (!pid) isJW(EX_OSERR, "insert %zd", mid);
    *pid = twind->pid;
out:
    ifBLIN_QX2("-srch_pid %zu %u", mid, *pid);
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}

static int
srch_prog(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    int               ex = EX_OK;                /*   */
    mular_descriptor *mular = cfg->qbuf->prog;   /*    */
    char            **prog = NULL;
    int8_t            com;                       /*   */
    size_t            first = 0;
    size_t            mid = 0;
    size_t            last = 0;

    ifBLIN_QX2("+srch_prog");
    last = MULAR_NEXT(mular);
    if  (last == 0) goto put;
    ifBLIN_QX2("last=%zd", last);
    while(first != last) {
        mid = (first + last) / 2;
        ifBLIN_QX4("mid=%zd", mid);
        prog = mular_getix(mular, mid);
        if  (!prog) isJW(1, "getix %zd", mid);
        ifBLIN_QX4("getix(%zd) %s", mid, *prog);
        if  (strlen(*prog) == twind->progsz) {
            com = strncmp(*prog, &twind->string[0], twind->progsz);
        } else if (strlen(*prog) > twind->progsz){
            com = 1;
        } else {
            com = -1;
        }
        if  (com == 0) {
            goto out;
        } else if (com > 0) {
            last = mid;
        } else {
            if (first == mid) mid = last;
            first = mid;
        }
        ifBLIN_QX4("first=%zd last=%zd", first, last);
    }
put:
    prog = mular_insert(mular, mid);
    if  (!prog) isJW(EX_OSERR, "insert %zd", mid);
    ifBLIN_QX2("now strndup prog");
    ifBLIN_QX4( "strndup %u %.*s"
              , twind->progsz
              , twind->progsz
              , &twind->string[0]
              )
    ;
    *prog = strndup(&twind->string[0], twind->progsz);
    if  (!*prog) isJW(EX_OSERR, "strndup");
    ifBLIN_QX4("*prog = %s", *prog);
out:
    ifBLIN_QX2("-srch_prog %zu %s", mid, *prog);
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}

static int
srch_sun(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    int               ex = EX_OK;                /*   */
    mular_descriptor *mular = cfg->qbuf->sun;    /*    */
    BLINr_qbuf_sun   *sun = NULL;
    int8_t            com = 1;                    /*   */
    char            **smem, **umem;
    size_t            first = 0;
    size_t            mid = 0;
    size_t            last = 0;

    ifBLIN_QX2("+srch_sun");
    last = MULAR_NEXT(mular);
    smem = umem = NULL;
    if  (last == 0) goto put;
    ifBLIN_QX2("last=%zd", last);
    while(first != last) {
        mid = (first + last) / 2;
        ifBLIN_QX4("mid=%zd", mid);
        sun = mular_getix(mular, mid);
        if  (!sun) isJW(1, "getix(%zd)", mid);
        ifBLIN_QX4( "getix(%zd) {%u, %s, %u, %s, %u}"
                  ,  mid
                  ,  sun->filesz
                  , *sun->file
                  ,  sun->funcsz
                  , *sun->func
                  ,  sun->line
                  )
        ;
        com = compare_sun(sun, twind);
        if  (com == 0) {
            goto out;
        } else if (com > 0) {
            last = mid;
        } else {
            if (first == mid) mid = last;
            first = mid;
        }
        if  (abs(com) <= 2) smem = sun->file;
        if  (abs(com) == 1) umem = sun->func;
        ifBLIN_QX4("first=%zd last=%zd", first, last);
    }
put:
    sun = mular_insert(mular, mid);
    if  (!sun) isJW(EX_OSERR, "insert %zd", mid);
    if  (!smem) {
        ifBLIN_QX2("now strndup file");
        sun->file = malloc(sizeof(char*));
        ifBLIN_QX4("strndup %u %.*s", twind->filesz, twind->filesz, &twind->string[twind->progsz]);
        *sun->file = strndup(&twind->string[twind->progsz], twind->filesz);
        if  (!sun->file) isJW(EX_OSERR, "file strndup");
    } else {
        sun->file = smem;
    }
    ifBLIN_QX4("sun->file = %s", *sun->file);
    if  (!umem) {
        ifBLIN_QX2("now strndup func");
        sun->func = malloc(sizeof(char*));
        ifBLIN_QX4( "strndup %u %.*s"
                  , twind->funcsz
                  , twind->funcsz
                  , &twind->string[twind->progsz + twind->filesz]
                  )
        ;
        *sun->func = strndup(&twind->string[twind->progsz + twind->filesz], twind->funcsz);
        if  (!sun->func) isJW(EX_OSERR, "func strndup");
    } else {
        ifBLIN_QX4("umem = %"BLIN_U, umem);
        sun->func = umem;
    }
    ifBLIN_QX4("sun->func = %s", sun->func);
    sun->line = twind->line;
    sun->filesz = twind->filesz;
    sun->funcsz = twind->funcsz;
out:
    ifBLIN_QX2( "-srch_sun %d %zd {%u, %s, %u, %s, %u}"
              , com
              , mid
              , sun->filesz
              , sun->file
              , sun->funcsz
              , sun->func
              , sun->line
              )
    ;
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}

int
BLINr_rq(BLINr_cfg *cfg, BLIN_trace *twind) {
#   define isJX(EXCODE, FORMAT, ...) \
        do { ifBLIN_QX0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define isJW(EXCODE, FORMAT, ...) \
        do { ifBLIN_QW0("!!" FORMAT, ## __VA_ARGS__); ex = EXCODE; goto out; }while(0)
#   define blin_internal_flags (cfg->flags & BLIN_MASK)
    u_int64_t   fstime;                /*    tracfile         */
    int         ex = EX_OK;            /*                      */
    BLINr_qbuf *qbuf = NULL;           /*                       */

    ifBLIN_QX2("now qbuf alloc");
    if  (!(qbuf = cfg->qbuf = calloc(1, sizeof(BLINr_qbuf)) )) isJW(EX_OSERR, "qbuf alloc");
    qbuf->time1 = qbuf->time2 = fstime = twind->time;
    if  (cfg->flags & (BLINREAD_P_D | BLINREAD_P_T)) {
        ifBLIN_QX4("qbuf->time={%"BLIN_O"u %"BLIN_O"u}", qbuf->time1, qbuf->time2);
    }
    if  (cfg->flags & BLINREAD_P_I) {
        qbuf->pid = mular_create(MULAR_OBJ | MULAR_STRI, 3, sizeof(u_int32_t), msz);
        if  (!qbuf->pid) isJW(EX_OSERR, "qbuf->pid create");
    }
    if  (cfg->flags & BLINREAD_P_R) {
        qbuf->prog = mular_create(MULAR_OBJ | MULAR_STRI | MULAR_PFRE, 3, sizeof(char*), msz);
        if  (!qbuf->prog) isJW(EX_OSERR, "qbuf->prog create");
        qbuf->prog->tofree = free;    /* free() */
    }
    if  (cfg->flags & (BLINREAD_P_S | BLINREAD_P_U | BLINREAD_P_N)) {
        qbuf->sun = mular_create(MULAR_OBJ | MULAR_STRI, 3, sizeof(BLINr_qbuf_sun), msz);
        if  (!qbuf->sun) isJW(EX_OSERR, "qbuf->sun create");
        qbuf->sun->tofree = sunfree;    /* sunfree() */
    }
    for (; ; twind = BLINr_next_wind(cfg)) {
        if  (!twind) isJW(EX_IOERR, "tracefile window %"BLIN_U, cfg->tfile->ofpoint);
        ifBLIN_QX4( "twind={%u %u %u %"BLIN_O"u %u %u %u %u %u %.*s}"
                  , twind->len
                  , twind->level
                  , twind->pid
                  , twind->time
                  , twind->erno
                  , twind->line
                  , twind->progsz
                  , twind->filesz
                  , twind->funcsz
                  , (int) (twind->len - offsetof(BLIN_trace, string))
                  , twind->string
                  )
        ;
        qbuf->level |= (0x01 << twind->level);
        if  (cfg->flags & BLINREAD_P_L) ifBLIN_QX4("qbuf->level=%02x", qbuf->level);
        if  (twind->time < qbuf->time1) {
            ifBLIN_QX3( "Base time shift %"BLIN_O"u.%09u > %"BLIN_O"u.%09u"
                      , qbuf->time1 / BLINr_E9
                      , (u_int32_t)(qbuf->time1 % BLINr_E9)
                      , twind->time / BLINr_E9
                      , (u_int32_t)(twind->time % BLINr_E9)
                      );
            qbuf->time1 = twind->time;
        } else if(qbuf->time2 < twind->time) {
            qbuf->time2 = twind->time;
        }
        if  (cfg->flags & (BLINREAD_P_D | BLINREAD_P_T)) {
            ifBLIN_QX4("qbuf->time={%"BLIN_O"u %"BLIN_O"u}", qbuf->time1, qbuf->time2);
        }
        if  (!!qbuf->pid) {
            if  (!!srch_pid(cfg, twind)) {
                isJW(EX_OSERR, "qbuf->pid srch");
        }   }
        if  (!!qbuf->prog) {
            if  (!!srch_prog(cfg, twind)) {
                isJW(EX_OSERR, "qbuf->prog srch");
        }   }
        if  (!!qbuf->sun) {
            if  (!!srch_sun(cfg, twind)) {
                isJW(EX_OSERR, "qbuf->sun srch");
        }   }
        if  (mife_ctlsize(cfg->tfile) == twind->len) break;
    }
    if  (cfg->flags & BLINREAD_P_D) {
        struct tm *h = NULL;
        time_t     t;

        t = qbuf->time1 / BLINr_E9;
        h = localtime(&t);
        if  (qbuf->time1 == qbuf->time2) {
            printf( "datime %u-%02u-%02u %02u:%02u:%02u.%09u\n"
                  , h->tm_year + 1900
                  , h->tm_mon + 1
                  , h->tm_mday
                  , h->tm_hour
                  , h->tm_min
                  , h->tm_sec
                  , (u_int32_t)(qbuf->time1 % BLINr_E9)
                  );
        } else {
            printf( "datime from %u-%02u-%02u %02u:%02u:%02u.%09u"
                  , h->tm_year + 1900
                  , h->tm_mon + 1
                  , h->tm_mday
                  , h->tm_hour
                  , h->tm_min
                  , h->tm_sec
                  , (u_int32_t)(qbuf->time1 % BLINr_E9)
                  );
            t = qbuf->time2 / BLINr_E9;
            h = localtime(&t);
            printf( " to %u-%02u-%02u %02u:%02u:%02u.%09u\n"
                  , h->tm_year + 1900
                  , h->tm_mon + 1
                  , h->tm_mday
                  , h->tm_hour
                  , h->tm_min
                  , h->tm_sec
                  , (u_int32_t)(qbuf->time2 % BLINr_E9)
                  );
    }   }
    if  (cfg->flags & BLINREAD_P_T) {
        if  (qbuf->time1 == qbuf->time2) {
            printf( "time %"BLIN_O"u.%09u\n"
                  , (qbuf->time1 - fstime) / BLINr_E9
                  , (u_int32_t)((qbuf->time1 - fstime) % BLINr_E9)
                  );
        } else {
            printf( "time from %"BLIN_O"u.%09u to %"BLIN_O"u.%09u\n"
                  , (qbuf->time1 - fstime) / BLINr_E9
                  , (u_int32_t)((qbuf->time1 - fstime) % BLINr_E9)
                  , (qbuf->time2 - fstime) / BLINr_E9
                  , (u_int32_t)((qbuf->time2 - fstime) % BLINr_E9)
                  );
    }   }
    if  (cfg->flags & BLINREAD_P_L) {
        printf("\nlevel %02X\n", qbuf->level);
    }
    if  (cfg->flags & BLINREAD_P_I) {
        void *mulind = NULL;

        printf("\npid:\n");
        for (size_t i = 0; i < MULAR_NEXT(qbuf->pid); i++) {
            if  (!(mulind = mular_getix(qbuf->pid, i))) isJW(1, "qbuf pid getix");
            printf("%u ", *(u_int32_t*)mulind);
        }
        printf("\n");
    }
    if  (cfg->flags & BLINREAD_P_R) {
        void *mulind = NULL;

        printf("\nprog:\n");
        for (size_t i = 0; i < MULAR_NEXT(qbuf->prog); i++) {
            if  (!(mulind = mular_getix(qbuf->prog, i))) isJW(1, "qbuf prog getix");
            printf("%s ", *(char**)mulind);
        }
        printf("\n");
    }
    if  (cfg->flags & (BLINREAD_P_S | BLINREAD_P_U | BLINREAD_P_N)) {
        BLINr_qbuf_sun *sun, *psun;

        sun = psun = NULL;
        printf("\n");
        for (size_t i = 0; i < MULAR_NEXT(qbuf->sun); i++) {
            sun = mular_getix(qbuf->sun, i);
            if  (!sun) isJW(1, "qbuf->sun getix");
            if  (cfg->flags & BLINREAD_P_S) {
                if  (  (!psun)
                    || (sun->filesz != psun->filesz)
                    || !!strncmp(*sun->file, *psun->file, sun->filesz)
                    ) {
                    if  (cfg->flags & (BLINREAD_P_U | BLINREAD_P_N)) {
                        printf("%s:", *sun->file);
                    } else {
                        printf("%s\n", *sun->file);
                    }
                } else {
                    if  (cfg->flags & (BLINREAD_P_U | BLINREAD_P_N)) {
                        printf("%.*s ", sun->filesz, BLINr_SPACES);
            }   }   }
            if  (cfg->flags & BLINREAD_P_U) {
                if  (  (!psun)
                    || (sun->funcsz != psun->funcsz)
                    || !!strncmp(*sun->func, *psun->func, sun->funcsz)
                    ) {
                    if  (cfg->flags & BLINREAD_P_N) {
                        printf("%s:", *sun->func);
                    } else {
                        printf("%s\n", *sun->func);
                    }
                } else {
                    if  (cfg->flags & BLINREAD_P_N) {
                    printf("%.*s ", sun->funcsz, BLINr_SPACES);
            }   }   }
            if  (cfg->flags & BLINREAD_P_N) printf("%u\n", sun->line);
            psun = sun;
    }   }
out:
    return(ex);
#   undef isJX
#   undef isJW
#   undef blin_internal_flags
}
