/*-
 * Copyright (C)2020..2021 @BABOLO http://www.babolo.ru/
 * PKG = babolo-libmake
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: blinread.h,v 1.12 2021/10/25 15:04:44 cuhegh Exp $
 */

#define BLINr_slen(T) strnlen((T)->string, (T)->len - offsetof(BLIN_trace, string))
#define BLINr_E9      1000000000
#define BLINr_SPACES  "                                                                "              \
                      "                                                                "              \
                      "                                                                "              \
                      "                                                                "   /* 256 */

typedef struct {
    struct {
        u_int64_t from : 63
                , abs  : 1
        ;
    };
    struct {
        u_int64_t to   : 63
                , nrng : 1
        ;
    };
} BLINr_time;

typedef struct {
    u_int32_t     from;
    struct {
        u_int32_t to : 31
                , nrng : 1
        ;
    };
} BLINr_line;

typedef struct {              /*   (from <=  < to)   multilar */
    u_int32_t from;
    u_int32_t to;
} BLINr_range;

typedef struct BLINr_fraze BLINr_fraze;

struct BLINr_fraze {
    BLINr_fraze *next;
    BLINr_range  time;
    BLINr_range  pid;
    BLINr_range  prog;
    BLINr_range  file;
    BLINr_range  func;
    BLINr_range  line;
    u_int8_t     level;
    u_int8_t     levfl;          /*  0    */
    u_int8_t     flags;          /*       */
#   define BLINREAD_X   0x80U    /*    */
#   define BLINREAD_L   0x40U    /*                   */
#   define BLINREAD_T   0x20U    /*                  */
#   define BLINREAD_I   0x10U    /*  pid'                  */
#   define BLINREAD_R   0x08U    /*           */
#   define BLINREAD_S   0x04U    /*               */
#   define BLINREAD_U   0x02U    /*           */
#   define BLINREAD_N   0x01U    /*             */
#   define BLINREAD_M   0x7FU    /*                  */
};

typedef struct BLINr_qbuf_sun {
    char    **file;
    char    **func;
    u_int32_t line;
    u_int8_t  filesz;
    u_int8_t  funcsz;
} BLINr_qbuf_sun;

typedef struct BLINr_qbuf {
    u_int64_t         time1;
    u_int64_t         time2;
    mular_descriptor *pid;
    mular_descriptor *prog;
    mular_descriptor *sun;    /*     */
    u_int8_t          level;
} BLINr_qbuf;

typedef struct BLINr_cfg {
    BLIN_flag  flags;
#   define BLINREAD_P_H   0x00000200U    /*                 (-p h) */
#   define BLINREAD_P_L   0x00000100U    /*           (-p l) */
#   define BLINREAD_P_D   0x00000080U    /*                      (-p a) */
#   define BLINREAD_P_T   0x00000040U    /*     (-p t) */
#   define BLINREAD_P_I   0x00000020U    /*   pid'                  (-p i) */
#   define BLINREAD_P_R   0x00000010U    /*            (-p r) */
#   define BLINREAD_P_S   0x00000008U    /*                (-p s) */
#   define BLINREAD_P_U   0x00000004U    /*            (-p u) */
#   define BLINREAD_P_N   0x00000002U    /*              (-p n) */
#   define BLINREAD_P_E   0x00000001U    /*   errno                  (-p e) */
#   define BLINREAD_PMASC 0x000003FFU
#   define BLINREAD_Q     0x00800000U    /*      tracfile (-Q) */
    mife_descriptor  *tfile;
    BLINr_fraze      *filt;
    mular_descriptor *time;
    mular_descriptor *pid;
    mular_descriptor *prog;
    mular_descriptor *file;
    mular_descriptor *func;
    mular_descriptor *line;
    BLINr_qbuf       *qbuf;
} BLINr_cfg;

BLIN_trace *BLINr_next_wind __P((BLINr_cfg *cfg));
int         BLINr_rq        __P((BLINr_cfg *cfg, BLIN_trace *twind));
int         BLINr_rp        __P((BLINr_cfg *cfg, BLIN_trace *twind));
int         tim2i           __P((BLINr_cfg *cfg, BLINr_time *time, const char *optargs));
