builtin(divert,-1)
dnl Copyright @BABOLO (C)2005..2017 http://www.babolo.ru/
dnl PKG = babolo-libmake
dnl All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that the following conditions
dnl are met:
dnl 1. Redistributions of source code must retain the above copyright
dnl    notice, this list of conditions and the following disclaimer.
dnl 2. Redistributions in binary form must reproduce the above copyright
dnl    notice, this list of conditions and the following disclaimer in the
dnl    documentation and/or other materials provided with the distribution.
dnl
dnl THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
dnl ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
dnl IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
dnl ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
dnl FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
dnl DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
dnl OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
dnl HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
dnl LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
dnl OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
dnl SUCH DAMAGE.
dnl
dnl $Id: pgocgi.m4,v 1.15 2017/04/02 09:59:14 babolo Exp $

define(PGOBLIN_BANG,#!BINDIR/pgoblinbuiltin(ifelse,$1,,, $1))
define(DBMSCLASS,builtin(ifelse,DBMS,sqlite2,sqlite,DBMS,sqlite3,sqlite,pgsql))

--################################################
--# GETGET(_)  GET    
--#
--# #perform
--# CREATE TEMP TABLE g(i int4, n text, g text) WITHOUT OIDS;
--# #getget 2
--# #copyin 002
--# COPY g FROM stdin;
--################################################
define(GETGET,dnl
#performbuiltin(ifelse,$2,,, 000$2)
CREATE TEMP TABLE g(i builtin(ifelse,DBMSCLASS,sqlite,integer PRIMARY KEY,int4), n text, builtin(ifelse,$1,,g,$1) text)builtin(ifelse,DBMSCLASS,sqlite,, WITHOUT OIDS);
#getget builtin(ifelse,$1,,2,$1)
#copyin 00builtin(ifelse,$1,,2,$1)builtin(ifelse,$2,,,$2)
COPY g FROM stdin;
)

--################################################
--# GETPOST(_)  POST    
--#
--# #perform
--# CREATE TEMP TABLE p(i int4, n text, p text) WITHOUT OIDS;
--# #getpost 2
--# #copyin 002
--# COPY p FROM stdin;
--################################################
define(GETPOST,dnl
#performbuiltin(ifelse,$2,,, 000$2)
CREATE TEMP TABLE p(i builtin(ifelse,DBMSCLASS,sqlite,integer PRIMARY KEY,int4), n text, builtin(ifelse,$1,,p,$1) text)builtin(ifelse,DBMSCLASS,sqlite,, WITHOUT OIDS);
#getpost builtin(ifelse,$1,,2,$1)
#copyin 00builtin(ifelse,$1,,2,$1)builtin(ifelse,$2,,,$2)
COPY p FROM stdin;
)

--################################################
--# GETENV(_)      
--#
--# #perform
--# CREATE TEMP TABLE e(i int4, n text, e text) WITHOUT OIDS);
--# #getenv 2
--# #copyin 002
--# COPY e FROM stdin;
--################################################
define(GETENV,dnl
#performbuiltin(ifelse,$2,,, 000$2)
CREATE TEMP TABLE e(i builtin(ifelse,DBMSCLASS,sqlite,integer PRIMARY KEY,int4), n text, builtin(ifelse,$1,,e,$1) text)builtin(ifelse,DBMSCLASS,sqlite,, WITHOUT OIDS);
#getenv builtin(ifelse,$1,,2,$1)
#copyin 00builtin(ifelse,$1,,2,$1)builtin(ifelse,$2,,,$2)
COPY e FROM stdin;
)

--################################################
--# GETARG(_)      
--#
--# #perform
--# CREATE TEMP TABLE a(i int4, a text) WITHOUT OIDS;
--# #getarg 2
--# #copyin 002
--# COPY a FROM stdin;
--################################################
define(GETARG,dnl
#performbuiltin(ifelse,$2,,, 000$2)
CREATE TEMP TABLE a(i builtin(ifelse,DBMSCLASS,sqlite,integer PRIMARY KEY,int4), builtin(ifelse,$1,,a,$1) text)builtin(ifelse,DBMSCLASS,sqlite,, WITHOUT OIDS);
#getarg builtin(ifelse,$1,,2,$1)
#copyin 00builtin(ifelse,$1,,2,$1)builtin(ifelse,$2,,,$2)
COPY a FROM stdin;
)

--################################################
--# GETPROC(_)      
--#
--# #perform
--# CREATE TEMP TABLE c(c int4, i int4, a text) WITHOUT OIDS;
--# #getproc 2
--# #copyin 002
--# COPY c FROM stdin;
--################################################
define(GETPROC,dnl
#performbuiltin(ifelse,$2,,, 000$2)
CREATE TEMP TABLE c(builtin(ifelse,$1,,c,$1) int4, i int4, a text)builtin(ifelse,DBMSCLASS,sqlite,, WITHOUT OIDS);
#getproc builtin(ifelse,$1,,2,$1)
#copyin 00builtin(ifelse,$1,,2,$1)builtin(ifelse,$2,,,$2)
COPY c FROM stdin;
)

--################################################
--# PGOBLIN_CGIPRE(,MIME,)
--#   pgoblinbang    ,
--#    HTML   
--# text/html;charset=koi8-r  MIME   
--#   :
--# p - HTTP POST
--# g - HTTP GET
--# e -  
--# a -  
--# c -    
--#
--# #!BINDIR/pgoblin 
--# #echo
--# Content-Type: text/html;charset=koi8-r
--# 
--#  
--################################################
define(-=PGOBLIN_CGIPRE=-,builtin(ifelse,dnl
g, builtin(substr,$1, 0, 1), GETGETdnl
,p, builtin(substr,$1, 0, 1), GETPOSTdnl
,e, builtin(substr,$1, 0, 1), GETENVdnl
,a, builtin(substr,$1, 0, 1), GETARGdnl
,c, builtin(substr,$1, 0, 1), GETPROCdnl
)builtin(ifelse,dnl
$1,,,indir(-=PGOBLIN_CGIPRE=-,builtin(substr,$1, 1))dnl
))

define(PGOBLIN_CGIPRE,dnl
PGOBLIN_BANG($1)
#echo
Content-Type: builtin(ifelse,$2,,text/html;charset=koi8-r, $2)
$4

indir(-=PGOBLIN_CGIPRE=-,$3)dnl
#dnl
)

--################################################
--# PGOBLIN_BINPRE(,)
--#   pgoblinbang    ,
--#   
--#   :
--# p - HTTP POST
--# g - HTTP GET
--# e -  
--# a -  
--# c -    
--#
--# #!BINDIR/pgoblin 
--#  
--################################################
define(PGOBLIN_BINPRE,dnl
PGOBLIN_BANG($1)
indir(-=PGOBLIN_CGIPRE=-,$2)dnl
)

--################################################
--# WWWheader  header,   
--#
--# #cat
--# WWWROOTDATA/header
--################################################
define(WWWheader,#cat
WWWROOTDATA/header
#
)

--################################################
--# WWWmediator  mediator,   
--#
--# #cat
--# WWWROOTDATA/mediator
--################################################
define(WWWmediator,#cat
WWWROOTDATA/mediator
#
)

--################################################
--# WWWfooter  footer,   
--#
--# #cat
--# WWWROOTDATA/footer
--################################################
define(WWWfooter,#cat
WWWROOTDATA/footer
#
)

--################################################
--# PGOBLIN_CGIHD(TITLE,PARM)  HTML 
--#
--# headerTITLEmediator
--################################################
define(PGOBLIN_CGIHD,dnl
WWWheader
#echo
$1
builtin(ifelse,$2,,,dnl
#select
SELECT $2 FROM x;
)dnl
WWWmediator
)

--################################################
--# PGOBLIN_CGIHEAD(TITLE,PARM)    PGOBLIN_CGIHD
--#                         H1 
--#
--# headerTITLEmediator
--# <h1>TITLE</h1>
--################################################
define(PGOBLIN_CGIHEAD,dnl
PGOBLIN_CGIHD($1,$2)dnl
#echo
<h1>$1
builtin(ifelse,$2,,,dnl
#select
SELECT $2 FROM x;
)dnl
#echo
</h1>dnl
)

--################################################
--# hdoc(TITLE,BODY)   
--#
--# #!/usr/local/bin/pgoblin
--# #echo
--# Content-Type: text/html;charset=koi8-r
--#
--# headerTITLEmediator
--# BODY
--# footer
--################################################
define(hdoc,dnl
PGOBLIN_CGIPRE
PGOBLIN_CGIHD($1)dnl
$2
WWWfooter)

--################################################
--# hpage(TITLE,BODY)   
--#
--# #!/usr/local/bin/pgoblin
--# #echo
--# Content-Type: text/html;charset=koi8-r
--#
--# headerTITLEmediator
--# <h1>TITLE</h1>
--# BODY
--# footer
--################################################
define(hpage,dnl
hdoc($1,<h1>$1</h1>
$2))

builtin(divert)dnl
