# Copyright (C)2003..2017 @BABOLO http://www.babolo.ru/
# PKG = babolo-libmake
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: define.make,v 1.36 2018/04/24 08:25:50 babolo Exp $

PREFIX		?= /usr/local

.if defined(BASE)
. if defined(MODULE)
   LIBEDIR	?= ${PREFIX}/libexec/${BASE}/${MODULE}${SUBMODULE}
. else
   LIBEDIR	?= ${PREFIX}/libexec/${BASE}
. endif
  DATADIR	?= ${LIBEDIR}
  GENCLASS	?= ${MODULE}
  PKG		?= ${BASE}-${MODULE}${SUBMODULE}
.endif

.if defined(VMINOR)
  VERS	= ${VMAJOR}.${VMINOR}
  DISTNM= ${PKG}-${VERS}
  DATE	!= env LANG= LC_ALL= date +%v | sed -e 's| ||g'
.endif

BINMODE		?= 0555
MANMODE		?= 0444
DATAMODE	?= 0444
#OWNER		?= -o root -g wheel
CHOWNER 	?= "0:0"
INSTALL_PROGRAM	?= install -c -s ${OWNER} -m ${BINMODE}
INSTALL_SCRIPT	?= install -C ${OWNER} -m ${BINMODE}
INSTALL_DATA	?= install -C ${OWNER} -m ${DATAMODE}
INSTALL_MAN	?= install -C ${OWNER} -m ${MANMODE}
BINDIR		?= ${PREFIX}/bin
LIBIDIR		?= ${PREFIX}/lib
CONFDIR		?= ${PREFIX}/etc
LIBODIR		?= ${LIBIDIR}
MAN1DIR		?= ${PREFIX}/man/${MANLANG}/man1
MAN3DIR		?= ${PREFIX}/man/${MANLANG}/man3
MAN5DIR		?= ${PREFIX}/man/${MANLANG}/man5
MAN8DIR		?= ${PREFIX}/man/${MANLANG}/man8
LIBEDIR		?= ${PREFIX}/libexec/${PKG}
INCLUDEDIR	?= ${PREFIX}/include
FORINCLUDEDIR	?= ${INCLUDEDIR}
LIBINCLUDEDIR	?= ${INCLUDEDIR}/babolo
VERSIONDIR	?= ${LIBINCLUDEDIR}
BUILDINCLUDEDIR	?= ${LIBINCLUDEDIR}
WWWROOT		?= ${PREFIX}/www
CGIDIR		?= ${WWWROOT}/bin
BABOLOMAKE_CONF	?= ${PREFIX}/etc/babolomake.conf
AR		?= ar
CP		?= cp
MV		?= mv
RM		?= rm
SH		?= sh
LN		?= ln
M4		?= gm4
CAT		?= cat
SED		?= sed
AWK		?= awk
SCP		?= scp
CVS		?= cvs
MD5		?= md5
PLUSENV		?= env
TAR		?= tar
PWD		?= pwd
GZIP		?= gzip
MAKE		?= make
GREP		?= grep
ECHO		?= echo
MKDIR		?= mkdir
CHOWN		?= chown
CHMOD		?= chmod
TOOLS		?= tools
SHA256		?= sha256
RANLIB		?= ranlib
LDCONFIG	?= ldconfig
PG_CONFIG	?= pg_config
CONFIGCONF	?= babololib_configconf
EXECTMPL	?= ${PLUSENV} ECHO=${ECHO} CAT=${CAT} SED=${SED} GREP=${GREP} SH=${SH} ${SH} -e
PG_INCLDIR_SRV	!= if ${PG_CONFIG} --includedir-server 2>/dev/null; then fi
PG_MODULEDIR	!= if ${PG_CONFIG} --pkglibdir 2>/dev/null; then fi
PG_SQLIBDIR	?= ${PREFIX}/share/postgresql/contrib

.if !defined(PG_INCLDIR_SRV) || ${PG_INCLDIR_SRV} == ""
  PG_INCLDIR_SRV=${POSTGRESRC}/src/include
.endif

.if !defined(PG_MODULEDIR) || ${PG_MODULEDIR} == ""
  PG_MODULEDIR	=${LIBODIR}/postgresql
.endif

CFLAGS		+= ${CFLAGSPLUS} -DPREFIX=\"${PREFIX}\"
CFLAGS		+= -DVMAJOR=${VMAJOR} -DVERS=\"${VERS}\" -DDATE=\"${DATE}\"
LDFLAGS 	+= ${LDFLAGSPLUS}
MAKEFLAGS	+= -m /usr/share/mk
MAKEFLAGS	+= -m ${BUILDINCLUDEDIR} BUILDINCLUDEDIR=${BUILDINCLUDEDIR}
MAKEFLAGS	+= -m ${LIBINCLUDEDIR} LIBINCLUDEDIR=${LIBINCLUDEDIR}
.if defined(DESTDIR)
MAKEFLAGS	+= DESTDIR=${DESTDIR}
.endif
M4FLAGS		+= -DLIBINCLUDEDIR=${LIBINCLUDEDIR}
M4FLAGS		+= -DBUILDINCLUDEDIR=${BUILDINCLUDEDIR}
M4INC		+= ${LIBINCLUDEDIR}/def.m4
MAKEINC		+= ${LIBINCLUDEDIR}/define.make ${LIBINCLUDEDIR}/common.make Makefile

MISC		+= Makefile
DIST		+= ${SRCS} ${MANS1} ${MANS3} ${MANS5} ${MANS8} ${MISC} ${SQLS} ${CONF}
CLEAN		+= ${CONG}

.if defined(MACHINE_CPU)
. if (${MACHINE_CPU} == i386)
   FPIC	= pic
. else # amd64
   FPIC	= PIC
. endif
.endif

.if defined(MACHINE_ARCH)
. if (${MACHINE_ARCH} == i386)
   FPIC	= pic
. else # amd64
   FPIC	= PIC
. endif
.endif

.for I in ${LEXORL}
  LEXORH	+= ${I}.h
  CLEAN		+= ${I}.h
  MISC		+= ${I}.lexor
.endfor

.if defined(PROG)
  CLEAN		+= ${PROG}
. for I in ${PROG}
    SRCS	+= ${I}.c
. endfor
.endif

.for I in ${INCS}
  INCH		+= ${I}.h
.endfor
INCI		?= ${INCH}

.if defined(PGMOD)
. for I in ${PGMOD}
   DATA		+= ${I}.so.${VMAJOR}
   SRCS		+= ${I}.c
   CLEAN	+= ${I}.so.${VMAJOR}
. endfor
.endif

.for I in ${CSRC}
  SRCS		+= ${I}.c
  OBJS		+= ${I}.o
  CLEAN		+= ${I}.o
.endfor

.if defined(SHLIB)
. if defined(LIBNAME)
   DOSHLIB	= ${LIBNAME}
. else
   DOSHLIB	= ${PKG}
. endif
   SHLIBNAME	= lib${DOSHLIB}.so
   SHLIBVNAME	= ${SHLIBNAME}.${VMAJOR}
   CLEAN	+= ${SHLIBVNAME} ${SHLIBNAME}
.endif

.if defined(STLIB)
. if defined(LIBNAME)
   DOSTLIB	+= ${LIBNAME}
. else
   DOSTLIB	+= ${PKG}
. endif
   STLIBNAME	= lib${DOSTLIB}.a
   CLEAN	+= ${STLIBNAME}
.endif

.if defined(SGEN)
  MGEN		+= ${SGEN}
  SCRIPTS	+= ${SGEN}
.endif

.if defined(MGEN)
  CLEAN		+= ${MGEN}
. for I in ${MGEN}
   DIST		+= ${I}.m4
. endfor
.endif

.if defined(CGM4)
  BINOVER	?= ${CGIDIR}/${PKG}
. for I in ${CGM4}
   SCRIPTS	+= ${I}.cgi
   CLEAN	+= ${I}.cgi
   DIST		+= ${I}.cgm4
. endfor
.endif

.if defined(TITLE)
  CLEAN		+= index.4tml index.dir
.endif

.for I in ${MAN} ${PROG} ${SCRIPTS} ${PKG}
. if exists(${I}.1)
   MANS1	+= ${I}.1
. endif
. if exists(${I}.3)
   MANS3	+= ${I}.3
. endif
. if exists(${I}.5)
   MANS5	+= ${I}.5
. endif
. if exists(${I}.8)
   MANS8	+= ${I}.8
. endif
.endfor

.for I in ${MANS1}
  DIST	+= ${I}
  MANZ1	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS3}
  DIST	+= ${I}
  MANZ3	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS5}
  DIST	+= ${I}
  MANZ5	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor
.for I in ${MANS8}
  DIST	+= ${I}
  MANZ8	+= ${I}.gz
  CLEAN	+= ${I}.gz
.endfor

.if defined(SCRIPTFILTER)
. if defined(CONFDIR)
   SCRIPTFILTER	+= -e 's|%%CONFDIR%%|${CONFDIR}|g'
. endif
. if defined(LIBEDIR)
   SCRIPTFILTER	+= -e 's|%%LIBEDIR%%|${LIBEDIR}|g'
. endif
. if defined(BINDIR)
   SCRIPTFILTER	+= -e 's|%%BINDIR%%|${BINDIR}|g'
. endif
. if defined(PREFIX)
   SCRIPTFILTER	+= -e 's|%%PREFIX%%|${PREFIX}|g'
. endif
. if defined(WWWROOT)
   SCRIPTFILTER	+= -e 's|%%WWWROOT%%|${WWWROOT}|g'
. endif
. if defined(WWWROOTDATA)
   SCRIPTFILTER	+= -e 's|%%WWWROOTDATA%%|${WWWROOTDATA}|g'
. endif
.endif

CLANG		!= if ${CC} -v 2>&1 | ${GREP} -q clang ; then echo clang; fi
.if (${CLANG} == clang)
  CFLAGSPLUS	+= -Wno-invalid-source-encoding
.endif

.if exists(${BABOLOMAKE_CONF})
. include <${BABOLOMAKE_CONF}>
. if defined(USERMAKE_CONF)
.  if exists(${USERMAKE_CONF})
.   include <${USERMAKE_CONF}>
.  endif
. endif
.endif

.MAIN: all
.SUFFIXES : .sql .4tml .html .shtml .so .so.${MAJOR} .cgm4 .cgi .m4 .la .lo .lexor .h

