/*-
 * Copyright (C)2003..2013 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: BLINflag.h,v 1.26 2014/03/13 15:10:15 babolo Exp $
 */

#ifndef  _BABOLO_BLINflag_H_
# define _BABOLO_BLINflag_H_

#ifndef _SYS_TYPES_H_
# warning this file needs sys/types.h as a prerequisite
# include <sys/types.h>
#endif

#ifndef _STDIO_H_
# warning this file needs stdio.h as a prerequisite
# include <stdio.h>
#endif

__BEGIN_DECLS

typedef u_int32_t BLIN_flag;

#ifdef BLIN_COMPAT2
/*****************************************************************************************************/
/*                                                          for use in old style points of debugging */
# define BLIN_VER1    0x01000000
# define BLIN_VER2    0x02000000
# define BLIN_VER3    0x04000000
# define BLIN_VER4    0x08000000
# define BLIN_VER5    0x10000000
# define BLIN_VER6    0x20000000
# define BLIN_VER7    0x40000000
# define BLIN_VER8    0x80000000
# define BLIN_VERMASK 0xFF000000
#endif

/*****************************************************************************************************/
/*                                                                    for use in points of debugging */
#define BLIN_BIT0    0x01000000
#define BLIN_BIT1    0x02000000
#define BLIN_BIT2    0x04000000
#define BLIN_BIT3    0x08000000
#define BLIN_BIT4    0x10000000
#define BLIN_BIT5    0x20000000
#define BLIN_BIT6    0x40000000
#define BLIN_BIT7    0x80000000
#define BLIN_MASK    0xFF000000
#define BLIN_GEN0    0x01000000
#define BLIN_GEN1    0x03000000
#define BLIN_GEN2    0x07000000
#define BLIN_GEN3    0x0F000000
#define BLIN_GEN4    0x1F000000
#define BLIN_GEN5    0x3F000000
#define BLIN_GEN6    0x7F000000
#define BLIN_GEN7    0xFF000000
#define BLIN_TRAC    0x00800000

/*****************************************************************************************************/
/*                   for use in blin_pamparam.what . sets by blin_ctl(BLIN_CTL_WHAT, ) 2nd parameter */
#define BLIN_MODWARN  0x800000       /*                                 warn()  warnx() */
#define BLIN_MODPRNT  0x400000       /*                                 fprintf(.file, ) */
#define BLIN_MODLOGR  0x200000       /*                                  syslog(.prio, ) */
#define BLIN_MODEOAU  0x040000       /*                      \n,    */
#define BLIN_MODEOCR  0x020000       /*                                           \r   */
#define BLIN_MODEOLF  0x010000       /*                                           \n   */
#define BLIN_MODTIME  0x008000

/*****************************************************************************************************/
/*                                                              for blin_ctl() control 1st parameter */
#ifdef BLIN_COMPAT2
# define BLIN_CTL_LEV0 BLIN_BIT0     /*                                            |          */
# define BLIN_CTL_LEV1 BLIN_BIT1     /*                                            |          */
# define BLIN_CTL_LEV2 BLIN_BIT2     /*                                            |       */
# define BLIN_CTL_LEV3 BLIN_BIT3     /*                                            |        */
# define BLIN_CTL_LEV4 BLIN_BIT4     /*                                            |         */
# define BLIN_CTL_LEV5 BLIN_BIT5     /*                                            | BLIN_CTL_WHAT,  */
# define BLIN_CTL_LEV6 BLIN_BIT6     /*                                            | BLIN_CTL_FILE   */
# define BLIN_CTL_LEV7 BLIN_BIT7     /*                                            |  BLIN_CTL_PRIO */
# define BLIN_CTL_LEVM BLIN_MASK     /*                        BLIN_CTL_LEV0 .. BLIN_CTL_LEV7*/
#endif
#define BLIN_CTL_NONE 0x00010000     /*                        ,     */
#define BLIN_CTL_FEQU 0x00000000     /*                                        .flags */
#define BLIN_CTL_FSET 0x00000001     /*                                       .flags */
#define BLIN_CTL_FRST 0x00000002     /*                                         .flags */
#define BLIN_CTL_FXOR 0x00000003     /*                                         .flags */
#define BLIN_CTL_FAFM 0x00000007     /*                                        */
#define BLIN_CTL_NPRM 0x00000008     /*                               */
#define BLIN_CTL_RISE 0x00000010     /*                                         */
#define BLIN_CTL_FNEG 0x00000020     /*                                  */
#define BLIN_CTL_NPRE 0x00000040     /*                      ,    */
#define BLIN_CTL_RMSK 0x00000080     /*                                        */
#define BLIN_CTL_FLAG 0x00000000     /*                                            .flags */
#define BLIN_CTL_WHAT 0x00000100     /*                                             .what */
#define BLIN_CTL_FILE 0x00000200     /*                 .file,    */
#define BLIN_CTL_PRIO 0x00000300     /*                 .prio,    */
#define BLIN_CTL_DUMP 0x00000400     /*              blin_pamparam_internal  stderr */
#define BLIN_CTL_VERS 0x00000E00     /*                          ,    */
#define BLIN_CTL_RCSI 0x00000F00     /*                          ,    */
#define BLIN_CTL_OPER 0x00000F00     /*                blin_pamparam_internal */

/*****************************************************************************************************/
/*                                                                               BLIN infrastructure */
#define ifBLIN_FLAG BLIN_flag blin_internal_flags
#define BLIN_flags blin_internal_flags

typedef struct blin_pamparam {
    BLIN_flag flags;                 /*                   0    */
    u_int32_t dummy;
    struct {
        FILE     *file;              /*                     ,    fprintf() */
        u_int32_t what;              /*                                          */
        int32_t   prio;              /*                      ,    syslog() */
    }         w[8];
} blin_pamparam;

#ifdef BLIN_COMPAT2
/*****************************************************************************************************/
/*                                        old style poins of debugging. have to be deleted sometimes */
# define ifBLIN_QV1(flags) if ((flags) & BLIN_VER1)
# define ifBLIN_QV2(flags) if ((flags) & BLIN_VER2)
# define ifBLIN_QV3(flags) if ((flags) & BLIN_VER3)
# define ifBLIN_QV4(flags) if ((flags) & BLIN_VER4)
# define ifBLIN_QV5(flags) if ((flags) & BLIN_VER5)
# define ifBLIN_QV6(flags) if ((flags) & BLIN_VER6)
# define ifBLIN_QV7(flags) if ((flags) & BLIN_VER7)
# define ifBLIN_QV8(flags) if ((flags) & BLIN_VER8)
#endif

/*****************************************************************************************************/
/*                                                                      new style poins of debugging */
#define ifBLIN_QQ0(FLAGS) if ((FLAGS) & BLIN_BIT0)
#define ifBLIN_QQ1(FLAGS) if ((FLAGS) & BLIN_BIT1)
#define ifBLIN_QQ2(FLAGS) if ((FLAGS) & BLIN_BIT2)
#define ifBLIN_QQ3(FLAGS) if ((FLAGS) & BLIN_BIT3)
#define ifBLIN_QQ4(FLAGS) if ((FLAGS) & BLIN_BIT4)
#define ifBLIN_QQ5(FLAGS) if ((FLAGS) & BLIN_BIT5)
#define ifBLIN_QQ6(FLAGS) if ((FLAGS) & BLIN_BIT6)
#define ifBLIN_QQ7(FLAGS) if ((FLAGS) & BLIN_BIT7)
#define ifBLIN_QO0 if ((blin_internal_flags) & BLIN_BIT0)
#define ifBLIN_QO1 if ((blin_internal_flags) & BLIN_BIT1)
#define ifBLIN_QO2 if ((blin_internal_flags) & BLIN_BIT2)
#define ifBLIN_QO3 if ((blin_internal_flags) & BLIN_BIT3)
#define ifBLIN_QO4 if ((blin_internal_flags) & BLIN_BIT4)
#define ifBLIN_QO5 if ((blin_internal_flags) & BLIN_BIT5)
#define ifBLIN_QO6 if ((blin_internal_flags) & BLIN_BIT6)
#define ifBLIN_QO7 if ((blin_internal_flags) & BLIN_BIT7)
#define ifBLIN_QU0(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT0, 0, F, ## __VA_ARGS__)
#define ifBLIN_QU1(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT1, 1, F, ## __VA_ARGS__)
#define ifBLIN_QU2(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT2, 2, F, ## __VA_ARGS__)
#define ifBLIN_QU3(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT3, 3, F, ## __VA_ARGS__)
#define ifBLIN_QU4(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT4, 4, F, ## __VA_ARGS__)
#define ifBLIN_QU5(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT5, 5, F, ## __VA_ARGS__)
#define ifBLIN_QU6(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT6, 6, F, ## __VA_ARGS__)
#define ifBLIN_QU7(FLAGS, F, ...) ifBLIN_TEMPLATE((FLAGS) & BLIN_BIT7, 7, F, ## __VA_ARGS__)
#define ifBLIN_QX0(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT0, 0, F, ## __VA_ARGS__)
#define ifBLIN_QX1(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT1, 1, F, ## __VA_ARGS__)
#define ifBLIN_QX2(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT2, 2, F, ## __VA_ARGS__)
#define ifBLIN_QX3(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT3, 3, F, ## __VA_ARGS__)
#define ifBLIN_QX4(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT4, 4, F, ## __VA_ARGS__)
#define ifBLIN_QX5(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT5, 5, F, ## __VA_ARGS__)
#define ifBLIN_QX6(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT6, 6, F, ## __VA_ARGS__)
#define ifBLIN_QX7(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT7, 7, F, ## __VA_ARGS__)
#define ifBLIN_QW0(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT0, 8, F, ## __VA_ARGS__)
#define ifBLIN_QW1(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT1, 9, F, ## __VA_ARGS__)
#define ifBLIN_QW2(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT2, 10, F, ## __VA_ARGS__)
#define ifBLIN_QW3(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT3, 11, F, ## __VA_ARGS__)
#define ifBLIN_QW4(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT4, 12, F, ## __VA_ARGS__)
#define ifBLIN_QW5(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT5, 13, F, ## __VA_ARGS__)
#define ifBLIN_QW6(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT6, 14, F, ## __VA_ARGS__)
#define ifBLIN_QW7(F, ...) ifBLIN_TEMPLATE((blin_internal_flags) & BLIN_BIT7, 15, F, ## __VA_ARGS__)

#define ifBLIN_TEMPLATE(FLAGS, LEVEL, FORMAT, ...)                                                    \
    do {if (FLAGS) blin_cry1(LEVEL, "%s:%s:%d: "FORMAT, __FILE__, __func__, __LINE__, ## __VA_ARGS__);\
    } while (0)

/*****************************************************************************************************/
/*                                                                                   BLIN procedures */
extern BLIN_flag blin_internal_flags;

void           *blin_ctl      __P((u_int32_t ctl, ...));                /* for ctl see BLIN_CTL_*    */
int             blin_cry1     __P((int mode, const char *format, ...)); /* mode & 0x000007 level     */
                                                                        /* mode & 0x000008 use errno */
void            blin_dumb     __P((int mode, void *buf, size_t len));
#define BLIN_DU_TEXT 0x000010

#ifdef BLIN_COMPAT2
/*****************************************************************************************************/
/*                                                                old style to manipulate BLIN flags */
# define kukBLIN_VERMASK(x)        (((BLIN_flag)(x) << 24) & BLIN_MASK)
# define setBLIN_VERMASK(flags, x) do{(flags) &= ~BLIN_MASK; (flags) |= kukBLIN_VERMASK(x);} while (0)
# define getBLIN_VERMASK(flags)    (((flags) >> 24) & (BLIN_MASK >> 24))
#endif

/*****************************************************************************************************/
/*                                                                          to manipulate BLIN flags */
#define BLIN_VERBOSE(flags)                                                                           \
    do{ (flags) |= (BLIN_flag)BLIN_I(blin_ctl( BLIN_CTL_RISE                                          \
                                             | BLIN_CTL_NPRE                                          \
                                             | BLIN_CTL_RMSK                                          \
                                             | BLIN_CTL_FSET                                          \
                                             , (flags)                                                \
                                    )        );                                                       \
    } while (0)
#define BLIN_QUIET(flags)   do{ (flags) &= ~BLIN_MASK; blin_ctl(BLIN_CTL_FRST, BLIN_MASK);} while (0)

/*****************************************************************************************************/
/*                                          for use in printf of pointers on both 32 and 64 bit arch */
#ifdef __amd64__
# define BLIN_D    "ld"
# define BLIN_U    "lu"
# define BLIN_X    "012lX"
# define BLIN_I(P) ((u_int64_t)(P) & 0x0000FFFFFFFFFFFFUL)
#else
# define BLIN_D    "d"
# define BLIN_U    "u"
# define BLIN_X    "08X"
# define BLIN_I(P) ((u_int32_t)(P))
#endif

/*****************************************************************************************************/
/*                                                                  for state mashine hard debugging */
# ifdef ALLIGN_TABLE

#  define BLIN_STATEHEADER(f, n) \
{   int BLIN_STATEVAR_i;                                                                              \
    fprintf((f), "control-");                                                                         \
    for (BLIN_STATEVAR_i = 0; BLIN_STATEVAR_i < 24; BLIN_STATEVAR_i++)                                \
        if  ((n)[BLIN_STATEVAR_i][0] != '-') fprintf((f), "-%s", (n)[BLIN_STATEVAR_i]);               \
    fprintf((f), "nst vl cl st     p    --- q ---\n");                                                \
}

#  define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (((n)[BLIN_STATEVAR_i][0] != '-') || (BLIN_STATEVAR_j & 0x80000000))                      \
            fprintf( (f), "%s "                                                                       \
                   , (BLIN_STATEVAR_j & 0x80000000) ? (n)[BLIN_STATEVAR_i] : (u_char*)"  "            \
                   );                                                                                 \
    fprintf( (f), "%s %02X %s %s %08X %" BLIN_X "\t~"                                                 \
           , (sn)[(c) & (C)], (u_int)(r), (cn), (sn)[(s)], BLIN_I(p), (u_int)(q)                      \
           );                                                                                         \
    for ( BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                 \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# else

#  define BLIN_STATEHEADER(f, n) \
{   fprintf((f), "-------- control ------nst rs cl st     p    --- q ---\n");}

#  define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (BLIN_STATEVAR_j & 0x80000000) {                                                          \
            fprintf((f), "%s ", (n)[BLIN_STATEVAR_i]);                                                \
            BLIN_STATEVAR_k++;                                                                        \
        };                                                                                            \
    for (; BLIN_STATEVAR_k < 5; BLIN_STATEVAR_k++) fprintf((f), "   ");                               \
    fprintf((f), "%s %02X %s %s %08X %08X\t~", (sn)[(c) & (C)], (r), (cn), (sn)[(s)], (p), (q));      \
    for (BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                  \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# endif

/*****************************************************************************************************/
/*                                                                                              misc */
#ifndef BLIN_offset
# define BLIN_offset(T, F) ((size_t)(&((T *)0)->F))
#endif

__END_DECLS

#endif /* _BABOLO_BLINflag_H_ */
