/*-
 * Copyright (C)2010..2013 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2010..2013 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n\
@(#)V.M "VERS;
#endif /* not lint */
static const char rcsid[] = "$Id: blin.c,v 1.14 2014/03/14 15:54:22 babolo Exp $";

#include <sys/types.h>
#include <string.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <err.h>
#include "../BLINflag.h"

#define BLIN_MAININI  0x000001
#define BLIN_FLEGAL   BLIN_MASK

blin_pamparam blin_pamparam_internal =
{ 0x00000000, 0
, { {NULL, BLIN_MODWARN, LOG_LOCAL7 | LOG_ERR}
  , {NULL, BLIN_MODWARN, LOG_LOCAL7 | LOG_WARNING}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
} };

__weak_reference(blin_pamparam_internal, blin_internal_flags);

static char *
fac[] =
{ "KERN"  , "USER"  , "MAIL"    , "DAEMON", "AUTH"  , "SYSLOG"  , "LPR"    , "NEWS"
, "UUCP"  , "CRON"  , "AUTHPRIV", "FTP"   , "NTP"   , "SECURITY", "CONSOLE", "reserved"
, "LOCAL0", "LOCAL1", "LOCAL2"  , "LOCAL3", "LOCAL4", "LOCAL5"  , "LOCAL6" , "LOCAL7"
};

static char *
pri[] = {"EMERG", "ALERT", "CRIT", "ERR", "WARNING", "NOTICE", "INFO", "DEBUG"};


static void
blin_init() {
    int i;

    if  (!(blin_pamparam_internal.flags & BLIN_MAININI)) {
        if  (blin_pamparam_internal.flags & BLIN_TRAC) {
            fprintf(stderr, "BLIN: +blin_init %08X\n", blin_pamparam_internal.flags);
        }
        for (i = 0; i < 8; i++) blin_pamparam_internal.w[i].file = stderr;
        blin_pamparam_internal.flags |= BLIN_MAININI;
        if  (blin_pamparam_internal.flags & BLIN_TRAC) {
            fprintf(stderr, "BLIN: -blin_init %08X\n", blin_pamparam_internal.flags);
}   }   }

static u_int32_t
blin_do(u_int32_t mode, u_int32_t w, u_int32_t legal, u_int32_t *f) {
    u_int32_t r = *f;

    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: +blin_do %08X %08X %08X %08X\n", mode, w, legal, *f);
    }
    if  (!(mode & BLIN_CTL_RISE)) {
        w = (mode & BLIN_CTL_NPRM) ? 0 : w;
    } else {
        w = (((((mode & BLIN_CTL_NPRM) ? r : w) << 1) & BLIN_MASK) | BLIN_BIT0);
    }
    if  (mode & BLIN_CTL_FNEG) w = ~w;
    w &= legal;
    switch (mode & (BLIN_CTL_NONE | BLIN_CTL_FAFM)) {
    case BLIN_CTL_FSET: *f |= w;                    break;
    case BLIN_CTL_FRST: *f &= ~w;                   break;
    case BLIN_CTL_FXOR: *f ^= w;                    break;
    case BLIN_CTL_FEQU: *f = (*f & ~legal) | w;     break;
    }
    if  (mode & BLIN_CTL_NPRE) r = *f;
    if  (mode & BLIN_CTL_RMSK) r &= legal;
    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: -blin_do %08X\n", r);
    }
    return(r);
}

void *
blin_ctl(u_int32_t mode, ...) {
    void *res = NULL;
    u_int32_t m;
    va_list ap;
    int i;

    va_start(ap, mode);
    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: +blin_ctl %08X\n", mode);
    }
    blin_init();
    switch (mode & BLIN_CTL_OPER) {
    case BLIN_CTL_FLAG: {
            u_int32_t w = va_arg(ap, u_int32_t);
            res = (void *)(size_t)blin_do(mode, w, BLIN_FLEGAL, &blin_pamparam_internal.flags);
        }
        break;
    case BLIN_CTL_WHAT: {
            u_int32_t w = va_arg(ap, u_int32_t);
            for (m = BLIN_BIT0, i = 0; m; m <<= 1, ++i) {
                if  (mode & m) {
                    res = (void *)(size_t)blin_do(mode, w, ~0, &blin_pamparam_internal.w[i].what);
        }   }   }
        break;
    case BLIN_CTL_FILE: {
            void *w = va_arg(ap, void *);
            for (m = BLIN_BIT0, i = 0; m < BLIN_MASK; m <<= 1, ++i) {
                if  (mode & m) {
                    res = blin_pamparam_internal.w[i].file;
                    if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.w[i].file = w;
        }   }   }
        break;
    case BLIN_CTL_PRIO: {
            u_int32_t w = va_arg(ap, u_int32_t);
            for (m = BLIN_BIT0, i = 0; m < BLIN_MASK; m <<= 1, ++i) {
                if  (mode & m) {
                    res = (void *)BLIN_I(blin_pamparam_internal.w[i].prio);
                    if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.w[i].prio = w;
        }   }   }
        break;
    case BLIN_CTL_RCSI: {
            res = (void *)rcsid;
        }
        break;
    case BLIN_CTL_VERS: {
            res = (void *)VERS;
        }
        break;
    case BLIN_CTL_DUMP: {
            int k = 0;
        ;   m = blin_pamparam_internal.flags;
        ;   fprintf(stderr, "blin_pamparam_internal %08X=<", m);
        ;   if  (m & ~(BLIN_MASK | BLIN_MAININI)) {
        ;       fprintf(stderr, "%sunkn", k++ ? " | " : "");
        ;   }
        ;   if  (m & BLIN_MAININI) {
        ;       fprintf(stderr, "%sMAININI", k++ ? " | " : "");
        ;   }
        ;   for (i = 0; m & BLIN_BIT0; ++i) {
        ;       m >>= 1;
        ;       if  (!(m & BLIN_BIT0)) {
        ;           fprintf(stderr, "%sGEN%u", k++ ? " | " : "", i);
        ;           break;
        ;   }   }
        ;   for (++i; m & BLIN_MASK; m >>= 1, ++i) {
        ;       if  (m & BLIN_BIT0) {
        ;           fprintf(stderr, "%sBIT%u", k++ ? " | " : "", i);
        ;   }   }
        ;   if  (blin_pamparam_internal.dummy) {
        ;       fprintf(stderr, "> !!! %08X !!!\n", blin_pamparam_internal.dummy);
        ;   } else {
        ;       fprintf(stderr, ">\n");
        ;   }
        ;   for (i = 0; i < 8; ++i) {
                k = 0;
        ;       m = blin_pamparam_internal.w[i].what;
        ;       fprintf(stderr, "  %u %08X=<", i, m);
        ;       if  (m & ~( BLIN_MODWARN
                          | BLIN_MODPRNT
                          | BLIN_MODLOGR
                          | BLIN_MODEOAU
                          | BLIN_MODEOCR
                          | BLIN_MODEOLF
                          | BLIN_MODTIME
                    )     ) {
        ;           fprintf(stderr, "%sunkn", k++ ? " | " : "");
        ;       }
        ;       if  (m & BLIN_MODWARN) fprintf(stderr, "%sMODWARN", k++ ? " | " : "");
        ;       if  (m & BLIN_MODPRNT) fprintf(stderr, "%sMODPRNT", k++ ? " | " : "");
        ;       if  (m & BLIN_MODLOGR) fprintf(stderr, "%sMODLOGR", k++ ? " | " : "");
        ;       if  (m & BLIN_MODEOAU) fprintf(stderr, "%sMODEOAU", k++ ? " | " : "");
        ;       if  (m & BLIN_MODEOCR) fprintf(stderr, "%sMODEOCR", k++ ? " | " : "");
        ;       if  (m & BLIN_MODEOLF) fprintf(stderr, "%sMODEOLF", k++ ? " | " : "");
        ;       if  (m & BLIN_MODTIME) fprintf(stderr, "%sMODTIME", k++ ? " | " : "");
        ;       k = 0;
        ;       m = blin_pamparam_internal.w[i].prio;
        ;       fprintf(stderr, "> %08X=<", m);
        ;       if  (m & ~(LOG_PRIMASK | LOG_FACMASK)) {
        ;           fprintf(stderr, "%sunkn", k++ ? " | " : "");
        ;       }
        ;       if  (((m & LOG_FACMASK) >> 3) >= LOG_NFACILITIES) {
        ;           fprintf(stderr, "%sbig", k++ ? " | " : "");
        ;       }
        ;       fprintf(stderr, "%s%s", k++ ? " | " : "", fac[(m & LOG_FACMASK) >> 3]);
        ;       fprintf(stderr, "%s%s", k++ ? " | " : "", pri[m & LOG_PRIMASK]);
        ;       fprintf(stderr, ">");
        ;       if  (blin_pamparam_internal.w[i].file == stdin) {
        ;           fprintf(stderr, "  file=stdin\n");
        ;       } else if (blin_pamparam_internal.w[i].file == stdout) {
        ;           fprintf(stderr, "  file=stdout\n");
        ;       } else if (blin_pamparam_internal.w[i].file == stderr) {
        ;           fprintf(stderr, "  file=stderr\n");
        ;       } else {
        ;           fprintf(stderr, "  file=%"BLIN_X"\n", BLIN_I(blin_pamparam_internal.w[i].file));
    }   }   }   }
    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: -blin_ctl %08X\n", (u_int32_t)res);
    }
    va_end(ap);
    return(res);
}

int
blin_cry1(int ctl, const char *format, ...) {
    struct timespec tp;
    u_int32_t control;
    size_t l = 0;
    va_list ap;

    va_start(ap, format);
    blin_init();
    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: +blin_cry1 %08X\n", ctl);
    }
    control = blin_pamparam_internal.w[ctl & 7].what;
    if  (control & BLIN_MODTIME) {
        if  (0 > clock_gettime(CLOCK_REALTIME, &tp)) control &= ~BLIN_MODTIME;
    }
    if  (control & BLIN_MODWARN) {
        if  (control & BLIN_MODTIME) {
            warnx("%10"BLIN_D".%09ld ", tp.tv_sec, tp.tv_nsec);
        }
        if  (ctl & 8) vwarn(format, ap); else vwarnx(format, ap);
    }
    if  (control & BLIN_MODPRNT) {
        if  (control & BLIN_MODTIME) {
            fprintf( blin_pamparam_internal.w[ctl & 7].file, "%10"BLIN_D".%09ld "
                   , tp.tv_sec, tp.tv_nsec
                   )
            ;
        }
        vfprintf(blin_pamparam_internal.w[ctl & 7].file, format, ap);
    }
    if  (control & BLIN_MODLOGR) {
        if  (control & BLIN_MODTIME) {
            syslog( blin_pamparam_internal.w[ctl & 7].prio, "%10"BLIN_D".%09ld "
                   , tp.tv_sec, tp.tv_nsec
                   )
            ;
        }
        vsyslog(blin_pamparam_internal.w[ctl & 7].prio, format, ap);
    }
    if  (control & BLIN_MODEOAU) {
        if  (format) l = strlen(format);
        if  (l && (format[l - 1] != '\n')) control |= BLIN_MODEOLF;
    }
    if  (control & BLIN_MODEOCR) {
        fprintf(blin_pamparam_internal.w[ctl & 7].file, "\r");
    }
    if  (control & BLIN_MODEOLF) {
        fprintf(blin_pamparam_internal.w[ctl & 7].file, "\n");
    }
    va_end(ap);
    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: -blin_cry1\n");
    }
    return(0);
}

static char
fullformat[] =
"%"BLIN_X
" %02X %02X %02X %02X  %02X %02X %02X %02X  %02X %02X %02X %02X  %02X %02X %02X %02X"
" |%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c|\n"
;
static char
space[] = "                                                                ";

static u_char
#ifdef __amd64__
xform[18] = {6, 11, 16, 21, 26, 32, 37, 42, 47, 53, 58, 63, 68, 74, 79, 84, 89, 124};
#else
xform[18] = {4, 9, 14, 19, 24, 30, 35, 40, 45, 51, 56, 61, 66, 72, 77, 82, 87, 122};
#endif
static u_char
bform[17] = {51, 48, 45, 42, 39, 35, 32, 29, 26, 22, 19, 16, 13, 9, 6, 3, 0};

static void
coformat(int mode, size_t len, char format[128]) {
    size_t p;

    if  (mode & BLIN_DU_TEXT) {
        p = xform[len];
        memcpy(&format[p], space, bform[len]);
        p += bform[len];
        memcpy(&format[p], &format[xform[16]], 2 * len + 2);
        p += 2 * len + 2;
        format[p++] = '|';
    } else {
        p = xform[len];
    }
    format[p++] = '\n';
    format[p++] = '\0';
}

static char
z(u_char u) {
    char s;

    if  (u < ' ') s = '.';
    else if ((u < 0x7F) || (u >= (u_char)'') || (u == (u_char)'') || (u == (u_char)'')) s = u;
    else s = '.';
    return(s);
}

void
blin_dumb(int mode, void *buf, size_t len) {
    struct timespec tp;
    u_int32_t control;
    char format[128];
    u_char *c;
    size_t p;

    if  (blin_pamparam_internal.flags & BLIN_TRAC) {
        fprintf(stderr, "BLIN: +blin_dumb %08X %"BLIN_D"\n", mode, len);
    }
    c = buf;
    control = blin_pamparam_internal.w[mode & 7].what;
    if  (control & BLIN_MODTIME) {
        if  (0 > clock_gettime(CLOCK_REALTIME, &tp)) control &= ~BLIN_MODTIME;
    }
    p = xform[(mode & BLIN_DU_TEXT) ? 17 : 16];
    memcpy(format, fullformat, p);
    format[p++] = '\n';
    format[p++] = '\0';
    if  (control & BLIN_MODWARN) {
    ;   if  (control & BLIN_MODTIME) {
    ;       warnx("%10"BLIN_D".%09ld", tp.tv_sec, tp.tv_nsec);
    ;   }
    ;   while (len >= 16) {
    ;       if  (mode & BLIN_DU_TEXT) {
    ;           warnx( format, BLIN_I(c)
                     , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                     , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                     , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                     , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14]), z(c[15])
                     );
    ;       } else {
    ;           warnx( format, BLIN_I(c)
                     , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                     , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                     );
    ;       }
    ;       len -= 16;
    ;       c += 16;
    ;   }
    ;   if  (len) {
    ;       coformat(mode, len, format);
    ;       if  (mode & BLIN_DU_TEXT) {
    ;       ;   switch(len) {
                case 15: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14])
                              );
    ;       ;            break;
                case 14: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12], c[13]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13])
                              );
    ;       ;            break;
                case 13: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12])
                              );
    ;       ;            break;
                case 12: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9]), z(c[10]), z(c[11])
                              );
    ;       ;            break;
                case 11: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9]), z(c[10])
                              );
    ;       ;            break;
                case 10: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8]), z(c[9])
                              );
    ;       ;            break;
                case 9:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              , z(c[8])
                              );
    ;       ;            break;
                case 8:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                              );
    ;       ;            break;
                case 7:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                              );
    ;       ;            break;
                case 6:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5])
                              );
    ;       ;            break;
                case 5:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4])
                              );
    ;       ;            break;
                case 4:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3]
                              , z(c[0]), z(c[1]), z(c[2]), z(c[3])
                              );
    ;       ;            break;
                case 3:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2]
                              , z(c[0]), z(c[1]), z(c[2])
                              );
    ;       ;            break;
                case 2:  warnx(format, BLIN_I(c), c[0], c[1], z(c[0]), z(c[1]));
    ;       ;            break;
                case 1:  warnx(format, BLIN_I(c), c[0], z(c[0]));
    ;       ;            break;
    ;       ;   }
    ;       } else {
    ;       ;   switch(len) {
                case 15: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                              );
    ;       ;            break;
                case 14: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12], c[13]
                              );
    ;       ;            break;
                case 13: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11], c[12]
                              );
    ;       ;            break;
                case 12: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10], c[11]
                              );
    ;       ;            break;
                case 11: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9], c[10]
                              );
    ;       ;            break;
                case 10: warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8], c[9]
                              );
    ;       ;            break;
                case 9:  warnx( format, BLIN_I(c)
                              , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                              , c[8]
                              );
    ;       ;            break;
                case 8:  warnx(format, BLIN_I(c), c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]);
    ;       ;            break;
                case 7:  warnx(format, BLIN_I(c), c[0], c[1], c[2], c[3], c[4], c[5], c[6]);
    ;       ;            break;
                case 6:  warnx(format, BLIN_I(c), c[0], c[1], c[2], c[3], c[4], c[5]);
    ;       ;            break;
                case 5:  warnx(format, BLIN_I(c), c[0], c[1], c[2], c[3], c[4]);
    ;       ;            break;
                case 4:  warnx(format, BLIN_I(c), c[0], c[1], c[2], c[3]);
    ;       ;            break;
                case 3:  warnx(format, BLIN_I(c), c[0], c[1], c[2]);
    ;       ;            break;
                case 2:  warnx(format, BLIN_I(c), c[0], c[1]);
    ;       ;            break;
                case 1:  warnx(format, BLIN_I(c), c[0]);
    ;       ;            break;
    }   }   }   }
    if  (control & BLIN_MODPRNT) {
    ;   if  (control & BLIN_MODTIME) {
    ;       fprintf( blin_pamparam_internal.w[mode & 7].file, "%10"BLIN_D".%09ld\n"
                   , tp.tv_sec, tp.tv_nsec
                   );
    ;   }
    ;   while (len >= 16) {
    ;       if  (mode & BLIN_DU_TEXT) {
    ;           fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                       , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                       , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                       , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                       , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14]), z(c[15])
                       );
    ;       } else {
    ;           fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                       , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                       , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                       );
    ;       }
    ;       len -= 16;
    ;       c += 16;
    ;   }
    ;   if  (len) {
    ;       coformat(mode, len, format);
    ;       if  (mode & BLIN_DU_TEXT) {
    ;       ;   switch(len) {
                case 15: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                                , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14])
                                );
    ;       ;            break;
                case 14: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12], c[13]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13])
                                );
    ;       ;            break;
                case 13: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12])
                                );
    ;       ;            break;
                case 12: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8]), z(c[9]), z(c[10]), z(c[11])
                                );
    ;       ;            break;
                case 11: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8]), z(c[9]), z(c[10])
                                );
    ;       ;            break;
                case 10: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8]), z(c[9])
                                );
    ;       ;            break;
                case 9:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7]), z(c[8])
                                );
    ;       ;            break;
                case 8:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                , z(c[7])
                                );
    ;       ;            break;
                case 7:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                                );
    ;       ;            break;
                case 6:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5])
                                );
    ;       ;            break;
                case 5:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4])
                                );
    ;       ;            break;
                case 4:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3]
                                , z(c[0]), z(c[1]), z(c[2]), z(c[3])
                                );
    ;       ;            break;
                case 3:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2]
                                , z(c[0]), z(c[1]), z(c[2])
                                );
    ;       ;            break;
                case 2:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], z(c[0]), z(c[1])
                                );
    ;       ;            break;
                case 1:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], z(c[0])
                                );
    ;       ;            break;
    ;       ;   }
    ;       } else {
    ;       ;   switch(len) {
                case 15: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                                );
    ;       ;            break;
                case 14: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12], c[13]
                                );
    ;       ;            break;
                case 13: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11], c[12]
                                );
    ;       ;            break;
                case 12: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10], c[11]
                                );
    ;       ;            break;
                case 11: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9], c[10]
                                );
    ;       ;            break;
                case 10: fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8], c[9]
                                );
    ;       ;            break;
                case 9:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                , c[8]
                                );
    ;       ;            break;
                case 8:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                                );
    ;       ;            break;
                case 7:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5], c[6]
                                );
    ;       ;            break;
                case 6:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4], c[5]
                                );
    ;       ;            break;
                case 5:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3], c[4]
                                );
    ;       ;            break;
                case 4:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2], c[3]
                                );
    ;       ;            break;
                case 3:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1], c[2]
                                );
    ;       ;            break;
                case 2:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0], c[1]
                                );
    ;       ;            break;
                case 1:  fprintf( blin_pamparam_internal.w[mode & 7].file, format, BLIN_I(c)
                                , c[0]
                                );
    ;       ;            break;
    }   }   }   }
    if  (control & BLIN_MODLOGR) {
    ;   if  (control & BLIN_MODTIME) {
    ;       syslog( blin_pamparam_internal.w[mode & 7].prio, "%10"BLIN_D".%09ld"
                  , tp.tv_sec, tp.tv_nsec
                  );
    ;   }
    ;   while (len >= 16) {
    ;       if  (mode & BLIN_DU_TEXT) {
    ;           syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                      , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                      , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                      , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                      , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14]), z(c[15])
                      );
    ;       } else {
    ;           syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                      , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                      , c[8], c[9], c[10], c[11], c[12], c[13], c[14], c[15]
                      );
    ;       }
    ;       len -= 16;
    ;       c += 16;
    ;   }
    ;   if  (len) {
    ;       coformat(mode, len, format);
    ;       if  (mode & BLIN_DU_TEXT) {
    ;       ;   switch(len) {
                case 15: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13]), z(c[14])
                               );
    ;       ;            break;
                case 14: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12], c[13]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12]), z(c[13])
                               );
    ;       ;            break;
                case 13: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9]), z(c[10]), z(c[11]), z(c[12])
                               );
    ;       ;            break;
                case 12: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9]), z(c[10]), z(c[11])
                               );
    ;       ;            break;
                case 11: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9]), z(c[10])
                               );
    ;       ;            break;
                case 10: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8]), z(c[9])
                               );
    ;       ;            break;
                case 9:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               , z(c[8])
                               );
    ;       ;            break;
                case 8:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6]), z(c[7])
                               );
    ;       ;            break;
                case 7:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5]), z(c[6])
                               );
    ;       ;            break;
                case 6:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4]), z(c[5])
                               );
    ;       ;            break;
                case 5:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4]
                               , z(c[0]), z(c[1]), z(c[2]), z(c[3]), z(c[4])
                               );
    ;       ;            break;
                case 4:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], z(c[0]), z(c[1]), z(c[2]), z(c[3])
                               );
    ;       ;            break;
                case 3:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], z(c[0]), z(c[1]), z(c[2])
                               );
    ;       ;            break;
                case 2:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], z(c[0]), z(c[1])
                               );
    ;       ;            break;
                case 1:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], z(c[0])
                               );
    ;       ;            break;
    ;       ;   }
    ;       } else {
    ;       ;   switch(len) {
                case 15: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12], c[13], c[14]
                               );
    ;       ;            break;
                case 14: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12], c[13]
                               );
    ;       ;            break;
                case 13: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11], c[12]
                               );
    ;       ;            break;
                case 12: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10], c[11]
                               );
    ;       ;            break;
                case 11: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9], c[10]
                               );
    ;       ;            break;
                case 10: syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8], c[9]
                               );
    ;       ;            break;
                case 9:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               , c[8]
                               );
    ;       ;            break;
                case 8:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7]
                               );
    ;       ;            break;
                case 7:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5], c[6]
                               );
    ;       ;            break;
                case 6:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4], c[5]
                               );
    ;       ;            break;
                case 5:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3], c[4]
                               );
    ;       ;            break;
                case 4:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2], c[3]
                               );
    ;       ;            break;
                case 3:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1], c[2]
                               );
    ;       ;            break;
                case 2:  syslog( blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c)
                               , c[0], c[1]
                               );
    ;       ;            break;
                case 1:  syslog(blin_pamparam_internal.w[mode & 7].prio, format, BLIN_I(c), c[0]);
    ;       ;            break;
}   }   }   }   }
