/*-
 * Copyright (C)2010..2013 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static const char copyright[] = "\
@(#)Copyright (C)2010..2013 @BABOLO http://www.babolo.ru/\n\
@(#)All rights reserved.\n\
@(#)V.M "VERS;
static const char rcsid[] = "$Id: blin.c,v 1.8 2013/10/27 21:34:54 babolo Exp $";
#endif /* not lint */

#include <sys/types.h>
#include <string.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdio.h>
#include <errno.h>
#include <err.h>
#include "../BLINflag.h"

#define BLIN_MAININI  0x000001

blin_pamparam blin_pamparam_internal =
{ 0x00000000, 0
, { {NULL, BLIN_MODWARN, LOG_LOCAL7 | LOG_ERR}
  , {NULL, BLIN_MODWARN, LOG_LOCAL7 | LOG_WARNING}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
  , {NULL, BLIN_MODPRNT, LOG_LOCAL7 | LOG_DEBUG}
} };

__weak_reference(blin_pamparam_internal, blin_internal_flags);

static void
blin_init() {
    int i;

    if  (!(blin_pamparam_internal.flags & BLIN_MAININI)) {
        for (i = 0; i < 8; i++) blin_pamparam_internal.w[i].file = stderr;
        blin_pamparam_internal.flags |= BLIN_MAININI;
}   }

void *
blin_ctl(int mode, ...) {
    void *res = NULL;
    u_int32_t m;
    va_list ap;
    int i;

    va_start(ap, mode);
    blin_init();
    if  ((mode & (BLIN_CTL_OPER | BLIN_CTL_LEVM)) == BLIN_CTL_FSET) {
        res = (void *)BLIN_I(blin_pamparam_internal.flags);
        if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.flags |= va_arg(ap, u_int32_t);
    } else if ((mode & (BLIN_CTL_OPER | BLIN_CTL_LEVM)) == BLIN_CTL_FRST) {
        res = (void *)BLIN_I(blin_pamparam_internal.flags);
        if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.flags &= ~va_arg(ap, u_int32_t);
    } else if ((mode & BLIN_CTL_OPER) == BLIN_CTL_WHAT) {
        u_int32_t w = va_arg(ap, u_int32_t);
        for (m = BLIN_CTL_LEV0, i = 0; m < BLIN_CTL_LEVM; m <<= 1, i++) {
            if  (mode & m) {
                res = (void *)BLIN_I(blin_pamparam_internal.w[i].what);
                if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.w[i].what = w;
        }   }
    } else if ((mode & BLIN_CTL_OPER) == BLIN_CTL_FILE) {
        void *w = va_arg(ap, void *);
        for (m = BLIN_CTL_LEV0, i = 0; m < BLIN_CTL_LEVM; m <<= 1, i++) {
            if  (mode & m) {
                res = blin_pamparam_internal.w[i].file;
                if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.w[i].file = w;
        }   }
    } else if ((mode & BLIN_CTL_OPER) == BLIN_CTL_PRIO) {
        u_int32_t w = va_arg(ap, u_int32_t);
        for (m = BLIN_CTL_LEV0, i = 0; m < BLIN_CTL_LEVM; m <<= 1, i++) {
            if  (mode & m) {
                res = (void *)BLIN_I(blin_pamparam_internal.w[i].prio);
                if  (!(mode & BLIN_CTL_NONE)) blin_pamparam_internal.w[i].prio = w;
    }   }   }
    va_end(ap);
    return(res);
}

int
blin_cry1(int mode, const char *format, ...) {
    u_int32_t control;
    va_list ap;
    size_t l = 0;

    va_start(ap, format);
    blin_init();
    control = blin_pamparam_internal.w[mode & 7].what;
    if  (control & BLIN_MODWARN) {
        if  (mode & 8) vwarn(format, ap); else vwarnx(format, ap);
    }
    if  (control & BLIN_MODPRNT) {
        vfprintf(blin_pamparam_internal.w[mode & 7].file, format, ap);
    }
    if  (control & BLIN_MODLOGR) {
        vsyslog(blin_pamparam_internal.w[mode & 7].prio, format, ap);
    }
    if  (control & BLIN_MODEOAU) {
        if  (format) l = strlen(format);
        if  (l && (format[l - 1] != '\n')) control |= BLIN_MODEOLF;
    }
    if  (control & BLIN_MODEOCR) {
        fprintf(blin_pamparam_internal.w[mode & 7].file, "\r");
    }
    if  (control & BLIN_MODEOLF) {
        fprintf(blin_pamparam_internal.w[mode & 7].file, "\n");
    }
    va_end(ap);
    return(0);
}
