# Copyright (C) @BABOLO  2006 May 30 http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: subdir.make,v 1.4 2009/05/31 21:44:31 babolo Exp $

SUBDIR	+= ${NXTDIR} ${MODULE}

all:
.for I in ${SUBDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} all)
.endfor

findiff:
	@make -V SUBDIR | tr ' ' '\n' | pgoblin -C 'DROP TABLE m;CREATE TABLE m(m text);COPY m FROM stdin'
	@make -V IGNORE | tr ' ' '\n' | pgoblin -C 'DROP TABLE i;CREATE TABLE i(i text);COPY i FROM stdin'
	@find ./ -type d -depth 1 | sed -e 's|^./||' | pgoblin -C 'DROP TABLE r;CREATE TABLE r(r text);COPY r FROM stdin'
	@pgoblin -D "DELETE FROM r WHERE r IN(SELECT i FROM i);DELETE FROM m WHERE m IN('')"
	@pgoblin -s "SELECT ' Makefile :\n' WHERE EXISTS(SELECT m FROM m EXCEPT SELECT r FROM r)"
	@pgoblin -s "SELECT m || '\n' FROM (SELECT m FROM m EXCEPT SELECT r FROM r)m"
	@pgoblin -s "SELECT ' ,    Makefile\n' WHERE EXISTS(SELECT r FROM r EXCEPT SELECT m FROM m)"
	@pgoblin -s "SELECT r || '\n' FROM (SELECT r FROM r EXCEPT SELECT m FROM m)r"
.for I in ${NXTDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} findiff)
.endfor

ignore:
	@-make -V IGNORE | tr ' ' '\n' | grep -v '^CVS$$'
.for I in ${NXTDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} ignore)
.endfor

clean:
.for I in ${SUBDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} clean)
.endfor

tarball:
.for I in ${SUBDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} tarball)
.endfor

install:
.for I in ${SUBDIR}
	@echo ================== ${I} ==================
	@(cd ${I}; ${MAKE} install)
.endfor
